/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.ControllerDialogKunde;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TextFieldPatternFormatter;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;

public class MaskeKundendaten
extends JPanel {
    private static final long serialVersionUID = -4326402023519634884L;
    private static Logger log = Logger.getLogger(MaskeKundendaten.class);
    private static final String DATE_FORMAT = "dd.MM.yyyy";
    private static final String PATTERN_DATE = "[0-9.]{0,10}";
    private static final String PATTERN_KUNDENNUMMER = "[0-9]{0,7}";
    private static final Color COLOR_PFLICHTFELD = Color.RED;
    private JPanel panKundennummer;
    private JPanel panKundenname;
    private JLabel labKundennummer;
    private JLabel labAnrede;
    private JLabel labName;
    private JLabel labVorname;
    private JLabel labStrasse;
    private JLabel labHausnr;
    private JLabel labLand;
    private JLabel labPlz;
    private JLabel labOrt;
    private JLabel labPostfachnr;
    private JLabel labTelefonnummer;
    private JLabel labMobilnummer;
    private JLabel labFaxnummer;
    private JLabel labEmail;
    private JLabel labBemerkung;
    private JLabel labGeburtsDatum;
    private JLabel labVin;
    private JLabel labPflichtfeld;
    private JFormattedTextField tfKundennummer;
    private JFormattedTextField tfGeburtsdatum;
    private JTextField tfAnrede;
    private JTextField tfName;
    private JTextField tfVorname;
    private JTextField tfStrasse;
    private JTextField tfHausnr;
    private JTextField tfLand;
    private JTextField tfPlz;
    private JTextField tfOrt;
    private JTextField tfPostfachnr;
    private JTextField tfTelefonnummer;
    private JTextField tfMobilnummer;
    private JTextField tfFaxnummer;
    private JTextField tfEmail;
    private JTextField tfBemerkung;
    private JTextField tfVin;
    private Kunde mKunde;

    public MaskeKundendaten() {
        this.createComponents();
        this.buildPanel();
    }

    private void createComponents() {
        this.labKundennummer = new JLabel(Resource.getInstance().getKundennummer() + ":");
        this.labAnrede = new JLabel(Resource.getInstance().getAnrede() + ":");
        this.labName = new JLabel(Resource.getInstance().getName() + ":");
        this.labVorname = new JLabel(Resource.getInstance().getVorname() + ":");
        this.labStrasse = new JLabel(Resource.getInstance().getStrasse() + ":");
        this.labHausnr = new JLabel(Resource.getInstance().getHausnummer() + ":");
        this.labLand = new JLabel(Resource.getInstance().getLand() + ":");
        this.labPlz = new JLabel(Resource.getInstance().getPlz() + ":");
        this.labOrt = new JLabel(Resource.getInstance().getOrt() + ":");
        this.labPostfachnr = new JLabel(Resource.getInstance().getPostfach() + ":");
        this.labTelefonnummer = new JLabel(Resource.getInstance().getTelefon() + ":");
        this.labMobilnummer = new JLabel(Resource.getInstance().getMobil() + ":");
        this.labFaxnummer = new JLabel(Resource.getInstance().getFax() + ":");
        this.labEmail = new JLabel(Resource.getInstance().getEmail() + ":");
        this.labBemerkung = new JLabel(Resource.getInstance().getBemerkung() + ":");
        this.labGeburtsDatum = new JLabel(Resource.getInstance().getGeburtsdatum() + ":");
        this.labVin = new JLabel("Vin:");
        this.tfAnrede = new JTextField();
        this.tfAnrede.setMaxCharacters(40);
        this.tfName = new JTextField();
        this.tfName.setMaxCharacters(40);
        this.tfVorname = new JTextField();
        this.tfVorname.setMaxCharacters(40);
        this.tfStrasse = new JTextField();
        this.tfStrasse.setMaxCharacters(40);
        this.tfHausnr = new JTextField();
        this.tfHausnr.setMaxCharacters(40);
        this.tfLand = new JTextField();
        this.tfLand.setMaxCharacters(40);
        this.tfPlz = new JTextField();
        this.tfPlz.setMaxCharacters(10);
        this.tfOrt = new JTextField();
        this.tfOrt.setMaxCharacters(40);
        this.tfPostfachnr = new JTextField();
        this.tfPostfachnr.setMaxCharacters(10);
        this.tfTelefonnummer = new JTextField();
        this.tfTelefonnummer.setMaxCharacters(25);
        this.tfMobilnummer = new JTextField();
        this.tfMobilnummer.setMaxCharacters(25);
        this.tfFaxnummer = new JTextField();
        this.tfFaxnummer.setMaxCharacters(25);
        this.tfEmail = new JTextField();
        this.tfEmail.setMaxCharacters(40);
        this.tfBemerkung = new JTextField();
        this.tfBemerkung.setMaxCharacters(56);
        this.tfVin = new JTextField();
        this.tfVin.setMaxCharacters(7);
        Pattern pKundennummer = Pattern.compile(PATTERN_KUNDENNUMMER);
        TextFieldPatternFormatter formatKundennummer = new TextFieldPatternFormatter(pKundennummer);
        formatKundennummer.setAllowsInvalid(false);
        this.tfKundennummer = new JFormattedTextField(formatKundennummer);
        Pattern pGebdatum = Pattern.compile(PATTERN_DATE);
        TextFieldPatternFormatter formatGebdatum = new TextFieldPatternFormatter(pGebdatum);
        formatGebdatum.setAllowsInvalid(false);
        this.tfGeburtsdatum = new JFormattedTextField(formatGebdatum);
        this.tfKundennummer.setPreferredSize(new Dimension(100, 20));
        this.tfAnrede.setPreferredSize(new Dimension(150, 20));
        this.tfName.setPreferredSize(new Dimension(150, 20));
        this.tfVorname.setPreferredSize(new Dimension(150, 20));
        this.tfStrasse.setPreferredSize(new Dimension(250, 20));
        this.tfHausnr.setPreferredSize(new Dimension(100, 20));
        this.tfPlz.setPreferredSize(new Dimension(65, 20));
        this.tfOrt.setPreferredSize(new Dimension(250, 20));
        this.tfPostfachnr.setPreferredSize(new Dimension(150, 20));
        this.tfLand.setPreferredSize(new Dimension(150, 20));
        this.tfTelefonnummer.setPreferredSize(new Dimension(150, 20));
        this.tfMobilnummer.setPreferredSize(new Dimension(150, 20));
        this.tfFaxnummer.setPreferredSize(new Dimension(150, 20));
        this.tfEmail.setPreferredSize(new Dimension(150, 20));
        this.tfBemerkung.setPreferredSize(new Dimension(300, 20));
        this.tfGeburtsdatum.setPreferredSize(new Dimension(100, 20));
        this.tfVin.setPreferredSize(new Dimension(150, 20));
        this.tfVin.setEditable(false);
        this.tfVin.setEnabled(false);
        ControllerDialogKunde.getInstance().addMaskeCaretListener(this);
        this.panKundennummer = new JPanel();
        this.panKundennummer.setLayout(new BoxLayout(this.panKundennummer, 0));
        JLabel labStern1 = new JLabel("*");
        labStern1.setForeground(COLOR_PFLICHTFELD);
        this.panKundennummer.add(this.labKundennummer);
        this.panKundennummer.add(Box.createRigidArea(new Dimension(2, 0)));
        this.panKundennummer.add(labStern1);
        this.panKundenname = new JPanel();
        this.panKundenname.setLayout(new BoxLayout(this.panKundenname, 0));
        JLabel labStern2 = new JLabel("*");
        labStern2.setForeground(COLOR_PFLICHTFELD);
        this.panKundenname.add(this.labName);
        this.panKundenname.add(Box.createRigidArea(new Dimension(2, 0)));
        this.panKundenname.add(labStern2);
        this.labPflichtfeld = new JLabel("* " + Resource.getInstance().getPflichtfeld());
        this.labPflichtfeld.setForeground(COLOR_PFLICHTFELD);
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 2, 1, 2);
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.panKundennummer, gbc);
        gbc = this.setGridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 2, 18, insets);
        this.add((Component)this.tfKundennummer, gbc);
        gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labAnrede, gbc);
        gbc = this.setGridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfAnrede, gbc);
        gbc = this.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labVorname, gbc);
        gbc = this.setGridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfVorname, gbc);
        gbc = this.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.panKundenname, gbc);
        gbc = this.setGridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.tfName, gbc);
        gbc = this.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labStrasse, gbc);
        gbc = this.setGridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfStrasse, gbc);
        gbc = this.setGridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.labHausnr, gbc);
        gbc = this.setGridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.tfHausnr, gbc);
        gbc = this.setGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labPlz, gbc);
        gbc = this.setGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfPlz, gbc);
        gbc = this.setGridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.labOrt, gbc);
        gbc = this.setGridBagConstraints(3, 4, 3, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.tfOrt, gbc);
        gbc = this.setGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labPostfachnr, gbc);
        gbc = this.setGridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfPostfachnr, gbc);
        gbc = this.setGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labLand, gbc);
        gbc = this.setGridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfLand, gbc);
        gbc = this.setGridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labTelefonnummer, gbc);
        gbc = this.setGridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfTelefonnummer, gbc);
        gbc = this.setGridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.labMobilnummer, gbc);
        gbc = this.setGridBagConstraints(4, 7, 2, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.tfMobilnummer, gbc);
        gbc = this.setGridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labFaxnummer, gbc);
        gbc = this.setGridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.tfFaxnummer, gbc);
        gbc = this.setGridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.labEmail, gbc);
        gbc = this.setGridBagConstraints(4, 8, 2, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.tfEmail, gbc);
        gbc = this.setGridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labBemerkung, gbc);
        gbc = this.setGridBagConstraints(1, 9, 5, 1, 0.0, 0.0, 2, 18, insets);
        this.add((Component)this.tfBemerkung, gbc);
        gbc = this.setGridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labGeburtsDatum, gbc);
        gbc = this.setGridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 2, 18, insets);
        this.add((Component)this.tfGeburtsdatum, gbc);
        gbc = this.setGridBagConstraints(3, 10, 1, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.labVin, gbc);
        gbc = this.setGridBagConstraints(4, 10, 2, 1, 0.0, 0.0, 0, 12, insets);
        this.add((Component)this.tfVin, gbc);
        gbc = this.setGridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 0, 18, insets);
        this.add((Component)this.labPflichtfeld, gbc);
    }

    public void setLayout(MarkenLayout layout) {
        this.setBackground(layout.getPrimaryBackground());
        this.panKundennummer.setBackground(layout.getPrimaryBackground());
        this.panKundenname.setBackground(layout.getPrimaryBackground());
        this.labKundennummer.setForeground(layout.getPrimaryForeground());
        this.labAnrede.setForeground(layout.getPrimaryForeground());
        this.labName.setForeground(layout.getPrimaryForeground());
        this.labVorname.setForeground(layout.getPrimaryForeground());
        this.labStrasse.setForeground(layout.getPrimaryForeground());
        this.labHausnr.setForeground(layout.getPrimaryForeground());
        this.labLand.setForeground(layout.getPrimaryForeground());
        this.labPlz.setForeground(layout.getPrimaryForeground());
        this.labOrt.setForeground(layout.getPrimaryForeground());
        this.labPostfachnr.setForeground(layout.getPrimaryForeground());
        this.labTelefonnummer.setForeground(layout.getPrimaryForeground());
        this.labMobilnummer.setForeground(layout.getPrimaryForeground());
        this.labFaxnummer.setForeground(layout.getPrimaryForeground());
        this.labEmail.setForeground(layout.getPrimaryForeground());
        this.labBemerkung.setForeground(layout.getPrimaryForeground());
        this.labGeburtsDatum.setForeground(layout.getPrimaryForeground());
        this.labVin.setForeground(layout.getPrimaryForeground());
    }

    public void fill(Kunde kunde) {
        this.mKunde = kunde;
        if (this.mKunde == null) {
            this.mKunde = new Kunde();
        }
        this.tfKundennummer.setText(this.mKunde.getKundennummer());
        this.tfAnrede.setText(this.mKunde.getAnrede());
        this.tfName.setText(this.mKunde.getName());
        this.tfVorname.setText(this.mKunde.getVorname());
        this.tfStrasse.setText(this.mKunde.getStrasse());
        this.tfHausnr.setText(this.mKunde.getHausnr());
        this.tfLand.setText(this.mKunde.getLand());
        this.tfPlz.setText(this.mKunde.getPlz());
        this.tfOrt.setText(this.mKunde.getStadt());
        this.tfPostfachnr.setText(this.mKunde.getPostfachnr());
        this.tfTelefonnummer.setText(this.mKunde.getTelefonnummer());
        this.tfMobilnummer.setText(this.mKunde.getMobilnummer());
        this.tfFaxnummer.setText(this.mKunde.getFaxnummer());
        this.tfEmail.setText(this.mKunde.getEmail());
        this.tfBemerkung.setText(this.mKunde.getBemerkung());
        SimpleDateFormat formatDatum = new SimpleDateFormat(DATE_FORMAT);
        this.tfGeburtsdatum.setText(this.mKunde.getGeburtsDatum() == null ? "" : formatDatum.format(this.mKunde.getGeburtsDatum()));
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null && GlobalObjects.getInstance().getIpacData().getFahrzeug().getFahrgestellnummer() != null && !GlobalObjects.getInstance().getIpacData().getFahrzeug().getFahrgestellnummer().equals("")) {
            this.tfVin.setText(GlobalObjects.getInstance().getIpacData().getFahrzeug().getFahrgestellnummer());
        }
    }

    public JTextField getTfAnrede() {
        return this.tfAnrede;
    }

    public JTextField getTfBemerkung() {
        return this.tfBemerkung;
    }

    public JTextField getTfEmail() {
        return this.tfEmail;
    }

    public JTextField getTfFaxnummer() {
        return this.tfFaxnummer;
    }

    public JTextField getTfHausnr() {
        return this.tfHausnr;
    }

    public JFormattedTextField getTfKundennummer() {
        return this.tfKundennummer;
    }

    public JTextField getTfLand() {
        return this.tfLand;
    }

    public JTextField getTfMobilnummer() {
        return this.tfMobilnummer;
    }

    public JTextField getTfName() {
        return this.tfName;
    }

    public JTextField getTfPlz() {
        return this.tfPlz;
    }

    public JTextField getTfPostfachnr() {
        return this.tfPostfachnr;
    }

    public JTextField getTfOrt() {
        return this.tfOrt;
    }

    public JTextField getTfStrasse() {
        return this.tfStrasse;
    }

    public JTextField getTfTelefonnummer() {
        return this.tfTelefonnummer;
    }

    public JTextField getTfVorname() {
        return this.tfVorname;
    }

    public JFormattedTextField getTfGeburtsdatum() {
        return this.tfGeburtsdatum;
    }

    protected GridBagConstraints setGridBagConstraints(int gx, int gy, int gw, int gh, double wx, double wy, int fill, int anchor, Insets in) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.weightx = wx;
        c.weighty = wy;
        c.fill = fill;
        c.insets = in;
        c.anchor = anchor;
        return c;
    }

    public Kunde getKunde() {
        this.updateKunde();
        return this.mKunde;
    }

    private void updateKunde() {
        this.mKunde.setKundennummer(this.tfKundennummer.getText());
        this.mKunde.setName(this.tfName.getText());
        this.mKunde.setAnrede(this.tfAnrede.getText().equals("") ? null : this.tfAnrede.getText());
        this.mKunde.setVorname(this.tfVorname.getText().equals("") ? null : this.tfVorname.getText());
        this.mKunde.setStrasse(this.tfStrasse.getText().equals("") ? null : this.tfStrasse.getText());
        this.mKunde.setHausnr(this.tfHausnr.getText().equals("") ? null : this.tfHausnr.getText());
        this.mKunde.setLand(this.tfLand.getText().equals("") ? null : this.tfLand.getText());
        this.mKunde.setPlz(this.tfPlz.getText().equals("") ? null : this.tfPlz.getText());
        this.mKunde.setStadt(this.tfOrt.getText().equals("") ? null : this.tfOrt.getText());
        this.mKunde.setPostfachnr(this.tfPostfachnr.getText().equals("") ? null : this.tfPostfachnr.getText());
        this.mKunde.setTelefonnummer(this.tfTelefonnummer.getText().equals("") ? null : this.tfTelefonnummer.getText());
        this.mKunde.setMobilnummer(this.tfMobilnummer.getText().equals("") ? null : this.tfMobilnummer.getText());
        this.mKunde.setFaxnummer(this.tfFaxnummer.getText().equals("") ? null : this.tfFaxnummer.getText());
        this.mKunde.setEmail(this.tfEmail.getText().equals("") ? null : this.tfEmail.getText());
        this.mKunde.setBemerkung(this.tfBemerkung.getText().equals("") ? null : this.tfBemerkung.getText());
        try {
            SimpleDateFormat formatDatum = new SimpleDateFormat(DATE_FORMAT);
            this.mKunde.setGeburtsDatum(formatDatum.parse(this.tfGeburtsdatum.getText()));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            this.mKunde.setGeburtsDatum((Date)null);
        }
    }

    public JPanel getPanKundenname() {
        return this.panKundenname;
    }

    public JPanel getPanKundennummer() {
        return this.panKundennummer;
    }
}

