/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.RequiredFieldChecker;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JRadioButton;
import de.esg.zub.utilities.viewcomp.JRequiredLabel;
import de.esg.zub.utilities.viewcomp.JTextArea;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.resources.Resource;

public class PrintDialog
extends AbstractDialog {
    private Konfiguration konfig;
    private JPanel optionPanel;
    private JPanel inputPanel;
    private JPanel errorPanel;
    private ArrayList<JRadioButton> actions = new ArrayList();
    private ArrayList<JLabel> actionsLab = new ArrayList();
    private ArrayList<JRadioButton> howToPrint = new ArrayList();
    private ArrayList<JLabel> howToPrintLab = new ArrayList();
    private ArrayList<JCheckBox> whatToPrint = new ArrayList();
    private ArrayList<JLabel> whatToPrintLab = new ArrayList();
    private String mode = "PRINT";
    private boolean areButtonsEnabled = true;
    private JPanel wie;
    private JPanel was;
    private JPanel aktion;
    private Color borderColor;
    private Color borderTitleColor;
    private int wieWasAktionBorderThickly;
    private int contentBorderThickly;
    private Font borderTitleFont;
    private JPanel betreffPanel;
    private JPanel left_right;
    private JPanel right;
    private JPanel left;
    private RequiredFieldChecker checker = new RequiredFieldChecker(Resource.getInstance().getErrormessageFelder());
    private JTextField faxFieldL;
    private JRequiredLabel anFax;
    private JRequiredLabel betreffFax;
    private JTextField betreffFaxField;
    private JRequiredLabel faxLeft;
    private JRequiredLabel von;
    private JRequiredLabel faxRight;
    private JRequiredLabel telRight;
    private JTextField anField1;
    private JTextField anField2;
    private JTextField anField3;
    private JTextField vonField1;
    private JTextField vonField2;
    private JTextField vonField3;
    private JTextField faxFieldR;
    private JTextField telFieldR;
    private JLabel anEmail;
    private JTextField anEmailField;
    private JLabel vonEmail;
    private JTextField vonEmailField;
    private JRequiredLabel anEmailEmail;
    private JRequiredLabel vonEmailEmail;
    private JRequiredLabel nameEmail;
    private JTextField nameEmailField;
    private JRequiredLabel betreffEmail;
    private JTextField betreffEmailField;
    private JLabel freitextEmail;
    private JTextArea freitextEmailField;
    public static final String ANGEBOT_DRUCKEN = "als Angebot";
    public static final String ANFRAGE_DRUCKEN = "Als Anfrage";
    public static final String KALKULATION = "Produktinfo";
    public static final String HOWTOPRINT = "1. Wie";
    public static final String WHATTOPRINT = "2. Mit";
    public static final String PRINTACTION = "3. Aktion";
    private static final Color COLOR_PFLICHTFELD = Color.RED;
    private boolean mailServerAktiv = false;
    private int height = 0;
    private static final int BASE_DIALOG_WIDTH = 640;
    private static final int BASE_DIALOG_HEIGHT = 240;
    private JLabel labPflichtfeldEmail;
    private JLabel labPflichtfeldFax;

    public PrintDialog(JFrame owner, String title, MarkenLayout markenLayout, Dimension dialogSize) {
        super(owner, title, markenLayout, dialogSize);
        this.mDialog.setDefaultCloseOperation(2);
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.getContentPane().setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mDialog.setModal(true);
        this.mDialog.setResizable(false);
        this.height = dialogSize.height;
        this.was = new JPanel(new GridBagLayout());
        this.was.setPreferredSize(new Dimension(177, 120));
        this.was.setMinimumSize(new Dimension(177, 120));
        this.wie = new JPanel(new GridBagLayout());
        this.wie.setPreferredSize(new Dimension(177, 120));
        this.wie.setMinimumSize(new Dimension(177, 120));
        this.aktion = new JPanel(new GridBagLayout());
        this.aktion.setPreferredSize(new Dimension(177, 120));
        this.aktion.setMinimumSize(new Dimension(177, 120));
        this.betreffFax = new JRequiredLabel(Resource.getInstance().getBetreff() + ":", 4);
        this.betreffFax.setSmallboldFont();
        this.betreffFaxField = new JTextField(30);
        this.anFax = new JRequiredLabel(Resource.getInstance().getAn() + ":", 4);
        this.anFax.setSmallboldFont();
        this.faxLeft = new JRequiredLabel(Resource.getInstance().getFax() + ":", 4);
        this.faxLeft.setSmallboldFont();
        this.anEmail = new JLabel(Resource.getInstance().getAn(), 2);
        this.anEmail.setSmallboldFont();
        this.anEmailField = new JTextField(35);
        this.anEmailEmail = new JRequiredLabel(Resource.getInstance().getEmail(), 4);
        this.anEmailEmail.setSmallboldFont();
        this.vonEmailEmail = new JRequiredLabel(Resource.getInstance().getEmail(), 4);
        this.vonEmailEmail.setSmallboldFont();
        this.vonEmail = new JLabel(Resource.getInstance().getVon(), 2);
        this.vonEmail.setSmallboldFont();
        this.vonEmailField = new JTextField(35);
        this.nameEmail = new JRequiredLabel(Resource.getInstance().getName(), 4);
        this.nameEmailField = new JTextField(35);
        this.betreffEmail = new JRequiredLabel(Resource.getInstance().getBetreff(), 2);
        this.betreffEmail.setSmallboldFont();
        this.betreffEmailField = new JTextField(35);
        this.freitextEmail = new JLabel(Resource.getInstance().getFreitext(), 2);
        this.freitextEmail.setSmallboldFont();
        this.freitextEmailField = new JTextArea(3, 35);
        this.freitextEmailField.setEditable(true);
        this.von = new JRequiredLabel(Resource.getInstance().getVon() + ":", 4);
        this.von.setSmallboldFont();
        this.vonField1 = new JTextField(28);
        this.vonField2 = new JTextField(28);
        this.vonField3 = new JTextField(28);
        this.faxRight = new JRequiredLabel(Resource.getInstance().getFax() + ":", 4);
        this.faxRight.setSmallboldFont();
        this.faxFieldR = new JTextField(28);
        this.telRight = new JRequiredLabel(Resource.getInstance().getTelefon() + ":", 4);
        this.telRight.setSmallboldFont();
        this.telFieldR = new JTextField(28);
        this.labPflichtfeldEmail = new JLabel("* " + Resource.getInstance().getPflichtfeld());
        this.labPflichtfeldEmail.setForeground(COLOR_PFLICHTFELD);
        this.labPflichtfeldFax = new JLabel("* " + Resource.getInstance().getPflichtfeld());
        this.labPflichtfeldFax.setForeground(COLOR_PFLICHTFELD);
    }

    @Override
    public void hideDialog() {
        if (this.mDialog.isVisible()) {
            this.mDialog.setVisible(false);
        }
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.setDialogLocation();
        this.setPrintDialog();
        this.setLayout(markenLayout);
        if ((this.konfig == null || this.konfig.getKonfigurationsId() == 0 || WorkflowController.getInstance().isNewKonfiguration() || WorkflowController.getInstance().isAddKonfiguration()) && (WorkflowController.getInstance().getActiveState().getName().equals("MARKETING") || WorkflowController.getInstance().getActiveState().getName().equals("FBI"))) {
            this.setMarketingOnly();
        } else if (this.konfig.getAngebot() != null && this.konfig.getAngebot().getAngebotsnummer() != 0) {
            this.setAngebotOnly();
            this.setAngebotsSichtenAktiv(this.konfig.getAngebot().isGeladen());
        } else if (this.konfig instanceof ClientKonfiguration && !((ClientKonfiguration)this.konfig).isKalkulationSet()) {
            this.setOhneAngebot();
        }
        this.setActionButtonEnabled(false);
        this.getActionButton().setEnabled(false);
        boolean selectionFlag = false;
        for (JCheckBox box : this.getWhatToPrint()) {
            if (!box.isSelected()) continue;
            this.setActionButtonEnabled(true);
            this.getActionButton().setEnabled(true);
            selectionFlag = true;
        }
        if (selectionFlag) {
            this.getActionButton().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.getActionButton().setCursor(Cursor.getPredefinedCursor(0));
        }
        this.setRequiredFields();
        this.mDialog.setCursor(Cursor.getPredefinedCursor(0));
        this.mDialog.setVisible(true);
        this.mDialog.validate();
    }

    private void setAngebotsSichtenAktiv(boolean onlyKalkulation) {
        if (!onlyKalkulation) {
            return;
        }
        for (JCheckBox box : this.getWhatToPrint()) {
            if (box.getName().equals(Resource.getInstance().getKalkulationsinfo())) {
                box.setEnabled(false);
                box.setSelected(true);
                continue;
            }
            box.setEnabled(false);
            box.setSelected(false);
        }
    }

    private void setAngebotOnly() {
        for (JCheckBox box : this.getWhatToPrint()) {
            if (box.getName().equals(Resource.getInstance().getKalkulationsinfo())) {
                box.setEnabled(false);
                box.setSelected(true);
                continue;
            }
            box.setEnabled(true);
            box.setSelected(false);
        }
        for (JRadioButton radio : this.getHowToPrint()) {
            if (radio.getName().equals(ANGEBOT_DRUCKEN)) {
                radio.setEnabled(true);
                radio.setSelected(true);
                continue;
            }
            radio.setSelected(false);
            radio.setEnabled(false);
        }
    }

    private void setOhneAngebot() {
        for (JCheckBox box : this.getWhatToPrint()) {
            if (box.getName().equals(Resource.getInstance().getKalkulationsinfo())) {
                box.setEnabled(false);
            } else {
                box.setEnabled(true);
            }
            box.setSelected(false);
        }
        for (JRadioButton radio : this.getHowToPrint()) {
            if (radio.getName().equals(ANFRAGE_DRUCKEN)) {
                radio.setEnabled(true);
                radio.setSelected(true);
                continue;
            }
            radio.setSelected(false);
            radio.setEnabled(false);
        }
    }

    private void setMarketingOnly() {
        for (JCheckBox box : this.getWhatToPrint()) {
            if (box.getName().equals(Resource.getInstance().getMarketinginfo())) {
                box.setEnabled(true);
                box.setSelected(true);
                continue;
            }
            box.setSelected(false);
            box.setEnabled(false);
        }
        this.setActionButtonEnabled(true);
        for (JRadioButton radio : this.getHowToPrint()) {
            if (radio.getName().equals(ANFRAGE_DRUCKEN)) {
                radio.setEnabled(true);
                radio.setSelected(true);
                continue;
            }
            radio.setSelected(false);
            radio.setEnabled(false);
        }
    }

    private void setPrintDialog() {
        this.mDialog.getContentPane().setLayout(new GridBagLayout());
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel(new GridBagLayout());
            this.optionPanel.setPreferredSize(this.mDialogSize);
            this.optionPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        } else {
            this.optionPanel.removeAll();
        }
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 1, 10, new Insets(0, 0, 0, 0));
        this.optionPanel.add(this.getErrorPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(10, 0, 10, 10));
        this.optionPanel.add((Component)this.setWie(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(10, 0, 10, 10));
        this.optionPanel.add((Component)this.setWas(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(10, 0, 10, 0));
        this.optionPanel.add((Component)this.setAktion(), gbc);
        JLabel empty = new JLabel("");
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 1, 1, 1, 0.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        this.optionPanel.add((Component)empty, gbc);
        this.mDialog.getContentPane().removeAll();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 10, new Insets(0, 10, 0, 10));
        this.mDialog.getContentPane().add((Component)this.optionPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mDialog.getContentPane().add((Component)this.setButtonsPanel(Resource.getInstance().getDrucken(), Resource.getInstance().getAbbrechen(), false, 15, 200), gbc);
        this.setDruckenPanel();
        this.setStartMarks();
    }

    private Component getErrorPanel() {
        if (this.errorPanel == null) {
            this.errorPanel = new JPanel();
            this.errorPanel.setLayout(new GridBagLayout());
        }
        this.errorPanel.removeAll();
        this.errorPanel.setVisible(false);
        return this.errorPanel;
    }

    public void setError(String message) {
        this.errorPanel.setVisible(true);
        this.errorPanel.removeAll();
        String[] labels = message.split("\n");
        int row = 0;
        for (String str : labels) {
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, row, 1, 1, 1.0, 0.0, 1, 10, new Insets(0, 0, 0, 0));
            JLabel label = new JLabel(str, 0);
            label.setBoldFont();
            label.setForeground(COLOR_PFLICHTFELD);
            label.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.errorPanel.add((Component)label, gbc);
            ++row;
        }
        this.errorPanel.validate();
        this.setSizeAndLocation();
    }

    private void setSizeAndLocation(int baseWidth, int baseHeight) {
        this.mDialog.validate();
        this.mDialog.setPreferredSize(new Dimension(baseWidth, baseHeight));
        this.mDialog.setSize(new Dimension(baseWidth, baseHeight));
        this.setDialogLocation();
        this.mDialog.validate();
    }

    private void setBaseSizeAndLocation() {
        this.mDialog.validate();
        this.mDialog.setPreferredSize(new Dimension(640, 240));
        this.mDialog.setSize(new Dimension(640, 240));
        this.setDialogLocation();
        this.mDialog.validate();
    }

    private void setSizeAndLocation() {
        this.mDialog.validate();
        this.mDialog.setSize(new Dimension(this.mDialog.getWidth(), this.height + this.errorPanel.getHeight()));
        this.setDialogLocation();
        this.mDialog.validate();
    }

    public void clearErrors() {
        this.errorPanel.setVisible(false);
        this.errorPanel.removeAll();
        this.errorPanel.validate();
    }

    private void setStartMarks() {
        this.howToPrint.get(0).setSelected(true);
        this.actions.get(0).setSelected(true);
        for (int i = 0; i < this.whatToPrint.size(); ++i) {
            this.whatToPrint.get(i).setSelected(false);
        }
    }

    private JPanel setWie() {
        if (this.howToPrint.isEmpty() && this.howToPrintLab.isEmpty()) {
            int i;
            JRadioButton radio = new JRadioButton();
            radio.setActionCommand(Resource.getInstance().getAnfrageDrucken());
            radio.setName(ANFRAGE_DRUCKEN);
            radio.setOpaque(false);
            radio.setEnabled(true);
            this.howToPrint.add(radio);
            JLabel label = new JLabel(radio.getActionCommand(), 2);
            this.howToPrintLab.add(label);
            radio = new JRadioButton();
            radio.setActionCommand(Resource.getInstance().getAngebotDrucken());
            radio.setName(ANGEBOT_DRUCKEN);
            radio.setOpaque(false);
            radio.setEnabled(true);
            this.howToPrint.add(radio);
            label = new JLabel(radio.getActionCommand(), 2);
            this.howToPrintLab.add(label);
            ButtonGroup group = new ButtonGroup();
            for (i = 0; i < this.howToPrint.size(); ++i) {
                group.add(this.howToPrint.get(i));
            }
            this.wie.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.wie.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.borderColor), Resource.getInstance().getWie(), 0, 0, this.borderTitleFont, this.borderTitleColor));
            for (i = 0; i < this.howToPrint.size(); ++i) {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, i, 1, 1, 0.0, 0.0, 0, 18, new Insets(5, 5, 5, 5));
                this.wie.add((Component)this.howToPrint.get(i), gbc);
                gbc = this.mMarkenLayout.setGridBagConstraints(1, i, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 5));
                this.wie.add((Component)this.howToPrintLab.get(i), gbc);
            }
        } else {
            for (JRadioButton button : this.howToPrint) {
                button.setEnabled(true);
                button.setSelected(false);
            }
        }
        this.setChanged();
        this.notifyObservers(HOWTOPRINT);
        return this.wie;
    }

    private JPanel setAktion() {
        if (this.actions.isEmpty() && this.actionsLab.isEmpty()) {
            int i;
            this.actions = new ArrayList();
            JRadioButton radio = new JRadioButton();
            radio.setSelected(true);
            radio.setActionCommand(Resource.getInstance().getDrucken());
            radio.setName("print");
            this.actions.add(radio);
            JLabel label = new JLabel(radio.getActionCommand(), 2);
            this.actionsLab.add(label);
            radio = new JRadioButton();
            radio.setActionCommand(Resource.getInstance().getAlsFaxDrucken());
            radio.setName("fax");
            this.actions.add(radio);
            label = new JLabel(radio.getActionCommand(), 2);
            this.actionsLab.add(label);
            radio = new JRadioButton();
            radio.setActionCommand(Resource.getInstance().getAlsEMailVersenden());
            radio.setName("email");
            radio.setEnabled(this.mailServerAktiv);
            this.actions.add(radio);
            label = new JLabel(radio.getActionCommand(), 2);
            this.actionsLab.add(label);
            ButtonGroup group = new ButtonGroup();
            for (i = 0; i < this.actions.size(); ++i) {
                group.add(this.actions.get(i));
            }
            this.aktion.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.borderColor), Resource.getInstance().getAktion(), 0, 0, this.borderTitleFont, this.borderTitleColor));
            for (i = 0; i < this.actions.size(); ++i) {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, i, 1, 1, 0.0, 0.0, 0, 18, new Insets(5, 5, 5, 5));
                this.aktion.add((Component)this.actions.get(i), gbc);
                gbc = this.mMarkenLayout.setGridBagConstraints(1, i, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 5));
                this.aktion.add((Component)this.actionsLab.get(i), gbc);
            }
            this.setChanged();
            this.notifyObservers(PRINTACTION);
        }
        return this.aktion;
    }

    private JPanel setWas() {
        if (this.whatToPrint.isEmpty() && this.whatToPrintLab.isEmpty()) {
            JCheckBox check = new JCheckBox();
            check.setName(Resource.getInstance().getMarketinginfo());
            check.setEnabled(true);
            this.whatToPrint.add(check);
            JLabel label = new JLabel(Resource.getInstance().getMarketinginfo(), 2);
            this.whatToPrintLab.add(label);
            check = new JCheckBox();
            check.setName(Resource.getInstance().getTechnischeinfo());
            check.setEnabled(true);
            this.whatToPrint.add(check);
            label = new JLabel(Resource.getInstance().getTechnischeinfo(), 2);
            this.whatToPrintLab.add(label);
            check = new JCheckBox();
            check.setName(Resource.getInstance().getKalkulationsinfo());
            check.setEnabled(true);
            this.whatToPrint.add(check);
            label = new JLabel(Resource.getInstance().getKalkulationsinfo(), 2);
            this.whatToPrintLab.add(label);
            this.was.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.borderColor), Resource.getInstance().getWas(), 0, 0, this.borderTitleFont, this.borderTitleColor));
            for (int i = 0; i < this.whatToPrint.size(); ++i) {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, i, 1, 1, 0.0, 0.0, 0, 18, new Insets(5, 5, 5, 5));
                this.was.add((Component)this.whatToPrint.get(i), gbc);
                this.whatToPrintLab.add(i, new JLabel(this.whatToPrint.get(i).getName(), 2));
                gbc = this.mMarkenLayout.setGridBagConstraints(1, i, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 5));
                this.was.add((Component)this.whatToPrintLab.get(i), gbc);
            }
            this.setChanged();
            this.notifyObservers(WHATTOPRINT);
        } else {
            for (JCheckBox button : this.whatToPrint) {
                button.setEnabled(true);
            }
        }
        return this.was;
    }

    public void setFaxPanel() {
        GridBagConstraints gbc;
        if (this.betreffPanel == null && this.left_right == null) {
            this.betreffPanel = new JPanel(new GridBagLayout());
            this.betreffPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 17, new Insets(0, 0, 0, 3));
            this.betreffPanel.add((Component)this.betreffFax, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(0, 0, 0, 3));
            this.betreffPanel.add((Component)this.betreffFaxField, gbc);
            this.left_right = new JPanel(new GridBagLayout());
            this.left_right.setBackground(this.mMarkenLayout.getPrimaryBackground());
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(0, 0, 0, 5));
            this.left_right.add((Component)this.createFaxLeft(), gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 1, 13, new Insets(0, 5, 0, 0));
            this.left_right.add((Component)this.createFaxRight(), gbc);
            this.betreffPanel.validate();
            this.left_right.validate();
        }
        if (this.inputPanel == null) {
            this.inputPanel = new JPanel(new GridBagLayout());
            this.inputPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.inputPanel.setPreferredSize(new Dimension(640, 240));
            this.inputPanel.setMinimumSize(new Dimension(640, 240));
        } else {
            this.inputPanel.removeAll();
        }
        if (this.mode.equals("PRINT")) {
            this.inputPanel.setVisible(true);
            this.mDialog.setSize(new Dimension(640, 460));
            this.height = 480;
            this.mDialog.getContentPane().validate();
        }
        this.inputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.contentBorderThickly, this.contentBorderThickly, this.contentBorderThickly, this.contentBorderThickly, this.borderColor), Resource.getInstance().getAlsFaxDrucken(), 0, 0, this.borderTitleFont, this.borderTitleColor));
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(10, 15, 5, 15));
        this.inputPanel.add((Component)this.betreffPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 5, 5, 15));
        this.inputPanel.add((Component)this.left_right, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 5, 0));
        this.inputPanel.add((Component)this.labPflichtfeldFax, gbc);
        this.inputPanel.validate();
        this.mDialog.getContentPane().removeAll();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(0, 20, 0, 20));
        this.mDialog.getContentPane().add((Component)this.optionPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 10, new Insets(10, 20, 10, 20));
        this.mDialog.getContentPane().add((Component)this.inputPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mDialog.getContentPane().add((Component)this.mButtonPanel, gbc);
        this.mode = "FAX";
        this.actionButton.setText(Resource.getInstance().getAlsFaxDrucken());
        this.mDialog.validate();
        this.clearErrors();
        this.setSizeAndLocation(640, this.height);
    }

    public void setEmailPanel() {
        JScrollPane scrollPane = new JScrollPane(this.freitextEmailField, 20, 31);
        if (this.inputPanel == null) {
            System.out.println("in setFaxPanel if");
            this.inputPanel = new JPanel(new GridBagLayout());
            this.inputPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.height = 210;
            this.inputPanel.setPreferredSize(new Dimension(640, this.height));
            this.inputPanel.setMinimumSize(new Dimension(640, this.height));
        } else {
            this.inputPanel.removeAll();
        }
        if (this.mode.equals("PRINT")) {
            this.inputPanel.setVisible(true);
            this.height = 460;
            this.mDialog.setSize(new Dimension(640, this.height));
            this.mDialog.getContentPane().validate();
        }
        this.inputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.contentBorderThickly, this.contentBorderThickly, this.contentBorderThickly, this.contentBorderThickly, this.borderColor), Resource.getInstance().getAlsEMailVersenden(), 0, 0, this.borderTitleFont, this.borderTitleColor));
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 3, 5, 15));
        this.inputPanel.add((Component)this.anEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 0, 5, 15));
        this.inputPanel.add((Component)this.anEmailEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 1, 12, new Insets(10, 0, 5, 15));
        this.inputPanel.add((Component)this.anEmailField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 3, 5, 15));
        this.inputPanel.add((Component)this.vonEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)this.nameEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 1, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)this.nameEmailField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)this.vonEmailEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 1, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)this.vonEmailField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 3, 5, 15));
        this.inputPanel.add((Component)this.betreffEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 1, 12, new Insets(0, 0, 5, 15));
        this.inputPanel.add((Component)this.betreffEmailField, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 0, 18, new Insets(0, 3, 10, 15));
        this.inputPanel.add((Component)this.freitextEmail, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 1, 12, new Insets(0, 0, 10, 15));
        this.inputPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 1, 12, new Insets(0, 0, 10, 15));
        this.inputPanel.add((Component)scrollPane, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 1, 18, new Insets(0, 0, 10, 15));
        this.inputPanel.add((Component)this.labPflichtfeldEmail, gbc);
        this.inputPanel.validate();
        this.mDialog.getContentPane().removeAll();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 10, new Insets(0, 20, 0, 20));
        this.mDialog.getContentPane().add((Component)this.optionPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 10, new Insets(10, 20, 10, 20));
        this.mDialog.getContentPane().add((Component)this.inputPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mDialog.getContentPane().add((Component)this.mButtonPanel, gbc);
        this.mDialog.getContentPane().validate();
        this.mode = "EMAIL";
        this.actionButton.setText(Resource.getInstance().getAlsEMailVersenden());
        this.mDialog.validate();
        this.clearErrors();
        this.setSizeAndLocation(640, this.height);
    }

    public void setDruckenPanel() {
        if (this.mode.equals("FAX") || this.mode.equals("EMAIL") || !this.mDialog.isVisible()) {
            if (this.inputPanel != null) {
                this.inputPanel.setVisible(false);
            }
            this.mDialog.setSize(new Dimension(240, 640));
            this.setLayout(this.mMarkenLayout);
            this.mDialog.validate();
            this.mDialog.getContentPane().validate();
            this.mode = "PRINT";
        }
        this.actionButton.setText(Resource.getInstance().getDrucken());
        this.clearErrors();
        this.setBaseSizeAndLocation();
    }

    private JPanel createFaxLeft() {
        if (this.left == null) {
            this.left = new JPanel(new GridBagLayout());
            this.left.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.anField1 = new JTextField(28);
            this.anField2 = new JTextField(28);
            this.anField3 = new JTextField(28);
            this.faxFieldL = new JTextField(28);
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 10, 0, 3));
            this.left.add((Component)this.anFax, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 12, new Insets(10, 0, 0, 0));
            this.left.add((Component)this.anField1, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 12, new Insets(5, 10, 0, 3));
            this.left.add((Component)new JLabel(""), gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, 12, new Insets(5, 0, 0, 0));
            this.left.add((Component)this.anField2, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(5, 10, 0, 3));
            this.left.add((Component)new JLabel(""), gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 2, 12, new Insets(5, 0, 0, 0));
            this.left.add((Component)this.anField3, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(5, 10, 0, 3));
            this.left.add((Component)this.faxLeft, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 2, 12, new Insets(5, 0, 0, 0));
            this.left.add((Component)this.faxFieldL, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 0, 12, new Insets(5, 10, 13, 3));
            this.left.add((Component)new JLabel(" "), gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 0, 12, new Insets(5, 0, 13, 0));
            this.left.add((Component)new JLabel(" "), gbc);
            this.left.validate();
        }
        return this.left;
    }

    private JPanel createFaxRight() {
        this.right = new JPanel(new GridBagLayout());
        this.right.setBackground(this.mMarkenLayout.getPrimaryBackground());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 0, 0, 3));
        this.right.add((Component)this.von, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 12, new Insets(10, 0, 0, 5));
        this.right.add((Component)this.vonField1, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 12, new Insets(5, 0, 0, 3));
        this.right.add((Component)new JLabel(""), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, 12, new Insets(5, 0, 0, 5));
        this.right.add((Component)this.vonField2, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(5, 0, 0, 3));
        this.right.add((Component)new JLabel(""), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 2, 12, new Insets(5, 0, 0, 5));
        this.right.add((Component)this.vonField3, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(5, 0, 0, 3));
        this.right.add((Component)this.faxRight, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 2, 12, new Insets(5, 0, 0, 5));
        this.right.add((Component)this.faxFieldR, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 0, 12, new Insets(5, 0, 7, 3));
        this.right.add((Component)this.telRight, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 2, 12, new Insets(5, 0, 7, 5));
        this.right.add((Component)this.telFieldR, gbc);
        return this.right;
    }

    public ArrayList<JRadioButton> getActions() {
        return this.actions;
    }

    public JDialog getPrintDialog() {
        return this.mDialog;
    }

    public ArrayList<JCheckBox> getWhatToPrint() {
        return this.whatToPrint;
    }

    public boolean areButtonsEnabled() {
        return this.areButtonsEnabled;
    }

    public void setLayout(MarkenLayout layout) {
        int i;
        this.mMarkenLayout = layout;
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.optionPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        if (this.mMarkenLayout.isMINI()) {
            this.borderColor = Constants.Layout.DARKGRAY_COLOR;
            this.borderTitleColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.borderTitleFont = Constants.Layout.getZubBoldFont();
            this.wieWasAktionBorderThickly = 1;
            this.contentBorderThickly = 2;
        } else if (this.mMarkenLayout.isBMWMotorrad()) {
            this.borderColor = Constants.Layout.BLACK_COLOR;
            this.borderTitleColor = Constants.Layout.BLACK_COLOR;
            this.borderTitleFont = Constants.Layout.getZubBoldFont();
            this.wieWasAktionBorderThickly = 1;
            this.contentBorderThickly = 2;
        } else if (this.mMarkenLayout.isBMW() || this.mMarkenLayout.isBMWi()) {
            this.borderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.borderTitleColor = Constants.Layout.DARKGRAY_COLOR;
            this.borderTitleFont = Constants.Layout.getZubBoldFont();
            this.wieWasAktionBorderThickly = 1;
            this.contentBorderThickly = 2;
        }
        this.wie.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.wie.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.borderColor), Resource.getInstance().getWie(), 0, 0, this.borderTitleFont, this.borderTitleColor));
        this.was.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.was.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.borderColor), Resource.getInstance().getWas(), 0, 0, this.borderTitleFont, this.borderTitleColor));
        this.aktion.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.aktion.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.wieWasAktionBorderThickly, this.borderColor), Resource.getInstance().getAktion(), 0, 0, this.borderTitleFont, this.borderTitleColor));
        for (i = 0; i < this.howToPrint.size(); ++i) {
            this.howToPrintLab.get(i).setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.howToPrintLab.get(i).validate();
            this.howToPrintLab.get(i).updateUI();
        }
        for (i = 0; i < this.whatToPrint.size(); ++i) {
            this.whatToPrintLab.get(i).setForeground(this.mMarkenLayout.getPrimaryForeground());
        }
        for (i = 0; i < this.actions.size(); ++i) {
            this.actionsLab.get(i).setForeground(this.mMarkenLayout.getPrimaryForeground());
        }
        if (this.inputPanel != null) {
            this.inputPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        }
        if (this.betreffPanel != null) {
            this.betreffPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        }
        if (this.left_right != null) {
            this.left_right.setBackground(this.mMarkenLayout.getPrimaryBackground());
        }
        if (this.right != null) {
            this.right.setBackground(this.mMarkenLayout.getPrimaryBackground());
        }
        if (this.left != null) {
            this.left.setBackground(this.mMarkenLayout.getPrimaryBackground());
        }
        this.setLabelsLayout();
        if (this.errorPanel != null) {
            this.errorPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        }
    }

    private void setLabelsLayout() {
        this.anFax.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.betreffFax.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.faxLeft.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.von.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.faxRight.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.telRight.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.anEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.vonEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.anEmailEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.vonEmailEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.nameEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.betreffEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.freitextEmail.setForeground(this.mMarkenLayout.getPrimaryForeground());
    }

    public ArrayList<JRadioButton> getHowToPrint() {
        return this.howToPrint;
    }

    public String getFaxBetreff() {
        if (!this.isFax()) {
            return null;
        }
        return this.betreffFaxField.getText();
    }

    public String getFaxSender() {
        if (!this.isFax()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.vonField1.getText());
        if (this.vonField2.getText() != null && this.vonField2.getText().length() > 0) {
            builder.append("\n").append(this.vonField2.getText());
        }
        if (this.vonField3.getText() != null && this.vonField3.getText().length() > 0) {
            builder.append("\n").append(this.vonField3.getText());
        }
        return builder.toString();
    }

    public String getFaxSenderFax() {
        if (!this.isFax()) {
            return null;
        }
        return this.faxFieldR.getText();
    }

    public String getFaxSenderTel() {
        if (!this.isFax()) {
            return null;
        }
        return this.telFieldR.getText();
    }

    public String getFaxReceiver() {
        if (!this.isFax()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.anField1.getText());
        if (this.anField2.getText() != null && this.anField2.getText().length() > 0) {
            builder.append("\n").append(this.anField2.getText());
        }
        if (this.anField3.getText() != null && this.anField3.getText().length() > 0) {
            builder.append("\n").append(this.anField3.getText());
        }
        return builder.toString();
    }

    public String getFaxReceiverFax() {
        if (!this.isFax()) {
            return null;
        }
        return this.faxFieldL.getText();
    }

    private boolean isEmail() {
        return this.mode.equals("EMAIL");
    }

    private boolean isFax() {
        return this.mode.equals("FAX");
    }

    public String getAnEMail() {
        if (!this.isEmail()) {
            return null;
        }
        return this.anEmailField.getText();
    }

    public String getAnName() {
        if (!this.isEmail()) {
            return null;
        }
        return this.nameEmailField.getText();
    }

    public String getVonEmail() {
        if (!this.isEmail()) {
            return null;
        }
        return this.vonEmailField.getText();
    }

    public String getBetreffEmail() {
        if (!this.isEmail()) {
            return null;
        }
        return this.betreffEmailField.getText();
    }

    public String getFreitextEmail() {
        if (!this.isEmail()) {
            return null;
        }
        return this.freitextEmailField.getText();
    }

    public void setRequiredFields() {
        this.checker.clearChecks();
        for (JRadioButton button : this.actions) {
            if (button.getName().equals("fax") && button.isSelected()) {
                this.checker.addRequiredField(this.betreffFaxField, this.betreffFax.getLabel());
                this.checker.addRequiredField(this.anField1, this.anFax.getLabel());
                this.checker.addRequiredField(this.vonField1, this.von.getLabel());
                this.checker.addRequiredField(this.faxFieldL, new JLabel(Resource.getInstance().getAn() + " " + this.faxLeft.getText()));
                this.checker.addRequiredField(this.faxFieldR, new JLabel(Resource.getInstance().getVon() + " " + this.faxRight.getText()));
                this.checker.addRequiredField(this.telFieldR, this.telRight.getLabel());
                continue;
            }
            if (!button.getName().equals("email") || !button.isSelected()) continue;
            this.checker.addRequiredField(this.anEmailField, new JLabel(Resource.getInstance().getAn() + " " + this.anEmailEmail.getText()));
            this.checker.addRequiredField(this.nameEmailField, new JLabel(Resource.getInstance().getVon() + " " + this.nameEmail.getText()));
            this.checker.addRequiredField(this.vonEmailField, new JLabel(Resource.getInstance().getVon() + " " + this.vonEmailEmail.getText()));
            this.checker.addRequiredField(this.betreffEmailField, this.betreffEmail.getLabel());
        }
    }

    public RequiredFieldChecker getChecker() {
        return this.checker;
    }

    public boolean isMailServerAktiv() {
        return this.mailServerAktiv;
    }

    public void setMailServerAktiv(boolean mailServerAktiv) {
        this.mailServerAktiv = mailServerAktiv;
    }

    public Konfiguration getKonfig() {
        return this.konfig;
    }

    public void setKonfig(Konfiguration konfig) {
        this.konfig = konfig;
    }

    public JTextField getNameEmailField() {
        return this.nameEmailField;
    }

    public void setNameEmailField(JTextField nameEmailField) {
        this.nameEmailField = nameEmailField;
    }

    public JTextField getAnField1() {
        return this.anField1;
    }

    public void setAnField1(JTextField anField1) {
        this.anField1 = anField1;
    }

    public JTextField getAnField2() {
        return this.anField2;
    }

    public void setAnField2(JTextField anField2) {
        this.anField2 = anField2;
    }

    public JTextField getAnField3() {
        return this.anField3;
    }

    public void setAnField3(JTextField anField3) {
        this.anField3 = anField3;
    }

    public JTextField getBetreffFaxField() {
        return this.betreffFaxField;
    }

    public JTextField getBetreffEmailField() {
        return this.betreffEmailField;
    }
}

