/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class TabelCellEditorInteger
extends JTextField
implements TableCellEditor,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private static final int LENGTH_MENGE = 4;
    private static String regex = "[0-9]{0,4}";
    private int row;
    private int column;
    private final Color background;
    private final Color foreground;

    public TabelCellEditorInteger(MarkenLayout layout) {
        this.background = layout.getPrimaryBackground();
        this.foreground = layout.getPrimaryForeground();
        this.setHorizontalAlignment(4);
        this.getDocument().addDocumentListener(this);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        this.setBackground(this.background);
        this.setForeground(this.foreground);
        this.validate();
        this.setText(value.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabelCellEditorInteger.this.selectAll();
            }
        });
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
            listener.editingCanceled(event);
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.getText().equals("")) {
            return new Integer(0);
        }
        return new Integer(this.getText());
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.isValidText()) {
            return false;
        }
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
            listener.editingStopped(event);
        }
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    private boolean isValidText() {
        return this.getText().matches(regex);
    }

    private void update() {
        Color color = this.isValidText() ? Color.GREEN : Color.RED;
        this.setBorder(BorderFactory.createLineBorder(color));
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }
}

