/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class TableCellEditorDouble
extends LimitedNumberField
implements TableCellEditor,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private DecimalFormat nf = null;
    private int row;
    private int column;
    private final Color background;
    private final Color foreground;
    private Double mMinvalue = null;

    public TableCellEditorDouble(MarkenLayout layout, Pattern textPatFormatter, Double minvalue) {
        super(textPatFormatter);
        this.background = layout.getPrimaryBackground();
        this.foreground = layout.getPrimaryForeground();
        this.setHorizontalAlignment(4);
        this.getDocument().addDocumentListener(this);
        this.setOpaque(true);
        this.mMinvalue = minvalue;
        this.nf = new DecimalFormat();
        this.nf.setGroupingUsed(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        this.setBackground(this.background);
        this.setForeground(this.foreground);
        this.setText(this.nf.format(new Double(value.toString())));
        this.setFont(Constants.Layout.getZubDefaultFont());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableCellEditorDouble.this.selectAll();
            }
        });
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
            listener.editingCanceled(event);
        }
    }

    @Override
    public Object getCellEditorValue() {
        try {
            String text = this.getText();
            DecimalFormatSymbols dec = this.nf.getDecimalFormatSymbols();
            char decsep = dec.getDecimalSeparator();
            text = decsep == '.' ? text.replace(",", ".") : text.replace(".", ",");
            return this.nf.parseObject(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.getText().length() < 1) {
            if (this.mMinvalue != null) {
                this.setText(this.mMinvalue.toString());
            } else {
                this.setText("0");
            }
        } else {
            String text = this.getText();
            text = text.replace(",", ".");
            if (this.mMinvalue != null && Double.parseDouble(text) < this.mMinvalue) {
                this.setText(this.mMinvalue.toString());
            }
        }
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
            listener.editingStopped(event);
        }
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    private void update() {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }
}

