/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.ConfigurationPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.VorgangKonfigView;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.resources.Resource;

public class ControllerConfigurationPanel
implements Observer,
MouseListener {
    private static final String KONFIGURATION_LOESCHEN_MELDUNG = Resource.getInstance().getLoeschenMeldungKonfiguration();
    private static ControllerConfigurationPanel mInstance = null;
    private static ConfigurationPanel mConfigPanel = null;
    private static final int MAXANZAHLKONFIG = 6;
    private static Logger log;

    private ControllerConfigurationPanel() {
    }

    public static ControllerConfigurationPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerConfigurationPanel();
            log = Logger.getLogger(ControllerMenuBar.class);
            log.debug((Object)"ControllerConfigurationPanel initialisieren");
            ControllerConfigurationPanel.init();
        }
        return mInstance;
    }

    private static void init() {
        Dimension dim = new Dimension(MainController.getInstance().getMainFrame().getMainPanel().getMainPanelDim().width, 20);
        mConfigPanel = new ConfigurationPanel(WorkflowController.getInstance().getMarkenLayout(), dim);
        mConfigPanel.getNewConfigButton().addMouseListener(mInstance);
        mConfigPanel.addObserver(mInstance);
    }

    public void addConfiguration() {
        String konfigurationsName = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().getKonfigurationsName();
        int konfigurationsId = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().getKonfigurationsId();
        mConfigPanel.addConfigurationButton(konfigurationsName, konfigurationsId);
    }

    public boolean checkAnzahlConfiguration() {
        return mConfigPanel.getCountKonfigurationen() + 1 <= 6;
    }

    public void removeAllConfigurations() {
        mConfigPanel.removeAllConfigurations();
    }

    @Override
    public void update(Observable o, Object arg) {
        VorgangKonfigView vView = (VorgangKonfigView)arg;
        vView.getSchliessen().addMouseListener(mInstance);
        vView.getBenennung().addMouseListener(mInstance);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (event.getComponent().getName().startsWith("schliessen_")) {
            Integer id = Integer.valueOf(event.getComponent().getName().substring("schliessen_".length()));
            VorgangKonfigView vorgangView = mConfigPanel.getKonfigurationenButtonHashtable().get(id);
            if (!vorgangView.isSelected()) {
                vorgangView.getSchliessen().setIcon(new ImageIcon(ImageCache.getInstance().getImage(WorkflowController.getInstance().getMarkenLayout().getIconPath() + "schliessen_small_mouseover.gif")));
                vorgangView.validate();
            }
            vorgangView.getSchliessen().setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (event.getComponent().getName().startsWith("schliessen_")) {
            Integer id = Integer.valueOf(event.getComponent().getName().substring("schliessen_".length()));
            VorgangKonfigView vorgangView = mConfigPanel.getKonfigurationenButtonHashtable().get(id);
            if (!vorgangView.isSelected()) {
                vorgangView.getSchliessen().setIcon(new ImageIcon(ImageCache.getInstance().getImage(WorkflowController.getInstance().getMarkenLayout().getIconPath() + "schliessen_small_inaktiv.gif")));
                vorgangView.validate();
            }
            vorgangView.getSchliessen().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            mConfigPanel.getNewConfigButton().setCursor(Cursor.getPredefinedCursor(3));
            event.getComponent().setCursor(Cursor.getPredefinedCursor(3));
            MainController.getInstance().getMainFrame().setBusiCursor();
            if (event.getSource() == mConfigPanel.getNewConfigButton()) {
                if (this.checkAnzahlConfiguration()) {
                    this.handleKonfigurationNeuMouseEvent(event);
                } else {
                    MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(Resource.getInstance().getMaxcountkonfig());
                }
            } else if (event.getComponent().getName().startsWith("text_")) {
                Integer id = Integer.valueOf(((JLabel)event.getComponent()).getName().substring("text_".length()));
                boolean ladePreise = false;
                this.handleKonfigurationMouseEvent(id, true, ladePreise);
                Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
                Vorgang vorgang = anfrage.getVorgang();
                String hauptkat = vorgang.getHauptKategorie().getName();
                String unterkat = vorgang.getUnterKategorie().getName();
                ControllerStatusBar.getInstance().getStatusBar().setConfigurationStatusbar(ControllerStatusBar.createStatusHauptkat(hauptkat), unterkat);
            } else if (event.getComponent().getName().startsWith("schliessen_")) {
                Integer id = Integer.valueOf(event.getComponent().getName().substring("schliessen_".length()));
                String fulName = mConfigPanel.getKonfigurationenButtonHashtable().get(id).getFulName();
                String msg = KONFIGURATION_LOESCHEN_MELDUNG;
                msg = msg.replace("{0}", fulName);
                if (MainController.getInstance().getMainFrame().showConfirmMessage(msg)) {
                    this.handleKonfigurationSchliessen(id);
                }
            }
        }
        finally {
            mConfigPanel.getNewConfigButton().setCursor(Cursor.getPredefinedCursor(0));
            event.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    public void addAllConfigurations(List<String> konfigurationenList, List<Integer> konfigurationsIdList, int lastSelectedKonf, boolean forceReload) {
        this.removeAllConfigurations();
        if (konfigurationenList == null) {
            return;
        }
        for (int i = 0; i < konfigurationenList.size(); ++i) {
            mConfigPanel.addConfigurationButton(konfigurationenList.get(i), konfigurationsIdList.get(i));
        }
        ClientKonfiguration konfig = ClientKonfiguration.getClientKonfiguration();
        if (forceReload) {
            String konfigName = konfig.getKonfigurationsName();
            int idx = 0;
            for (int i = 0; i < mConfigPanel.getReihenfolge().size(); ++i) {
                if (!mConfigPanel.getKonfigurationenButtonHashtable().get(mConfigPanel.getReihenfolge().get(i)).getName().equals(konfigName)) continue;
                idx = i;
                break;
            }
            if (konfigurationenList.size() > 0 && mConfigPanel.getReihenfolge() != null && mConfigPanel.getReihenfolge().size() > 0) {
                boolean ladePreise = forceReload;
                this.handleKonfigurationMouseEvent(mConfigPanel.getReihenfolge().get(idx), false, ladePreise);
            }
        } else {
            ControllerMarketingPanel.getInstance().refreshMarketingPanel(konfig.getMarketingModel());
            String konfigurationSicht = konfig.getLetzteSicht();
            if (konfigurationSicht == null || konfigurationSicht.length() == 0 || konfigurationSicht.equals("failure")) {
                MainController.getInstance().getMainFrame().setDefaultCursor();
                MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(Resource.getInstance().getProduktFehlerMsg());
            } else {
                ClientKonfiguration.getClientKonfiguration().setKalkulationSet(true);
                MainController.getInstance().getMainFrame().setDefaultCursor();
                WorkflowController.getInstance().changeState(konfigurationSicht);
            }
        }
    }

    public void handleKonfigurationSchliessen(Integer id) {
        if (mConfigPanel.getReihenfolge().size() > 1) {
            if (mConfigPanel.getKonfigurationenButtonHashtable().get(id).isSelected()) {
                Integer id_nextSelected = null;
                for (int i = 0; i < mConfigPanel.getReihenfolge().size(); ++i) {
                    if (!mConfigPanel.getReihenfolge().get(i).equals(id)) continue;
                    if (i == 0) {
                        id_nextSelected = mConfigPanel.getReihenfolge().get(i + 1);
                        break;
                    }
                    id_nextSelected = mConfigPanel.getReihenfolge().get(i - 1);
                    break;
                }
                this.deleteKonfigurationFromViewAndDB(id);
                if (id_nextSelected != null) {
                    boolean ladePreise = true;
                    this.handleKonfigurationMouseEvent(id_nextSelected, false, ladePreise);
                }
            } else {
                this.deleteKonfigurationFromViewAndDB(id);
            }
        } else {
            Integer vorgangsId = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getVorgangsId();
            ControllerMenuBar.getInstance().handleVorgangSchliessen(vorgangsId);
        }
    }

    private void deleteKonfigurationFromViewAndDB(Integer id) {
        mConfigPanel.removeConfiguration(id);
        try {
            if (id != 0) {
                KalkulationDataLoader.loescheKonfiguration(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        Vorgang vorgang = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang();
        for (int i = 0; i < vorgang.getKonfigurationsId().size(); ++i) {
            if (Integer.parseInt(vorgang.getKonfigurationsId().get(i).toString()) != id) continue;
            vorgang.getKonfigurationsId().remove(i);
            break;
        }
    }

    public void handleKonfigurationMouseEvent(Integer aktuelleKonfigurationId, boolean save, boolean loadPreise) {
        VorgangKonfigView vorgangView;
        if (aktuelleKonfigurationId == null) {
            return;
        }
        mConfigPanel.selectButton(aktuelleKonfigurationId);
        Integer vorgangsId = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getVorgangsId();
        if (ControllerMenuBar.getInstance().getMenuBar().getVorgaenge().containsKey(vorgangsId) && !(vorgangView = ControllerMenuBar.getInstance().getMenuBar().getVorgaenge().get(vorgangsId)).isSelected()) {
            ControllerMenuBar.getInstance().getMenuBar().selectButton(vorgangsId);
        }
        if (aktuelleKonfigurationId != null && mConfigPanel.getKonfigurationenButtonHashtable().containsKey(aktuelleKonfigurationId)) {
            try {
                MainController.getInstance().getMainFrame().setBusiCursor();
                String konfigurationSicht = null;
                konfigurationSicht = AnfrageHandler.getInstance().ladeKonfiguration(aktuelleKonfigurationId, save, loadPreise);
                if (konfigurationSicht == null || konfigurationSicht.length() == 0 || konfigurationSicht.equals("failure")) {
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                    MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(Resource.getInstance().getProduktFehlerMsg());
                } else {
                    ClientKonfiguration.getClientKonfiguration().setKalkulationSet(true);
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                    WorkflowController.getInstance().changeState(konfigurationSicht);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                log.error((Object)e1.getMessage());
                return;
            }
        }
    }

    public void handleKonfigurationNeuMouseEvent(MouseEvent event) {
        WorkflowController.getInstance().setNewKonfiguration(true);
        WorkflowController.getInstance().setAddKonfiguration(true);
        WorkflowController.getInstance().setAddKonfigurationDataSet(false);
        String activeStateName = WorkflowController.getInstance().getActiveState().getName();
        if (GlobalObjects.getInstance().getIpacData().getAnfrage() != null) {
            try {
                ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(activeStateName);
            }
            catch (Exception e1) {
                log.error((Object)"Error saving Konfiguration data: ", (Throwable)e1);
            }
        }
        mConfigPanel.deselectAllButtons();
        WorkflowController.getInstance().changeState("MARKETING");
    }

    public ConfigurationPanel getConfigurationPanel() {
        return mConfigPanel;
    }
}

