/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.ViewComponent;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HeaderPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JLabel headLabel = null;
    private JLabel empty = null;
    private JLabel empty2 = null;
    private JLabel empty4 = null;
    private String headerName = null;
    private Color borderColor = null;
    private ViewComponent viewComponent;
    private String header;
    private String teaserText;
    private String headLabelTooltip = null;
    private MarkenLayout mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();
    private Color aktuellBackgr;
    private Color aktuellForegr;

    public HeaderPanel(String label, String teaser) {
        this.viewComponent = new ViewComponent();
        this.empty = new JLabel("");
        this.empty2 = new JLabel("");
        this.empty4 = new JLabel("");
        this.headLabel = new JLabel(label);
        this.headLabel.setForeground(this.borderColor);
        this.headLabel.setSmallHeaderFont();
        this.setLayout(new GridBagLayout());
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.aktuellBackgr = this.mMarkenLayout.getPrimaryBackground();
        this.aktuellForegr = this.mMarkenLayout.getPrimaryForeground();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 20, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 50;
        gridBagConstraints.weightx = 0.03;
        gridBagConstraints.fill = 1;
        this.add((Component)this.empty, gridBagConstraints);
        this.empty.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(8, 8, 8, 0, this.borderColor)));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 0, 20, 10);
        gridBagConstraints.ipady = 50;
        gridBagConstraints.weightx = 0.97;
        this.add((Component)this.headLabel, gridBagConstraints);
        this.headLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(8, 0, 8, 8, this.borderColor)));
        this.setVisible(false);
    }

    public void changeSetting(String header, String tooltip, String teaser, String mode, Color borderColor) {
        this.header = header;
        this.headLabelTooltip = tooltip;
        this.headLabel.setText(this.header);
        this.headLabel.setToolTipText(this.headLabelTooltip);
        this.teaserText = teaser;
        this.setBorderColor(borderColor);
        this.updatePanel(mode);
    }

    private void updatePanel(String mode) {
        if (mode == null) {
            mode = "";
        }
        if (this.mMarkenLayout.isBMW() || this.mMarkenLayout.isBMWi()) {
            this.setHeaderBMW(mode);
        } else if (this.mMarkenLayout.isBMWMotorrad()) {
            this.setHeaderMotorrad(mode);
        } else if (this.mMarkenLayout.isMINI()) {
            this.setHeaderMini();
        }
    }

    private void setHeaderMini() {
        this.removeAll();
        this.borderColor = this.mMarkenLayout.getSecondaryForeground();
        this.headLabel.setForeground(this.mMarkenLayout.getSecondaryForeground());
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.aktuellBackgr = this.mMarkenLayout.getPrimaryBackground();
        this.aktuellForegr = this.mMarkenLayout.getPrimaryForeground();
        if (WorkflowController.getInstance().getActiveState().getName().equals("PRODUCTLIST")) {
            this.setBorderColor(ControllerProduktListPanel.getInstance().getHeaderBorderColor());
        } else if (WorkflowController.getInstance().getActiveState().getName().equals("SUBCAT")) {
            this.setBorderColor(MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKategorieBorderColor());
        } else {
            this.setBorderColor(Color.LIGHT_GRAY);
        }
        this.empty.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.empty.setForeground(this.mMarkenLayout.getPrimaryBackground());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.headLabel.setSmallHeaderFont();
        this.setLayout(new GridBagLayout());
        if (this.teaserText.equals("")) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.ipady = 50;
            gbc.weightx = 0.03;
            gbc.fill = 1;
            this.add((Component)this.empty, gbc);
            this.empty.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.mMarkenLayout.getBorderSize(), this.mMarkenLayout.getBorderSize(), this.mMarkenLayout.getBorderSize(), 0, this.borderColor)));
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.weightx = 0.97;
            this.add((Component)this.headLabel, gbc);
            this.headLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.mMarkenLayout.getBorderSize(), 0, this.mMarkenLayout.getBorderSize(), this.mMarkenLayout.getBorderSize(), this.borderColor)));
        } else if (!this.teaserText.equals("")) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 16;
            gbc.insets = new Insets(20, 0, 0, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 0.03;
            gbc.fill = 1;
            this.add((Component)this.empty, gbc);
            this.empty.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.mMarkenLayout.getBorderSize(), this.mMarkenLayout.getBorderSize(), 0, 0, this.borderColor)));
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(20, 0, 0, 0);
            gbc.weightx = 0.97;
            this.headLabel.setBigBoldFont();
            this.add((Component)this.headLabel, gbc);
            this.headLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(this.mMarkenLayout.getBorderSize(), 0, 0, this.mMarkenLayout.getBorderSize(), this.borderColor)));
            gbc.anchor = 11;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.ipady = 0;
            gbc.weightx = 0.03;
            gbc.fill = 1;
            this.empty2.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.empty2.setForeground(this.mMarkenLayout.getPrimaryBackground());
            this.add((Component)this.empty2, gbc);
            this.empty2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(0, this.mMarkenLayout.getBorderSize(), 0, 0, this.borderColor)));
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.weightx = 0.97;
            JLabel textLabel = new JLabel(this.teaserText);
            textLabel.setBigFont();
            textLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.add((Component)textLabel, gbc);
            textLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(0, 0, 0, this.mMarkenLayout.getBorderSize(), this.borderColor)));
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 3;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.ipady = 20;
            gbc.weightx = 1.0;
            this.empty4.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.empty4.setForeground(this.mMarkenLayout.getPrimaryBackground());
            this.empty4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(0, this.mMarkenLayout.getBorderSize(), this.mMarkenLayout.getBorderSize(), this.mMarkenLayout.getBorderSize(), this.borderColor)));
            this.add((Component)this.empty4, gbc);
        }
    }

    private void setHeaderMotorrad(String mode) {
        this.removeAll();
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getPrimaryBackground()));
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.aktuellBackgr = this.mMarkenLayout.getPrimaryBackground();
        this.aktuellForegr = this.mMarkenLayout.getPrimaryForeground();
        GridBagConstraints gbc = new GridBagConstraints();
        if (mode.equals("MARKETING")) {
            boolean isLifestyle = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getUnterkategorie().isLifestyle();
            if (isLifestyle) {
                this.viewComponent.setImage(ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_weiss_schwarz_rahmen.jpg"), 0, 0, 808, 100);
                this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.BLACK));
            } else {
                this.viewComponent.setImage(ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_schwarz_weiss.jpg"), 0, 0, 808, 100);
                this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.WHITE));
            }
            this.headLabel.setSmallHeaderFont();
            this.setLayout(new GridBagLayout());
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
            gbc.ipadx = 808;
            gbc.ipady = 100;
            this.viewComponent.setToolTipText(this.headLabelTooltip);
            this.add((Component)this.viewComponent, gbc);
        } else if (mode.equals("PRODUCTLIST")) {
            boolean isLifestyle = ControllerProduktListPanel.getInstance().isLifestyle();
            if (isLifestyle) {
                this.viewComponent.setImage(ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_weiss_schwarz_rahmen.jpg"), 0, 0, 808, 100);
                this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.BLACK));
            } else {
                this.viewComponent.setImage(ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_schwarz_weiss.jpg"), 0, 0, 808, 100);
                this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.WHITE));
            }
            this.headLabel.setSmallHeaderFont();
            this.setLayout(new GridBagLayout());
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
            gbc.ipadx = 808;
            gbc.ipady = 100;
            this.viewComponent.setToolTipText(this.headLabelTooltip);
            this.add((Component)this.viewComponent, gbc);
        } else if (mode.equals("SUBCAT")) {
            Color fontColor = null;
            Image image = null;
            int i = ControllerSubCategoryPanel.getInstance().getSubcatHeaderImageMode();
            if (i == 0) {
                image = ImageCache.getInstance().getImage("aussenzubehoer/BMW/start_pic_forHeader.jpg");
                fontColor = Color.WHITE;
            } else if (i == -1) {
                image = ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_weiss_schwarz_rahmen.jpg");
                fontColor = Color.BLACK;
            } else {
                image = ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_schwarz_weiss.jpg");
                fontColor = Color.WHITE;
            }
            this.viewComponent.setImage(image, 0, 0, 808, 100);
            this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), fontColor));
            this.headLabel.setSmallHeaderFont();
            this.setLayout(new GridBagLayout());
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
            gbc.ipadx = 808;
            gbc.ipady = 100;
            this.viewComponent.setToolTipText(this.headLabelTooltip);
            this.add((Component)this.viewComponent, gbc);
        } else {
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 20, 0));
            gbc.ipadx = 808;
            gbc.ipady = 120;
            this.viewComponent.setImage(ImageCache.getInstance().getImage("aussenzubehoer/BMW/fussabdruck_schwarz_weiss.jpg"), 0, 0, 808, 120);
            this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.WHITE));
            this.viewComponent.setToolTipText(this.headLabelTooltip);
            this.add((Component)this.viewComponent, gbc);
        }
    }

    private void setHeaderBMW(String mode) {
        this.removeAll();
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.aktuellBackgr = this.mMarkenLayout.getPrimaryBackground();
        this.aktuellForegr = this.mMarkenLayout.getPrimaryForeground();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 808;
        gridBagConstraints.ipady = 120;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        if (mode.equals("MARKETING")) {
            this.setBackground(Color.GRAY);
            this.aktuellBackgr = this.mMarkenLayout.getTertiaryBackground();
            this.aktuellForegr = this.mMarkenLayout.getTertiaryForeground();
            this.borderColor = this.mMarkenLayout.getBorderColor();
            this.headLabel.setSmallHeaderFont();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.ipady = 20;
            gbc.weightx = 0.03;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(50, 0, 0, 0);
            gbc.anchor = 16;
            this.add((Component)new JLabel(), gbc);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.WHITE));
            this.setToolTipText(this.headLabelTooltip);
        } else {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 10;
            gbc.insets = new Insets(0, 0, 20, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.ipadx = 808;
            gbc.ipady = 120;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.aktuellBackgr = this.mMarkenLayout.getPrimaryBackground();
            this.aktuellForegr = this.mMarkenLayout.getPrimaryForeground();
            this.viewComponent.setImage(ImageCache.getInstance().getImage("aussenzubehoer/BMW/auspuffbmw-gross.jpg"), 0, 0, 808, 120);
            this.viewComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), this.header, 1, 5, Constants.Layout.getZubSmallHeaderFont(), Color.WHITE));
            this.viewComponent.setToolTipText(this.headLabelTooltip);
            this.add((Component)this.viewComponent, gbc);
        }
        this.updateUI();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public JLabel getHeadLabel() {
        return this.headLabel;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setHeadLabel(JLabel headLabel) {
        this.headLabel = headLabel;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getTeaserText() {
        return this.teaserText;
    }

    public void setTeaserText(String teaserText) {
        this.teaserText = teaserText;
    }

    public Color getAktuellBackgr() {
        return this.aktuellBackgr;
    }

    public Color getAktuellForegr() {
        return this.aktuellForegr;
    }
}

