/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.admin;

import de.esg.commonclient.GlobalObjects;
import java.util.ArrayList;
import java.util.List;
import webetk.app.MarktIpac;
import webetk.app.admintool.Sprache;
import webetk.app.konfiguration.Nutzer;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.resources.Resource;

public class AdminDataLoader {
    public static List<Nutzer> ladeUserListe() throws Exception {
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
        aUserIdToIgnore.add("score");
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("userids_to_ignore", aUserIdToIgnore);
        GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_BENUTZER);
        if (trfNutzer.getError() != null) {
            throw trfNutzer.getError();
        }
        return (List)trfNutzer.getValue("nutzer_list");
    }

    public static List<FilialeZub> ladeFilialListeZub(String firmaId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        if (firmaId != null) {
            verwaltung.setValue("firma", firmaId);
        }
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LISTE_FILIALEN);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (List)verwaltung.getValue("filialenZUB");
    }

    public static List<MarktIpac> ladeMarktListe() throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LISTE_MAERKTE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        List liste = (List)verwaltung.getValue("marktListeIpac");
        for (MarktIpac markt : liste) {
            if (markt.getMarktId() != 0) continue;
            markt.setName(Resource.getInstance().getAndere());
            break;
        }
        return liste;
    }

    public static NutzerZub ladeNutzerDatenZuUserId(String userId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("user_id", userId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ERMITTLE_USER_INFO);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (NutzerZub)verwaltung.getValue("user");
    }

    public static AufwandsKonfiguration ladeAufwandKonfiguration(String filialId) throws Exception {
        return AdminDataLoader.ladeAufwandKonfiguration(filialId, null, null);
    }

    public static AufwandsKonfiguration ladeAufwandKonfiguration(String filialId, String marke, String produktArt) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("filialid", filialId);
        if (marke != null) {
            verwaltung.setValue("marke", marke);
        }
        if (produktArt != null) {
            verwaltung.setValue("produktart", produktArt);
        }
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ERMITTLE_ARBEIT_KONFIG);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (AufwandsKonfiguration)verwaltung.getValue("arbeitKonfig");
    }

    public static void speichereNutzerDaten(NutzerZub user) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("user", user);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.UPDATE_ZUB_USER);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void speichereFilialDaten(FilialeZub filiale) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("filialeZUB", filiale);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_FILIALDATEN);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void speichereArbeitAlleFilialen(AufwandsKonfiguration konfig, String marke, String produktArt) throws Exception {
        AdminDataLoader.speichereArbeiten(konfig, null, marke, produktArt);
    }

    public static void speichereArbeitAlleMarken(AufwandsKonfiguration konfig, FilialeZub filiale) throws Exception {
        AdminDataLoader.speichereArbeiten(konfig, filiale.getId(), null, null);
    }

    public static void speichereArbeitAlles(AufwandsKonfiguration konfig) throws Exception {
        AdminDataLoader.speichereArbeiten(konfig, null, null, null);
    }

    public static void speichereArbeiten(AufwandsKonfiguration konfig, String filialId, String marke, String produktArt) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        GlobalObjects.getInstance().getIpacData().setPreise(null);
        if (filialId != null) {
            verwaltung.setValue("filialid", filialId);
        }
        if (marke != null) {
            verwaltung.setValue("marke", marke);
        }
        if (produktArt != null) {
            verwaltung.setValue("produktart", produktArt);
        }
        verwaltung.setValue("arbeitKonfig", konfig);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_ARBEIT_KONFIG);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static List<Sprache> listeSprachen() throws Exception {
        TrfHashMap verwaltung = new TrfHashMap(null);
        ArrayList<Sprache> sprachen = new ArrayList<Sprache>();
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LOAD_SETTINGS_SPRACHEN);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        List isoList = (List)verwaltung.getValue("iso_list");
        List regisoList = (List)verwaltung.getValue("regiso_list");
        List benennungList = (List)verwaltung.getValue("benennung_list");
        for (int i = 0; i < isoList.size(); ++i) {
            String regIso = (String)regisoList.get(i);
            regIso = "".equals(regIso) ? "  " : regIso;
            sprachen.add(new Sprache((String)benennungList.get(i), (String)isoList.get(i), regIso));
        }
        return sprachen;
    }

    public static AufwandsKonfiguration ladeMarktAufwandKonfiguration(Integer marktId, String marke, String produktart) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        if (marktId != null) {
            verwaltung.setValue("markt", marktId);
        }
        verwaltung.setValue("marke", marke);
        verwaltung.setValue("produktart", produktart);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.RESET_AW_KONFIG_MARKT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (AufwandsKonfiguration)verwaltung.getValue("arbeitKonfig");
    }

    public static boolean ladeMwstAnzeigen() throws Exception {
        return AdminDataLoader.ladeMwstAnzeigen(null);
    }

    public static boolean ladeMwstAnzeigen(Integer marktId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        if (marktId != null) {
            verwaltung.setValue("markt", marktId);
        }
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ANZEIGE_MWST);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Boolean)verwaltung.getValue("anzeigeMwSt");
    }

    public static boolean isMailServerEingestellt() throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.CHECK_MAILSERVER_ACTIVE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Boolean)verwaltung.getValue("mailServerAktiv");
    }
}

