/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.admin;

import de.esg.zub.configurator.content.admin.ControllerAdminPanel;
import javax.swing.table.DefaultTableModel;
import webetk.WebetkUtils;
import webetk.resources.Resource;

public class AdminTableModel
extends DefaultTableModel {
    private static final String AW_NR = "AW-Nr";
    private static final String AUFWAND_ORGINAL = Resource.getInstance().getAufwandOrginal();
    private static final String AUFWAND_BEZEICHNUNG = Resource.getInstance().getAufwandBezeichnung();
    private static final String ZEIT_IN_MIN = "Zeit AW in Min";
    private static final String PREIS_PRO_AW = Resource.getInstance().getPreisPro() + " AW";
    private String mMarke;
    private String mProduktart;
    private static final long serialVersionUID = 1L;

    public AdminTableModel(Object[][] data, String marke, String produktart) {
        this.mMarke = marke;
        this.mProduktart = produktart;
        this.setDataVector(data, new Object[]{AW_NR, AUFWAND_ORGINAL, AUFWAND_BEZEICHNUNG, ZEIT_IN_MIN, PREIS_PRO_AW});
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0 && column != 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return String.class;
        }
        if (columnIndex == 3) {
            return Double.class;
        }
        if (columnIndex == 4) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.getValueAt(rowIndex, columnIndex).equals(aValue.toString())) {
            ControllerAdminPanel.getInstance().setArbeitenVeraendert(true);
        }
        this.getDataVector().get(rowIndex).set(columnIndex, aValue.toString());
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void setPreise(double[] preise) {
        for (int ii = 0; ii < this.getDataVector().size(); ++ii) {
            this.getDataVector().get(ii).set(4, WebetkUtils.getPriceString(preise[ii]));
            this.fireTableCellUpdated(ii, ii);
        }
    }

    public String[] getAwNummern() {
        String[] awNummern = new String[5];
        for (int ii = 0; ii < this.getDataVector().size(); ++ii) {
            awNummern[ii] = this.getDataVector().get(ii).get(0).toString();
        }
        return awNummern;
    }

    public String getMarke() {
        return this.mMarke;
    }

    public String getProduktart() {
        return this.mProduktart;
    }
}

