/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.anfrage.AnfrageSucheBean;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.ObjectLockedException;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.AnfrageSuche;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.javaclient.utils.BooleanWrapper;

public class AnfragenDataLoader {
    public static List<AnfrageSuche> sucheAnfrage(AnfrageSucheBean suchDaten) throws Exception {
        TrfZubVerwaltung verwaltung = suchDaten.getTrfMap();
        verwaltung.setValue("ispasuche", GlobalObjects.getInstance().getIpacData().isStartedFromISPA());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SUCHE_ANFRAGEN);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (List)verwaltung.getValue("AnfrageErgebnisse");
    }

    public static Anfrage ladeAnfrage(int anfrageId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("anfrageId", anfrageId);
        BooleanWrapper bVINSpecAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bIGDOMAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bVINSpecVerwendenUser = new BooleanWrapper(false);
        BooleanWrapper bIGDOMVerwendenUser = new BooleanWrapper(false);
        FBIDataloader.ermitteleAusstattungUeber(bVINSpecAngeschlossen, bIGDOMAngeschlossen, bVINSpecVerwendenUser, bIGDOMVerwendenUser);
        String sVINSpecKontaktieren = bVINSpecAngeschlossen.getValue() && bVINSpecVerwendenUser.getValue() ? "true" : "false";
        boolean bIGDOMKontaktieren = bIGDOMAngeschlossen.getValue() && bIGDOMVerwendenUser.getValue();
        String sIGDOMKontaktieren = bIGDOMKontaktieren ? "true" : "false";
        verwaltung.setValue("vinspec_schnittstelle_kontaktieren", sVINSpecKontaktieren);
        verwaltung.setValue("igdom_schnittstelle_kontaktieren", sIGDOMKontaktieren);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LADE_ANFRAGE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        Anfrage anfrage = (Anfrage)verwaltung.getValue("anfrage");
        if (anfrage.getVorgang() != null) {
            GlobalObjects.getInstance().getIpacData().setSelectedBnb(anfrage.getVorgang().getBildPos());
            GlobalObjects.getInstance().getIpacData().setSelectedBte(anfrage.getVorgang().getBtNummer());
        }
        return anfrage;
    }

    public static void loescheAnfrage(int anfrageId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("anfrageId", anfrageId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LOESCHE_ANFRAGE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void entsperreAnfrage(int anfrageId) throws ObjectLockedException, Exception {
        if (anfrageId == 0) {
            Logger.getLogger(AnfragenDataLoader.class).warn((Object)"Trying to unlock anfrage with id=0 - please prove workflow");
            return;
        }
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("anfrageId", anfrageId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ENTSPERRE_ANFRAGE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void speichereAnfrage(Anfrage anfrage) throws ObjectLockedException, Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        Konfiguration konfig = anfrage.getVorgang().getKonfiguration();
        if (konfig instanceof ClientKonfiguration) {
            anfrage.getVorgang().setKonfiguration(((ClientKonfiguration)konfig).getKonfiguration());
        }
        verwaltung.setValue("anfrage", anfrage);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_ANFRAGE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }
}

