/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.anfrage;

import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.utilities.ImageCache;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import webetk.app.zub.verwaltung.AnfrageSuche;
import webetk.app.zub.verwaltung.BaseVorgang;
import webetk.resources.Resource;

public class AnfragenTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<Object[][]> mVorgaenge;
    private static final String ANFRAGEN = Resource.getInstance().getNueNr();
    private static final String BENENNUNG = Resource.getInstance().getBenennung();
    private static final String ERSTELLUNGSDATUM = Resource.getInstance().getErstellungsdatum();
    private static final String KUNDENNAME = Resource.getInstance().getKundenname();
    private static final String KUNDENVORNAME = Resource.getInstance().getKundenvorname();
    private static final String KUNDENNUMMER = Resource.getInstance().getKundennummer();
    private static final String BEARBEITER = Resource.getInstance().getBearbeiter();
    private SimpleDateFormat dateFormatter;
    private ArrayList<AnfrageSuche> mAnfragen;
    private ArrayList<int[]> mVorgangsId;
    private static final String MINUS = "MINUS";
    private static final String PLUS = "PLUS";
    private static final String LEER = "LEER";

    public AnfragenTableModel(ArrayList<AnfrageSuche> anfragen) {
        this.mAnfragen = anfragen;
        this.mVorgangsId = new ArrayList();
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
        this.setDataVector(this.createDataVector(anfragen), new Object[]{" ", " ", ANFRAGEN, " ", " ", BENENNUNG, ERSTELLUNGSDATUM, KUNDENNAME, KUNDENVORNAME, KUNDENNUMMER, BEARBEITER});
    }

    private Object[][] createDataVector(ArrayList<AnfrageSuche> anfragen) {
        Object[][] anfragenArray = new Object[anfragen.size()][11];
        for (int i = 0; i < anfragen.size(); ++i) {
            if (anfragen.get(i).getVorgaenge().size() != 1) {
                anfragenArray[i][0] = new ImageIcon(ImageCache.getInstance().getImage("Icons/lupe.gif"));
                anfragenArray[i][1] = new ImageIcon(ImageCache.getInstance().getImage("Icons/recycle.gif"));
                anfragenArray[i][2] = anfragen.get(i).getAnfrageId();
                anfragenArray[i][3] = this.getImageIcon(PLUS);
                anfragenArray[i][4] = new ImageIcon(ImageCache.getInstance().getImage("Icons/space.gif"));
                anfragenArray[i][5] = anfragen.get(i).getBemerkung();
                anfragenArray[i][6] = this.dateFormatter.format(anfragen.get(i).getAnlageDatum());
                anfragenArray[i][7] = anfragen.get(i).getKundeName();
                anfragenArray[i][8] = anfragen.get(i).getKundeVorname();
                anfragenArray[i][9] = anfragen.get(i).getKunde().getKundennummer();
                anfragenArray[i][10] = anfragen.get(i).getErstellerName();
            } else {
                anfragenArray[i][0] = new ImageIcon(ImageCache.getInstance().getImage("Icons/lupe.gif"));
                anfragenArray[i][1] = new ImageIcon(ImageCache.getInstance().getImage("Icons/recycle.gif"));
                anfragenArray[i][2] = anfragen.get(i).getAnfrageId();
                anfragenArray[i][3] = this.getImageIcon(LEER);
                anfragenArray[i][4] = new ImageIcon(ImageCache.getInstance().getImage("Icons/space.gif"));
                anfragenArray[i][5] = anfragen.get(i).getVorgaenge().get(0).getProduktName();
                anfragenArray[i][6] = this.dateFormatter.format(anfragen.get(i).getVorgaenge().get(0).getAnlageDatum());
                anfragenArray[i][7] = anfragen.get(i).getKundeName();
                anfragenArray[i][8] = anfragen.get(i).getKundeVorname();
                anfragenArray[i][9] = anfragen.get(i).getKunde().getKundennummer();
                anfragenArray[i][10] = anfragen.get(i).getErstellerName();
            }
            this.createVorgangsArray((ArrayList)anfragen.get(i).getVorgaenge(), anfragen.get(i));
        }
        return anfragenArray;
    }

    private void createVorgangsArray(ArrayList<BaseVorgang> vorgaenge, AnfrageSuche anfrage) {
        if (this.mVorgaenge == null) {
            this.mVorgaenge = new ArrayList();
        }
        Object[][] vorgangsArray = new Object[vorgaenge.size()][11];
        int[] vorgangsId = new int[vorgaenge.size()];
        if (vorgaenge.size() == 1) {
            this.mVorgaenge.add(vorgangsArray);
            this.mVorgangsId.add(vorgangsId);
            return;
        }
        for (int i = 0; i < vorgaenge.size(); ++i) {
            vorgangsArray[i][0] = new ImageIcon(ImageCache.getInstance().getImage("Icons/space.gif"));
            vorgangsArray[i][1] = new ImageIcon(ImageCache.getInstance().getImage("Icons/recycle.gif"));
            vorgangsArray[i][2] = "";
            vorgangsArray[i][3] = new ImageIcon(ImageCache.getInstance().getImage("Icons/space.gif"));
            vorgangsArray[i][4] = i == vorgaenge.size() - 1 ? new ImageIcon(ImageCache.getInstance().getImage("Icons/astsymbol1.gif")) : new ImageIcon(ImageCache.getInstance().getImage("Icons/astsymbol2.gif"));
            vorgangsArray[i][5] = vorgaenge.get(i).getProduktName();
            vorgangsArray[i][6] = " ";
            vorgangsArray[i][7] = anfrage.getKundeName();
            vorgangsArray[i][8] = anfrage.getKundeVorname();
            vorgangsArray[i][9] = anfrage.getKunde().getKundennummer();
            vorgangsArray[i][10] = anfrage.getErstellerName();
            vorgangsId[i] = vorgaenge.get(i).getVorgangsId();
        }
        this.mVorgaenge.add(vorgangsArray);
        this.mVorgangsId.add(vorgangsId);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ImageIcon.class;
        }
        if (columnIndex == 1) {
            return ImageIcon.class;
        }
        if (columnIndex == 3) {
            return ImageIcon.class;
        }
        if (columnIndex == 4) {
            return ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public void removeRow(int rowIndex) {
        if (((ImageIcon)this.getDataVector().get(rowIndex).get(3)).getDescription() == null) {
            int index = rowIndex;
            int counter = 0;
            while (this.getDataVector().get(index).get(2).equals("")) {
                --index;
                ++counter;
            }
            Object[][] dummy = new Object[this.mVorgaenge.get(index).length - 1][11];
            int position = 0;
            for (int ii = 0; ii < this.mVorgaenge.get(index).length; ++ii) {
                if (ii == counter - 1) continue;
                dummy[position] = this.mVorgaenge.get(index)[ii];
                ++position;
            }
            this.mVorgaenge.remove(index);
            this.mVorgaenge.add(index, dummy);
            if (this.getDataVector().get(rowIndex - 1).get(2).equals("")) {
                this.mVorgaenge.get((int)index)[counter - 2][4] = new ImageIcon(ImageCache.getInstance().getImage("Icons/astsymbol1.gif"));
                this.setValueAt(new ImageIcon(ImageCache.getInstance().getImage("Icons/astsymbol1.gif")), rowIndex - 1, 4);
            }
            this.getDataVector().remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
            if (this.mVorgaenge.get(index).length == 0) {
                ControllerAnfragenPanel.getInstance().checkInaktivAnfrageToDelete(this.getAnfrageIdFromRow(rowIndex - 1));
                this.getDataVector().remove(rowIndex - 1);
                this.fireTableRowsDeleted(rowIndex - 1, rowIndex - 1);
            } else if (!this.getDataVector().get(rowIndex - 1).get(2).equals("")) {
                ControllerAnfragenPanel.getInstance().checkInaktivAnfrageToDelete(this.getAnfrageIdFromRow(rowIndex - 1));
                this.getDataVector().remove(rowIndex - 1);
                this.fireTableRowsDeleted(rowIndex - 1, rowIndex - 1);
            }
        } else if (((ImageIcon)this.getDataVector().get(rowIndex).get(3)).getDescription().equals(LEER) || ((ImageIcon)this.getDataVector().get(rowIndex).get(3)).getDescription().equals(PLUS)) {
            this.getDataVector().remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        } else {
            for (int ii = 0; ii < this.mVorgaenge.get(rowIndex).length; ++ii) {
                if (((ImageIcon)this.getDataVector().get(rowIndex + 1).get(3)).getDescription() != null) continue;
                this.getDataVector().remove(rowIndex + 1);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
            this.mVorgaenge.remove(rowIndex);
            this.getDataVector().remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public void alleAufKlappen() {
        for (int jj = 0; jj < this.getDataVector().size(); ++jj) {
            if (((ImageIcon)this.getDataVector().get(jj).get(3)).getDescription() == null || !((ImageIcon)this.getDataVector().get(jj).get(3)).getDescription().equals(PLUS)) continue;
            this.getDataVector().get(jj).set(3, this.getImageIcon(MINUS));
            int position = 0;
            for (int i = 0; i < this.mAnfragen.size(); ++i) {
                if (new Integer(this.getDataVector().get(jj).get(2).toString()).intValue() != this.mAnfragen.get(i).getAnfrageId()) continue;
                position = i;
            }
            if (this.mVorgaenge.size() < position) continue;
            for (int ii = 0; ii < this.mVorgaenge.get(position).length; ++ii) {
                this.insertRow(jj + ii + 1, this.mVorgaenge.get(position)[ii]);
                this.fireTableRowsInserted(jj + ii + 1, jj + ii + 1);
            }
        }
    }

    public void alleZuKlappen() {
        for (int jj = 0; jj < this.getDataVector().size(); ++jj) {
            if (!((ImageIcon)this.getDataVector().get(jj).get(3)).getDescription().equals(MINUS)) continue;
            this.getDataVector().get(jj).set(3, this.getImageIcon(PLUS));
            int position = 0;
            for (int i = 0; i < this.mAnfragen.size(); ++i) {
                if (new Integer(this.getDataVector().get(jj).get(2).toString()).intValue() != this.mAnfragen.get(i).getAnfrageId()) continue;
                position = i;
            }
            for (int ii = 0; ii < this.mVorgaenge.get(position).length; ++ii) {
                if (((ImageIcon)this.getDataVector().get(jj + 1).get(3)).getDescription() != null) continue;
                this.getDataVector().remove(jj + 1);
                this.fireTableRowsDeleted(jj, jj);
            }
        }
    }

    public int getAnfrageIdFromRow(int rowIndex) {
        if (!this.getDataVector().get(rowIndex).get(2).equals("")) {
            return new Integer(this.getDataVector().get(rowIndex).get(2).toString());
        }
        int index = rowIndex;
        while (this.getDataVector().get(index).get(2).equals("")) {
            --index;
        }
        return new Integer(this.getDataVector().get(index).get(2).toString());
    }

    public int getVorgangsIdFromRow(int rowIndex) {
        int index = rowIndex;
        int counter = 0;
        while (this.getDataVector().get(index).get(2).equals("")) {
            --index;
            ++counter;
        }
        return this.mVorgangsId.get(index)[counter - 1];
    }

    public boolean isRowAnfrage(int rowIndex) {
        return !this.getDataVector().get(rowIndex).get(2).equals("");
    }

    public void aufzuklappen(int rowIndex) {
        block7: {
            block6: {
                if (((ImageIcon)this.getDataVector().get(rowIndex).get(3)).getDescription().equals(LEER)) {
                    return;
                }
                if (!((ImageIcon)this.getDataVector().get(rowIndex).get(3)).getDescription().equals(MINUS)) break block6;
                this.getDataVector().get(rowIndex).set(3, this.getImageIcon(PLUS));
                int position = 0;
                for (int i = 0; i < this.mAnfragen.size(); ++i) {
                    if (new Integer(this.getDataVector().get(rowIndex).get(2).toString()).intValue() != this.mAnfragen.get(i).getAnfrageId()) continue;
                    position = i;
                }
                for (int ii = 0; ii < this.mVorgaenge.get(position).length; ++ii) {
                    if (((ImageIcon)this.getDataVector().get(rowIndex + 1).get(3)).getDescription() != null) continue;
                    this.getDataVector().remove(rowIndex + 1);
                    this.fireTableRowsDeleted(rowIndex, rowIndex);
                }
                break block7;
            }
            if (!((ImageIcon)this.getDataVector().get(rowIndex).get(3)).getDescription().equals(PLUS)) break block7;
            int position = 0;
            for (int i = 0; i < this.mAnfragen.size(); ++i) {
                if (new Integer(this.getDataVector().get(rowIndex).get(2).toString()).intValue() != this.mAnfragen.get(i).getAnfrageId()) continue;
                position = i;
            }
            this.getDataVector().get(rowIndex).set(3, this.getImageIcon(MINUS));
            if (this.mVorgaenge.size() >= position) {
                for (int ii = 0; ii < this.mVorgaenge.get(position).length; ++ii) {
                    this.insertRow(rowIndex + ii + 1, this.mVorgaenge.get(position)[ii]);
                    this.fireTableRowsInserted(rowIndex + ii + 1, rowIndex + ii + 1);
                }
            }
        }
    }

    private ImageIcon getImageIcon(String art) {
        ImageIcon dummy = new ImageIcon(ImageCache.getInstance().getImage("Icons/leer_bmw.gif"));
        if (art.equals(LEER)) {
            dummy = new ImageIcon(ImageCache.getInstance().getImage("Icons/leer_bmw.gif"));
            dummy.setDescription(LEER);
        } else if (art.equals(PLUS)) {
            dummy = new ImageIcon(ImageCache.getInstance().getImage("Icons/plus.gif"));
            dummy.setDescription(PLUS);
        } else if (art.equals(MINUS)) {
            dummy = new ImageIcon(ImageCache.getInstance().getImage("Icons/minus.gif"));
            dummy.setDescription(MINUS);
        }
        return dummy;
    }
}

