/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.angebot;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.configurator.content.angebot.AngebotsSucheBean;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import java.util.List;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.AngebotsSuche;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.javaclient.utils.BooleanWrapper;
import webetk.resources.Resource;

public class AngebotDataLoader {
    public static List<AngebotsSuche> sucheAngebote(AngebotsSucheBean suchDaten) throws Exception {
        TrfZubVerwaltung verwaltung = suchDaten.getTrfMap();
        verwaltung.setValue("ispasuche", false);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SUCHE_ANGEBOTE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (List)verwaltung.getValue("AngebotsErgebnisse");
    }

    public static void loescheAngebot(Angebot angebot, boolean forceDelete) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("AngebotsNr", angebot.getAngebotsnummer());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LOESCHE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void storniereAngebot(Angebot angebot) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("AngebotsNr", angebot.getAngebotsnummer());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.STORNIERE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void storniereAngebot(Konfiguration konfig) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfig.getKonfigurationsId());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.STORNIERE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void storniereAngebot(int konfigId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfigId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.STORNIERE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static Anfrage ladeAngebot(int konfigId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfigId);
        BooleanWrapper bVINSpecAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bIGDOMAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bVINSpecVerwendenUser = new BooleanWrapper(false);
        BooleanWrapper bIGDOMVerwendenUser = new BooleanWrapper(false);
        FBIDataloader.ermitteleAusstattungUeber(bVINSpecAngeschlossen, bIGDOMAngeschlossen, bVINSpecVerwendenUser, bIGDOMVerwendenUser);
        String sVINSpecKontaktieren = bVINSpecAngeschlossen.getValue() && bVINSpecVerwendenUser.getValue() ? "true" : "false";
        boolean bIGDOMKontaktieren = bIGDOMAngeschlossen.getValue() && bIGDOMVerwendenUser.getValue();
        String sIGDOMKontaktieren = bIGDOMKontaktieren ? "true" : "false";
        verwaltung.setValue("vinspec_schnittstelle_kontaktieren", sVINSpecKontaktieren);
        verwaltung.setValue("igdom_schnittstelle_kontaktieren", sIGDOMKontaktieren);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LADE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Anfrage)verwaltung.getValue("anfrage");
    }

    public static Anfrage ersetzeAngebot(Konfiguration konfig) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfiguration", konfig);
        verwaltung.setValue("konfigurationTEXT", Resource.getInstance().getKonfiguration());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.UEBERARBEITE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Anfrage)verwaltung.getValue("anfrage");
    }

    public static Anfrage ersetzeAngebot(int konfigId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfigId);
        verwaltung.setValue("benennung", Resource.getInstance().getKonfiguration());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LADE_KONFIGURATION);
        return AngebotDataLoader.ersetzeAngebot((Konfiguration)verwaltung.getValue("konfiguration"));
    }

    public static int ermittleBindeFrist() throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ERMITTLE_BINDEFRIST);
        int bindeFrist = (Integer)verwaltung.getValue("bindeFrist");
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return bindeFrist;
    }

    public static int ermittleNeueAngebotsnummer() throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ERMITTLE_NEUE_ANGEBOTSNUMMER);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Integer)verwaltung.getValue("AngebotsNr");
    }
}

