/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.angebot;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.angebot.AngebotsTableModel;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class AngebotsTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    MarkenLayout mLayout;

    public AngebotsTableCellRenderer(MarkenLayout layout) {
        this.setBackground(layout.getPrimaryBackground());
        this.setForeground(layout.getPrimaryForeground());
        this.mLayout = layout;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (((AngebotsTableModel)table.getModel()).getAngebote().get(row).isStorniert()) {
            this.setForeground(Color.LIGHT_GRAY);
        } else {
            this.setForeground(Color.BLACK);
        }
        if (column == 0) {
            this.setHorizontalAlignment(0);
            if (value != null) {
                this.setIcon((ImageIcon)value);
            }
            this.setText("");
        } else {
            if (column == 2) {
                this.setHorizontalAlignment(4);
            } else if (column == 4 || column == 5 || column == 7) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            Border b = BorderFactory.createEmptyBorder(0, 6, 0, 2);
            this.setBorder(b);
            String valueString = value == null ? "" : value.toString();
            FontMetrics fontMetrics = this.getFontMetrics(Constants.Layout.getZubDefaultFont());
            this.setText(valueString);
            int textBreite = fontMetrics.stringWidth(valueString);
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            if (textBreite > columnWidth - 5) {
                this.setToolTipText(valueString);
            } else {
                this.setToolTipText(null);
            }
            this.setIcon(null);
        }
        return this;
    }
}

