/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.angebot;

import de.esg.zub.utilities.ImageCache;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import webetk.app.zub.verwaltung.AngebotsSuche;
import webetk.resources.Resource;

public class AngebotsTableModel
extends DefaultTableModel {
    private static final String ANGEBOTSNR = Resource.getInstance().getNueNr();
    private static final String ANGEBOTSNAME = Resource.getInstance().getAngebotsname();
    private static final String ERSTELLUNGSDATUM = Resource.getInstance().getErstellungsdatum();
    private static final String BINDEFRIST = Resource.getInstance().getBindefristBis();
    private static final String ZUSATZINFO = Resource.getInstance().getZusatzinfo();
    private static final String ISPA = "ISPA";
    private SimpleDateFormat dateFormatter;
    private ArrayList<AngebotsSuche> mAngebote;

    public AngebotsTableModel(ArrayList<AngebotsSuche> angebote) {
        this.mAngebote = angebote;
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
        this.setDataVector(this.createDataVector(angebote), new Object[]{" ", " ", ANGEBOTSNR, ANGEBOTSNAME, ERSTELLUNGSDATUM, BINDEFRIST, ZUSATZINFO, ISPA});
    }

    private Object[][] createDataVector(ArrayList<AngebotsSuche> angebote) {
        Object[][] angebotArray = new Object[angebote.size()][11];
        for (int i = 0; i < angebote.size(); ++i) {
            angebotArray[i][0] = new ImageIcon(ImageCache.getInstance().getImage("Icons/lupe.gif"));
            angebotArray[i][1] = false;
            angebotArray[i][2] = angebote.get(i).getAngebotsNummer();
            angebotArray[i][3] = angebote.get(i).getAngebotsName();
            angebotArray[i][4] = this.dateFormatter.format(angebote.get(i).getErstellungsDatum());
            angebotArray[i][5] = this.dateFormatter.format(angebote.get(i).getBindeFrist());
            angebotArray[i][6] = this.createZusatzInfo(angebote.get(i));
            angebotArray[i][7] = angebote.get(i).isAnIspa() ? "X" : "";
        }
        return angebotArray;
    }

    private String createZusatzInfo(AngebotsSuche angebot) {
        String dummy = "";
        if (angebot.getKunde() != null) {
            if (angebot.getKunde().getName() != null && !angebot.getKunde().getName().equals("")) {
                dummy = dummy + angebot.getKunde().getName();
            }
            if (angebot.getKunde().getVorname() != null && !angebot.getKunde().getVorname().equals("")) {
                dummy = dummy + ", " + angebot.getKunde().getVorname();
            }
            if (angebot.getKunde().getKundennummer() != null && !angebot.getKunde().getKundennummer().equals("")) {
                dummy = dummy + "; " + angebot.getKunde().getKundennummer() + " ";
            }
        }
        if (angebot.getVorgang() != null) {
            dummy = dummy + "; " + angebot.getVorgang().getProduktName() + " ";
        }
        return dummy;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.mAngebote.get(row).isStorniert()) {
            return false;
        }
        return column == 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ImageIcon.class;
        }
        if (columnIndex == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    public ArrayList<Integer> getSelectedRows() {
        ArrayList<Integer> selection = new ArrayList<Integer>();
        for (int ii = 0; ii < this.getDataVector().size(); ++ii) {
            if (!this.getDataVector().get(ii).get(1).toString().equals("true")) continue;
            selection.add(ii);
        }
        return selection;
    }

    public void removeSelectedRows() {
        for (int ii = 0; ii < this.getDataVector().size(); ++ii) {
            if (!this.getDataVector().get(ii).get(1).toString().equals("true")) continue;
            this.getDataVector().remove(ii);
            this.fireTableRowsDeleted(ii, ii);
        }
    }

    public int getAngebotsIdFromRow(int rowIndex) {
        return this.mAngebote.get(rowIndex).getKonfigId();
    }

    public AngebotsSuche getAngebotFromRow(int rowIndex) {
        return this.mAngebote.get(rowIndex);
    }

    public ArrayList<AngebotsSuche> getAngebote() {
        return this.mAngebote;
    }

    public void storniereAngebot(int rowIndex) {
        this.mAngebote.get(rowIndex).setStorniert(true);
        this.setValueAt(false, rowIndex, 1);
        this.fireTableCellUpdated(rowIndex, 1);
    }
}

