/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.angebot;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.ControllerPrintDialog;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.configurator.content.angebot.AngebotDataLoader;
import de.esg.zub.configurator.content.angebot.AngebotsPanel;
import de.esg.zub.configurator.content.angebot.AngebotsTableModel;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.ControllerWelcomePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.ObjectLockedException;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.javaclient.framework.MainView;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class ControllerAngebotsPanel
implements MouseListener {
    private static Logger log = Logger.getLogger(ControllerAngebotsPanel.class);
    private AngebotsPanel mAngebotsPanel;
    private static ControllerAngebotsPanel mInstance;
    private int mSelectedRow;
    private ArrayList<Integer> mAllSelectedRows;
    private boolean mAngebotGeladen;
    private static final String LOESCHEN_MELDUNG;
    private static final String AUSWAHL_MELDUNG;
    private static final String AUSWAHL_MELDUNG2;
    private static final String ANFRAGE_GESPERRT;
    private static final String ANFRGE_GESPERRT_MSG;

    private ControllerAngebotsPanel() {
    }

    public static ControllerAngebotsPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerAngebotsPanel();
        }
        return mInstance;
    }

    public void init(Dimension panelSize, MarkenLayout markenLayout) {
        this.mAngebotsPanel = new AngebotsPanel(panelSize, markenLayout);
        this.mAngebotGeladen = false;
        this.addListener();
    }

    private void addListener() {
        this.mAngebotsPanel.getSuchkriterienPanel2().getSearchButton().addMouseListener(mInstance);
        this.mAngebotsPanel.getSuchkriterienPanel2().getResetButton().addMouseListener(mInstance);
        this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().addMouseListener(mInstance);
        this.mAngebotsPanel.getAngebotsTablePanel().getVorlageButton().addMouseListener(mInstance);
        this.mAngebotsPanel.getAngebotsTablePanel().getDruckenButton().addMouseListener(mInstance);
        this.mAngebotsPanel.getAngebotsTablePanel().getLoeschenButton().addMouseListener(mInstance);
    }

    public AngebotsPanel getAngebotsPanel() {
        if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.mAngebotsPanel.getSuchkriterienPanel2().resetFields();
            this.mAngebotsPanel.getAngebotsTablePanel().setVisible(false);
        }
        return this.mAngebotsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent event) {
        block4: {
            try {
                int aktColumn;
                this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().setCursor(Cursor.getPredefinedCursor(3));
                this.mAngebotsPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(3));
                if (event.getClickCount() != 2 || event.getComponent() != this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable() || (aktColumn = this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().columnAtPoint(new Point(event.getX(), event.getY()))) == 1) break block4;
                if (this.mAngebotsPanel.getAngebotsTablePanel().getAngebotIdFromRow(event) != -1) {
                    this.loadAngebote(this.mAngebotsPanel.getAngebotsTablePanel().getAngebotIdFromRow(event));
                    break block4;
                }
                return;
            }
            finally {
                this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().setCursor(Cursor.getPredefinedCursor(0));
                this.mAngebotsPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private void loadAngebote(int angebotId) {
        try {
            Anfrage anfrage = AngebotDataLoader.ladeAngebot(angebotId);
            this.mAngebotGeladen = true;
            ControllerWelcomePanel.setMarkeProduktartGlobal(anfrage.getMarke(), String.valueOf(anfrage.getProduktArt()));
            AnfrageHandler.getInstance().setAnfrage(anfrage);
            WorkflowController.getInstance().changeState("KALKULATION");
            Fahrzeug fzg = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getFahrzeug();
            GlobalObjects.getInstance().getIpacData().setFahrzeug(fzg);
            this.setAngebotStatus(fzg);
            this.mAngebotGeladen = false;
        }
        catch (Exception ex) {
            if (ex instanceof ObjectLockedException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog((Component)MainView.getInstance(), ANFRGE_GESPERRT_MSG, ANFRAGE_GESPERRT, 0);
            }
            ex.printStackTrace();
        }
    }

    public void setAngebotStatus(Fahrzeug fahrzeug) {
        if (fahrzeug != null) {
            ControllerMenuBar.getInstance().getMenuBar().enableIcon("add");
        } else {
            ControllerMenuBar.getInstance().getMenuBar().disableIcon("add");
        }
        ControllerMenuBar.getInstance().getMenuBar().disableIcon("remove");
        ControllerMenuBar.getInstance().getMenuBar().enableMenuSpeichern(false);
        ControllerStatusBar.getInstance().getStatusBar().removeStatus(1);
        ControllerMarketingPanel.getInstance().setAngebotsSicht(true);
        ControllerTechnikPanel.getInstance().setAngebotsSicht(true);
        ControllerKalkulationPanel.getInstance().setAngebotsSicht(true);
        ControllerMiniaturansicht.getInstance().setAngebotsSicht(true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        block30: {
            try {
                this.mAngebotsPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(3));
                this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().setCursor(Cursor.getPredefinedCursor(3));
                if (event.getComponent() == this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable()) {
                    int aktColumn = this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().columnAtPoint(new Point(event.getX(), event.getY()));
                    if (aktColumn != 0) break block30;
                    if (this.mAngebotsPanel.getAngebotsTablePanel().getAngebotIdFromRow(event) != -1) {
                        this.loadAngebote(this.mAngebotsPanel.getAngebotsTablePanel().getAngebotIdFromRow(event));
                        break block30;
                    }
                    return;
                }
                if (event.getComponent() == this.mAngebotsPanel.getSuchkriterienPanel2().getSearchButton()) {
                    try {
                        event.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                        this.sucheAngebote();
                        break block30;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error((Object)e);
                        break block30;
                    }
                    finally {
                        event.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (event.getComponent() == this.mAngebotsPanel.getSuchkriterienPanel2().getResetButton()) {
                    this.mAngebotsPanel.getSuchkriterienPanel2().resetFields();
                    this.mAngebotsPanel.getAngebotsTablePanel().setVisible(false);
                    break block30;
                }
                if (event.getComponent() == this.mAngebotsPanel.getAngebotsTablePanel().getVorlageButton()) {
                    try {
                        event.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                        if (this.checkTableSelection(false)) {
                            this.aendereAngebot(((AngebotsTableModel)this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().getModel()).getAngebotsIdFromRow(this.mSelectedRow));
                        }
                        break block30;
                    }
                    finally {
                        event.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (event.getComponent() == this.mAngebotsPanel.getAngebotsTablePanel().getDruckenButton()) {
                    if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) break block30;
                    try {
                        event.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                        if (!this.checkTableSelection(false)) break block30;
                        try {
                            Anfrage anfrage = AngebotDataLoader.ladeAngebot(((AngebotsTableModel)this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().getModel()).getAngebotsIdFromRow(this.mSelectedRow));
                            GlobalObjects.getInstance().getIpacData().setAnfrage(anfrage);
                            MarkenLayout.setSessionMarke(anfrage.getMarke(), String.valueOf(anfrage.getProduktArt()));
                            WorkflowController.getInstance().setMarkenLayout(Marken.getInstance().getMarke("BMW").getBerechtigung(), Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
                            KalkulationModel model = new KalkulationModel();
                            ClientKonfiguration.getClientKonfiguration().setKonfiguration(anfrage.getVorgang().getKonfiguration());
                            model.setAnfrage(anfrage);
                            boolean loadPreise = false;
                            ClientKonfiguration.getClientKonfiguration().setKalkulationModel(model, loadPreise);
                            ControllerPrintDialog.getInstance(anfrage.getVorgang().getKonfiguration()).getPrintDialog().showDialog(WorkflowController.getInstance().getMarkenLayout());
                            WorkflowController.getInstance().setMarkenLayout(null, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error((Object)e);
                        }
                        GlobalObjects.getInstance().getIpacData().setAnfrage(null);
                        break block30;
                    }
                    finally {
                        event.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (event.getComponent() != this.mAngebotsPanel.getAngebotsTablePanel().getLoeschenButton() || GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) break block30;
                try {
                    event.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                    if (!this.checkTableSelection(true) || !MainController.getInstance().getMainFrame().showConfirmMessage(LOESCHEN_MELDUNG)) break block30;
                    this.mAllSelectedRows = ((AngebotsTableModel)this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().getModel()).getSelectedRows();
                    for (int ii = 0; ii < this.mAllSelectedRows.size(); ++ii) {
                        try {
                            AngebotDataLoader.storniereAngebot(((AngebotsTableModel)this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().getModel()).getAngebotsIdFromRow(this.mAllSelectedRows.get(ii)));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.error((Object)e);
                        }
                        ((AngebotsTableModel)this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().getModel()).storniereAngebot(this.mAllSelectedRows.get(ii));
                        this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().updateUI();
                        this.mAngebotsPanel.getAngebotsTablePanel().calculateTableSize();
                    }
                }
                finally {
                    event.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            finally {
                this.mAngebotsPanel.getContentPanel().setCursor(Cursor.getPredefinedCursor(0));
                this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void aendereAngebot(int konfigId) {
        try {
            Anfrage anfrage = AngebotDataLoader.ersetzeAngebot(konfigId);
            ControllerAnfragenPanel.getInstance().setAnfrage(anfrage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkTableSelection(boolean mehrfach) {
        if (this.mAllSelectedRows == null) {
            this.mAllSelectedRows = new ArrayList();
        }
        this.mAllSelectedRows = ((AngebotsTableModel)this.mAngebotsPanel.getAngebotsTablePanel().getAngebotsTable().getModel()).getSelectedRows();
        if (this.mAllSelectedRows.size() == 1) {
            this.mSelectedRow = this.mAllSelectedRows.get(0);
        } else {
            if (this.mAllSelectedRows.size() == 0) {
                MainController.getInstance().getMainFrame().showErrorMessage(AUSWAHL_MELDUNG);
                return false;
            }
            if (this.mAllSelectedRows.size() > 1 && !mehrfach) {
                MainController.getInstance().getMainFrame().showErrorMessage(AUSWAHL_MELDUNG2);
                return false;
            }
        }
        return true;
    }

    public boolean isAngebotGeladen() {
        return this.mAngebotGeladen;
    }

    public int sucheAngebote() {
        try {
            ArrayList angebote = (ArrayList)AngebotDataLoader.sucheAngebote(this.mAngebotsPanel.getSuchkriterienPanel2().getSucheBean());
            this.mAngebotsPanel.getAngebotsTablePanel().setTablePanel(angebote);
            this.mAngebotsPanel.getAngebotsTablePanel().setVisible(true);
            return angebote.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return 0;
        }
    }

    static {
        LOESCHEN_MELDUNG = Resource.getInstance().getLoeschenMeldung();
        AUSWAHL_MELDUNG = Resource.getInstance().getAuswahlMeldung();
        AUSWAHL_MELDUNG2 = Resource.getInstance().getAuswahlMeldung2();
        ANFRAGE_GESPERRT = Resource.getInstance().getAnfrageGesperrt();
        ANFRGE_GESPERRT_MSG = Resource.getInstance().getAnfrgeGesperrtMsg();
    }
}

