/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.common.AbstractPanel;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import webetk.app.zub.verwaltung.Angebot;
import webetk.resources.Resource;

public class AngebotPanel
extends AbstractPanel {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    private JPanel spacer;
    private JLabel labAngebotsDatum;
    private JLabel labBindeFrist;
    private JLabel labBindeFristWert;
    private JLabel labAngebotsnummer;
    private JLabel labAngebotsnummerWert;
    private JTextField tfAngebotsDatum;
    private SimpleDateFormat dateFormatter;

    public AngebotPanel(MarkenLayout layout) {
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.labAngebotsDatum = new JLabel(" ");
        this.tfAngebotsDatum = layout.getTextField();
        this.tfAngebotsDatum.setMinimumSize(new Dimension(60, 20));
        this.tfAngebotsDatum.setPreferredSize(new Dimension(60, 20));
        this.tfAngebotsDatum.addMouseListener(new HilfeMouseListener("i50086"));
        this.labBindeFrist = new JLabel(" ");
        this.labBindeFristWert = new JLabel();
        this.labAngebotsnummer = new JLabel(" ");
        this.labAngebotsnummerWert = new JLabel();
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
        gbc = this.setGridBagConstraints(0, 0, 1, 3, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.spacer = new JPanel();
        this.mPanel.add((Component)this.spacer, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 13, new Insets(0, 0, 1, 5));
        this.mPanel.add((Component)this.labAngebotsDatum, gbc);
        gbc = this.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 1, 13, new Insets(0, 0, 1, 5));
        this.mPanel.add((Component)this.labBindeFrist, gbc);
        gbc = this.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 1, 13, new Insets(0, 0, 1, 5));
        this.mPanel.add((Component)this.labAngebotsnummer, gbc);
        gbc = this.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 1, 13, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.tfAngebotsDatum, gbc);
        gbc = this.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 1, 13, new Insets(0, 0, 0, 4));
        this.mPanel.add((Component)this.labBindeFristWert, gbc);
        gbc = this.setGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 1, 13, new Insets(0, 0, 0, 4));
        this.mPanel.add((Component)this.labAngebotsnummerWert, gbc);
        this.setLayout(layout);
        this.mPanel.validate();
    }

    @Override
    protected void setLayout(MarkenLayout layout) {
        super.setLayout(layout);
        this.mPanel.setBackground(this.background);
        this.spacer.setBackground(this.background);
        this.labAngebotsDatum.setForeground(this.textColor);
        this.labBindeFrist.setForeground(this.textColor);
        this.labAngebotsnummer.setForeground(this.textColor);
        if (this.tfAngebotsDatum != null) {
            this.labBindeFristWert.setForeground(this.textColor);
            this.labAngebotsnummerWert.setForeground(this.textColor);
        }
    }

    public void updateAngebotPanel(Angebot angebot) {
        if (angebot == null) {
            this.tfAngebotsDatum.setVisible(false);
            this.labAngebotsDatum.setText(" ");
            this.labBindeFrist.setText(" ");
            this.labBindeFristWert.setText(" ");
            this.labAngebotsnummer.setText(" ");
            this.labAngebotsnummerWert.setText(" ");
        } else {
            this.tfAngebotsDatum.setText(this.sdf.format(angebot.getAnlageDatum()));
            this.tfAngebotsDatum.setVisible(true);
            this.labAngebotsDatum.setText(Resource.getInstance().getAngebotsdatum());
            this.labBindeFrist.setText(Resource.getInstance().getBindefristBis());
            this.labBindeFristWert.setText(this.dateFormatter.format(angebot.getBindeFristDatum()));
            this.labAngebotsnummer.setText(Resource.getInstance().getAngebotsnummer());
            this.labAngebotsnummerWert.setText(Integer.toString(angebot.getAngebotsnummer()));
        }
    }

    public JTextField getTfAngebotsDatum() {
        return this.tfAngebotsDatum;
    }

    public void setAngebotsSicht(boolean flag) {
        this.tfAngebotsDatum.setEditable(!flag);
        this.tfAngebotsDatum.setEnabled(!flag);
    }
}

