/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.common.AbstractPanel;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class BetragPanel
extends AbstractPanel {
    private JLabel labNetto;
    private JLabel labNettoWert;
    private JLabel labAufAbschlag;
    private JLabel labMwSt;
    private JLabel labMwStWert;
    private JLabel labSeperator;
    private JLabel labGesamt;
    private JLabel labGesamtWert;
    private JFormattedTextField tfAufAbschlagWert;

    public BetragPanel(MarkenLayout layout) {
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.labNetto = new JLabel(Resource.getInstance().getNetto());
        gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labNetto, gbc);
        this.labNettoWert = new JLabel();
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labNettoWert, gbc);
        this.labMwSt = new JLabel("+ " + ZubCustomizable.getInstance().getBegriffAbkuerzungMwst());
        gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labMwSt, gbc);
        this.labMwStWert = new JLabel();
        gbc = this.setGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labMwStWert, gbc);
        this.labAufAbschlag = new JLabel(ZubCustomizable.getInstance().getBegriffAufAbschlag());
        gbc = this.setGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 0, 13, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labAufAbschlag, gbc);
        this.tfAufAbschlagWert = new JFormattedTextField(KalkulationModel.nfWaehrung);
        this.tfAufAbschlagWert.setBackground(Color.WHITE);
        this.tfAufAbschlagWert.setPreferredSize(new Dimension(50, 20));
        this.tfAufAbschlagWert.setHorizontalAlignment(4);
        this.tfAufAbschlagWert.addMouseListener(new HilfeMouseListener("i50086"));
        gbc = this.setGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, 12, new Insets(0, 10, 0, 1));
        this.mPanel.add((Component)this.tfAufAbschlagWert, gbc);
        this.labSeperator = new JLabel();
        this.labSeperator.setPreferredSize(new Dimension(200, 2));
        gbc = this.setGridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 2, 12, new Insets(5, 0, 5, 0));
        this.mPanel.add((Component)this.labSeperator, gbc);
        this.labGesamt = new JLabel(Resource.getInstance().getAngebotsbetrag());
        gbc = this.setGridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labGesamt, gbc);
        this.labGesamtWert = new JLabel();
        gbc = this.setGridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 10, 0, 5));
        this.mPanel.add((Component)this.labGesamtWert, gbc);
        this.setLayout(layout);
        this.mPanel.validate();
    }

    @Override
    protected void setLayout(MarkenLayout layout) {
        super.setLayout(layout);
        this.mPanel.setBackground(this.background);
        this.labNetto.setForeground(this.textColor);
        this.labNettoWert.setForeground(this.textColor);
        this.labAufAbschlag.setForeground(this.textColor);
        this.labMwSt.setForeground(this.textColor);
        this.labMwStWert.setForeground(this.textColor);
        this.labSeperator.setForeground(this.textColor);
        this.labGesamt.setForeground(this.textColor);
        this.labGesamtWert.setForeground(this.textColor);
        this.labSeperator.setBorder(BorderFactory.createLineBorder(this.textColor));
    }

    public void updateBetragPanel(KalkulationModel model) {
        this.labNettoWert.setText(KalkulationModel.nfWaehrung.format(model.getNettoPreis()));
        this.tfAufAbschlagWert.setText(KalkulationModel.nfWaehrung.format(model.getAufAbschlag()));
        this.labMwStWert.setText(KalkulationModel.nfWaehrung.format(model.getMwSt()));
        this.labGesamtWert.setText(KalkulationModel.nfWaehrung.format(model.getGesamtPreis()));
    }

    public JFormattedTextField getTfAufAbschlagWert() {
        return this.tfAufAbschlagWert;
    }

    public void setAngebotsSicht(boolean flag) {
        this.tfAufAbschlagWert.setEditable(!flag);
        this.tfAufAbschlagWert.setEnabled(!flag);
    }
}

