/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.ControllerDialogKunde;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.content.kalkulation.KalkulationsPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationsTableCellEditorDouble;
import de.esg.zub.configurator.content.kalkulation.KundePanel;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Kunde;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.resources.Resource;

public class ControllerKalkulationPanel
extends Observable
implements Observer,
MouseListener,
KeyListener,
FocusListener,
CellEditorListener {
    public static final String AUF_ABSCHLAG = "aufAbschlag";
    private static ControllerKalkulationPanel mInstance;
    private static Logger log;
    private static KalkulationsPanel mKalkulationView;
    private static KalkulationModel mModel;
    private static MarkenLayout mLayout;
    private boolean mAngebotsSicht;

    private ControllerKalkulationPanel() {
    }

    public static ControllerKalkulationPanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerKalkulationPanel();
            mLayout = WorkflowController.getInstance().getMarkenLayout();
            mKalkulationView = new KalkulationsPanel(mLayout);
            mKalkulationView.addObserver(mInstance);
            mInstance.addObserver(mKalkulationView);
            mKalkulationView.getPanFirma().getLabKundeIcon().addMouseListener(mInstance);
            mKalkulationView.getPanFirma().getLabKundeIcon().addMouseListener(new HilfeMouseListener("i50086"));
            mKalkulationView.getPanFirma().getTfKundenNr().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfAnrede().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfName().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfVorname().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfStrasse().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfHausnr().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfPlz().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfOrt().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfLand().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfTel().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfMobil().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfFax().addFocusListener(mInstance);
            mKalkulationView.getPanKunde().getTfEmail().addFocusListener(mInstance);
            if (mKalkulationView.getPanAngebot().getTfAngebotsDatum() != null) {
                mKalkulationView.getPanAngebot().getTfAngebotsDatum().addFocusListener(mInstance);
            }
            mKalkulationView.getPanBetrag().getTfAufAbschlagWert().addFocusListener(mInstance);
            mKalkulationView.getPanFirma().getTfKundenNr().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfAnrede().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfName().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfVorname().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfStrasse().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfHausnr().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfPlz().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfOrt().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfLand().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfTel().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfMobil().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfFax().addKeyListener(mInstance);
            mKalkulationView.getPanKunde().getTfEmail().addKeyListener(mInstance);
            if (mKalkulationView.getPanAngebot().getTfAngebotsDatum() != null) {
                mKalkulationView.getPanAngebot().getTfAngebotsDatum().addKeyListener(mInstance);
            }
            mKalkulationView.getPanBetrag().getTfAufAbschlagWert().addKeyListener(mInstance);
            mKalkulationView.getEditor().addCellEditorListener(mInstance);
        }
        return mInstance;
    }

    public void init() {
        ControllerKalkulationPanel.createModel();
        mKalkulationView.setModel(mModel);
        if (!GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().isReadOnly()) {
            this.setAngebotsSicht(false);
        }
        mKalkulationView.setLayout(WorkflowController.getInstance().getMarkenLayout());
        MainController.getInstance().getMainFrame().getMainPanel().showKalkulationPanel();
        ControllerMiniaturansicht.getInstance().showMiniaturansichten();
    }

    private static void createModel() {
        ClientKonfiguration ck = ClientKonfiguration.getClientKonfiguration();
        if (ck.getKalkulationModel() == null) {
            ck.estimateKalkulationModelFromTechnik(GlobalObjects.getInstance().getIpacData().getAnfrage(), true);
        }
        mModel = ck.getKalkulationModel();
        ArrayList filialenList = null;
        NutzerZub nutzer = null;
        try {
            filialenList = (ArrayList)AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId());
            nutzer = AdminDataLoader.ladeNutzerDatenZuUserId(GlobalObjects.getInstance().getSessionInfo().getLogin());
        }
        catch (Exception e) {
            Logger.getLogger(ControllerKalkulationPanel.class).error((Object)"Konnte Firmendaten nicht lesen.");
            e.printStackTrace();
        }
        FilialeZub filiale = null;
        if (filialenList != null) {
            for (int i = 0; i < filialenList.size(); ++i) {
                if (!((FilialeZub)filialenList.get(i)).getId().equals(GlobalObjects.getInstance().getSessionInfo().getFilialeId())) continue;
                filiale = (FilialeZub)filialenList.get(i);
            }
        }
        mModel.setFirmenAnschrift(ControllerKalkulationPanel.getFirmenAnschrift2(filiale, nutzer));
        if (mModel.getKunde() == null) {
            mModel.getAnfrage().setKunde(new Kunde());
            if (mModel.getAngebot() != null) {
                mModel.getAngebot().setKunde(new Kunde());
            }
        }
    }

    public KalkulationModel getModel() {
        return mModel;
    }

    private static String getFirmenAnschrift2(FilialeZub filiale, NutzerZub nutzer) {
        if (filiale != null) {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("<div align=right>");
            if (filiale.getBezeichnung() != null) {
                sb.append(filiale.getBezeichnung());
            }
            sb.append("</div>");
            sb.append("<div align=right>");
            if (filiale.getStrasse() != null) {
                sb.append(filiale.getStrasse());
            }
            sb.append("</div>");
            sb.append("<div align=right>");
            if (filiale.getPlz() != null) {
                sb.append(filiale.getPlz());
            }
            if (filiale.getOrt() != null) {
                sb.append(" ");
                sb.append(filiale.getOrt());
            }
            if (filiale.getTelefon() != null && !filiale.getTelefon().equals("")) {
                sb.append("</div>");
                sb.append("<div align=right>");
                sb.append(Resource.getInstance().getTelefon() + ": " + filiale.getTelefon());
            }
            if (filiale.getFax() != null && !filiale.getFax().equals("")) {
                sb.append("</div>");
                sb.append("<div align=right>");
                sb.append(Resource.getInstance().getFax() + ": " + filiale.getFax());
            }
            if (nutzer != null) {
                if (nutzer.getRealName() != null) {
                    sb.append("</div>");
                    sb.append("<div align=right>");
                    sb.append(Resource.getInstance().getBearbeiter() + ": " + nutzer.getRealName());
                }
                if (nutzer.getTelefon() != null && !nutzer.getTelefon().equals("")) {
                    sb.append("</div>");
                    sb.append("<div align=right>");
                    sb.append(Resource.getInstance().getTelefon() + ": " + nutzer.getTelefon());
                }
                if (nutzer.getEmail() != null && !nutzer.getEmail().equals("")) {
                    sb.append("</div>");
                    sb.append("<div align=right>");
                    sb.append(Resource.getInstance().getEmail() + ": " + nutzer.getEmail());
                }
                sb.append("</div>");
                sb.append("</html>");
            }
            return sb.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            return;
        }
        if (e.getComponent().getName().equals("DIALOG_KUNDE")) {
            try {
                Kunde kunde;
                mKalkulationView.getPanFirma().getLabKundeIcon().setCursor(Cursor.getPredefinedCursor(3));
                if (!this.mAngebotsSicht && (kunde = ControllerDialogKunde.getInstance().getKunde(mKalkulationView.getPanFirma().getTfKundenNr().getText(), mModel.getKunde().getName())) != null) {
                    mModel.getAnfrage().setKunde(kunde);
                    this.setChanged();
                    this.notifyObservers(mModel.getKunde());
                }
            }
            finally {
                mKalkulationView.getPanFirma().getLabKundeIcon().setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public KalkulationsPanel getKalkulationView() {
        return mKalkulationView;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent().getParent().getParent().equals(mKalkulationView.getPanKunde().getPanel())) {
            this.handleKundeFocusGained(e);
        } else if (e.getComponent().getParent().equals(mKalkulationView.getPanAngebot().getPanel())) {
            this.handleAngebotFocusGained(e);
        } else if (e.getComponent().getParent().equals(mKalkulationView.getPanBetrag().getPanel())) {
            this.handleBetragFocusGained(e);
        } else if (e.getComponent().getParent().equals(mKalkulationView.getPanFirma().getPanel())) {
            this.handleFirmaFocusGained(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getID() != -1 && e.getComponent().getParent().getParent() != null) {
            if (e.getComponent().getParent().getParent().equals(mKalkulationView.getPanKunde().getPanel())) {
                this.handleKundeFocusLost(e);
            } else if (e.getComponent().getParent().equals(mKalkulationView.getPanAngebot().getPanel())) {
                this.handleAngebotFocusLost(e);
            } else if (e.getComponent().getParent().equals(mKalkulationView.getPanBetrag().getPanel())) {
                this.handleBetragFocusLost(e);
            } else if (e.getComponent().getParent().equals(mKalkulationView.getPanFirma().getPanel())) {
                this.handleFirmaFocusLost(e);
            }
        }
    }

    private void handleKundeFocusLost(FocusEvent e) {
        if (e.getComponent() instanceof JTextField) {
            JTextField field = (JTextField)e.getComponent();
            String text = field.getText();
            if (text.equals("")) {
                text = null;
            }
            if (field.getForeground() == KalkulationsPanel.DUMMY_COLOR) {
                text = null;
            }
            if (field.equals(mKalkulationView.getPanKunde().getTfAnrede())) {
                mModel.getKunde().setAnrede(text);
            } else if (field.equals(mKalkulationView.getPanKunde().getTfName())) {
                mModel.getKunde().setName(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfVorname())) {
                mModel.getKunde().setVorname(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfStrasse())) {
                mModel.getKunde().setStrasse(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfHausnr())) {
                mModel.getKunde().setHausnr(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfPlz())) {
                mModel.getKunde().setPlz(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfOrt())) {
                mModel.getKunde().setStadt(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfLand())) {
                mModel.getKunde().setLand(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfTel())) {
                mModel.getKunde().setTelefonnummer(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfMobil())) {
                mModel.getKunde().setMobilnummer(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfFax())) {
                mModel.getKunde().setFaxnummer(text);
            } else if (e.getComponent().equals(mKalkulationView.getPanKunde().getTfEmail())) {
                mModel.getKunde().setEmail(text);
            }
            this.setChanged();
            this.notifyObservers(mModel.getKunde());
        }
    }

    private void handleKundeFocusGained(FocusEvent e) {
        if (e.getComponent() instanceof JTextField) {
            JTextField field = (JTextField)e.getComponent();
            if (field.getForeground() == KalkulationsPanel.DUMMY_COLOR) {
                field.setText("");
                field.setForeground(Color.BLACK);
            } else {
                field.selectAll();
            }
        }
    }

    private void handleAngebotFocusLost(FocusEvent e) {
    }

    private void handleAngebotFocusGained(FocusEvent e) {
        if (e.getComponent() == mKalkulationView.getPanAngebot().getTfAngebotsDatum()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mKalkulationView.getPanAngebot().getTfAngebotsDatum().select(0, 2);
                }
            });
        }
    }

    private void handleBetragFocusLost(FocusEvent e) {
        if (e.getComponent() == mKalkulationView.getPanBetrag().getTfAufAbschlagWert()) {
            JFormattedTextField field = (JFormattedTextField)e.getComponent();
            try {
                String betragString = field.getText();
                if (field.getText().equals("")) {
                    betragString = "0";
                }
                if (betragString.contains("-") && Math.abs(Double.parseDouble(betragString.replace(",", "."))) > mModel.getNettoPreis() + mModel.getMwSt()) {
                    field.setText(Double.toString(mModel.getAufAbschlag()));
                    mKalkulationView.getKalkulationPanel().updateUI();
                } else {
                    mModel.getKonfiguration().setAufabschlag(KalkulationModel.nfWaehrung.parse(betragString).doubleValue());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.setChanged();
            this.notifyObservers(AUF_ABSCHLAG);
        }
    }

    private void handleBetragFocusGained(FocusEvent e) {
        if (e.getComponent() == mKalkulationView.getPanBetrag().getTfAufAbschlagWert()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mKalkulationView.getPanBetrag().getTfAufAbschlagWert().selectAll();
                }
            });
        }
    }

    private void handleFirmaFocusLost(FocusEvent e) {
        if (e.getComponent() == mKalkulationView.getPanFirma().getTfKundenNr() && mKalkulationView.getPanFirma().getTfKundenNr().getText().equals("")) {
            mModel.getKunde().setKundennummer(mKalkulationView.getPanFirma().getTfKundenNr().getText());
        }
        this.setChanged();
        this.notifyObservers(mModel.getKunde());
    }

    private void handleFirmaFocusGained(FocusEvent e) {
        if (e.getComponent() == mKalkulationView.getPanFirma().getTfKundenNr()) {
            JFormattedTextField field = (JFormattedTextField)e.getComponent();
            if (field.getForeground() == KalkulationsPanel.DUMMY_COLOR) {
                field.setText("");
                field.setForeground(mLayout.getPrimaryForeground());
            } else {
                field.selectAll();
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (e.getSource() instanceof KalkulationsTableCellEditorDouble) {
            KalkulationsTableCellEditorDouble editor = (KalkulationsTableCellEditorDouble)e.getSource();
            int konfigPosIndex = Integer.parseInt(mModel.getTableData()[editor.getRow()][8].toString());
            double rabatt = Double.parseDouble(editor.getCellEditorValue().toString());
            KonfigurationsPosition konfigPos = (KonfigurationsPosition)mModel.getKonfiguration().getPositionen().get(konfigPosIndex);
            konfigPos.setRabatt(rabatt);
            mModel.updateTableData();
            this.setChanged();
            this.notifyObservers(konfigPosIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (!(e.getComponent() instanceof JFormattedTextField)) return;
        JFormattedTextField field = (JFormattedTextField)e.getComponent();
        if (field == mKalkulationView.getPanFirma().getTfKundenNr()) {
            if (e.getKeyCode() == 10) {
                Cursor oldCursor = field.getCursor();
                try {
                    field.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.mAngebotsSicht) return;
                    Kunde kunde = ControllerDialogKunde.getInstance().getKunde(mKalkulationView.getPanFirma().getTfKundenNr().getText(), mModel.getKunde().getName());
                    if (kunde != null) {
                        mModel.getAnfrage().setKunde(kunde);
                        this.setChanged();
                        this.notifyObservers(mModel.getKunde());
                    }
                    ControllerDialogKunde.getInstance().sucheNachKundennummer(mKalkulationView.getPanFirma().getTfKundenNr().getText());
                    return;
                }
                finally {
                    field.setCursor(oldCursor);
                }
            } else {
                if (e.getKeyCode() != 27) return;
                this.focusLost(new FocusEvent(field, -1));
                field.transferFocusUpCycle();
            }
            return;
        } else if (e.getKeyCode() == 10) {
            field.transferFocusUpCycle();
            return;
        } else {
            if (e.getKeyCode() != 27) return;
            this.focusLost(new FocusEvent(field, -1));
            field.transferFocusUpCycle();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setAngebotsSicht(boolean flag) {
        this.mAngebotsSicht = flag;
        mKalkulationView.setAngebotSicht(flag);
    }

    public void updateKalkulationModel() {
        Kunde kunde = mModel.getKunde();
        if (kunde != null) {
            KundePanel panKunde = mKalkulationView.getPanKunde();
            kunde.setAnrede(panKunde.getTfAnrede().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfAnrede().getText());
            kunde.setName(panKunde.getTfName().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfName().getText());
            kunde.setVorname(panKunde.getTfVorname().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfVorname().getText());
            kunde.setStrasse(panKunde.getTfStrasse().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfStrasse().getText());
            kunde.setHausnr(panKunde.getTfHausnr().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfHausnr().getText());
            kunde.setPlz(panKunde.getTfPlz().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfPlz().getText());
            kunde.setStadt(panKunde.getTfOrt().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfOrt().getText());
            kunde.setLand(panKunde.getTfLand().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfLand().getText());
            kunde.setTelefonnummer(panKunde.getTfTel().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfTel().getText());
            kunde.setMobilnummer(panKunde.getTfAnrede().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfMobil().getText());
            kunde.setFaxnummer(panKunde.getTfFax().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfFax().getText());
            kunde.setEmail(panKunde.getTfEmail().getForeground() == KalkulationsPanel.DUMMY_COLOR ? null : panKunde.getTfEmail().getText());
            kunde.setKundennummer(mKalkulationView.getPanFirma().getTfKundenNr().getText());
        }
        try {
            JFormattedTextField field = mKalkulationView.getPanBetrag().getTfAufAbschlagWert();
            String betragString = field.getText();
            if (field.getText().equals("")) {
                betragString = "0";
            }
            if (betragString.contains("-") && Math.abs(Double.parseDouble(betragString.replace(",", "."))) > mModel.getNettoPreis() + mModel.getMwSt()) {
                field.setText(Double.toString(mModel.getAufAbschlag()));
                mKalkulationView.getKalkulationPanel().updateUI();
            } else {
                mModel.getKonfiguration().setAufabschlag(KalkulationModel.nfWaehrung.parse(betragString).doubleValue());
                mKalkulationView.getPanBetrag().updateBetragPanel(mModel);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), e.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
        catch (ParseException e) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), e.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    static {
        log = Logger.getLogger(ControllerKalkulationPanel.class);
    }
}

