/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import java.util.Hashtable;
import java.util.List;
import webetk.app.BTEBedingungsmenge;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Kunde;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubVerwaltung;

public class KalkulationDataLoader {
    public static Konfiguration ladeKonfiguration(int konfigurationsId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfigurationsId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LADE_KONFIGURATION);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Konfiguration)verwaltung.getValue("konfiguration");
    }

    public static String[] ladeFirmenAnschrift() throws Exception {
        webetk.app.konfiguration.Konfiguration config = GlobalObjects.getInstance().getConfig();
        String[] result = new String[]{config.getHaendleranschriftZeile1(), config.getHaendleranschriftZeile2(), config.getHaendleranschriftZeile3(), config.getHaendleranschriftPLZ(), config.getHaendleranschriftOrt(), config.getHaendleranschriftTelefon()};
        return result;
    }

    public static Hashtable<String, String> loadMWSteuer() throws Exception {
        Hashtable<String, String> mwst = new Hashtable<String, String>();
        webetk.app.konfiguration.Konfiguration config = GlobalObjects.getInstance().getConfig();
        mwst.put("A", config.getMWStSatzHoch());
        mwst.put("B", config.getMWStSatzNiedrig());
        mwst.put("C", config.getMWStSatz3());
        mwst.put("D", config.getMWStSatz4());
        mwst.put("E", config.getMWStSatzAltteile());
        return mwst;
    }

    public static Anfrage speichereKonfiguration(Anfrage anfrage, boolean updateAbschlag, List<KonfigurationsPosition> addPosList, List<KonfigurationsPosition> updatePosList, List<KonfigurationsPosition> delPosList) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("anfrage", anfrage);
        verwaltung.setValue("addPos", addPosList);
        verwaltung.setValue("updatePos", updatePosList);
        verwaltung.setValue("deletePos", delPosList);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_KONFIGURATION);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Anfrage)verwaltung.getValue("anfrage");
    }

    public static Vorgang ladeVorgang(int vorgangId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("vorgangsId", vorgangId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LADE_VORGANG);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        Vorgang vorgang = (Vorgang)verwaltung.getValue("vorgang");
        return vorgang;
    }

    public static void ermittleAktiveBedingungen(Fahrzeug fahrzeug, MarketingProdukt mProdukt) throws Exception {
        Vorgang vorgang = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang();
        BTEBedingungsmenge menge = FBIDataloader.getBedingungen(fahrzeug, mProdukt);
        vorgang.getFahrzeug().setBedingungsMenge(menge.getBedingungsmenge());
        BTEBedingungsmenge mengeBTE = FBIDataloader.getBedingungen(fahrzeug, mProdukt);
        vorgang.getFahrzeug().setBedingungsMenge_BTE(mengeBTE.getBedingungsmenge());
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("anfrage", GlobalObjects.getInstance().getIpacData().getAnfrage());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LADE_VORGANG_BEDINGUNGEN);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        GlobalObjects.getInstance().getIpacData().setAnfrage((Anfrage)verwaltung.getValue("anfrage"));
    }

    public static void loescheVorgang(int vorgangsId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("vorgangsId", vorgangsId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LOESCHE_VORGANG);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static void loescheKonfiguration(int konfigId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfigId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.LOESCHE_KONFIGURATION);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public static Kunde speichereKunde(Kunde kunde) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("kunde", kunde);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_KUNDE);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Kunde)verwaltung.getValue("kunde");
    }

    public static Angebot speichereAngebot(Angebot angebot) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("angebot", angebot);
        verwaltung.setValue("konfigurationsId", ClientKonfiguration.getClientKonfiguration().getKonfigurationsId());
        verwaltung.setValue("konfiguration", ClientKonfiguration.getClientKonfiguration().getKonfiguration());
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_ANGEBOT);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Angebot)verwaltung.getValue("angebot");
    }

    public static void speichereKundenZuordnung(Anfrage anfrage) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("anfrage", anfrage);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SPEICHERE_KUNDENZUORDNUNG);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }
}

