/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Kunde;
import webetk.app.zub.verwaltung.Vorgang;

public class KalkulationModel {
    protected Anfrage anfrage;
    protected String firmenAnschrift;
    protected boolean isSpeicherKunde;
    public static final DecimalFormat nfWaehrung = new DecimalFormat("#0.00");
    public static final DecimalFormat nfNumber = new DecimalFormat("#0.##");
    private Object[][] mTableData;
    private static int mTableColumnCount = 10;
    public static final int COL_POSITION = 0;
    public static final int COL_TNR_AWNR = 1;
    public static final int COL_BENENNUNG = 2;
    public static final int COL_MENGE = 3;
    public static final int COL_EINZELPREIS = 4;
    public static final int COL_RABATT = 5;
    public static final int COL_GESAMTPREIS = 6;
    public static final int COL_MWST = 7;
    public static final int COL_MODEL_POSITION = 8;
    public static final int COL_ARTIKEL_ART = 9;
    public static final int IDX_MWST_SATZ = 0;
    public static final int IDX_MWST_BETRAG = 1;
    private Hashtable<String, String> mwstSymbole = new Hashtable();
    private static Logger log = Logger.getLogger(ControllerTechnikPanel.class);

    public KalkulationModel() {
        try {
            this.mwstSymbole = KalkulationDataLoader.loadMWSteuer();
        }
        catch (Exception e) {
            log.error((Object)"loadMWSteuer ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public Object[][] getTableData() {
        return this.mTableData;
    }

    public int getTableColumnCount() {
        return mTableColumnCount;
    }

    public void updateTableData() {
        ArrayList positionenList = (ArrayList)this.getKonfiguration().getPositionen();
        int size = 0;
        for (int ii = 0; ii < positionenList.size(); ++ii) {
            if (((KonfigurationsPosition)positionenList.get(ii)).getStatus().equalsIgnoreCase("DELETE")) continue;
            ++size;
        }
        this.mTableData = new Object[size][mTableColumnCount];
        Character symbolKey = Character.valueOf(' ');
        int zeile = 0;
        for (int ii = 0; ii < positionenList.size(); ++ii) {
            KonfigurationsPosition pos = (KonfigurationsPosition)positionenList.get(ii);
            Character i = Character.valueOf('A');
            while (i.charValue() < 'F') {
                double symbolMwst;
                try {
                    symbolMwst = Double.parseDouble(this.mwstSymbole.get(i.toString()));
                }
                catch (NumberFormatException e) {
                    symbolMwst = 0.0;
                }
                if (pos.getMwstSatz() == symbolMwst) {
                    if (symbolMwst == 0.0) {
                        symbolKey = Character.valueOf(' ');
                        break;
                    }
                    symbolKey = i;
                    break;
                }
                symbolKey = Character.valueOf(' ');
                Character c = i;
                Character c2 = i = Character.valueOf((char)(i.charValue() + '\u0001'));
            }
            if (pos.getStatus().equalsIgnoreCase("DELETE")) continue;
            this.mTableData[zeile] = new Object[]{zeile + 1, pos.getArtikelNummer(), pos.getArtikelBenennung(), pos.getMenge(), pos.getPreis(), pos.getRabatt(), pos.getGesamtPreis(), symbolKey.toString(), ii, Character.valueOf(pos.getArt())};
            ++zeile;
        }
    }

    public Anfrage getAnfrage() {
        return this.anfrage;
    }

    public void setAnfrage(Anfrage anfrage) {
        this.anfrage = anfrage;
    }

    public String getFirmenAnschrift() {
        return this.firmenAnschrift;
    }

    public void setFirmenAnschrift(String firmenAnschrift) {
        this.firmenAnschrift = firmenAnschrift;
    }

    public boolean isSpeicherKunde() {
        return this.isSpeicherKunde;
    }

    public void setSpeicherKunde(boolean isSpeicherKunde) {
        this.isSpeicherKunde = isSpeicherKunde;
    }

    public double getNettoPreis() {
        ArrayList pos = (ArrayList)this.getKonfiguration().getPositionen();
        double gesamtPreis = 0.0;
        for (int ii = 0; ii < pos.size(); ++ii) {
            if (((KonfigurationsPosition)pos.get(ii)).getStatus().equalsIgnoreCase("DELETE")) continue;
            gesamtPreis += Math.floor(((KonfigurationsPosition)pos.get(ii)).getGesamtPreis() * 100.0 + 0.5) / 100.0;
        }
        gesamtPreis = Math.floor(gesamtPreis * 100.0 + 0.5) / 100.0;
        return gesamtPreis;
    }

    public double getTeilePreis() {
        ArrayList pos = (ArrayList)this.getKonfiguration().getPositionen();
        double preis = 0.0;
        for (int ii = 0; ii < pos.size(); ++ii) {
            if (((KonfigurationsPosition)pos.get(ii)).getStatus().equalsIgnoreCase("DELETE") || ((KonfigurationsPosition)pos.get(ii)).getArt() != 'T' && ((KonfigurationsPosition)pos.get(ii)).getArt() != 'F') continue;
            preis += Math.floor(((KonfigurationsPosition)pos.get(ii)).getGesamtPreis() * 100.0 + 0.5) / 100.0;
        }
        preis = Math.floor(preis * 100.0 + 0.5) / 100.0;
        return preis;
    }

    public double getArbeitPreis() {
        ArrayList pos = (ArrayList)this.getKonfiguration().getPositionen();
        double preis = 0.0;
        for (int ii = 0; ii < pos.size(); ++ii) {
            if (((KonfigurationsPosition)pos.get(ii)).getStatus().equalsIgnoreCase("DELETE") || ((KonfigurationsPosition)pos.get(ii)).getArt() != 'A' && ((KonfigurationsPosition)pos.get(ii)).getArt() != 'S') continue;
            preis += Math.floor(((KonfigurationsPosition)pos.get(ii)).getGesamtPreis() * 100.0 + 0.5) / 100.0;
        }
        preis = Math.floor(preis * 100.0 + 0.5) / 100.0;
        return preis;
    }

    public double[][] getMwStSaetze() {
        Vector<Double> mwStSatz = new Vector<Double>();
        for (KonfigurationsPosition pos : (ArrayList)this.getKonfiguration().getPositionen()) {
            Double satz;
            if (pos.getStatus().equalsIgnoreCase("DELETE") || mwStSatz.contains(satz = Double.valueOf(pos.getMwstSatz()))) continue;
            mwStSatz.add(satz);
        }
        Collections.sort(mwStSatz);
        double[][] result = new double[2][mwStSatz.size()];
        if (mwStSatz.size() > this.mwstSymbole.size()) {
            Logger log = Logger.getLogger(ControllerTechnikPanel.class);
            log.error((Object)("Zu viele unterschiedliche MwSt-S\u00e4tze erkannt. Zul\u00e4ssige Anzahl von MwSt-S\u00e4tzen = " + this.mwstSymbole.size() + ". Aktuelle Anzahl = " + mwStSatz.size() + "."));
        }
        for (int ii = 0; ii < mwStSatz.size(); ++ii) {
            result[0][ii] = (Double)mwStSatz.get(ii);
            result[1][ii] = 0.0;
        }
        for (KonfigurationsPosition pos : (ArrayList)this.getKonfiguration().getPositionen()) {
            if (pos.getStatus().equalsIgnoreCase("DELETE")) continue;
            Double satz = pos.getMwstSatz();
            int index = mwStSatz.indexOf(satz);
            double[] dArray = result[1];
            int n = index;
            dArray[n] = dArray[n] + Math.floor(pos.getGesamtPreis() * pos.getMwstSatz() + 0.5) / 100.0;
        }
        return result;
    }

    public double getMwSt() {
        double result = 0.0;
        for (int ii = 0; ii < this.getMwStSaetze()[1].length; ++ii) {
            result += this.getMwStSaetze()[1][ii];
        }
        return result;
    }

    public double getAufAbschlag() {
        return Math.floor(this.getKonfiguration().getAufabschlag() * 100.0 + 0.5) / 100.0;
    }

    public double getGesamtPreis() {
        return this.getNettoPreis() + this.getMwSt() + this.getAufAbschlag();
    }

    public Vorgang getVorgang() {
        if (this.anfrage == null) {
            return null;
        }
        return this.anfrage.getVorgang();
    }

    public Konfiguration getKonfiguration() {
        if (this.getVorgang() == null) {
            return null;
        }
        return this.getVorgang().getKonfiguration();
    }

    public Angebot getAngebot() {
        if (this.getKonfiguration() == null) {
            return null;
        }
        return this.getKonfiguration().getAngebot();
    }

    public Kunde getKunde() {
        if (this.getAngebot() == null) {
            return this.anfrage.getKunde();
        }
        return this.getAngebot().getKunde();
    }

    public Fahrzeug getFahrzeug() {
        return this.getVorgang().getFahrzeug();
    }

    public Hashtable<String, String> getMwstSymbole() {
        return this.mwstSymbole;
    }

    public void setMwstSymbole(Hashtable<String, String> mwstSymbole) {
        this.mwstSymbole = mwstSymbole;
    }
}

