/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class KalkulationTableCellRendererDouble
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat nfZahl = new DecimalFormat("#0.0#");
    private static Cursor textCursor = Cursor.getPredefinedCursor(2);
    private final Color background;
    private final Color foreground;

    public KalkulationTableCellRendererDouble(MarkenLayout layout) {
        this.background = layout.getPrimaryBackground();
        this.foreground = layout.getPrimaryForeground();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont(Constants.Layout.getZubDefaultFont());
        if (column == 4 || column == 6) {
            this.setText(KalkulationModel.nfWaehrung.format(value));
        } else {
            this.setText(nfZahl.format(value));
            if (column == 5) {
                this.setCursor(textCursor);
            }
        }
        this.setHorizontalAlignment(4);
        this.setBackground(this.background);
        this.setForeground(this.foreground);
        return this;
    }
}

