/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.kalkulation;

import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TableCellRendererInteger;
import de.esg.zub.common.TableCellRendererString;
import de.esg.zub.configurator.content.kalkulation.AngebotPanel;
import de.esg.zub.configurator.content.kalkulation.BetragPanel;
import de.esg.zub.configurator.content.kalkulation.FahrzeugPanel;
import de.esg.zub.configurator.content.kalkulation.FirmaPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.content.kalkulation.KalkulationTableCellRendererDouble;
import de.esg.zub.configurator.content.kalkulation.KalkulationTableModel;
import de.esg.zub.configurator.content.kalkulation.KalkulationsTableCellEditorDouble;
import de.esg.zub.configurator.content.kalkulation.KalkulationsTableHeaderRenderer;
import de.esg.zub.configurator.content.kalkulation.KundePanel;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;

public class KalkulationsPanel
extends Observable
implements Observer {
    private JPanel mKalkulationsPanel;
    private MarkenLayout mLayout;
    private KalkulationModel mModel;
    public static final Color DUMMY_COLOR = Color.LIGHT_GRAY;
    private GridBagConstraints gbc;
    private JTable kalkulationTable;
    private KalkulationTableModel kalkulationTableModel;
    private KalkulationsTableCellEditorDouble editor;
    private JScrollPane kalkulationScrollPane;
    private FirmaPanel panFirma;
    private KundePanel panKunde;
    private AngebotPanel panAngebot;
    private FahrzeugPanel panFahrzeug;
    private BetragPanel panBetrag;
    private JLabel labLegendeMwSt;
    private boolean isFBAVisible = false;

    public KalkulationsPanel(MarkenLayout layout) {
        this.mLayout = layout;
        this.createComponents();
        this.setKalkulationPanel();
    }

    public void setModel(KalkulationModel model) {
        this.mModel = model;
        this.mModel.updateTableData();
        this.getPanFirma().updateFirmaPanel(model.getFirmenAnschrift(), model.getKunde().getKundennummer());
        this.getPanKunde().updateKundePanel(model.getKunde());
        this.getPanAngebot().updateAngebotPanel(model.getAngebot());
        this.getPanFahrzeug().updateFahrzeugPanel(model.getVorgang());
        this.kalkulationTableModel.updateData(this.mModel.getTableData());
        this.setTableSize();
        this.kalkulationScrollPane.updateUI();
        this.kalkulationTable.updateUI();
        this.getPanBetrag().updateBetragPanel(this.mModel);
        this.labLegendeMwSt.setText(this.getMwStLegende());
        this.mKalkulationsPanel.updateUI();
    }

    private void setTableSize() {
        int rows = this.kalkulationTable.getRowCount();
        if (rows > 5) {
            rows = 5;
        }
        int height = this.kalkulationTable.getTableHeader().getPreferredSize().height;
        height += 3;
        Dimension scrollPaneSize = new Dimension(786, height += rows * this.kalkulationTable.getRowHeight());
        this.kalkulationScrollPane.setPreferredSize(scrollPaneSize);
        this.kalkulationScrollPane.setMinimumSize(scrollPaneSize);
        this.kalkulationScrollPane.setMaximumSize(scrollPaneSize);
    }

    public JPanel getKalkulationPanel() {
        return this.mKalkulationsPanel;
    }

    private void createComponents() {
        this.mKalkulationsPanel = new JPanel();
        this.mKalkulationsPanel.setLayout(new GridBagLayout());
        this.mKalkulationsPanel.setCursor(null);
        this.mKalkulationsPanel.setPreferredSize(new Dimension(846, 500));
        this.mKalkulationsPanel.setMinimumSize(new Dimension(846, 500));
        this.mKalkulationsPanel.setCursor(Cursor.getPredefinedCursor(0));
        this.gbc = new GridBagConstraints();
    }

    private void setKalkulationPanel() {
        this.mKalkulationsPanel.removeAll();
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 12, new Insets(0, 10, 0, 10));
        this.mKalkulationsPanel.add((Component)this.getPanFirma().getPanel(), this.gbc);
        this.gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 10, 0, 10));
        this.mKalkulationsPanel.add((Component)this.getPanKunde().getPanel(), this.gbc);
        this.gbc = this.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 10, 0, 10));
        this.mKalkulationsPanel.add((Component)this.getPanAngebot().getPanel(), this.gbc);
        this.gbc = this.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 10, 0, 10));
        this.mKalkulationsPanel.add((Component)this.getPanFahrzeug().getPanel(), this.gbc);
        this.gbc = this.setGridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 2, 18, new Insets(0, 10, 0, 10));
        this.mKalkulationsPanel.add((Component)this.getKalkulationScrollPane(), this.gbc);
        JLabel empty = new JLabel();
        this.gbc = this.setGridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 0, 12, new Insets(0, 0, 0, 0));
        this.mKalkulationsPanel.add((Component)empty, this.gbc);
        this.gbc = this.setGridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 0, 14, new Insets(0, 10, 0, 8));
        this.mKalkulationsPanel.add((Component)this.getPanBetrag().getPanel(), this.gbc);
        this.labLegendeMwSt = new JLabel();
        this.gbc = this.setGridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 0, 12, new Insets(3, 10, 4, 14));
        this.mKalkulationsPanel.add((Component)this.labLegendeMwSt, this.gbc);
        this.mKalkulationsPanel.validate();
        this.mKalkulationsPanel.setVisible(true);
    }

    public FirmaPanel getPanFirma() {
        if (this.panFirma == null) {
            this.panFirma = new FirmaPanel(this.mLayout);
        }
        return this.panFirma;
    }

    public KundePanel getPanKunde() {
        if (this.panKunde == null) {
            this.panKunde = new KundePanel(this.mLayout);
        }
        return this.panKunde;
    }

    public AngebotPanel getPanAngebot() {
        if (this.panAngebot == null) {
            this.panAngebot = new AngebotPanel(this.mLayout);
        }
        return this.panAngebot;
    }

    public FahrzeugPanel getPanFahrzeug() {
        if (this.panFahrzeug == null) {
            this.panFahrzeug = new FahrzeugPanel(this.mLayout);
        }
        return this.panFahrzeug;
    }

    public BetragPanel getPanBetrag() {
        if (this.panBetrag == null) {
            this.panBetrag = new BetragPanel(this.mLayout);
        }
        return this.panBetrag;
    }

    public JScrollPane getKalkulationScrollPane() {
        this.kalkulationScrollPane = new JScrollPane();
        this.kalkulationScrollPane.setViewportView(this.getKalkulationTable());
        return this.kalkulationScrollPane;
    }

    private JTable getKalkulationTable() {
        this.kalkulationTableModel = new KalkulationTableModel(null);
        this.kalkulationTable = new JTable(this.kalkulationTableModel);
        this.kalkulationTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                Point p = me.getPoint();
                int column = KalkulationsPanel.this.kalkulationTable.columnAtPoint(p);
                if (column == 5) {
                    KalkulationsPanel.this.kalkulationTable.setCursor(Cursor.getPredefinedCursor(2));
                } else {
                    KalkulationsPanel.this.kalkulationTable.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.kalkulationTable.addMouseListener(new HilfeMouseListener("i50086"));
        TableColumnModel columnModel = this.kalkulationTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(5);
        columnModel.getColumn(1).setPreferredWidth(40);
        columnModel.getColumn(2).setPreferredWidth(375);
        columnModel.getColumn(3).setPreferredWidth(20);
        columnModel.getColumn(4).setPreferredWidth(40);
        columnModel.getColumn(5).setPreferredWidth(35);
        columnModel.getColumn(6).setPreferredWidth(50);
        columnModel.getColumn(7).setPreferredWidth(5);
        columnModel.getColumn(7).setMaxWidth(5);
        this.kalkulationTable.setDefaultRenderer(String.class, new TableCellRendererString(this.mLayout));
        this.kalkulationTable.setDefaultRenderer(Integer.class, new TableCellRendererInteger(this.mLayout));
        this.kalkulationTable.setDefaultRenderer(Double.class, new KalkulationTableCellRendererDouble(this.mLayout));
        this.kalkulationTable.getTableHeader().setDefaultRenderer(new KalkulationsTableHeaderRenderer(this.mLayout));
        this.editor = new KalkulationsTableCellEditorDouble(this.mLayout);
        this.kalkulationTable.setDefaultEditor(Double.class, this.editor);
        this.kalkulationTable.getTableHeader().setReorderingAllowed(false);
        return this.kalkulationTable;
    }

    private String getMwStLegende() {
        StringBuilder sb = new StringBuilder();
        sb.append(Resource.getInstance().getAngebotsbetragEnthaelt());
        sb.append(" ");
        double[][] mwSt = this.mModel.getMwStSaetze();
        Hashtable<String, String> mwstSymbole = this.mModel.getMwstSymbole();
        Character symbolKey = Character.valueOf(' ');
        for (int ii = 0; ii < mwSt[0].length; ++ii) {
            Double mwst = mwSt[0][ii];
            Character i = Character.valueOf('A');
            while (i.charValue() < 'F') {
                double symbolMwst;
                try {
                    symbolMwst = Double.parseDouble(mwstSymbole.get(i.toString()));
                }
                catch (NumberFormatException e) {
                    symbolMwst = 0.0;
                }
                if (mwst == symbolMwst) {
                    if (symbolMwst == 0.0) {
                        symbolKey = Character.valueOf(' ');
                        break;
                    }
                    symbolKey = i;
                    break;
                }
                symbolKey = Character.valueOf(' ');
                Character c = i;
                Character c2 = i = Character.valueOf((char)(i.charValue() + '\u0001'));
            }
            if (ii > 3) break;
            if (symbolKey.charValue() == ' ') continue;
            sb.append(symbolKey);
            sb.append(" = ");
            sb.append(KalkulationModel.nfNumber.format(mwSt[0][ii]));
            sb.append(" % = ");
            sb.append(KalkulationModel.nfWaehrung.format(mwSt[1][ii]));
            sb.append(" ");
            sb.append(ZubCustomizable.getInstance().getWaehrungsKz());
            sb.append(", ");
        }
        if (!sb.toString().contains(", ")) {
            return sb.toString() + " " + ZubCustomizable.getInstance().getBegriffAbkuerzungMwst();
        }
        return sb.substring(0, sb.lastIndexOf(", ")) + " " + ZubCustomizable.getInstance().getBegriffAbkuerzungMwst();
    }

    public void setLayout(MarkenLayout layout) {
        this.getPanFirma().setLayout(layout);
        this.getPanKunde().setLayout(layout);
        this.getPanAngebot().setLayout(layout);
        this.getPanFahrzeug().setLayout(layout);
        this.getPanBetrag().setLayout(layout);
        this.mKalkulationsPanel.setBackground(layout.getPrimaryBackground());
        this.kalkulationTable.getTableHeader().setForeground(Color.WHITE);
        this.kalkulationTable.getTableHeader().setBackground(Color.GRAY);
        this.kalkulationTable.setBackground(layout.getPrimaryBackground());
        this.kalkulationTable.setDefaultRenderer(String.class, new TableCellRendererString(layout));
        this.kalkulationTable.setDefaultRenderer(Integer.class, new TableCellRendererInteger(layout));
        this.kalkulationTable.setDefaultRenderer(Double.class, new KalkulationTableCellRendererDouble(layout));
        this.editor = new KalkulationsTableCellEditorDouble(layout);
        this.kalkulationScrollPane.setBackground(Color.GRAY);
        this.labLegendeMwSt.setForeground(layout.getPrimaryForeground());
        this.mKalkulationsPanel.validate();
    }

    private GridBagConstraints setGridBagConstraints(int gx, int gy, int gw, int gh, double wx, double wy, int fill, int anchor, Insets in) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.weightx = wx;
        c.weighty = wy;
        c.fill = fill;
        c.insets = in;
        c.anchor = anchor;
        return c;
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obj == null) {
            if (this.mModel != null && this.mModel.getKunde() != null) {
                this.getPanFirma().updateFirmaPanel(this.mModel.getFirmenAnschrift(), this.mModel.getKunde().getKundennummer());
                this.getPanKunde().updateKundePanel(this.mModel.getKunde());
                this.getPanAngebot().updateAngebotPanel(this.mModel.getAngebot());
            }
        } else if (obj instanceof Kunde) {
            this.getPanKunde().updateKundePanel((Kunde)obj);
        } else if (obj instanceof Angebot) {
            this.getPanAngebot().updateAngebotPanel((Angebot)obj);
        } else if (obj instanceof Integer) {
            this.kalkulationTableModel.updateData(this.mModel.getTableData());
            this.setTableSize();
            this.kalkulationScrollPane.updateUI();
            this.mKalkulationsPanel.updateUI();
            this.getPanBetrag().updateBetragPanel(this.mModel);
            this.labLegendeMwSt.setText(this.getMwStLegende());
        } else if (obj instanceof String) {
            String arg = (String)obj;
            if (arg.equals("aufAbschlag")) {
                this.getPanBetrag().updateBetragPanel(this.mModel);
            } else {
                Logger.getLogger(KalkulationsPanel.class).warn((Object)("KalkulationsPanel.update(): Unbekanntes Argument " + arg + " erhalten."));
            }
        }
    }

    public KalkulationsTableCellEditorDouble getEditor() {
        return this.editor;
    }

    public void compactView() {
        this.mKalkulationsPanel.remove(this.getPanFirma().getPanel());
        GridBagConstraints gbcPlatzhalter = this.mLayout.setGridBagConstraints(0, 8, 1, 1, 1.0, 100.0, 1, 11, new Insets(0, 0, 0, 0));
        this.mKalkulationsPanel.add((Component)new JLabel(), gbcPlatzhalter);
    }

    public void normalizeView() {
        this.gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 12, new Insets(0, 10, 0, 10));
        this.mKalkulationsPanel.add((Component)this.getPanFirma().getPanel(), this.gbc);
    }

    public void setAngebotSicht(boolean flag) {
        if (this.kalkulationTableModel != null) {
            this.kalkulationTableModel.setAngebotsSicht(flag);
        }
        this.panKunde.setAngebotsSicht(flag);
        this.panFirma.setAngebotsSicht(flag);
        this.panAngebot.setAngebotsSicht(flag);
        this.panBetrag.setAngebotsSicht(flag);
    }

    public boolean isFBAVisible() {
        return this.isFBAVisible;
    }

    public void setFBAVisible(boolean isFBAVisible) {
        this.isFBAVisible = isFBAVisible;
    }
}

