/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import webetk.app.Bedingung;
import webetk.app.ausstattung.Ausstattung;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.RealMultilineCellRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class AusstattungsPanel {
    private static Logger log = Logger.getLogger(AusstattungsPanel.class);
    private static final int SONDERAUSSTATTUNG = 2;
    private static final int SERIENAUSSTATTUNG = 3;
    private static final int INFORMATION = 4;
    private static final int INDIVIDUALFAHRZEUGDATEN = 5;
    private static AusstattungsPanel instance = null;
    private JDialog dlg = null;
    private JPanel mContainePanel = new JPanel();
    private JScrollPane scInhalt;
    private JPanel inhaltPanel;
    private JPanel panInhalt = null;
    private HIGLayout layoutInhalt = null;
    private HIGLayout mlayoutSonderausstattung = null;
    private JPanel mpanSonderausstattung = null;
    private JLabel mlabIconPlusSonderausstattung = null;
    private JLabel mlabIconMinusSonderausstattung = null;
    private JComponent mpanTabelleSonderausstattung = null;
    private GenericTableModel mtmSonderausstattung = null;
    private int mdHeightTabelleSonderausstattung = 0;
    private int mdWidthTabelleSonderausstattung = 0;
    private JPanel sonderausstattungLabelPanel = null;
    private JLabel labSonderausstattung = null;
    private HIGLayout mlayoutSerienausstattung = null;
    private JPanel mpanSerienausstattung = null;
    private JLabel mlabIconPlusSerienausstattung = null;
    private JLabel mlabIconMinusSerienausstattung = null;
    private JComponent mpanTabelleSerienausstattung = null;
    private GenericTableModel mtmSerienausstattung = null;
    private int mdHeightTabelleSerienausstattung = 0;
    private int mdWidthTabelleSerienausstattung = 0;
    private JPanel serienaussttungsLabelPanel = null;
    private JLabel labSerienausstattung = null;
    private HIGLayout mlayoutInformation = null;
    private JPanel mpanInformation = null;
    private JLabel mlabIconPlusInformation = null;
    private JLabel mlabIconMinusInformation = null;
    private JComponent mpanTabelleInformation = null;
    private GenericTableModel mtmInformation = null;
    private int mdHeightTabelleInformation = 0;
    private int mdWidthTabelleInformation = 0;
    private JPanel infoLabPanel = null;
    private JLabel labInformation = null;
    private HIGLayout mlayoutIndividualfahrzeugdaten = null;
    private JPanel mpanIndividualfahrzeugdaten = null;
    private JLabel mlabIconPlusIndividualfahrzeugdaten = null;
    private JLabel mlabIconMinusIndividualfahrzeugdaten = null;
    private JComponent mpanTabelleIndividualfahrzeugdaten = null;
    private GenericTableModel mtmIndividualfahrzeugdaten = null;
    private int mdHeightTabelleIndividualfahrzeugdaten = 0;
    private int mdWidthTabelleIndividual = 0;
    private JPanel individualLabPanel = null;
    private JLabel labIndividualfahrzeugdaten = null;

    public AusstattungsPanel() {
        this.initComponents();
        this.aufklappen(2);
        this.aufklappen(3);
        this.aufklappen(4);
        this.aufklappen(5);
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static AusstattungsPanel getInstance() {
        if (instance == null) {
            instance = new AusstattungsPanel();
        }
        return instance;
    }

    public static void resetInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    public void initComponents() {
        Fahrzeug oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (oFzgSucheInfo == null) {
            log.error((Object)"Keine Fahrzeugidentifikation vorhanden => Dialog beenden");
            return;
        }
        this.layoutAll();
    }

    protected void layoutAll() {
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mContainePanel.setLayout((LayoutManager)l);
        this.panInhalt = this.createInhaltPanel();
        this.scInhalt = new JScrollPane(this.panInhalt, 20, 30);
        this.scInhalt.setBorder(BorderFactory.createEmptyBorder());
        this.mContainePanel.add((Component)this.scInhalt, c.rc(3, 1, "tlbr"));
    }

    public JPanel createInhaltPanel() {
        this.inhaltPanel = new JPanel();
        this.inhaltPanel.setAutoscrolls(true);
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.layoutInhalt = new HIGLayout(w, h);
        this.layoutInhalt.setColumnWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        this.inhaltPanel.setLayout((LayoutManager)this.layoutInhalt);
        Fahrzeug oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        boolean bHatSonderausstattung = false;
        boolean bHatSerienausstattung = false;
        boolean bHatInformation = false;
        boolean bHatIndividualfahrzeugdaten = false;
        if (oAusstattung != null) {
            bHatSonderausstattung = oAusstattung.hatSonderausstattung();
            bHatSerienausstattung = oAusstattung.hatSerienausstattung();
            bHatInformation = oAusstattung.hatInformation();
            bHatIndividualfahrzeugdaten = oAusstattung.hatIndividualFahrzeugdaten();
        }
        JPanel panSonderausstattung = this.createPanelSonderausstattung();
        JPanel panSerienausstattung = this.createPanelSerienausstattung();
        JPanel panInformation = this.createPanelInformation();
        JPanel panIndividualfahrzeugdaten = this.createPanelIndividualfahrzeugdaten();
        if (bHatSonderausstattung) {
            this.inhaltPanel.add((Component)panSonderausstattung, c.rc(3, 1));
        }
        if (bHatSerienausstattung) {
            this.inhaltPanel.add((Component)panSerienausstattung, c.rc(4, 1));
        }
        if (bHatInformation) {
            this.inhaltPanel.add((Component)panInformation, c.rc(5, 1));
        }
        if (bHatIndividualfahrzeugdaten) {
            this.inhaltPanel.add((Component)panIndividualfahrzeugdaten, c.rc(6, 1));
        }
        return this.inhaltPanel;
    }

    private JPanel createPanelSonderausstattung() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutSonderausstattung = new HIGLayout(w, h);
        this.mlayoutSonderausstattung.setColumnWeight(2, 1);
        this.mlayoutSonderausstattung.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanSonderausstattung = new JPanel();
        this.mpanSonderausstattung.setLayout((LayoutManager)this.mlayoutSonderausstattung);
        Icon iconPlusSonderausstattung = UIHelper.getPlusIcon();
        this.mlabIconPlusSonderausstattung = new JLabel(iconPlusSonderausstattung);
        Icon iconMinusSonderausstattung = UIHelper.getMinusIcon();
        this.mlabIconMinusSonderausstattung = new JLabel(iconMinusSonderausstattung);
        this.sonderausstattungLabelPanel = new JPanel();
        this.labSonderausstattung = new JLabel(Resource.getInstance().getSonderausstattung());
        this.labSonderausstattung.setBoldFont();
        this.sonderausstattungLabelPanel.add(this.mlabIconPlusSonderausstattung);
        this.sonderausstattungLabelPanel.add(this.mlabIconMinusSonderausstattung);
        this.sonderausstattungLabelPanel.add(this.labSonderausstattung);
        this.sonderausstattungLabelPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AusstattungsPanel.this.mlabIconPlusSonderausstattung.isVisible()) {
                    AusstattungsPanel.this.aufklappen(2);
                } else {
                    AusstattungsPanel.this.zuklappen(2);
                }
            }
        });
        this.mpanSonderausstattung.add((Component)this.sonderausstattungLabelPanel, c.rc(2, 2, "l"));
        this.mpanTabelleSonderausstattung = this.createTabelleSonderausstattung();
        this.mpanSonderausstattung.add((Component)this.mpanTabelleSonderausstattung, c.rc(4, 2, "lrbt"));
        return this.mpanSonderausstattung;
    }

    private JPanel createPanelSerienausstattung() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutSerienausstattung = new HIGLayout(w, h);
        this.mlayoutSerienausstattung.setColumnWeight(2, 1);
        this.mlayoutSerienausstattung.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanSerienausstattung = new JPanel();
        this.mpanSerienausstattung.setLayout((LayoutManager)this.mlayoutSerienausstattung);
        Icon iconPlusSerienausstattung = UIHelper.getPlusIcon();
        this.mlabIconPlusSerienausstattung = new JLabel(iconPlusSerienausstattung);
        Icon iconMinusSerienausstattung = UIHelper.getMinusIcon();
        this.mlabIconMinusSerienausstattung = new JLabel(iconMinusSerienausstattung);
        this.serienaussttungsLabelPanel = new JPanel();
        this.labSerienausstattung = new JLabel(Resource.getInstance().getSerienausstattung());
        this.labSerienausstattung.setBoldFont();
        this.serienaussttungsLabelPanel.add(this.mlabIconPlusSerienausstattung);
        this.serienaussttungsLabelPanel.add(this.mlabIconMinusSerienausstattung);
        this.serienaussttungsLabelPanel.add(this.labSerienausstattung);
        this.serienaussttungsLabelPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AusstattungsPanel.this.mlabIconPlusSerienausstattung.isVisible()) {
                    AusstattungsPanel.this.aufklappen(3);
                } else {
                    AusstattungsPanel.this.zuklappen(3);
                }
            }
        });
        this.mpanSerienausstattung.add((Component)this.serienaussttungsLabelPanel, c.rc(2, 2, "l"));
        this.mpanTabelleSerienausstattung = this.createTabelleSerienausstattung();
        this.mpanSerienausstattung.add((Component)this.mpanTabelleSerienausstattung, c.rc(4, 2, "lrbt"));
        return this.mpanSerienausstattung;
    }

    private JPanel createPanelInformation() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutInformation = new HIGLayout(w, h);
        this.mlayoutInformation.setColumnWeight(2, 1);
        this.mlayoutInformation.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanInformation = new JPanel();
        this.mpanInformation.setLayout((LayoutManager)this.mlayoutInformation);
        Icon iconPlusInformation = UIHelper.getPlusIcon();
        this.mlabIconPlusInformation = new JLabel(iconPlusInformation);
        Icon iconMinusInformation = UIHelper.getMinusIcon();
        this.mlabIconMinusInformation = new JLabel(iconMinusInformation);
        this.infoLabPanel = new JPanel();
        this.labInformation = new JLabel(Resource.getInstance().getInformation());
        this.labInformation.setBoldFont();
        this.infoLabPanel.add(this.mlabIconPlusInformation);
        this.infoLabPanel.add(this.mlabIconMinusInformation);
        this.infoLabPanel.add(this.labInformation);
        this.infoLabPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AusstattungsPanel.this.mlabIconPlusInformation.isVisible()) {
                    AusstattungsPanel.this.aufklappen(4);
                } else {
                    AusstattungsPanel.this.zuklappen(4);
                }
            }
        });
        this.mpanInformation.add((Component)this.infoLabPanel, c.rc(2, 2, "l"));
        this.mpanTabelleInformation = this.createTabelleInformation();
        this.mpanInformation.add((Component)this.mpanTabelleInformation, c.rc(4, 2, "lrbt"));
        return this.mpanInformation;
    }

    private JPanel createPanelIndividualfahrzeugdaten() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutIndividualfahrzeugdaten = new HIGLayout(w, h);
        this.mlayoutIndividualfahrzeugdaten.setColumnWeight(2, 1);
        this.mlayoutIndividualfahrzeugdaten.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanIndividualfahrzeugdaten = new JPanel();
        this.mpanIndividualfahrzeugdaten.setLayout((LayoutManager)this.mlayoutIndividualfahrzeugdaten);
        Icon iconPlusIndividualfahrzeugdaten = UIHelper.getPlusIcon();
        this.mlabIconPlusIndividualfahrzeugdaten = new JLabel(iconPlusIndividualfahrzeugdaten);
        Icon iconMinusIndividualfahrzeugdaten = UIHelper.getMinusIcon();
        this.mlabIconMinusIndividualfahrzeugdaten = new JLabel(iconMinusIndividualfahrzeugdaten);
        this.individualLabPanel = new JPanel();
        this.labIndividualfahrzeugdaten = new JLabel(Resource.getInstance().getIndividualfahrzeugdaten());
        this.labIndividualfahrzeugdaten.setBoldFont();
        this.individualLabPanel.add(this.mlabIconPlusIndividualfahrzeugdaten);
        this.individualLabPanel.add(this.mlabIconMinusIndividualfahrzeugdaten);
        this.individualLabPanel.add(this.labIndividualfahrzeugdaten);
        this.individualLabPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AusstattungsPanel.this.mlabIconPlusIndividualfahrzeugdaten.isVisible()) {
                    AusstattungsPanel.this.aufklappen(5);
                } else {
                    AusstattungsPanel.this.zuklappen(5);
                }
            }
        });
        this.mpanIndividualfahrzeugdaten.add((Component)this.individualLabPanel, c.rc(2, 2, "l"));
        this.mpanTabelleIndividualfahrzeugdaten = this.createTabelleIndividualfahrzeugdaten();
        this.mpanIndividualfahrzeugdaten.add((Component)this.mpanTabelleIndividualfahrzeugdaten, c.rc(4, 2, "lrbt"));
        return this.mpanIndividualfahrzeugdaten;
    }

    private JComponent createTabelleSonderausstattung() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 0, false, "XXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungSchnittstelle(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungEtk(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmSonderausstattung = new GenericTableModel(tableConfig);
        Fahrzeug oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<Bedingung> cSonderausstattungen = oAusstattung.getSonderausstattung();
        if (cSonderausstattungen == null) {
            return null;
        }
        for (Bedingung oBedingung : cSonderausstattungen) {
            String sCode = oBedingung.getCode();
            String sBenennung = oBedingung.getName();
            String sBenennungSS = oBedingung.getNameSS();
            sBenennungSS = sBenennungSS == null ? "" : sBenennungSS;
            this.mtmSonderausstattung.addRow((GenericRow)new AbstractRow(new Object[]{sCode, sBenennungSS, sBenennung}));
        }
        GenericTable table = new GenericTable(this.mtmSonderausstattung);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.setFont(Constants.Layout.getZubDefaultFont());
        table.getTableHeader().setFont(Constants.Layout.getZubBoldFont());
        this.mdHeightTabelleSonderausstattung = table.calcRowHeights();
        this.mdWidthTabelleSonderausstattung = table.getColumnModel().getTotalColumnWidth();
        JScrollPane tableScroll = table.getScrollPane();
        tableScroll.setVerticalScrollBarPolicy(21);
        tableScroll.setHorizontalScrollBarPolicy(31);
        return tableScroll;
    }

    private JComponent createTabelleSerienausstattung() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 0, false, "XXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungSchnittstelle(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungEtk(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmSerienausstattung = new GenericTableModel(tableConfig);
        Fahrzeug oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<Bedingung> cSerienausstattungen = oAusstattung.getSerienausstattung();
        if (cSerienausstattungen == null) {
            return null;
        }
        for (Bedingung oBedingung : cSerienausstattungen) {
            String sCode = oBedingung.getCode();
            String sBenennung = oBedingung.getName();
            String sBenennungSS = oBedingung.getNameSS();
            sBenennungSS = sBenennungSS == null ? "" : sBenennungSS;
            this.mtmSerienausstattung.addRow((GenericRow)new AbstractRow(new Object[]{sCode, sBenennungSS, sBenennung}));
        }
        GenericTable table = new GenericTable(this.mtmSerienausstattung);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.setFont(Constants.Layout.getZubDefaultFont());
        table.getTableHeader().setFont(Constants.Layout.getZubBoldFont());
        this.mdHeightTabelleSerienausstattung = table.calcRowHeights();
        this.mdWidthTabelleSerienausstattung = table.getColumnModel().getTotalColumnWidth();
        JScrollPane tableScroll = table.getScrollPane();
        tableScroll.setVerticalScrollBarPolicy(21);
        tableScroll.setHorizontalScrollBarPolicy(31);
        return tableScroll;
    }

    private JComponent createTabelleInformation() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 0, false, "XXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungSchnittstelle(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungEtk(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmInformation = new GenericTableModel(tableConfig);
        Fahrzeug oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<Bedingung> cInformationen = oAusstattung.getInformationen();
        if (cInformationen == null) {
            return null;
        }
        for (Bedingung oBedingung : cInformationen) {
            String sCode = oBedingung.getCode();
            String sBenennung = oBedingung.getName();
            String sBenennungSS = oBedingung.getNameSS();
            sBenennungSS = sBenennungSS == null ? "" : sBenennungSS;
            this.mtmInformation.addRow((GenericRow)new AbstractRow(new Object[]{sCode, sBenennungSS, sBenennung}));
        }
        GenericTable table = new GenericTable(this.mtmInformation);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.setFont(Constants.Layout.getZubDefaultFont());
        table.getTableHeader().setFont(Constants.Layout.getZubBoldFont());
        this.mdHeightTabelleInformation = table.calcRowHeights();
        this.mdWidthTabelleInformation = table.getColumnModel().getTotalColumnWidth();
        JScrollPane tableScroll = table.getScrollPane();
        tableScroll.setVerticalScrollBarPolicy(21);
        tableScroll.setHorizontalScrollBarPolicy(31);
        return tableScroll;
    }

    private JComponent createTabelleIndividualfahrzeugdaten() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getText(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        RealMultilineCellRenderer textRenderer = new RealMultilineCellRenderer();
        tableConfig.setRenderer(0, (TableCellRenderer)textRenderer);
        this.mtmIndividualfahrzeugdaten = new GenericTableModel(tableConfig);
        Fahrzeug oFzgSucheInfo = GlobalObjects.getInstance().getIpacData().getFahrzeug();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<String> cIndividualFahrzeugdaten = oAusstattung.getIndividualFahrzeugdaten();
        if (cIndividualFahrzeugdaten == null) {
            return null;
        }
        String sInterieur = oAusstattung.getIndividualInterieurCode();
        if (sInterieur != null && sInterieur.length() > 0) {
            String sText = Resource.getInstance().getRestlicheInnenausstattung() + ": " + sInterieur;
            this.mtmIndividualfahrzeugdaten.addRow((GenericRow)new AbstractRow(new Object[]{sText}));
            this.mtmIndividualfahrzeugdaten.addRow((GenericRow)new AbstractRow(new Object[]{""}));
        }
        for (String sText : cIndividualFahrzeugdaten) {
            this.mtmIndividualfahrzeugdaten.addRow((GenericRow)new AbstractRow(new Object[]{sText}));
        }
        GenericTable table = new GenericTable(this.mtmIndividualfahrzeugdaten);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.setFont(Constants.Layout.getZubDefaultFont());
        table.getTableHeader().setFont(Constants.Layout.getZubBoldFont());
        this.mdHeightTabelleIndividualfahrzeugdaten = table.calcRowHeights();
        this.mdWidthTabelleIndividual = table.getColumnModel().getTotalColumnWidth();
        JScrollPane tableScroll = table.getScrollPane();
        tableScroll.setVerticalScrollBarPolicy(21);
        tableScroll.setHorizontalScrollBarPolicy(31);
        return tableScroll;
    }

    public void aufklappen(int nWas) {
        Dimension dim = new Dimension();
        switch (nWas) {
            case 2: {
                this.mlabIconPlusSonderausstattung.setVisible(false);
                this.mlabIconMinusSonderausstattung.setVisible(true);
                this.mpanTabelleSonderausstattung.setVisible(true);
                dim.setSize((double)this.mdWidthTabelleSonderausstattung, this.calcPanelHeight(2));
                this.mpanTabelleSonderausstattung.setPreferredSize(dim);
                break;
            }
            case 3: {
                this.mlabIconPlusSerienausstattung.setVisible(false);
                this.mlabIconMinusSerienausstattung.setVisible(true);
                this.mpanTabelleSerienausstattung.setVisible(true);
                dim.setSize((double)this.mdWidthTabelleSerienausstattung, this.calcPanelHeight(3));
                this.mpanTabelleSerienausstattung.setPreferredSize(dim);
                break;
            }
            case 4: {
                this.mlabIconPlusInformation.setVisible(false);
                this.mlabIconMinusInformation.setVisible(true);
                this.mpanTabelleInformation.setVisible(true);
                dim.setSize((double)this.mdWidthTabelleInformation, this.calcPanelHeight(4));
                this.mpanTabelleInformation.setPreferredSize(dim);
                break;
            }
            case 5: {
                this.mlabIconPlusIndividualfahrzeugdaten.setVisible(false);
                this.mlabIconMinusIndividualfahrzeugdaten.setVisible(true);
                this.mpanTabelleIndividualfahrzeugdaten.setVisible(true);
                dim.setSize((double)this.mdWidthTabelleIndividual, this.calcPanelHeight(5));
                this.mpanTabelleIndividualfahrzeugdaten.setPreferredSize(dim);
                break;
            }
        }
        this.mContainePanel.repaint();
    }

    public void zuklappen(int nWas) {
        switch (nWas) {
            case 2: {
                this.mlabIconPlusSonderausstattung.setVisible(true);
                this.mlabIconMinusSonderausstattung.setVisible(false);
                this.mpanTabelleSonderausstattung.setVisible(false);
                break;
            }
            case 3: {
                this.mlabIconPlusSerienausstattung.setVisible(true);
                this.mlabIconMinusSerienausstattung.setVisible(false);
                this.mpanTabelleSerienausstattung.setVisible(false);
                break;
            }
            case 4: {
                this.mlabIconPlusInformation.setVisible(true);
                this.mlabIconMinusInformation.setVisible(false);
                this.mpanTabelleInformation.setVisible(false);
                break;
            }
            case 5: {
                this.mlabIconPlusIndividualfahrzeugdaten.setVisible(true);
                this.mlabIconMinusIndividualfahrzeugdaten.setVisible(false);
                this.mpanTabelleIndividualfahrzeugdaten.setVisible(false);
                break;
            }
        }
        this.mContainePanel.repaint();
    }

    private double calcPanelHeight(int nWas) {
        switch (nWas) {
            case 2: {
                return this.mdHeightTabelleSonderausstattung;
            }
            case 3: {
                return this.mdHeightTabelleSerienausstattung;
            }
            case 4: {
                return this.mdHeightTabelleInformation;
            }
            case 5: {
                return this.mdHeightTabelleIndividualfahrzeugdaten;
            }
        }
        return 0.0;
    }

    public JPanel getContainerPanel() {
        return this.mContainePanel;
    }

    public JScrollPane getScInhalt() {
        return this.scInhalt;
    }

    public void setBackground(Color color) {
        this.mContainePanel.setBackground(color);
        this.scInhalt.setBackground(color);
        this.inhaltPanel.setBackground(color);
        this.mpanSonderausstattung.setBackground(color);
        this.mpanTabelleSonderausstattung.setBackground(color);
        this.mpanSerienausstattung.setBackground(color);
        this.mpanTabelleSerienausstattung.setBackground(color);
        this.mpanInformation.setBackground(color);
        this.mpanTabelleInformation.setBackground(color);
        this.mpanIndividualfahrzeugdaten.setBackground(color);
        this.mpanTabelleIndividualfahrzeugdaten.setBackground(color);
        this.sonderausstattungLabelPanel.setBackground(color);
        this.serienaussttungsLabelPanel.setBackground(color);
        this.infoLabPanel.setBackground(color);
        this.individualLabPanel.setBackground(color);
        this.mContainePanel.updateUI();
    }

    public void setForeground(Color color) {
        this.mlabIconPlusSonderausstattung.setForeground(color);
        this.mlabIconMinusSonderausstattung.setForeground(color);
        this.mlabIconPlusSerienausstattung.setForeground(color);
        this.mlabIconMinusSerienausstattung.setForeground(color);
        this.mlabIconPlusInformation.setForeground(color);
        this.mlabIconMinusInformation.setForeground(color);
        this.mlabIconPlusIndividualfahrzeugdaten.setForeground(color);
        this.mlabIconMinusIndividualfahrzeugdaten.setForeground(color);
        this.labSonderausstattung.setForeground(color);
        this.labSerienausstattung.setForeground(color);
        this.labInformation.setForeground(color);
        this.labIndividualfahrzeugdaten.setForeground(color);
        this.mContainePanel.updateUI();
    }
}

