/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.ControllerDialogKundeKeyReader;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.FBI;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import de.esg.zub.configurator.content.marketing.FBIModel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.StatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.InvalidInitializationException;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class ControllerFBI
implements ActionListener,
ItemListener,
MouseListener {
    private static ControllerFBI mInstance = null;
    private static FBIModel mModel;
    private FBI mFbi = new FBI(WorkflowController.getInstance().getMarkenLayout());
    private FBIDataloader mFBIDataloader = new FBIDataloader();
    private boolean mErstesBetreten = true;
    private static Logger log;

    private ControllerFBI() {
    }

    public static ControllerFBI getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerFBI();
        }
        return mInstance;
    }

    public void init() {
        if (this.createModel()) {
            if (this.mFbi.isComponentsCreated()) {
                this.removeComponentListener();
            }
            this.mFbi.setModel(mModel);
            this.mFbi.setLayout(WorkflowController.getInstance().getMarkenLayout());
            this.addComponentListener();
            if (this.mErstesBetreten) {
                this.addHilfeListener();
                this.mErstesBetreten = false;
            }
            MainController.getInstance().getMainFrame().getMainPanel().addFBI(this.mFbi);
            if (mModel.isVinIdentified() || mModel.isAttrIdentified() || mModel.getFahrzeug() != null) {
                if (mModel.isBedingungermittelt()) {
                    this.mFbi.setBedingungen2();
                    this.mFbi.getUebernehmenButton().setEnabled(true, WorkflowController.getInstance().getMarkenLayout());
                    this.mFbi.getPruefenButton().setEnabled(true, WorkflowController.getInstance().getMarkenLayout());
                    this.mFbi.aktiviereWeiterPfeil(true);
                } else {
                    this.mFbi.aktiviereWeiterPfeil(true);
                }
            } else {
                this.fzIdausreichend();
            }
        } else {
            WorkflowController.getInstance().setAddKonfigurationDataSet(true);
            WorkflowController.getInstance().setFzBedIdentified(true);
            WorkflowController.getInstance().changeState("TECHNIK");
        }
    }

    private void addComponentListener() {
        this.mFbi.getBauartComboBox().addItemListener(mInstance);
        this.mFbi.getKarosserieComboBox().addItemListener(mInstance);
        this.mFbi.getBaureihenComboBox().addItemListener(mInstance);
        this.mFbi.getModellComboBox().addItemListener(mInstance);
        this.mFbi.getKatalogausfuehrungComboBox().addItemListener(mInstance);
        this.mFbi.getBaujahrComboBox().addItemListener(mInstance);
        this.mFbi.getZulassungsmonatComboBox().addItemListener(mInstance);
        this.mFbi.getGetriebeComboBox().addItemListener(mInstance);
        this.mFbi.getLenkungComboBox().addItemListener(mInstance);
        this.mFbi.getVinTextField().addActionListener(mInstance);
        this.mFbi.getAbbrechenButton().addMouseListener(mInstance);
        this.mFbi.getKundenDialogLabel().addMouseListener(mInstance);
        this.mFbi.getUebernehmenButton().addMouseListener(mInstance);
        this.mFbi.getPruefenButton().addMouseListener(mInstance);
    }

    private void addHilfeListener() {
        HilfeMouseListener hilfeListener = new HilfeMouseListener("i50097");
        this.mFbi.addMouseListener(hilfeListener);
        this.mFbi.getAbbrechenButton().addMouseListener(hilfeListener);
        this.mFbi.getKundenDialogLabel().addMouseListener(hilfeListener);
        this.mFbi.getUebernehmenButton().addMouseListener(hilfeListener);
        this.mFbi.getVinTextField().addMouseListener(hilfeListener);
        this.mFbi.getBauartComboBox().addMouseListener(hilfeListener);
        this.mFbi.getBaureihenComboBox().addMouseListener(hilfeListener);
        this.mFbi.getModellComboBox().addMouseListener(hilfeListener);
        this.mFbi.getGetriebeComboBox().addMouseListener(hilfeListener);
        this.mFbi.getKarosserieComboBox().addMouseListener(hilfeListener);
        this.mFbi.getKatalogausfuehrungComboBox().addMouseListener(hilfeListener);
        this.mFbi.getLenkungComboBox().addMouseListener(hilfeListener);
        this.mFbi.getBaujahrComboBox().addMouseListener(hilfeListener);
        this.mFbi.getZulassungsmonatComboBox().addMouseListener(hilfeListener);
    }

    private void removeComponentListener() {
        this.mFbi.getKarosserieComboBox().removeItemListener(mInstance);
        this.mFbi.getBaureihenComboBox().removeItemListener(mInstance);
        this.mFbi.getModellComboBox().removeItemListener(mInstance);
        this.mFbi.getKatalogausfuehrungComboBox().removeItemListener(mInstance);
        this.mFbi.getBaujahrComboBox().removeItemListener(mInstance);
        this.mFbi.getZulassungsmonatComboBox().removeItemListener(mInstance);
        this.mFbi.getGetriebeComboBox().removeItemListener(mInstance);
        this.mFbi.getLenkungComboBox().removeItemListener(mInstance);
        this.mFbi.getVinTextField().removeActionListener(mInstance);
        this.mFbi.getAbbrechenButton().removeMouseListener(mInstance);
        this.mFbi.getKundenDialogLabel().removeMouseListener(mInstance);
        this.mFbi.getUebernehmenButton().removeMouseListener(mInstance);
        this.mFbi.getPruefenButton().removeMouseListener(mInstance);
    }

    private boolean createModel() {
        mModel = new FBIModel(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt());
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null) {
            mModel.setFahrzeug(GlobalObjects.getInstance().getIpacData().getFahrzeug());
            if (!this.checkFBIn\u00f6tig()) {
                return false;
            }
            if (GlobalObjects.getInstance().getIpacData().getFahrzeug().getFahrgestellnummer() != null) {
                mModel.setVinIdentified(true);
            } else {
                mModel.setAttrIdentified(true);
            }
        } else {
            mModel.setVinIdentified(false);
            mModel.setAttrIdentified(false);
        }
        if (WorkflowController.getInstance().getMarkenLayout().getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            mModel.setListBaureihen(NavigationPanelDataLoader.loadBaureihenElemente(mModel.getMarketingProdukt().getBteNr(), mModel.getMarketingProdukt().getBildPosNr()));
        } else {
            mModel.setListBauarten(NavigationPanelDataLoader.loadBauartenElemente(mModel.getMarketingProdukt().getBteNr(), mModel.getMarketingProdukt().getBildPosNr()));
            if (mModel.getListBauarten().size() == 1) {
                mModel.setListBaureihen((ArrayList)mModel.getListBauarten().get(0).getBaureihe());
            }
        }
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedBauart() != null) {
            mModel.setBauart(MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedBauart());
        }
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedBaureihe() != null) {
            mModel.setBaureihe(NavigationPanelDataLoader.loadKarosserieformen(MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedBaureihe()));
        }
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKarosserieForm() != null) {
            mModel.setKarosserieform(NavigationPanelDataLoader.loadModelle(mModel.getBaureihe(), MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKarosserieForm()));
        }
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedModell() != null) {
            mModel.setModell(NavigationPanelDataLoader.loadKatalogausfuehrungen(MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedModell(), mModel.getBaureihe().getBaureihe(), mModel.getKarosserieform().getKarosserieForm()));
        }
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKatalogAusfuehrung() != null) {
            mModel.setSelectedKatalogausf\u00fchrung(MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKatalogAusfuehrung());
            if (!mModel.isVinIdentified()) {
                Fahrzeug fahrzeug = new Fahrzeug();
                if (WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad()) {
                    fahrzeug.setBauart(mModel.getBauart().getBauart());
                }
                fahrzeug.setBaureihe(mModel.getBaureihe().getBaureihe());
                fahrzeug.setKarosserie(mModel.getKarosserieform().getKarosserieForm());
                fahrzeug.setModell(mModel.getModell().getModell());
                fahrzeug.setKatalogausf(mModel.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung());
                this.checkFahrzeug(fahrzeug);
            }
        } else {
            mModel.setIndexSelectedKatalogausf\u00fchrung(-1);
        }
        mModel.setIndexSelectedLenkung(-1);
        mModel.setIndexSelectedGetriebe(-1);
        mModel.setIndexSelectedBaujahr(-1);
        mModel.setIndexSelectedZulassungsmonat(-1);
        return true;
    }

    private boolean checkFBIn\u00f6tig() {
        if (!this.checkFahrzeug(GlobalObjects.getInstance().getIpacData().getFahrzeug())) {
            return this.checkBedingungen();
        }
        return true;
    }

    private boolean checkFahrzeug(Fahrzeug fahrzeug) {
        if (fahrzeug != null) {
            try {
                FBIDataloader.ermittleZusatzAttrib(fahrzeug, ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), "Fehler beim Ermitteln der n\u00f6tigen Attribute :" + e.getMessage());
            }
            mModel.setMarketingProdukt(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt());
            return !mModel.isFzIdausreichend(fahrzeug);
        }
        return true;
    }

    private boolean checkBedingungen() {
        BTEBedingungsmenge bteBedingungsmenge = FBIDataloader.getBedingungen(mModel.getMarketingProdukt());
        Bedingungsmenge produktBedingungsmenge = bteBedingungsmenge.getBedingungsmenge();
        mModel.setBTEBedingungsmenge(bteBedingungsmenge);
        mModel.setBedingungermittelt(true);
        if (bteBedingungsmenge.getBedingungsmenge().alleWerteGesetzt()) {
            GlobalObjects.getInstance().getIpacData().getFahrzeug().setBedingungsMenge(produktBedingungsmenge);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mFbi.setCursor(Cursor.getPredefinedCursor(3));
            this.mFbi.getVinTextField().setCursor(Cursor.getPredefinedCursor(3));
            this.handleVinTextfeldActionEvent(arg0);
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.mFbi.setCursor(Cursor.getPredefinedCursor(0));
            this.mFbi.getVinTextField().setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public void handleVinTextfeldActionEvent(ActionEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JFormattedTextField)) {
            return;
        }
        if (!this.mFbi.checkPlausibilitaetenVin()) {
            this.mFbi.getNext().removeMouseListener(mInstance);
            mModel.setVinIdentified(false);
            this.mFbi.initBaureihen();
            this.mFbi.getBedingungsPanel();
            this.mFbi.getUebernehmenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
            this.mFbi.getPruefenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
            return;
        }
        String vin = ((JFormattedTextField)event.getSource()).getText();
        vin = vin.toUpperCase();
        Fahrzeug fahrzeug = NavigationPanelDataLoader.loadFahrzeugdatenVin(vin);
        mModel.setFahrzeug(fahrzeug);
        FzgSucheInfo oFzgSucheInfo = FBIDataloader.getFIByFahrgesellnummer(vin);
        if (oFzgSucheInfo == null) {
            this.mFbi.getVinTextField().setText("");
            mModel.setFahrzeug(null);
            this.mFbi.getNext().removeMouseListener(mInstance);
            mModel.setVinIdentified(false);
            this.mFbi.initBaureihen();
            this.mFbi.getBedingungsPanel();
            this.mFbi.getUebernehmenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
            this.mFbi.getPruefenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
            return;
        }
        ControllerFBI.getModel().createFahrzeugFromFzIdInfo2(oFzgSucheInfo);
        mModel.setVinIdentified(true);
        this.mFbi.setVinAttributes();
        this.mFbi.getUebernehmenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
        this.mFbi.getPruefenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
        this.mFbi.aktiviereWeiterPfeil(true);
        this.mFbi.getBedingungsPanel();
        this.mFbi.aktiviereWeiterPfeil(false);
        BTEBedingungsmenge menge = FBIDataloader.getBedingungen(mModel.getMarketingProdukt());
        mModel.setBTEBedingungsmenge(menge);
        mModel.setBedingungermittelt(true);
        this.mFbi.setBedingungen2();
        this.mFbi.getUebernehmenButton().setEnabled(true, WorkflowController.getInstance().getMarkenLayout());
        this.mFbi.getPruefenButton().setEnabled(true, WorkflowController.getInstance().getMarkenLayout());
    }

    public void exit() {
        if (MainController.getInstance().getMainFrame().getMainPanel().getFbi() != null) {
            MainController.getInstance().getMainFrame().getMainPanel().removeFBI();
        }
    }

    public void ladeBaureihen(int i) {
        mModel.setListBaureihen(NavigationPanelDataLoader.loadBaureihenElemente(mModel.getMarketingProdukt().getBteNr(), mModel.getMarketingProdukt().getBildPosNr(), mModel.getListBauarten().get(i).getBauart()));
    }

    public void ladeKarosserieformen(int i) {
        mModel.setBaureihe(NavigationPanelDataLoader.loadKarosserieformen(mModel.getListBaureihen().get(i)));
    }

    public void ladeModelle(int i) {
        mModel.setKarosserieform(NavigationPanelDataLoader.loadModelle(mModel.getBaureihe(), mModel.getBaureihe().getKarosserieForm().get(i)));
    }

    public void ladeKatalogausf\u00fchrung(int i) {
        mModel.setModell(NavigationPanelDataLoader.loadKatalogausfuehrungen(mModel.getKarosserieform().getModelle().get(i), mModel.getBaureihe().getBaureihe(), mModel.getKarosserieform().getKarosserieForm()));
    }

    public FBIModel getFbiModel() {
        return mModel;
    }

    public FBI getFbi() {
        return this.mFbi;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if ((this.mFbi.getBauartComboBox().hasFocus() || this.mFbi.getBaureihenComboBox().hasFocus() || this.mFbi.getKarosserieComboBox().hasFocus() || this.mFbi.getModellComboBox().hasFocus() || this.mFbi.getKatalogausfuehrungComboBox().hasFocus() || this.mFbi.getBaujahrComboBox().hasFocus() || this.mFbi.getZulassungsmonatComboBox().hasFocus() || this.mFbi.getLenkungComboBox().hasFocus() || this.mFbi.getGetriebeComboBox().hasFocus()) && e.getStateChange() == 1) {
            this.handleFahrzeugdatenItemStateChangedEvent(e);
        }
    }

    public void handleFahrzeugdatenItemStateChangedEvent(ItemEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JComboBox)) {
            return;
        }
        if (event.getSource() == this.mFbi.getBauartComboBox()) {
            this.mFbi.setInitialeAnzeigeMotorrad();
            if (this.mFbi.getBauartComboBox().getSelectedIndex() == 0) {
                mModel.setBaureihe(null);
            } else {
                int index = this.mFbi.getBauartComboBox().getSelectedIndex() - 1;
                this.ladeBaureihen(index);
                mModel.setBauart(mModel.getListBauarten().get(index));
                this.mFbi.initBaureihen();
            }
        } else if (event.getSource() == this.mFbi.getBaureihenComboBox()) {
            this.mFbi.setInitialeAnzeige();
            if (this.mFbi.getBaureihenComboBox().getSelectedIndex() == 0) {
                mModel.setKarosserieform(null);
            } else {
                int index = this.mFbi.getBaureihenComboBox().getSelectedIndex() - 1;
                mModel.setBaureihe(mModel.getListBaureihen().get(index));
                this.mFbi.initKarosserieformen();
            }
            if (this.mFbi.getSelectedBaureihenText().length() > 20) {
                this.mFbi.getBaureihenComboBox().setToolTipText(this.mFbi.getSelectedBaureihenText());
            } else {
                this.mFbi.getBaureihenComboBox().setToolTipText(null);
            }
        } else if (event.getSource() == this.mFbi.getKarosserieComboBox()) {
            this.mFbi.anzeigeNurBisKarosserie();
            if (this.mFbi.getKarosserieComboBox().getSelectedIndex() == 0) {
                mModel.setModell(null);
            } else {
                int index = this.mFbi.getKarosserieComboBox().getSelectedIndex() - 1;
                mModel.setKarosserieform(mModel.getBaureihe().getKarosserieForm().get(index));
                this.mFbi.initModelle();
            }
        } else if (event.getSource() == this.mFbi.getModellComboBox()) {
            this.mFbi.anzeigeNurBisModelle();
            if (this.mFbi.getModellComboBox().getSelectedIndex() > 0) {
                this.ladeKatalogausf\u00fchrung(this.mFbi.getModellComboBox().getSelectedIndex() - 1);
                this.mFbi.initKatalogausfuehrungen();
            } else {
                mModel.setIndexSelectedKatalogausf\u00fchrung(-1);
            }
            if (this.mFbi.getSelectedModellText().length() > 20) {
                this.mFbi.getModellComboBox().setToolTipText(this.mFbi.getSelectedModellText());
            } else {
                this.mFbi.getModellComboBox().setToolTipText(null);
            }
        } else if (event.getSource() == this.mFbi.getKatalogausfuehrungComboBox()) {
            if (this.mFbi.getKatalogausfuehrungComboBox().getSelectedIndex() == 0) {
                this.mFbi.anzeigeNurBisKatalog();
                mModel.setIndexSelectedKatalogausf\u00fchrung(-1);
            } else {
                mModel.setIndexSelectedKatalogausf\u00fchrung(this.mFbi.getKatalogausfuehrungComboBox().getSelectedIndex() - 1);
                if (mModel.getFahrzeug() != null && !mModel.getFahrzeug().getKatalogausf().equals(mModel.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung())) {
                    mModel.getFahrzeug().setKatalogausf(mModel.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung());
                    this.mFBIDataloader.getFImitAttr();
                }
                MarketingProdukt marketingProdukt = ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt();
                String produktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
                if (marketingProdukt.isLenkungNoetig() || marketingProdukt.isGetriebeNoetig() || marketingProdukt.isDatumNoetig()) {
                    Fahrzeug fahrzeug = new Fahrzeug();
                    fahrzeug.setBaureihe(mModel.getBaureihe().getBaureihe());
                    fahrzeug.setKarosserie(mModel.getKarosserieform().getKarosserieForm());
                    fahrzeug.setModell(mModel.getModell().getModell());
                    fahrzeug.setKatalogausf(mModel.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung());
                    if (produktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                        fahrzeug.setBauArt(mModel.getBauart().getBauart().charAt(0));
                    }
                    this.checkFahrzeug(fahrzeug);
                    if (produktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) && (mModel.isLenkungNoetig() || mModel.isGetriebeNoetig() || mModel.isDatumNoetig())) {
                        this.mFbi.initLenkungen();
                    } else if (produktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()) && mModel.isDatumNoetig()) {
                        this.mFbi.aktiviereBaujahreComboBox(true);
                    }
                }
            }
        } else if (event.getSource() == this.mFbi.getLenkungComboBox()) {
            if (mModel.getFahrzeug() != null) {
                mModel.getFahrzeug().setGetriebe(null);
            }
            if (this.mFbi.getLenkungComboBox().getSelectedIndex() == 0) {
                mModel.setIndexSelectedLenkung(-1);
                this.mFbi.aktiviereGetriebeComboBox(false);
            } else {
                mModel.setIndexSelectedLenkung(this.mFbi.getLenkungComboBox().getSelectedIndex() - 1);
                if (mModel.isGetriebeNoetig() || mModel.isDatumNoetig()) {
                    this.mFbi.aktiviereGetriebeComboBox(true);
                }
            }
        } else if (event.getSource() == this.mFbi.getGetriebeComboBox()) {
            if (mModel.getFahrzeug() != null) {
                mModel.getFahrzeug().setBaujahr(null);
            }
            if (this.mFbi.getGetriebeComboBox().getSelectedIndex() == 0) {
                mModel.setIndexSelectedGetriebe(-1);
                this.mFbi.aktiviereBaujahreComboBox(false);
            } else {
                mModel.setIndexSelectedGetriebe(this.mFbi.getGetriebeComboBox().getSelectedIndex() - 1);
                if (mModel.isDatumNoetig()) {
                    this.mFbi.aktiviereBaujahreComboBox(true);
                }
            }
        } else if (event.getSource() == this.mFbi.getBaujahrComboBox()) {
            if (mModel.getFahrzeug() != null) {
                mModel.getFahrzeug().setZulassungsmonat(null);
            }
            if (this.mFbi.getBaujahrComboBox().getSelectedIndex() == 0) {
                mModel.setIndexSelectedBaujahr(-1);
                this.mFbi.aktiviereZulassungsComboBox(false);
            } else {
                mModel.setIndexSelectedBaujahr(this.mFbi.getBaujahrComboBox().getSelectedIndex() - 1);
                this.mFbi.aktiviereZulassungsComboBox(true);
            }
        } else if (event.getSource() == this.mFbi.getZulassungsmonatComboBox()) {
            if (this.mFbi.getZulassungsmonatComboBox().getSelectedIndex() == 0) {
                mModel.setIndexSelectedZulassungsmonat(-1);
            } else {
                mModel.setIndexSelectedZulassungsmonat(this.mFbi.getZulassungsmonatComboBox().getSelectedIndex() - 1);
            }
        }
        this.fzIdausreichend();
        this.mFbi.updateUI();
    }

    private void fzIdausreichend() {
        if (mModel.isEnoughSelected()) {
            this.mFbi.aktiviereWeiterPfeil(true);
            this.berecheneBedingungen();
        } else {
            mModel.setFahrzeug(null);
            this.mFbi.getUebernehmenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
            this.mFbi.getPruefenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
            this.mFbi.aktiviereWeiterPfeil(false);
            this.mFbi.getBedingungsPanel();
            mModel.setBedingungermittelt(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleButtonAction(MouseEvent e) {
        Cursor oldCursor = Cursor.getPredefinedCursor(0);
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.mFbi.setCursor(Cursor.getPredefinedCursor(3));
            if (e.getComponent() == this.mFbi.getUebernehmenButton()) {
                oldCursor = this.mFbi.getUebernehmenButton().getCursor();
                this.mFbi.getUebernehmenButton().setCursor(Cursor.getPredefinedCursor(3));
                if ((mModel.isAllSelected() || mModel.isVinIdentified() || mModel.getFahrzeug() != null) && mModel.isBedingungermittelt()) {
                    WorkflowController.getInstance().setFzBedIdentified(true);
                    MainController.getInstance().getMainFrame().getMainPanel().removeFBI();
                    MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("add");
                    MainController.getInstance().getMainFrame().getPrototypeMenuBar().enableIcon("remove");
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(mModel.getFahrzeug());
                    if (mModel.getBTEBedingungsmenge() != null) {
                        Bedingungsmenge menge = this.mFbi.getBedMenge() != null ? this.mFbi.getBedMenge() : mModel.getBTEBedingungsmenge().getBedingungsmenge();
                        if (this.mFbi.getBedingungsCheckboxes() != null) {
                            for (int ii = 0; ii < this.mFbi.getBedingungsCheckboxes().size(); ++ii) {
                                String bedWert = "";
                                bedWert = this.mFbi.getBedingungsCheckboxes().get(ii).isSelected() ? "1" : "2";
                                try {
                                    menge.setBedWert(Long.decode(this.mFbi.getBedingungsCheckboxes().get(ii).getName()), new Bedingungswert(bedWert));
                                    continue;
                                }
                                catch (InvalidInitializationException e1) {
                                    log.error((Object)"setBedWert", (Throwable)e1);
                                }
                            }
                        }
                        GlobalObjects.getInstance().getIpacData().getFahrzeug().setBedingungsMenge(menge);
                    }
                    WorkflowController.getInstance().setAddKonfigurationDataSet(true);
                    ControllerNavigationPanel.getInstance().getNavigationPanel().setRefreshForFZChange(true);
                    StatusBar statusBar = MainController.getInstance().getMainFrame().getStatusBar();
                    Fahrzeug fahrzeug = GlobalObjects.getInstance().getIpacData().getFahrzeug();
                    String kategorie = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKategorieText();
                    if (fahrzeug != null) {
                        StringBuilder bui = new StringBuilder(" ");
                        bui.append(Resource.getInstance().getFuer());
                        bui.append(" ");
                        bui.append(fahrzeug.getBaureiheBezeichnung()).append(" ").append(fahrzeug.getKarosserieBezeichnung());
                        bui.append(" ").append(fahrzeug.getModellBezeichnung());
                        bui.append(" ").append(fahrzeug.getKatalogausf());
                        kategorie = kategorie + bui.toString();
                        if (!statusBar.getStatusName(2).equals(kategorie)) {
                            statusBar.removeStatus(2);
                            statusBar.addNewStatusAtIndex(" > " + kategorie, "SUBCAT", 2);
                        }
                    }
                    this.mFbi.getUebernehmenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
                    this.mFbi.getPruefenButton().setEnabled(false, WorkflowController.getInstance().getMarkenLayout());
                    WorkflowController.getInstance().changeState("TECHNIK");
                    if (!ControllerTechnikPanel.getInstance().hasErrors()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ClientKonfiguration.getClientKonfiguration().speichereKonfiguration("TECHNIK");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    return;
                }
                this.mFbi.getUebernehmenButton().setCursor(oldCursor);
            } else if (e.getComponent() == this.mFbi.getAbbrechenButton()) {
                oldCursor = this.mFbi.getAbbrechenButton().getCursor();
                this.mFbi.getAbbrechenButton().setCursor(Cursor.getPredefinedCursor(3));
                this.mFbi.clearFBI();
                if (!mModel.isVinIdentified() && !mModel.isAttrIdentified()) {
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(null);
                }
                WorkflowController.getInstance().changeState("MARKETING");
                this.mFbi.getAbbrechenButton().setCursor(oldCursor);
            } else if (e.getComponent() == this.mFbi.getKundenDialogLabel()) {
                if (GlobalObjects.getInstance().getIpacData().getFahrzeug() == null) {
                    ControllerDialogKundeKeyReader.getInstance().getDialogKunde().showDialog(WorkflowController.getInstance().getMarkenLayout());
                    if (ControllerDialogKundeKeyReader.getInstance().getDialogKunde().getDialogResult() == 1) {
                        String vin = ControllerDialogKundeKeyReader.getInstance().getDialogKunde().getVin();
                        this.mFbi.setVinText(vin);
                    }
                    this.mFbi.getVinTextField().requestFocusInWindow();
                    this.mFbi.getVinTextField().postActionEvent();
                }
            } else if (e.getComponent() == this.mFbi.getNext()) {
                this.berecheneBedingungen();
            } else if (e.getComponent() == this.mFbi.getPruefenButton()) {
                boolean result;
                oldCursor = this.mFbi.getAbbrechenButton().getCursor();
                this.mFbi.getPruefenButton().setCursor(Cursor.getPredefinedCursor(3));
                boolean fahrzeugGlobal = false;
                Fahrzeug oldFz = GlobalObjects.getInstance().getIpacData().getFahrzeug();
                if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null) {
                    fahrzeugGlobal = true;
                }
                GlobalObjects.getInstance().getIpacData().setFahrzeug(mModel.getFahrzeug());
                if (mModel.getBTEBedingungsmenge() != null) {
                    Bedingungsmenge menge = this.mFbi.getBedMenge() != null ? this.mFbi.getBedMenge() : mModel.getBTEBedingungsmenge().getBedingungsmenge();
                    if (this.mFbi.getBedingungsCheckboxes() != null) {
                        for (int ii = 0; ii < this.mFbi.getBedingungsCheckboxes().size(); ++ii) {
                            String bedWert = "";
                            bedWert = this.mFbi.getBedingungsCheckboxes().get(ii).isSelected() ? "1" : "2";
                            try {
                                menge.setBedWert(Long.decode(this.mFbi.getBedingungsCheckboxes().get(ii).getName()), new Bedingungswert(bedWert));
                                continue;
                            }
                            catch (InvalidInitializationException e1) {
                                log.error((Object)"setBedWert", (Throwable)e1);
                            }
                        }
                    }
                    GlobalObjects.getInstance().getIpacData().getFahrzeug().setBedingungsMenge(menge);
                }
                if (result = ControllerTechnikPanel.getInstance().createModel("Pruefen")) {
                    JOptionPane.showConfirmDialog(this.mFbi, Resource.getInstance().getProduktVerfuegbar(), Resource.getInstance().getInformation(), -1, 1, 100, -180);
                } else {
                    String errorMessage = "<html>" + Resource.getInstance().getProduktNichtVerfuegbar() + "</html>";
                    int error = ControllerTechnikPanel.getInstance().getError();
                    if (error == 2) {
                        errorMessage = "<html>" + Resource.getInstance().getNichtVerfuegbarAlter() + "</html>";
                    } else if (error == 5) {
                        errorMessage = "<html>" + Resource.getInstance().getNichtVerfuegbarZusatz() + "</html>";
                    } else if (error == 3 || error == 4) {
                        errorMessage = "<html>" + Resource.getInstance().getNichtVerfuegbarVar() + "</html>";
                    }
                    JOptionPane.showConfirmDialog(this.mFbi, errorMessage, Resource.getInstance().getInformation(), -1, 1, 100, -180);
                }
                if (fahrzeugGlobal) {
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(oldFz);
                } else {
                    GlobalObjects.getInstance().getIpacData().setFahrzeug(null);
                }
                this.mFbi.getPruefenButton().setCursor(oldCursor);
            }
        }
        finally {
            this.mFbi.setCursor(Cursor.getPredefinedCursor(0));
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void berecheneBedingungen() {
        try {
            this.mFbi.getNext().setCursor(Cursor.getPredefinedCursor(3));
            if (mModel.isEnoughSelected() || mModel.isVinIdentified() || mModel.getFahrzeug() != null) {
                if (mModel.isVinIdentified()) {
                    FzgSucheInfo oFzgSucheInfo = FBIDataloader.getFIByFahrgesellnummer(mModel.getFahrzeug().getFahrgestellnummer());
                    if (oFzgSucheInfo == null) {
                        return;
                    }
                    ControllerFBI.getModel().createFahrzeugFromFzIdInfo2(oFzgSucheInfo);
                } else {
                    this.mFBIDataloader.getFImitAttr();
                }
                this.mFbi.aktiviereWeiterPfeil(false);
                BTEBedingungsmenge menge = FBIDataloader.getBedingungen(mModel.getMarketingProdukt());
                mModel.setBTEBedingungsmenge(menge);
                mModel.setBedingungermittelt(true);
                this.mFbi.setBedingungen2();
                this.mFbi.getUebernehmenButton().setEnabled(true, WorkflowController.getInstance().getMarkenLayout());
                this.mFbi.getPruefenButton().setEnabled(true, WorkflowController.getInstance().getMarkenLayout());
            }
        }
        finally {
            this.mFbi.getNext().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            return;
        }
        this.handleButtonAction(e);
    }

    public static FBIModel getModel() {
        if (mModel == null) {
            mModel = ControllerMarketingPanel.getInstance().getModel() == null ? new FBIModel(null) : new FBIModel(ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt());
        }
        return mModel;
    }

    static {
        log = Logger.getLogger(ControllerFBI.class);
    }
}

