/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.AusstattungsPanel;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import webetk.app.Bedingungsmenge;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.resources.Resource;

public class FBA
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GridBagConstraints gbc;
    private static final String FAHRZEUGDATEN = "Fahrzeugdaten";
    private static final String BEDINGUNGEN = "Bedingungen des Produkts";
    private static final String AUSSTATTUNG = "Ausstattung";
    public static final int MAX_LABEL_LENGTH = 15;
    private static final String VIN = "VIN:";
    private JLabel bauart;
    private JLabel baureihe;
    private JLabel karosserie;
    private JLabel modell;
    private JLabel katalog;
    private JLabel lenkung;
    private JLabel getriebe;
    private JLabel baujahr;
    private JLabel zulassung;
    private JLabel vin;
    private JLabel bauartData;
    private JLabel baureiheData;
    private JLabel karosserieData;
    private JLabel modellData;
    private JLabel katalogData;
    private JLabel lenkungData;
    private JLabel getriebeData;
    private JLabel baujahrData;
    private JLabel zulassungData;
    private JLabel vinData;
    private static final Dimension panelDim = new Dimension(800, 180);
    private static final Dimension buttonDim = new Dimension(785, 25);
    private static final Dimension contentDim = new Dimension(780, 95);
    private MarkenLayout mLayoutFba;
    private JPanel menuPanel;
    private JPanel content;
    private JPanel[] contentPanels;
    private JLabel[] menus;
    private Fahrzeug aktuellFzg;
    private boolean isVisible = false;
    private ArrayList<JCheckBox> bedingungen = new ArrayList();

    public FBA(MarkenLayout markenLayout, Fahrzeug fzg) {
        this.mLayoutFba = markenLayout;
        this.aktuellFzg = fzg;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(panelDim);
        this.setMinimumSize(panelDim);
        this.setBorder(BorderFactory.createLineBorder(this.mLayoutFba.getSelectedReiterBackground(), 10));
        this.content = new JPanel(new CardLayout());
        this.content.setPreferredSize(contentDim);
        this.content.setMinimumSize(contentDim);
        this.content.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.contentPanels = new JPanel[3];
        this.createContentPanels();
        ((CardLayout)this.content.getLayout()).first(this.content);
        this.menus = new JLabel[3];
        this.menus = this.createMenus();
        this.menuPanel = new JPanel(new GridLayout(1, 3));
        this.menuPanel.setPreferredSize(buttonDim);
        this.menuPanel.setMinimumSize(buttonDim);
        this.menuPanel = this.setMenuPanel();
        this.gbc = this.mLayoutFba.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.menuPanel, this.gbc);
        this.gbc = this.mLayoutFba.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.content, this.gbc);
        this.validate();
        this.updateUI();
    }

    private JPanel setMenuPanel() {
        this.menuPanel.setBorder(BorderFactory.createLineBorder(this.mLayoutFba.getPrimaryBackground()));
        this.menuPanel.setBackground(this.mLayoutFba.getPrimaryBackground());
        for (int i = 0; i < this.menus.length; ++i) {
            this.menuPanel.add(this.menus[i]);
        }
        this.menuPanel.validate();
        return this.menuPanel;
    }

    public void changeFBABox(MarkenLayout markenLayout, Fahrzeug fzg) {
        this.setLayout(markenLayout);
        this.aktuellFzg = fzg;
        this.bauartData.setText(this.aktuellFzg.getBauartBezeichnung());
        this.baureiheData.setText(this.aktuellFzg.getBaureiheBezeichnung());
        this.karosserieData.setText(this.aktuellFzg.getKarosserieBezeichnung());
        if (this.aktuellFzg.getModellBezeichnung().length() > 15) {
            this.modellData.setText(this.aktuellFzg.getModellBezeichnung().substring(0, 15) + "...");
            this.modellData.setToolTipText(this.aktuellFzg.getModellBezeichnung());
        } else {
            this.modellData.setText(this.aktuellFzg.getModellBezeichnung());
        }
        this.katalogData.setText(this.aktuellFzg.getKatalogausf());
        if (this.aktuellFzg.getLenkung() != null && !this.aktuellFzg.getLenkung().equals("kA")) {
            this.lenkungData.setText(this.aktuellFzg.getLenkung());
        } else {
            this.lenkungData.setText("");
        }
        if (this.aktuellFzg.getGetriebe() != null && !this.aktuellFzg.getGetriebe().equals("kA")) {
            this.getriebeData.setText(this.aktuellFzg.getGetriebe());
        } else {
            this.getriebeData.setText("");
        }
        if (this.aktuellFzg.getBaujahr() != null && !this.aktuellFzg.getBaujahr().equals("kA")) {
            this.baujahrData.setText(this.aktuellFzg.getBaujahr());
        } else {
            this.baujahrData.setText("");
        }
        if (this.aktuellFzg.getZulassungsmonat() != null && !this.aktuellFzg.getZulassungsmonat().equals("kA")) {
            this.zulassungData.setText(this.aktuellFzg.getZulassungsmonat());
        } else {
            this.zulassungData.setText("");
        }
        this.vinData.setText(this.aktuellFzg.getFahrgestellnummer());
        this.createFahrzeugPanel();
        JCheckBox bedCheckBox = new JCheckBox();
        this.bedingungen.clear();
        Bedingungsmenge oBedingungen = fzg.getBedingungsMenge();
        this.createAusstattungPanel();
        try {
            oBedingungen.goFirst();
            while (true) {
                if (oBedingungen.isCurrentBteBedingung()) {
                    JPanel bedPanel = new JPanel(new GridBagLayout());
                    bedPanel.setBackground(this.mLayoutFba.getPrimaryBackground());
                    String sBenennung = oBedingungen.getCurrentBenennung() + "  (" + oBedingungen.getCurrentCode() + ")";
                    Long id = oBedingungen.getCurrentId();
                    String bedWert = oBedingungen.getBedWert(id);
                    String sCode = oBedingungen.getCurrentCode();
                    if (!ControllerMarketingPanel.getInstance().getModel().getMarketingProdukt().getSzCode().equals(sCode)) {
                        if (bedWert != null && bedWert.equals("1")) {
                            bedCheckBox = new JCheckBox(sBenennung, true);
                        }
                        if (bedWert != null && bedWert.equals("2")) {
                            bedCheckBox = new JCheckBox(sBenennung, false);
                        }
                        bedCheckBox.setBackground(this.mLayoutFba.getPrimaryBackground());
                        bedCheckBox.setPreferredSize(new Dimension(FBA.contentDim.width / 3 - 20, 20));
                        bedCheckBox.setMaximumSize(new Dimension(FBA.contentDim.width / 3 - 20, 20));
                        bedCheckBox.setToolTipText(sBenennung);
                        bedCheckBox.setEnabled(false);
                        this.bedingungen.add(bedCheckBox);
                    }
                }
                if (oBedingungen.hasNext()) {
                    oBedingungen.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setBedingungen();
        ((CardLayout)this.content.getLayout()).first(this.content);
        this.updateUI();
        this.validate();
    }

    private void setFahrzeugLabelLayout() {
        this.bauartData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.bauartData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.bauart.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.bauart.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.baureiheData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.baureiheData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.baureihe.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.baureihe.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.karosserieData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.karosserieData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.karosserie.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.karosserie.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.modellData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.modellData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.modell.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.modell.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.katalogData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.katalogData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.katalog.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.katalog.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.lenkungData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.lenkungData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.lenkung.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.lenkung.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.getriebeData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.getriebeData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.getriebe.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.getriebe.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.baujahrData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.baujahrData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.baujahr.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.baujahr.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.zulassungData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.zulassungData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.zulassung.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.zulassung.setForeground(this.mLayoutFba.getTertiaryForeground());
        this.vinData.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.vinData.setForeground(this.mLayoutFba.getPrimaryForeground());
        this.vin.setBackground(this.mLayoutFba.getTertiaryBackground());
        this.vin.setForeground(this.mLayoutFba.getTertiaryForeground());
    }

    private JLabel[] createMenus() {
        this.menus[0] = new JLabel(Resource.getInstance().getFahrzeugdaten(), 0);
        this.menus[0].setBackground(this.mLayoutFba.getSelectedReiterBackground());
        this.menus[0].setOpaque(true);
        this.menus[0].setForeground(this.mLayoutFba.getSelectedReiterForeground());
        this.menus[0].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.mLayoutFba.getPrimaryForeground()));
        this.menus[0].setName(FAHRZEUGDATEN);
        this.menus[1] = new JLabel(Resource.getInstance().getBedingungen(), 0);
        this.menus[1].setBackground(this.mLayoutFba.getDeselectedReiterBackground());
        this.menus[1].setOpaque(true);
        this.menus[1].setForeground(this.mLayoutFba.getDeselectedReiterForeground());
        this.menus[1].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.mLayoutFba.getPrimaryForeground()));
        this.menus[1].setName(BEDINGUNGEN);
        this.menus[2] = new JLabel(Resource.getInstance().getAusstattung(), 0);
        this.menus[2].setBackground(this.mLayoutFba.getDeselectedReiterBackground());
        this.menus[2].setOpaque(true);
        this.menus[2].setForeground(this.mLayoutFba.getDeselectedReiterForeground());
        this.menus[2].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.mLayoutFba.getPrimaryForeground()));
        this.menus[2].setName(AUSSTATTUNG);
        return this.menus;
    }

    private void setMenuLabelLayout() {
        if (this.menus != null) {
            this.menus[0].setBackground(this.mLayoutFba.getSelectedReiterBackground());
            this.menus[0].setForeground(this.mLayoutFba.getSelectedReiterForeground());
            this.menus[0].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.mLayoutFba.getPrimaryForeground()));
            this.menus[1].setBackground(this.mLayoutFba.getDeselectedReiterBackground());
            this.menus[1].setForeground(this.mLayoutFba.getDeselectedReiterForeground());
            this.menus[1].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.mLayoutFba.getPrimaryForeground()));
            this.menus[2].setBackground(this.mLayoutFba.getDeselectedReiterBackground());
            this.menus[2].setForeground(this.mLayoutFba.getDeselectedReiterForeground());
            this.menus[2].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.mLayoutFba.getPrimaryForeground()));
        }
    }

    public void createContentPanels() {
        this.createFahrzeugPanel();
        this.createBedingungenPanel();
        this.createAusstattungPanel();
    }

    private void createFahrzeugPanelLayout() {
        this.bauart = this.setLabelLayout(Resource.getInstance().getBauart() + ":", true);
        this.bauartData = this.setLabelDataLayout(this.aktuellFzg.getBauartBezeichnung(), true);
        this.baureihe = this.setLabelLayout(Resource.getInstance().getBaureihe() + ":", true);
        this.baureiheData = this.setLabelDataLayout(this.aktuellFzg.getBaureiheBezeichnung(), true);
        this.karosserie = this.setLabelLayout(Resource.getInstance().getKarosserie() + ":", true);
        this.karosserieData = this.setLabelDataLayout(this.aktuellFzg.getKarosserie(), true);
        this.modell = this.setLabelLayout(Resource.getInstance().getModell() + ":", true);
        this.modellData = this.setLabelDataLayout(this.aktuellFzg.getModellBezeichnung(), true);
        this.katalog = this.setLabelLayout(Resource.getInstance().getKatalogausfuehrung() + ":", true);
        this.katalogData = this.setLabelDataLayout(this.aktuellFzg.getKatalogausf(), true);
        if (this.mLayoutFba.isBMWMotorrad()) {
            this.katalogData.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.mLayoutFba.getTertiaryBackground()));
        }
        this.lenkung = this.setLabelLayout(Resource.getInstance().getLenkung() + ":", true);
        this.lenkungData = this.setLabelDataLayout(this.aktuellFzg.getLenkung(), true);
        this.getriebe = this.setLabelLayout(Resource.getInstance().getGetriebe() + ":", false);
        this.getriebeData = this.setLabelDataLayout(this.aktuellFzg.getGetriebe(), false);
        this.baujahr = this.setLabelLayout(Resource.getInstance().getBaujahr() + ":", true);
        this.baujahrData = this.setLabelDataLayout(this.aktuellFzg.getBaujahr(), true);
        this.zulassung = this.setLabelLayout(Resource.getInstance().getZulassungsmonat() + ":", true);
        this.zulassungData = this.setLabelDataLayout(this.aktuellFzg.getZulassungsmonat(), true);
        this.vin = this.setLabelLayout(VIN, false);
        this.vinData = this.setLabelDataLayout(this.aktuellFzg.getFahrgestellnummer(), false);
        if (this.mLayoutFba.isBMWMotorrad()) {
            this.vinData.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.mLayoutFba.getTertiaryBackground()));
        }
        this.setFahrzeugLabelLayout();
    }

    private void setPanelsLayout() {
        for (int i = 0; i < this.contentPanels.length; ++i) {
            this.contentPanels[i].setBackground(this.mLayoutFba.getPrimaryBackground());
            this.contentPanels[i].setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.mLayoutFba.getPrimaryBackground()));
            this.contentPanels[i].validate();
        }
    }

    private void createFahrzeugPanel() {
        this.createFahrzeugPanelLayout();
        JPanel dummy = new JPanel();
        if (this.aktuellFzg.getProduktArt() == 'M') {
            dummy.setLayout(new GridLayout(4, 6));
            dummy.add(this.bauart);
            dummy.add(this.bauartData);
            dummy.add(this.baujahr);
            dummy.add(this.baujahrData);
            dummy.add(this.baureihe);
            dummy.add(this.baureiheData);
            dummy.add(this.zulassung);
            dummy.add(this.zulassungData);
            dummy.add(this.modell);
            dummy.add(this.modellData);
            dummy.add(this.vin);
            dummy.add(this.vinData);
            dummy.add(this.katalog);
            dummy.add(this.katalogData);
            dummy.setBackground(this.mLayoutFba.getPrimaryBackground());
        } else {
            dummy.setLayout(new GridLayout(3, 6));
            dummy.add(this.baureihe);
            dummy.add(this.baureiheData);
            dummy.add(this.katalog);
            dummy.add(this.katalogData);
            dummy.add(this.baujahr);
            dummy.add(this.baujahrData);
            dummy.add(this.karosserie);
            dummy.add(this.karosserieData);
            dummy.add(this.lenkung);
            dummy.add(this.lenkungData);
            dummy.add(this.zulassung);
            dummy.add(this.zulassungData);
            dummy.add(this.modell);
            dummy.add(this.modellData);
            dummy.add(this.getriebe);
            dummy.add(this.getriebeData);
            dummy.add(this.vin);
            dummy.add(this.vinData);
        }
        this.contentPanels[0] = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = this.mLayoutFba.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 30, 0));
        this.contentPanels[0].add((Component)dummy, gbc2);
        this.contentPanels[0].setBackground(this.mLayoutFba.getPrimaryBackground());
        this.contentPanels[0].setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.mLayoutFba.getPrimaryBackground()));
        this.contentPanels[0].validate();
        this.contentPanels[0].updateUI();
        this.content.add(this.contentPanels[0], FAHRZEUGDATEN, 0);
        this.content.validate();
    }

    private JLabel setLabelLayout(String name, boolean setBottomBorder) {
        JLabel label = new JLabel("  " + name, 2);
        label.setOpaque(true);
        label.setBoldFont();
        label.setName(name);
        if (setBottomBorder) {
            label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.mLayoutFba.getPrimaryBackground()));
        }
        label.validate();
        return label;
    }

    private JLabel setLabelDataLayout(String name, boolean setBottomBorder) {
        JLabel label = new JLabel(name, 0);
        label.setOpaque(true);
        label.setName(name);
        if (setBottomBorder) {
            label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.mLayoutFba.getTertiaryBackground()));
        }
        return label;
    }

    public void changeContentPanel(String contentName) {
        ((CardLayout)this.content.getLayout()).show(this.content, contentName);
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i].getName().equals(contentName)) {
                this.setSelectedMenu(i, this.mLayoutFba.getSelectedReiterBackground(), this.mLayoutFba.getSelectedReiterForeground());
                continue;
            }
            this.setSelectedMenu(i, this.mLayoutFba.getDeselectedReiterBackground(), this.mLayoutFba.getDeselectedReiterForeground());
        }
    }

    private void setSelectedMenu(int menuCount, Color bckgr, Color foregr) {
        this.menus[menuCount].setBackground(bckgr);
        this.menus[menuCount].setForeground(foregr);
        this.menus[menuCount].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, foregr));
    }

    private void createBedingungenPanel() {
        this.contentPanels[1] = new JPanel(new GridBagLayout());
        this.contentPanels[1].setBackground(this.mLayoutFba.getPrimaryBackground());
        this.contentPanels[1].validate();
        this.content.add((Component)this.contentPanels[1], BEDINGUNGEN);
    }

    private void setBedingungen() {
        if (this.contentPanels[1] != null) {
            this.contentPanels[1].removeAll();
        }
        if (this.bedingungen != null && this.bedingungen.size() > 0) {
            JPanel bedPanel = new JPanel();
            bedPanel.setBackground(this.mLayoutFba.getPrimaryBackground());
            bedPanel.setLayout(new GridLayout((2 + this.bedingungen.size()) / 3, 3, 5, 10));
            JScrollPane panelScroll = new JScrollPane(bedPanel, 20, 31);
            panelScroll.setPreferredSize(contentDim);
            panelScroll.setBorder(BorderFactory.createEmptyBorder());
            for (int i = 0; i < this.bedingungen.size(); ++i) {
                bedPanel.add(this.bedingungen.get(i));
            }
            bedPanel.validate();
            GridBagConstraints gbc = this.mLayoutFba.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
            this.contentPanels[1].add((Component)panelScroll, gbc);
            this.contentPanels[1].validate();
        }
    }

    private void createAusstattungPanel() {
        if (GlobalObjects.getInstance().getIpacData().getFahrzeug().getAusstattung() != null) {
            AusstattungsPanel.resetInstance();
            this.contentPanels[2] = AusstattungsPanel.getInstance().getContainerPanel();
            AusstattungsPanel.getInstance().setBackground(this.mLayoutFba.getPrimaryBackground());
            AusstattungsPanel.getInstance().setForeground(this.mLayoutFba.getPrimaryForeground());
            this.contentPanels[2].setBackground(this.mLayoutFba.getPrimaryBackground());
        } else {
            this.contentPanels[2] = new JPanel();
        }
        this.contentPanels[2].setBackground(this.mLayoutFba.getPrimaryBackground());
        this.contentPanels[2].validate();
        this.content.add((Component)this.contentPanels[2], AUSSTATTUNG);
    }

    private void setLayout(MarkenLayout markenLayout) {
        this.mLayoutFba = markenLayout;
        this.setBorder(BorderFactory.createLineBorder(this.mLayoutFba.getSelectedReiterBackground(), 10));
        this.content.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.menuPanel.setBorder(BorderFactory.createLineBorder(this.mLayoutFba.getPrimaryBackground()));
        this.menuPanel.setBackground(this.mLayoutFba.getPrimaryBackground());
        this.setPanelsLayout();
        this.setMenuLabelLayout();
        this.setFahrzeugLabelLayout();
        this.validate();
        this.updateUI();
    }

    public JLabel[] getMenus() {
        return this.menus;
    }

    public boolean getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(boolean visible) {
        this.isVisible = visible;
    }
}

