/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.zub.configurator.workflow.WorkflowController;
import java.util.ArrayList;
import webetk.app.BTEBedingungsmenge;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baujahr;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.Getriebe;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.KatalogAusfuehrung;
import webetk.app.zub.suche.Lenkung;
import webetk.app.zub.suche.Modell;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class FBIModel {
    private ArrayList<Bauart> mListBauarten;
    private Bauart mBauart;
    private ArrayList<Baureihe> mListBaureihen;
    private Baureihe mBaureihe;
    private KarosserieForm mKarosserieform;
    private Modell mModell;
    private ArrayList<String> mKatalogausfuehrung;
    private MarketingProdukt mMarketingProdukt;
    private Boolean mLenkungNoetig = null;
    private Boolean mGetriebeNoetig = null;
    private Boolean mDatumNoetig = null;
    private KatalogAusfuehrung mSelectedKatalogausf\u00fchrung;
    private int mIndexSelectedKatalogausf\u00fchrung;
    private int mIndexSelectedLenkung;
    private int mIndexSelectedBaujahr;
    private int mIndexSelectedGetriebe;
    private int mIndexSelectedZulassungsmonat;
    private BTEBedingungsmenge mBTEBedingungsmenge;
    private boolean mBedingungermittelt = false;
    private Fahrzeug mFahrzeug = null;
    private boolean mVinIdentified = false;
    private boolean mAttrIdentified = false;
    public static final int VIN_COMMAND = 1;
    public static final int ATTRIBUT_COMMAND = 2;
    private ArrayList<String> mBaureihenTooltip = null;
    private ArrayList<String> mModellTooltip = null;

    public FBIModel(MarketingProdukt marketingProdukt) {
        this.mMarketingProdukt = marketingProdukt;
        this.mLenkungNoetig = null;
        this.mGetriebeNoetig = null;
        this.mDatumNoetig = null;
    }

    public ArrayList<Baureihe> getListBaureihen() {
        return this.mListBaureihen;
    }

    public void setListBaureihen(ArrayList<Baureihe> baureihen) {
        this.mListBaureihen = baureihen;
    }

    public Baureihe getBaureihe() {
        return this.mBaureihe;
    }

    public void setBaureihe(Baureihe baureihe) {
        this.mBaureihe = baureihe;
        this.mKarosserieform = null;
        this.mModell = null;
        this.mKatalogausfuehrung = null;
    }

    public KarosserieForm getKarosserieform() {
        return this.mKarosserieform;
    }

    public void setKarosserieform(KarosserieForm karosserieform) {
        this.mKarosserieform = karosserieform;
        this.mModell = null;
        this.mKatalogausfuehrung = null;
    }

    public Modell getModell() {
        return this.mModell;
    }

    public void setModell(Modell modell) {
        this.mModell = modell;
        this.mKatalogausfuehrung = null;
    }

    public ArrayList<String> getKatalogausfuehrung() {
        return this.mKatalogausfuehrung;
    }

    public void setKatalogausfuehrung(ArrayList<String> katalogausfuehrung) {
        this.mKatalogausfuehrung = katalogausfuehrung;
    }

    public BTEBedingungsmenge getBTEBedingungsmenge() {
        return this.mBTEBedingungsmenge;
    }

    public void setBTEBedingungsmenge(BTEBedingungsmenge bteBedingungsmenge) {
        this.mBTEBedingungsmenge = bteBedingungsmenge;
    }

    public KatalogAusfuehrung getSelectedKatalogausf\u00fchrung() {
        return this.mSelectedKatalogausf\u00fchrung;
    }

    public void setSelectedKatalogausf\u00fchrung(KatalogAusfuehrung selectedKatalogausf\u00fchrung) {
        this.mSelectedKatalogausf\u00fchrung = selectedKatalogausf\u00fchrung;
    }

    public void setIndexSelectedKatalogausf\u00fchrung(int selectedIndexKatalogausf\u00fchrung) {
        this.mIndexSelectedKatalogausf\u00fchrung = selectedIndexKatalogausf\u00fchrung;
        if (selectedIndexKatalogausf\u00fchrung != -1) {
            this.mSelectedKatalogausf\u00fchrung = this.mModell.getKatalogausfuehrungen().get(this.mIndexSelectedKatalogausf\u00fchrung);
        }
    }

    public boolean isVollstaendigeFI() {
        return true;
    }

    public Lenkung getSelectedLenkung() {
        if (this.mIndexSelectedLenkung > -1 && this.mIndexSelectedLenkung < this.getSelectedKatalogausf\u00fchrung().getLenkungen().size()) {
            return this.getSelectedKatalogausf\u00fchrung().getLenkungen().get(this.mIndexSelectedLenkung);
        }
        return null;
    }

    public void setIndexSelectedLenkung(int index) {
        this.mIndexSelectedLenkung = index;
    }

    public Baujahr getSelectedBaujahr() {
        if (WorkflowController.getInstance().getMarkenLayout().isBMW() || WorkflowController.getInstance().getMarkenLayout().isBMWi() || WorkflowController.getInstance().getMarkenLayout().isMINI()) {
            if (this.mIndexSelectedBaujahr > -1 && this.mIndexSelectedBaujahr < this.getSelectedGetriebe().getBaujahre().size()) {
                return (Baujahr)this.getSelectedGetriebe().getBaujahre().get(this.mIndexSelectedBaujahr);
            }
        } else if (WorkflowController.getInstance().getMarkenLayout().isBMWMotorrad() && this.mIndexSelectedBaujahr > -1 && this.mIndexSelectedBaujahr < this.getSelectedKatalogausf\u00fchrung().getBaujahreMotorrad().size()) {
            return this.getSelectedKatalogausf\u00fchrung().getBaujahreMotorrad().get(this.mIndexSelectedBaujahr);
        }
        return null;
    }

    public void setIndexSelectedBaujahr(int index) {
        this.mIndexSelectedBaujahr = index;
    }

    public Getriebe getSelectedGetriebe() {
        if (this.mIndexSelectedGetriebe > -1 && this.mIndexSelectedGetriebe < this.getSelectedLenkung().getGetriebe().size()) {
            return this.getSelectedLenkung().getGetriebe().get(this.mIndexSelectedGetriebe);
        }
        return null;
    }

    public void setIndexSelectedGetriebe(int index) {
        this.mIndexSelectedGetriebe = index;
    }

    public String getSelectedZulassungsmonat() {
        if (this.mIndexSelectedZulassungsmonat > -1 && this.mIndexSelectedZulassungsmonat < this.getSelectedBaujahr().getMonate().size()) {
            return this.getSelectedBaujahr().getMonate().get(this.mIndexSelectedZulassungsmonat);
        }
        return null;
    }

    public void setIndexSelectedZulassungsmonat(int index) {
        this.mIndexSelectedZulassungsmonat = index;
    }

    public boolean isAllSelected() {
        if (this.mBaureihe == null) {
            return false;
        }
        if (this.mKarosserieform == null) {
            return false;
        }
        if (this.mModell == null) {
            return false;
        }
        if (this.mIndexSelectedKatalogausf\u00fchrung == -1) {
            return false;
        }
        if (this.mIndexSelectedBaujahr == -1) {
            return false;
        }
        if (this.mIndexSelectedGetriebe == -1) {
            return false;
        }
        if (this.mIndexSelectedLenkung == -1) {
            return false;
        }
        return this.mIndexSelectedZulassungsmonat != -1;
    }

    public boolean isEnoughSelected() {
        if (this.mBaureihe == null) {
            return false;
        }
        if (this.mKarosserieform == null) {
            return false;
        }
        if (this.mModell == null) {
            return false;
        }
        if (this.mIndexSelectedKatalogausf\u00fchrung == -1) {
            return false;
        }
        if (WorkflowController.getInstance().getMarkenLayout().getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if ((this.isLenkungNoetig() || this.isGetriebeNoetig() || this.isDatumNoetig()) && this.mIndexSelectedLenkung == -1) {
                return false;
            }
            if ((this.isGetriebeNoetig() || this.isDatumNoetig()) && this.mIndexSelectedGetriebe == -1) {
                return false;
            }
        }
        if (this.isDatumNoetig()) {
            if (this.mIndexSelectedBaujahr == -1) {
                return false;
            }
            if (this.mIndexSelectedZulassungsmonat == -1) {
                return false;
            }
        }
        return true;
    }

    public boolean isFzIdausreichend(Fahrzeug fzg) {
        if (fzg != null) {
            if ((this.isLenkungNoetig() || this.isGetriebeNoetig() || this.isDatumNoetig()) && (fzg.getLenkung() == null || fzg.getLenkung().equals("kA"))) {
                return false;
            }
            if ((this.isGetriebeNoetig() || this.isDatumNoetig()) && (fzg.getGetriebe() == null || fzg.getGetriebe().equals("kA"))) {
                return false;
            }
            if (this.isDatumNoetig()) {
                if (fzg.getBaujahr() == null || fzg.getBaujahr().equals("kA")) {
                    return false;
                }
                if (fzg.getZulassungsmonat() == null || fzg.getZulassungsmonat().equals("kA")) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void setFahrzeug(Fahrzeug fahrzeug) {
        this.mFahrzeug = fahrzeug;
    }

    public boolean isVinIdentified() {
        return this.mVinIdentified;
    }

    public void setVinIdentified(boolean vinIdentified) {
        this.mVinIdentified = vinIdentified;
    }

    public Fahrzeug getFahrzeug() {
        return this.mFahrzeug;
    }

    public String getDialogTitel() {
        return Resource.getInstance().getFehlerErmittlungBedingungsmenge();
    }

    public void createFahrzeugFromFzIdInfo(FzgSucheInfo oFzgIdInfo) {
        Fahrzeug newFahrzeug = new Fahrzeug(oFzgIdInfo);
        if (this.mFahrzeug != null) {
            newFahrzeug.setBauArt(this.mFahrzeug.getBauart().charAt(0));
            newFahrzeug.setBaureihe(this.mFahrzeug.getBaureihe());
            newFahrzeug.setBaureiheBezeichnung(this.mFahrzeug.getBaureiheBezeichnung());
            newFahrzeug.setKarosserie(this.mFahrzeug.getKarosserie());
            newFahrzeug.setKarosserieBezeichnung(this.mFahrzeug.getKarosserieBezeichnung());
            newFahrzeug.setModell(this.mFahrzeug.getModell());
            newFahrzeug.setModellBezeichnung(this.mFahrzeug.getModellBezeichnung());
            newFahrzeug.setKatalogausf(this.mFahrzeug.getKatalogausf());
        }
        this.mFahrzeug = newFahrzeug;
    }

    public Fahrzeug createFahrzeugFromFzIdInfo2(FzgSucheInfo oFzgIdInfo) {
        if (this.mFahrzeug != null) {
            this.mFahrzeug.setFzgSucheInfo(oFzgIdInfo);
        } else {
            this.mFahrzeug = new Fahrzeug(oFzgIdInfo);
            this.mFahrzeug.setBaureihe(this.mBaureihe.getBaureihe());
            this.mFahrzeug.setBaureiheBezeichnung(this.mBaureihe.getBezeichnung());
            this.mFahrzeug.setKarosserie(this.mKarosserieform.getKarosserieForm());
            this.mFahrzeug.setKarosserieBezeichnung(this.mKarosserieform.getBezeichnung());
            this.mFahrzeug.setModell(this.mModell.getModell());
            this.mFahrzeug.setModellBezeichnung(this.mModell.getModell());
            this.mFahrzeug.setKatalogausf(this.getSelectedKatalogausf\u00fchrung().getKatalogAusfuehrung());
        }
        return this.mFahrzeug;
    }

    public void setAttrIdentified(boolean b) {
        this.mAttrIdentified = b;
    }

    public boolean isAttrIdentified() {
        return this.mAttrIdentified;
    }

    public boolean isBedingungermittelt() {
        return this.mBedingungermittelt;
    }

    public void setBedingungermittelt(boolean bedingungermittelt) {
        this.mBedingungermittelt = bedingungermittelt;
    }

    public MarketingProdukt getMarketingProdukt() {
        return this.mMarketingProdukt;
    }

    public void setMarketingProdukt(MarketingProdukt marketingprod) {
        this.mMarketingProdukt = marketingprod;
    }

    public boolean isLenkungNoetig() {
        if (this.mLenkungNoetig == null) {
            return this.mMarketingProdukt.isLenkungNoetig();
        }
        return this.mLenkungNoetig;
    }

    public void setLenkungNoetig(boolean lenkungNoetig) {
        this.mLenkungNoetig = lenkungNoetig;
    }

    public boolean isGetriebeNoetig() {
        if (this.mGetriebeNoetig == null) {
            return this.mMarketingProdukt.isGetriebeNoetig();
        }
        return this.mGetriebeNoetig;
    }

    public void setGetriebeNoetig(boolean getriebeNoetig) {
        this.mGetriebeNoetig = getriebeNoetig;
    }

    public boolean isDatumNoetig() {
        if (this.mDatumNoetig == null) {
            return this.mMarketingProdukt.isDatumNoetig();
        }
        return this.mDatumNoetig;
    }

    public void setDatumNoetig(boolean datumNoetig) {
        this.mDatumNoetig = datumNoetig;
    }

    public ArrayList<String> getBaureihenTooltip() {
        return this.mBaureihenTooltip;
    }

    public void setBaureihenTooltip(ArrayList<String> baureihenTooltip) {
        this.mBaureihenTooltip = baureihenTooltip;
    }

    public ArrayList<String> getModellTooltip() {
        return this.mModellTooltip;
    }

    public void setModellTooltip(ArrayList<String> modellTooltip) {
        this.mModellTooltip = modellTooltip;
    }

    public ArrayList<Bauart> getListBauarten() {
        return this.mListBauarten;
    }

    public void setListBauarten(ArrayList<Bauart> listBauarten) {
        this.mListBauarten = listBauarten;
    }

    public Bauart getBauart() {
        return this.mBauart;
    }

    public void setBauart(Bauart bauart) {
        this.mBauart = bauart;
    }
}

