/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.common.Preise;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubMarketing;
import webetk.resources.Resource;

public class MarketingDataloader {
    private static Logger log = Logger.getLogger(MarketingDataloader.class);
    private static final int MAX_DMS_FEHLERZEILEN = 20;

    public static MarketingProdukt getMarketingProdukt(String btenr, String bildPosNr, ProduktListenElement produktListeneElem, boolean isLifestyle) throws Exception {
        Fahrzeug fahrzeug;
        TrfZubMarketing trfMarketing = new TrfZubMarketing(null);
        int marktid = GlobalObjects.getInstance().getSessionInfo().getMarktId();
        if (marktid == -1) {
            marktid = 0;
        }
        trfMarketing.setValue("markt", marktid);
        trfMarketing.setValue("btnummer", btenr);
        trfMarketing.setValue("isLifestyle", isLifestyle ? "J" : "N");
        if (bildPosNr != null && bildPosNr.length() > 0) {
            trfMarketing.setValue("bildPosNr", bildPosNr);
        }
        if ((fahrzeug = GlobalObjects.getInstance().getIpacData().getFahrzeug()) != null) {
            trfMarketing.setValue("fahrzeug", fahrzeug);
        } else {
            FzgSucheInfo fzgSucheInfo = NavigationPanelDataLoader.getFzgZuSuche();
            if (fzgSucheInfo != null) {
                trfMarketing.setValue("fzgsucheinfo_app", fzgSucheInfo);
            }
        }
        GlobalObjects.getInstance().getServiceExecutor().executeService(trfMarketing, Command.LOAD_MARKETINGINFO_PRODUKT);
        if (trfMarketing.getError() != null) {
            Exception ex = trfMarketing.getError();
            MarketingDataloader.setDMSErrorMessage(ex);
        }
        Preise preise = null;
        if (produktListeneElem != null && produktListeneElem.getPreise() != null) {
            preise = produktListeneElem.getPreise();
            GlobalObjects.getInstance().getIpacData().setPreise(preise);
        }
        MarketingProdukt produkt = (MarketingProdukt)trfMarketing.getValue("marketingProdukt");
        log.debug((Object)("Marketingprodukt = " + produkt));
        if (preise != null) {
            produkt.ermittlePreiseZusatzprodukte(preise);
        }
        if (produktListeneElem != null) {
            produkt.setUnterkategorie(produktListeneElem.getUnterkategorie());
        }
        return produkt;
    }

    public static void setDMSErrorMessage(Exception ex) {
        String msgString = null;
        if (ex instanceof DMSException) {
            StringBuffer sMsg = new StringBuffer("<html> " + Resource.getInstance().getFehlerDmsAbgleich() + ".<br>");
            sMsg.append(Resource.getInstance().getMsgPosOhneDatenabgleich() + "<br>");
            DMSException exDms = (DMSException)ex;
            Collection aTeilenummern = exDms.getTeilenummern();
            Collection aPos = exDms.getPositionen();
            Collection aRetcodes = exDms.getRetCodes();
            if (aTeilenummern != null && aRetcodes != null) {
                int counter = 0;
                Iterator iTeilenummern = aTeilenummern.iterator();
                Iterator iPos = aPos.iterator();
                Iterator iRetcodes = aRetcodes.iterator();
                while (iTeilenummern.hasNext() && iRetcodes.hasNext()) {
                    ++counter;
                    String sTeilenummer = (String)iTeilenummern.next();
                    String sPos = ((Integer)iPos.next()).toString();
                    int nStatus = (Integer)iRetcodes.next();
                    sMsg.append(sPos + ":    " + sTeilenummer + ":    " + Resource.getInstance().getDmsFehlerText(nStatus) + "<br>");
                    if (counter <= 20) continue;
                    sMsg.append("... <br>");
                    break;
                }
            } else {
                int nStatus = Integer.parseInt(ex.getMessage());
                sMsg.append(Resource.getInstance().getDmsFehlerText(nStatus));
            }
            sMsg.append("</html>");
            msgString = sMsg.toString();
        } else {
            msgString = ex.getMessage();
        }
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), msgString, Resource.getInstance().getPreiseBestimmen(), 0);
    }
}

