/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.BlaetternPanel;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.content.marketing.TextPanel;
import de.esg.zub.configurator.content.marketing.WeitereInfoPanel;
import de.esg.zub.configurator.content.marketing.ZusatzproduktPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.Variante;
import webetk.resources.Resource;

public class MarketingPanel
extends Observable {
    public static final String INFO_LASTSHOWN = "INFO";
    public static final String ZUSATZ_LASTSHOWN = "ZUSATZ";
    private JPanel mMarketingPanel = new JPanel();
    private MarkenLayout mMarkenLayout;
    int maxSpalte1 = 0;
    int maxSpalte2 = 0;
    int maxSpalte3 = 0;
    private JLabel imageLabelBig = null;
    private JLabel platzhalter;
    private TextPanel mTextPanel;
    private ImageIcon mDefaultImage = null;
    private JPanel mPricePanel;
    private JPanel mLinkPanel;
    private JPanel mWeitereReiter;
    private JPanel mZusatzReiter;
    private WeitereInfoPanel mWeitereInfoPanel;
    private boolean mWeitereInfoShown = false;
    private boolean mWeitereInaktiv = false;
    private boolean mZusatzProdukteShown = false;
    private boolean mZusatzInaktiv = false;
    private String mLastShown = "";
    private JLabel mPriceLabel = null;
    private JLabel mInfoLabel = null;
    private JLabel mZusatzLabel = null;
    private JLabel mIconEinkaufswagen;
    private JLabel mIconTaschenrechner;
    private JLabel mOpenIconWeitere;
    private JLabel mOpenIconInaktivWeitere;
    private JLabel mCloseIconWeitere;
    private JLabel mOpenIconZusatz;
    private JLabel mCloseIconZusatz;
    private JLabel mOpenIconInaktivZusatz;
    private ZusatzproduktPanel mZusatzproduktPanel = null;
    private MarketingModel mModel;
    private boolean isFBAVisible = false;
    private BackgroundPanel mBackgrImagePanel;
    private BlaetternPanel mBlaetternPanel;

    public MarketingPanel(MarkenLayout layout) {
        this.mMarketingPanel.setLayout(new GridBagLayout());
        this.mMarkenLayout = layout;
        this.createComponents();
    }

    private void createComponents() {
        this.mOpenIconWeitere = new JLabel(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mOpenIconWeitere.setName("OPEN_WEITERE");
        this.mOpenIconInaktivWeitere = new JLabel(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mCloseIconWeitere = new JLabel(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mCloseIconWeitere.setName("CLOSE_WEITERE");
        this.mCloseIconWeitere.setCursor(Cursor.getPredefinedCursor(12));
        this.mOpenIconZusatz = new JLabel(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mOpenIconZusatz.setName("OPEN_ZUSATZ");
        this.mOpenIconZusatz.setCursor(Cursor.getPredefinedCursor(12));
        this.mOpenIconInaktivZusatz = new JLabel(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mCloseIconZusatz = new JLabel(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mCloseIconZusatz.setName("CLOSE_ZUSATZ");
        this.mCloseIconZusatz.setCursor(Cursor.getPredefinedCursor(12));
        this.mIconTaschenrechner = new JLabel(new ImageIcon(ImageCache.getInstance().getImage("Icons/neue_konfig1.gif")));
        this.mIconTaschenrechner.setName("KCursor.getPredefinedCursor(N");
        this.mIconTaschenrechner.setCursor(Cursor.getPredefinedCursor(12));
        this.mIconEinkaufswagen = new JLabel(new ImageIcon(ImageCache.getInstance().getImage("Icons/Bmw/warenkorb_bmw_klein_2.jpg")));
        this.mIconEinkaufswagen.setName("EINKAUFSWAGEN");
        this.mIconEinkaufswagen.setCursor(Cursor.getPredefinedCursor(12));
        this.mPricePanel = new JPanel();
        this.mPricePanel.setLayout(new GridBagLayout());
        this.mPricePanel.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
        this.mLinkPanel = new JPanel();
        this.mLinkPanel.setLayout(new GridBagLayout());
        this.mLinkPanel.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
        this.mWeitereReiter = new JPanel(new GridBagLayout());
        this.mWeitereReiter.setName(INFO_LASTSHOWN);
        this.mWeitereReiter.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
        this.mInfoLabel = this.mMarkenLayout.getLabel();
        this.mInfoLabel.setName(INFO_LASTSHOWN);
        this.mZusatzReiter = new JPanel(new GridBagLayout());
        this.mZusatzReiter.setName(ZUSATZ_LASTSHOWN);
        this.mZusatzReiter.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
        this.mZusatzLabel = this.mMarkenLayout.getLabel();
        this.mZusatzLabel.setName(ZUSATZ_LASTSHOWN);
        this.platzhalter = new JLabel();
    }

    public void setModel(MarketingModel model) {
        this.mModel = model;
    }

    public void setMarketingPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mMarketingPanel.removeAll();
        this.maxSpalte1 = 0;
        this.maxSpalte2 = 0;
        this.maxSpalte3 = 0;
        this.setTextPanel();
        this.setImage();
        this.setLeistePreis();
        if (this.mModel.hasZusatz()) {
            gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 11, new Insets(0, 0, 0, 0));
            this.mMarketingPanel.add((Component)this.platzhalter, gbc);
        } else {
            gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 11, new Insets(240, 0, 0, 0));
            this.mMarketingPanel.add((Component)this.platzhalter, gbc);
        }
    }

    public void setImage() {
        boolean isProduktbild = false;
        if (this.mModel.getMarketingProdukt().getImages() != null && this.mModel.getMarketingProdukt().getImages().size() > 0) {
            for (int i = 0; i < this.mModel.getMarketingProdukt().getImages().size(); ++i) {
                if (!this.mModel.getMarketingProdukt().getImages().get(i).getElementart().equals("")) continue;
                isProduktbild = true;
                this.mDefaultImage = this.mModel.getBteImage(i);
                this.mModel.setIndexAktuellesImage(i);
                break;
            }
        }
        if (!isProduktbild) {
            this.mDefaultImage = this.mModel.getBteImage(0);
            this.mModel.setIndexAktuellesImage(0);
        }
        if (this.mBackgrImagePanel != null) {
            this.mMarketingPanel.remove(this.mBackgrImagePanel);
        }
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 0, 0, 2, 18, new Insets(0, 0, 0, 0));
        this.mBackgrImagePanel = new BackgroundPanel(this.mDefaultImage);
        this.mBackgrImagePanel.setLayout(new GridBagLayout());
        this.mBackgrImagePanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mMarketingPanel.add((Component)this.mBackgrImagePanel, gbc);
        if (this.mModel.getMarketingProdukt().getImages() != null && this.mModel.getMarketingProdukt().getImages().size() > 0) {
            String name = "";
            if (this.mModel.getMarketingProdukt().getImages() != null && this.mModel.getMarketingProdukt().getImages().size() > 0) {
                name = this.mModel.getMarketingProdukt().getImages().get(this.mModel.getIndexAktuellesImage()).getProduktName();
            }
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 14, new Insets(235, 210, 0, 0));
            this.mBlaetternPanel = new BlaetternPanel(name.equals("") ? this.mModel.getMarketingProdukt().getProduktNamePlain() : name, this.mMarkenLayout);
            this.mBackgrImagePanel.add((Component)this.mBlaetternPanel, gbc);
            this.setChanged();
            this.notifyObservers(this.mBlaetternPanel);
        }
    }

    private void setTextPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mTextPanel = new TextPanel(this.mModel, this.mMarkenLayout);
        this.setChanged();
        this.notifyObservers(this.mTextPanel);
        this.mTextPanel.setTextPanelView();
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 2, 11, new Insets(5, 5, 5, 5));
        this.mMarketingPanel.add((Component)this.mTextPanel.getTextPanel(), gbc);
        this.mMarketingPanel.validate();
    }

    public void setLeistePreis() {
        this.mLinkPanel.removeAll();
        this.mPricePanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setReiter();
        gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 0, 0, 0, 17, new Insets(0, 0, 0, 0));
        this.mPricePanel.add((Component)this.mLinkPanel, gbc);
        this.mPriceLabel = this.mMarkenLayout.getLabel();
        String price = "<html>" + Resource.getInstance().getUnverbindlichePreisempfehlung() + "<br>" + Resource.getInstance().getAb() + " " + this.mModel.getPrice() + " +</html>";
        this.mPriceLabel.setText(price);
        gbc = this.setGridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 0, 0, 1, 13, new Insets(0, 10, 0, 10));
        this.mPricePanel.add((Component)this.mPriceLabel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.setIcon("EINKAUFWAGEN");
        this.mMarketingPanel.add((Component)this.mPricePanel, gbc);
    }

    private JPanel setReiter() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mWeitereReiter.removeAll();
        this.mZusatzReiter.removeAll();
        this.mWeitereReiter.setBorder(null);
        this.mZusatzReiter.setBorder(null);
        boolean isWeitereSet = false;
        if (this.mModel.hasWeitereInfo()) {
            this.mWeitereInaktiv = false;
            this.mWeitereInfoPanel = new WeitereInfoPanel(this.mModel, this.mMarkenLayout);
            this.mOpenIconWeitere.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.mCloseIconWeitere.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
            if (!this.mLastShown.equals(ZUSATZ_LASTSHOWN)) {
                this.setWeitereReiter(this.mCloseIconWeitere, Color.BLACK);
                this.mWeitereReiter.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getSelectedReiterBackground()));
                this.showWeitereInfoPanel();
                isWeitereSet = true;
            } else {
                this.setWeitereReiter(this.mOpenIconWeitere, Color.BLACK);
                isWeitereSet = false;
            }
        } else {
            this.mWeitereInaktiv = true;
            this.mWeitereInfoShown = false;
            this.removePanelWeitere(true);
            this.mOpenIconInaktivWeitere.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.setWeitereReiter(this.mOpenIconInaktivWeitere, Color.GRAY);
        }
        if (this.mModel.hasZusatz()) {
            this.mZusatzInaktiv = false;
            this.mOpenIconZusatz.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.mCloseIconZusatz.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.setZusatzProdukte();
            if (isWeitereSet) {
                this.setZusatzReiter(this.mOpenIconZusatz, Color.BLACK);
            } else {
                this.setZusatzReiter(this.mCloseIconZusatz, Color.BLACK);
                this.mZusatzReiter.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getSelectedReiterBackground()));
                this.mZusatzProdukteShown = true;
                gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 18, new Insets(3, 5, 5, 5));
                this.mMarketingPanel.add((Component)this.mZusatzproduktPanel.getOptionalPanel(), gbc);
            }
        } else {
            this.mZusatzInaktiv = true;
            this.mZusatzProdukteShown = false;
            this.mOpenIconInaktivZusatz.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.setZusatzReiter(this.mOpenIconInaktivZusatz, Color.GRAY);
        }
        this.mWeitereReiter.validate();
        this.mZusatzReiter.validate();
        this.mLinkPanel.validate();
        this.mWeitereReiter.updateUI();
        this.mZusatzReiter.updateUI();
        this.mLinkPanel.updateUI();
        return this.mLinkPanel;
    }

    public void changeReiterWeitereInfo() {
        if (this.mModel.hasWeitereInfo()) {
            this.mWeitereReiter.validate();
            if (this.mWeitereInaktiv) {
                this.mWeitereReiter.remove(this.mOpenIconInaktivWeitere);
            } else if (this.mWeitereInfoShown && !this.mWeitereInaktiv) {
                this.mWeitereReiter.remove(this.mCloseIconWeitere);
            } else {
                this.mWeitereReiter.remove(this.mOpenIconWeitere);
            }
            if (this.mWeitereInfoShown || !this.mWeitereInaktiv) {
                this.mMarketingPanel.remove(this.mWeitereInfoPanel);
                this.mWeitereInfoShown = !this.mWeitereInfoShown;
            }
            this.mWeitereInaktiv = false;
            this.mWeitereInfoPanel = new WeitereInfoPanel(this.mModel, this.mMarkenLayout);
            this.mOpenIconWeitere.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.mCloseIconWeitere.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.setWeitereReiter(this.mCloseIconWeitere, Color.BLACK);
            this.mWeitereReiter.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getSelectedReiterBackground()));
            this.showWeitereInfoPanel();
            if (this.mModel.hasZusatz()) {
                this.removePanelZusatz(true);
                this.mZusatzProdukteShown = !this.mZusatzProdukteShown;
            }
        } else {
            this.mWeitereInaktiv = true;
            this.mWeitereInfoShown = false;
            this.removePanelWeitere(true);
            this.mOpenIconInaktivWeitere.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mMarkenLayout.getPrimaryBackground()));
            this.setWeitereReiter(this.mOpenIconInaktivWeitere, Color.GRAY);
            if (this.mModel.hasZusatz() && !this.mZusatzProdukteShown) {
                this.mZusatzReiter.remove(this.mOpenIconZusatz);
                GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 2, 5, 3));
                this.mZusatzReiter.add((Component)this.mCloseIconZusatz, gbc);
                this.mZusatzReiter.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getSelectedReiterBackground()));
                gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 18, new Insets(3, 5, 5, 5));
                this.mMarketingPanel.add((Component)this.mZusatzproduktPanel.getOptionalPanel(), gbc);
                this.mZusatzProdukteShown = !this.mZusatzProdukteShown;
            }
        }
        this.mWeitereReiter.validate();
        this.mZusatzReiter.validate();
        this.mLinkPanel.validate();
        this.mWeitereReiter.updateUI();
        this.mZusatzReiter.updateUI();
        this.mLinkPanel.updateUI();
        this.mMarketingPanel.validate();
        this.mMarketingPanel.updateUI();
    }

    private void setWeitereReiter(JLabel openCloseIcon, Color labelColor) {
        String linksText = Resource.getInstance().getWeitereInformationen();
        this.mInfoLabel.setText(linksText);
        this.mInfoLabel.setForeground(labelColor);
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 2, 5, 3));
        this.mWeitereReiter.add((Component)openCloseIcon, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 3, 5, 3));
        this.mWeitereReiter.add((Component)this.mInfoLabel, gbc);
        gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 0, 3, 11, new Insets(0, 2, 0, 10));
        this.mLinkPanel.add((Component)this.mWeitereReiter, gbc);
    }

    private void setZusatzReiter(JLabel openCloseIcon, Color labelColor) {
        String zubehoerText = Resource.getInstance().getZusatzprodukte();
        this.mZusatzLabel.setText(zubehoerText);
        this.mZusatzLabel.setForeground(labelColor);
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 2, 5, 3));
        this.mZusatzReiter.add((Component)openCloseIcon, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 3, 5, 20));
        this.mZusatzReiter.add((Component)this.mZusatzLabel, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 17, new Insets(0, 2, 0, 20));
        this.mLinkPanel.add((Component)this.mZusatzReiter, gbc);
    }

    private void showWeitereInfoPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mWeitereInfoShown = true;
        gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 18, new Insets(3, 5, 5, 5));
        this.mMarketingPanel.add((Component)this.mWeitereInfoPanel, gbc);
    }

    public void nurZuklappen() {
        this.mLastShown = "";
        if (this.mWeitereInfoShown) {
            this.removePanelWeitere(true);
            this.mLastShown = INFO_LASTSHOWN;
        }
        if (!this.mWeitereInfoShown) {
            this.mWeitereReiter.setBorder(BorderFactory.createEmptyBorder());
        }
        this.mWeitereInfoShown = false;
        if (this.mZusatzProdukteShown) {
            this.removePanelZusatz(true);
            this.mLastShown = ZUSATZ_LASTSHOWN;
        }
        if (!this.mZusatzProdukteShown) {
            this.mZusatzReiter.setBorder(BorderFactory.createEmptyBorder());
        }
        this.mZusatzProdukteShown = false;
    }

    public void aufZuklappenWeitere() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (!this.mWeitereInfoShown && this.mModel.hasWeitereInfo()) {
            this.mWeitereReiter.remove(this.mOpenIconWeitere);
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 2, 5, 3));
            this.mWeitereReiter.add((Component)this.mCloseIconWeitere, gbc);
            gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 18, new Insets(3, 5, 5, 5));
            if (this.mZusatzProdukteShown) {
                this.removePanelZusatz(true);
                this.mZusatzProdukteShown = !this.mZusatzProdukteShown;
            } else {
                this.mZusatzReiter.setBorder(BorderFactory.createEmptyBorder());
            }
            this.mMarketingPanel.add((Component)this.mWeitereInfoPanel, gbc);
            this.mWeitereReiter.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getSelectedReiterBackground()));
        } else {
            this.removePanelWeitere(false);
        }
        if (this.mModel.hasWeitereInfo()) {
            this.mWeitereInfoShown = !this.mWeitereInfoShown;
        }
        this.mMarketingPanel.updateUI();
    }

    public void aufZuklappenZusatz() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (!this.mZusatzProdukteShown && this.mModel.hasZusatz()) {
            if (this.mWeitereInfoShown) {
                this.removePanelWeitere(true);
                this.mWeitereInfoShown = !this.mWeitereInfoShown;
            } else {
                this.mWeitereReiter.setBorder(BorderFactory.createEmptyBorder());
            }
            this.mZusatzReiter.remove(this.mOpenIconZusatz);
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 2, 5, 3));
            this.mZusatzReiter.add((Component)this.mCloseIconZusatz, gbc);
            this.mZusatzReiter.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getSelectedReiterBackground()));
            gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 0, 0, 1, 18, new Insets(3, 5, 5, 5));
            this.mMarketingPanel.add((Component)this.mZusatzproduktPanel.getOptionalPanel(), gbc);
        } else {
            this.removePanelZusatz(false);
        }
        if (this.mModel.hasZusatz()) {
            this.mZusatzProdukteShown = !this.mZusatzProdukteShown;
        }
        this.mMarketingPanel.validate();
        this.mMarketingPanel.updateUI();
    }

    private void removePanelWeitere(boolean withBorder) {
        if (this.mWeitereInfoPanel != null) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 0, 0, 11, new Insets(5, 2, 5, 3));
            this.mWeitereReiter.remove(this.mCloseIconWeitere);
            if (this.mModel.hasWeitereInfo()) {
                this.mWeitereReiter.add((Component)this.mOpenIconWeitere, gbc);
            }
            this.mMarketingPanel.remove(this.mWeitereInfoPanel);
            if (withBorder) {
                this.mWeitereReiter.setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    private void removePanelZusatz(boolean withBorder) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 0, 0, 1, 11, new Insets(5, 2, 5, 3));
        this.mZusatzReiter.remove(this.mCloseIconZusatz);
        if (this.mModel.hasZusatz()) {
            this.mZusatzReiter.add((Component)this.mOpenIconZusatz, gbc);
        }
        this.mMarketingPanel.remove(this.mZusatzproduktPanel.getOptionalPanel());
        if (withBorder) {
            this.mZusatzReiter.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setPreis() {
        String price = "<html>" + Resource.getInstance().getUnverbindlichePreisempfehlung() + "<br>" + Resource.getInstance().getAb() + " " + this.mModel.getPrice() + "</html>";
        this.mPriceLabel.setText(price);
        this.getMarketingPanel().invalidate();
    }

    public void setIcon(String name) {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.mMarketingPanel.getComponentCount() > 2 && this.mPricePanel.getComponentCount() > 2 && this.mPricePanel.getComponent(2) != null) {
            this.mPricePanel.remove(2);
            this.mPricePanel.updateUI();
        }
        if (name.equals("EINKAUFWAGEN")) {
            gbc = this.setGridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 20, 0, 0, 13, new Insets(0, 20, 0, 10));
            this.mPricePanel.add((Component)this.mIconEinkaufswagen, gbc);
        } else if (name.equals("KONFIGURATION")) {
            this.mPricePanel.remove(this.mIconEinkaufswagen);
            gbc = this.setGridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 20, 0, 0, 13, new Insets(0, 20, 0, 10));
            this.mPricePanel.add((Component)this.mIconTaschenrechner, gbc);
        }
        this.mMarketingPanel.updateUI();
    }

    private void setZusatzProdukte() {
        if (this.mModel.hasZusatz()) {
            this.mZusatzproduktPanel = new ZusatzproduktPanel(this.mMarkenLayout);
            this.mZusatzproduktPanel.setOptionalPanel(this.mModel);
            this.mZusatzproduktPanel.setLayout(this.mMarkenLayout);
            this.setChanged();
            this.notifyObservers(this.mZusatzproduktPanel);
        }
    }

    public void compactView() {
        if (this.mModel.hasZusatz()) {
            this.mZusatzproduktPanel.getOptionalPanel().setVisible(false);
        }
        if (this.mWeitereInfoPanel != null) {
            this.mWeitereInfoPanel.setVisible(false);
        }
        this.mMarketingPanel.updateUI();
        this.mMarketingPanel.validate();
    }

    public void normalizeView() {
        if (this.mModel.hasZusatz()) {
            this.mZusatzproduktPanel.getOptionalPanel().setVisible(true);
        }
        if (this.mWeitereInfoPanel != null) {
            this.mWeitereInfoPanel.setVisible(true);
        }
        this.mMarketingPanel.updateUI();
        this.mMarketingPanel.validate();
    }

    public void changePicture(Variante variante) {
        if (variante != null && variante.getGrafik() != null && variante.getGrafik().getImageData() != null) {
            int aktIndex = -1;
            String zubGrName = "";
            for (int i = 0; i < this.mModel.getMarketingProdukt().getImages().size(); ++i) {
                Zubehoergrafik zubGr = this.mModel.getMarketingProdukt().getImages().get(i);
                if (zubGr.getGrafikId().intValue() != variante.getGrafik().getGrafikId().intValue() || !zubGr.getProduktName().equals(variante.getGrafik().getProduktName())) continue;
                aktIndex = i;
                zubGrName = zubGr.getProduktName();
                break;
            }
            if (aktIndex > -1) {
                this.mModel.setIndexAktuellesImage(aktIndex);
                this.mBackgrImagePanel.setNewImage(this.mModel.getBteImage(this.mModel.getIndexAktuellesImage()));
                this.mBlaetternPanel.setBildName(zubGrName.equals("") ? this.mModel.getMarketingProdukt().getProduktNamePlain() : zubGrName);
            }
            this.enableDisableBlaetternLabels();
        }
    }

    public void changeBnbPicture(Bnb alt) {
        if (alt != null && alt.getBnbGrafik() != null && alt.getBnbGrafik().getImageData() != null) {
            int aktIndex = -1;
            String zubGrName = "";
            for (int i = 0; i < this.mModel.getMarketingProdukt().getImages().size(); ++i) {
                Zubehoergrafik zubGr = this.mModel.getMarketingProdukt().getImages().get(i);
                if (zubGr.getGrafikId() == null || zubGr.getGrafikId().intValue() != alt.getBnbGrafik().getGrafikId().intValue()) continue;
                aktIndex = i;
                zubGrName = zubGr.getProduktName();
                break;
            }
            if (aktIndex > -1) {
                this.mModel.setIndexAktuellesImage(aktIndex);
                this.mBackgrImagePanel.setNewImage(this.mModel.getBteImage(this.mModel.getIndexAktuellesImage()));
                this.mBlaetternPanel.setBildName(zubGrName.equals("") ? this.mModel.getMarketingProdukt().getProduktNamePlain() : zubGrName);
            }
            this.enableDisableBlaetternLabels();
        }
    }

    public void enableDisableBlaetternLabels() {
        int aktIndex = this.mModel.getIndexAktuellesImage();
        if (aktIndex >= 0) {
            if (aktIndex > 0 && aktIndex < this.mModel.getIndexAnzahlMaxImage()) {
                this.mBlaetternPanel.enableBlaetternZurueck(true);
                this.mBlaetternPanel.enableBlaetternVor(true);
            } else if (aktIndex == 0 && this.mModel.getIndexAnzahlMaxImage() > 0) {
                this.mBlaetternPanel.enableBlaetternZurueck(false);
                this.mBlaetternPanel.enableBlaetternVor(true);
            } else if (aktIndex == this.mModel.getIndexAnzahlMaxImage() && this.mModel.getIndexAnzahlMaxImage() > 0) {
                this.mBlaetternPanel.enableBlaetternZurueck(true);
                this.mBlaetternPanel.enableBlaetternVor(false);
            } else {
                this.mBlaetternPanel.enableBlaetternZurueck(false);
                this.mBlaetternPanel.enableBlaetternVor(false);
            }
        }
    }

    private GridBagConstraints setGridBagConstraints(int gx, int gy, int gw, int gh, double wx, double wy, int ix, int iy, int fill, int anchor, Insets inset) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.weightx = wx;
        c.weighty = wy;
        c.ipadx = ix;
        c.ipady = iy;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = inset;
        return c;
    }

    public void setLayout(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        if (this.imageLabelBig != null) {
            this.mMarketingPanel.remove(this.imageLabelBig);
        }
        this.mMarketingPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.platzhalter.setForeground(this.mMarkenLayout.getPrimaryBackground());
        this.mTextPanel.getTextPanel().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPriceLabel.setForeground(Color.BLACK);
        this.mMarketingPanel.updateUI();
        this.mMarketingPanel.validate();
    }

    public ZusatzproduktPanel getOptionalPanel() {
        return this.mZusatzproduktPanel;
    }

    public JPanel getMarketingPanel() {
        return this.mMarketingPanel;
    }

    public JLabel getIconEinkaufswagen() {
        return this.mIconEinkaufswagen;
    }

    public JLabel getIconTaschenrechner() {
        return this.mIconTaschenrechner;
    }

    public JLabel getOpenIconWeitere() {
        return this.mOpenIconWeitere;
    }

    public JLabel getCloseIconWeitere() {
        return this.mCloseIconWeitere;
    }

    public JLabel getOpenIconZusatz() {
        return this.mOpenIconZusatz;
    }

    public JLabel getCloseIconZusatz() {
        return this.mCloseIconZusatz;
    }

    public JLabel getInfoLabel() {
        return this.mInfoLabel;
    }

    public JPanel getWeiterePanel() {
        return this.mWeitereReiter;
    }

    public JPanel getZusatzPanel() {
        return this.mZusatzReiter;
    }

    public boolean isWeitereInaktiv() {
        return this.mWeitereInaktiv;
    }

    public boolean isZusatzInaktiv() {
        return this.mZusatzInaktiv;
    }

    public void setWeitereInaktiv(boolean weitereInaktiv) {
        this.mWeitereInaktiv = weitereInaktiv;
    }

    public void setZusatzInaktiv(boolean zusatzInaktiv) {
        this.mZusatzInaktiv = zusatzInaktiv;
    }

    public String getLastShown() {
        return this.mLastShown;
    }

    public void setLastShown(String lastShown) {
        this.mLastShown = lastShown;
    }

    public boolean isFBAVisible() {
        return this.isFBAVisible;
    }

    public void setFBAVisible(boolean isFBAVisible) {
        this.isFBAVisible = isFBAVisible;
    }

    public MarketingModel getModel() {
        return this.mModel;
    }

    public TextPanel getTextPanel() {
        return this.mTextPanel;
    }

    public void setTextPanel(TextPanel textPanel) {
        this.mTextPanel = textPanel;
    }

    public BlaetternPanel getBlaetternPanel() {
        return this.mBlaetternPanel;
    }

    public void setBlaetternPanel(BlaetternPanel blaetternPanel) {
        this.mBlaetternPanel = blaetternPanel;
    }

    public BackgroundPanel getBackgrImagePanel() {
        return this.mBackgrImagePanel;
    }

    public void setBackgrImagePanel(BackgroundPanel backgrImagePanel) {
        this.mBackgrImagePanel = backgrImagePanel;
    }

    public MarkenLayout getMarkenLayout() {
        return this.mMarkenLayout;
    }

    public void setMarkenLayout(MarkenLayout markenLayout) {
        this.mMarkenLayout = markenLayout;
    }

    class BackgroundPanel
    extends JPanel {
        ImageIcon icon;

        public BackgroundPanel(ImageIcon icon) {
            this.setPreferredSize(new Dimension(450, 270));
            this.setMinimumSize(new Dimension(450, 270));
            this.setMaximumSize(new Dimension(450, 270));
            this.icon = icon;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.icon != null) {
                int width = this.icon.getIconWidth();
                int height = this.icon.getIconHeight();
                int x = (Constants.BildGroessen.NORMALBILD_MAX_SIZE.width - width) / 2;
                int y = (Constants.BildGroessen.NORMALBILD_MAX_SIZE.height - height) / 2;
                g.drawImage(this.icon.getImage(), x, y, width, height, this);
            }
        }

        public void setNewImage(ImageIcon newIcon) {
            this.icon = newIcon;
            this.paintComponent(this.getGraphics());
            this.repaint();
            this.updateUI();
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }
    }
}

