/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrototypeTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MarkenLayout mLayout;
    private Color textSelect;

    public PrototypeTabPanel(MarkenLayout mLayout) {
        this.mLayout = mLayout;
        this.textSelect = mLayout.isMINI() ? mLayout.getTertiaryForeground() : mLayout.getPrimaryForeground();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(800, 470));
        this.setMinimumSize(new Dimension(800, 470));
        this.setBackground(mLayout.getPrimaryBackground());
        String[] tabNames = new String[]{"Nutzen", "Kommentare", "Wettbewerb", "Zusatznutzen", "Tipps und Tricks", "Weitergehende Informationen", "Marketingmaterial"};
        Component[] panels = new Component[7];
        for (int i = 0; i < panels.length; ++i) {
            JPanel test = new JPanel();
            test.setBackground(mLayout.getPrimaryBackground());
            panels[i] = test;
        }
        ((JPanel)panels[1]).setLayout(new GridBagLayout());
        GridBagConstraints gbc = mLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 11, new Insets(20, 0, 0, 150));
        JLabel text = new JLabel("<html>ACHTUNG: EINE EINBAUANLEITUNG (EBA) IST IM NACHR\u00dcSTSATZ NICHT ENTHALTEN. <br>DIE EBA IST TAGESAKTUELL AUS DEM AFTERSALES ASSISTANCE PORTAL (ASAP AUSZUDRUCKEN UND <br>DEM KUNDEN MITZUGEBEN. BEI KOMBINATION VON FUNKFERNBEDIENUNG UND THERMOCALL IST SATZ NUR <br>EINMAL NOTWENDIG MIT R\u00dcCKMELDUNG F\u00dcR EMPFANGENES EINSCHALTSIGNAL </html>");
        text.setForeground(mLayout.getPrimaryForeground());
        ((JPanel)panels[1]).add((Component)text, gbc);
        gbc = mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 8));
        this.add((Component)this.getPrototypeTabbedPane(tabNames, panels, 800, 470), gbc);
        this.validate();
    }

    public PrototypeTabPanel(MarkenLayout mLayout, Component optContent) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mLayout = mLayout;
        this.setBackground(mLayout.getPrimaryBackground());
        this.textSelect = mLayout.isMINI() ? mLayout.getTertiaryForeground() : mLayout.getPrimaryForeground();
        String[] tabNames = new String[]{"Zusatzprodukte 1", "Zusatzprodukte 2"};
        JPanel test2 = new JPanel(new GridBagLayout());
        JLabel product1 = new JLabel("* Original BMW Aerodynamik-Paket");
        product1.setBigFont();
        gbc = mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 5, 0));
        test2.add((Component)product1, gbc);
        JLabel product2 = new JLabel("* Original BMW M Aerodynamik-Paket");
        product2.setBigFont();
        gbc = mLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(5, 10, 5, 0));
        test2.add((Component)product2, gbc);
        JLabel product3 = new JLabel("* Original BMW Leichtmetallr\u00e4der");
        product3.setBigFont();
        gbc = mLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(5, 10, 5, 0));
        test2.add((Component)product3, gbc);
        JLabel product4 = new JLabel("* Original BMW Komplettr\u00e4der");
        product4.setBigFont();
        gbc = mLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 18, new Insets(5, 10, 5, 0));
        test2.add((Component)product4, gbc);
        JLabel product5 = new JLabel("* Original BMW Wei\u00dfe Blinkleuchten");
        product5.setBigFont();
        gbc = mLayout.setGridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 0, 18, new Insets(5, 10, 5, 0));
        test2.add((Component)product5, gbc);
        test2.setBackground(mLayout.getPrimaryBackground());
        gbc = mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 8));
        this.add((Component)this.getPrototypeTabbedPane(tabNames, new Component[]{optContent, test2}, 790, 240), gbc);
        this.validate();
    }

    protected JTabbedPane getPrototypeTabbedPane(String[] bezeichnungen, Component[] content, int width, int height) {
        int i;
        JTabbedPane pane = new JTabbedPane();
        for (i = 0; i < Math.max(bezeichnungen.length, content.length); ++i) {
            String bezeichnung = i >= bezeichnungen.length ? "" : bezeichnungen[i];
            Component comp = i >= content.length ? new JPanel() : content[i];
            pane.setFont(Constants.Layout.getZubBigFont());
            pane.addTab(bezeichnung, comp);
        }
        pane.setPreferredSize(new Dimension(width, height));
        for (i = 0; i < pane.getTabCount(); ++i) {
            pane.setBackgroundAt(i, i == pane.getSelectedIndex() ? this.mLayout.getSelectedReiterBackground() : this.mLayout.getDeselectedReiterBackground());
            pane.setForegroundAt(i, i == pane.getSelectedIndex() ? this.textSelect : this.mLayout.getPrimaryForeground());
            ((JPanel)pane.getComponent(i)).setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mLayout.getBorderColor()));
        }
        pane.setBackground(this.mLayout.getPrimaryBackground());
        pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                for (int i = 0; i < pane.getTabCount(); ++i) {
                    pane.setBackgroundAt(i, PrototypeTabPanel.this.mLayout.getDeselectedReiterBackground());
                    pane.setForegroundAt(i, PrototypeTabPanel.this.mLayout.getPrimaryForeground());
                }
                pane.setBackgroundAt(pane.getSelectedIndex(), PrototypeTabPanel.this.mLayout.getSelectedReiterBackground());
                pane.setForegroundAt(pane.getSelectedIndex(), PrototypeTabPanel.this.textSelect);
            }
        });
        return pane;
    }
}

