/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.LimitedComboBoxRenderer;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.Bestandteil;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.utilities.CssEditorKit;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JRadioButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.Variante;
import webetk.resources.Resource;

public class TextPanel
extends Observable {
    private JPanel textPanel;
    private static final int MAX_ZWEIBALKEN_SIZE = 12;
    private static final Dimension BALKEN_DIMENSION = new Dimension(490, 20);
    public static final String BESTANDTEILE = "Bestandteile";
    public static final String ALTERNATIVEN = "Alternativen";
    public static final String TEXT = "Text";
    public static final String EINZELTEILE = "Einzelteile";
    private int modus;
    private boolean isDynamic = false;
    private JPanel mDescrPanel = new JPanel(new GridBagLayout());
    private JLabel mDescrLabel;
    private JTextPane mTextLabel;
    private JScrollPane mDescrScrollPanel;
    private JLabel mBestandteileLabel = null;
    private JPanel mBestandteilePanel = null;
    private JPanel mBestandteileInhalt = null;
    private JScrollPane mBesttScrollPanel;
    private JPanel mAltPanel;
    private JLabel mAltLabel;
    private JScrollPane mAltScrollPanel;
    private JPanel mAltInhaltPanel;
    private JPanel mEinzelteilPanel;
    private JLabel mEinzelteilLabel;
    private JScrollPane mEinzelteilScrollPanel;
    private JPanel mEinzelteilInhaltPanel;
    private HashMap<String, JComboBox> mVariantenZuAlternativen = new HashMap();
    private ArrayList<JRadioButton> mAlternativesRadioButtons = new ArrayList();
    private HashMap<String, JComboBox> mVariantenZuEinzelteile = new HashMap();
    private ArrayList<JCheckBox> mEinzelteilCheckBoxes = new ArrayList();
    private MarketingModel mModel;
    private MarkenLayout mLayout;
    private int textSize;
    private int besttSize;
    private int altSize;
    private int einzelteileSize;
    private ArrayList<JLabel> dynamicLabels;
    private boolean isTextOpened = false;
    private boolean isBestOpened = false;
    private boolean isAltOpened = false;
    private boolean isEinzelOpened = false;
    private String marketingText = "";
    boolean isEditable = true;
    boolean fehlerFall = false;

    public TextPanel(MarketingModel model, MarkenLayout layout) {
        this.mModel = model;
        this.mLayout = layout;
        this.textPanel = new JPanel(new GridBagLayout());
        this.textPanel.setPreferredSize(new Dimension(490, 260));
        this.textPanel.setMinimumSize(new Dimension(490, 260));
        this.textPanel.setMaximumSize(new Dimension(490, 260));
        this.dynamicLabels = new ArrayList();
        this.setMarketingText(this.mModel.getMaketingText());
        this.textSize = this.setTextSize();
        this.besttSize = this.setBesttSize();
        if (this.besttSize < 3 && !model.habenBestandteileVarianten()) {
            this.besttSize = 0;
        }
        this.altSize = this.setAltSize();
        this.einzelteileSize = this.setEinzelteileSize();
        this.modus = this.getModus();
        this.isDynamic = this.setDynamic();
    }

    private int getModus() {
        int modus = 0;
        if (this.textSize > 0) {
            ++modus;
        }
        if (this.altSize > 0) {
            ++modus;
        }
        if (this.besttSize > 0) {
            ++modus;
        }
        if (this.einzelteileSize > 0) {
            ++modus;
        }
        return modus;
    }

    public void showNewMarketingText(String text) {
        this.setMarketingText(text);
        this.textSize = this.setTextSize();
        this.modus = this.getModus();
        boolean isDynamicOld = this.isDynamic;
        this.isDynamic = this.setDynamic();
        if (isDynamicOld != this.isDynamic) {
            this.resetView();
            this.setTextPanelView();
        }
        this.textPanel.validate();
        this.textPanel.updateUI();
    }

    private boolean setDynamic() {
        if (this.modus > 2) {
            return true;
        }
        if (this.modus == 2) {
            return this.textSize + this.besttSize + this.altSize + this.einzelteileSize > 12;
        }
        return false;
    }

    public void setTextPanelView() {
        this.setTextPanel();
        this.setBestandteilePanel();
        this.setAlternativenPanel();
        this.setEinzelteilePanel();
        this.setChanged();
        this.notifyObservers(this.dynamicLabels);
    }

    private void setMarketingText(String text) {
        if (text != null) {
            if (this.mLayout.isBMWMotorrad()) {
                this.marketingText = text;
            } else {
                if (this.mModel.getMaketingText().contains("#")) {
                    this.marketingText = this.mLayout.cleanTextWithNewLine(this.mModel.getMaketingText(), "#", "&#149; ");
                    this.marketingText = this.marketingText.replaceAll("<ul>", "");
                    this.marketingText = this.marketingText.replaceAll("</ul>", "");
                } else {
                    this.marketingText = this.mLayout.cleanText(this.mModel.getMaketingText(), "#", "");
                }
                if (!this.marketingText.contains("&#149;")) {
                    this.marketingText = "<html>" + this.marketingText + "</html>";
                }
            }
        } else {
            this.marketingText = "";
        }
    }

    public static int getLineAtCaret(JTextComponent component) {
        int caretPosition = component.getCaretPosition();
        Element root = component.getDocument().getDefaultRootElement();
        return root.getElementIndex(caretPosition) + 1;
    }

    public static int[] getWrappedLines(JTextPane component) {
        int[] wrappedlines = new int[2];
        int y = 0;
        View view = component.getUI().getRootView(component).getView(0);
        int preferredHeight = (int)view.getPreferredSpan(1);
        try {
            Rectangle caretCoords = component.modelToView(component.getCaret().getDot());
            y = (int)caretCoords.getY();
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        int lineHeight = component.getFontMetrics(component.getFont()).getHeight();
        wrappedlines[0] = preferredHeight / lineHeight;
        wrappedlines[1] = y / lineHeight + 1;
        return wrappedlines;
    }

    private int setTextSize() {
        int textSize = 0;
        String text = new String(this.marketingText);
        if (this.mLayout.isBMWMotorrad()) {
            if (text.length() != 0) {
                ++textSize;
            }
            text = text.replaceAll("<ul>", "");
            text = text.replaceAll("</ul>", "");
            text = text.replaceAll("&#149;", "");
            while (text.contains("<p>")) {
                text = text.replaceFirst("<p>", "");
                ++textSize;
            }
            while (text.contains("<br>")) {
                text = text.replaceFirst("<br>", "");
                ++textSize;
            }
            ArrayList<String> textToArr = new ArrayList<String>();
            while (text.contains("<li>")) {
                int beginIndex = text.indexOf("<li>") + 4;
                int endIndex = text.indexOf("</li>");
                textToArr.add(text.substring(beginIndex, endIndex));
                text = text.replaceFirst("<li>", " ");
                text = text.replaceFirst("</li>", " ");
            }
            JTextPane test = new JTextPane();
            test.setPreferredSize(new Dimension(490, 2000));
            test.setMinimumSize(new Dimension(490, 2000));
            test.setMaximumSize(new Dimension(490, 2000));
            test.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            test.setFont(Constants.Layout.getZubDefaultFont());
            test.setContentType("text/html; charset=UTF-8");
            test.setEditorKit(new CssEditorKit());
            FontMetrics fontMetrics = test.getFontMetrics(Constants.Layout.getZubDefaultFont());
            for (String arrText : textToArr) {
                test.setText(arrText);
                int textBreite = fontMetrics.stringWidth(arrText);
                textSize += textBreite / 400;
                if (textBreite % 400 <= 0) continue;
                ++textSize;
            }
        } else {
            if (text.length() != 0) {
                ++textSize;
            }
            text = text.replaceAll("<ul>", "");
            text = text.replaceAll("</ul>", "");
            text = text.replaceAll("<li>", "");
            text = text.replaceAll("</li>", "");
            text = text.replaceAll("&#149;", "");
            while (text.contains("<p>")) {
                text = text.replaceFirst("<p>", "");
                ++textSize;
            }
            ArrayList<String> textToArr = new ArrayList<String>();
            int beginIndex = 0;
            int endIndex = 0;
            while (text.contains("<br>")) {
                endIndex = text.indexOf("<br>", beginIndex);
                textToArr.add(text.substring(beginIndex, endIndex));
                text = text.replaceFirst("<br>", " ");
                beginIndex = endIndex;
            }
            JTextPane test = new JTextPane();
            test.setPreferredSize(new Dimension(490, 2000));
            test.setMinimumSize(new Dimension(490, 2000));
            test.setMaximumSize(new Dimension(490, 2000));
            test.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            test.setFont(Constants.Layout.getZubDefaultFont());
            test.setContentType("text/html; charset=UTF-8");
            test.setEditorKit(new CssEditorKit());
            FontMetrics fontMetrics = test.getFontMetrics(Constants.Layout.getZubDefaultFont());
            for (String arrText : textToArr) {
                test.setText(arrText);
                int textBreite = fontMetrics.stringWidth(arrText);
                textSize += textBreite / 400;
                if (textBreite % 400 <= 0) continue;
                ++textSize;
            }
        }
        return textSize;
    }

    private int setBesttSize() {
        return this.mModel.getBestandteile().size() * 2;
    }

    private int setAltSize() {
        return this.mModel.getMarketingProdukt().getAlternativen().size() * 2;
    }

    private int setEinzelteileSize() {
        return this.mModel.getMarketingProdukt().getEinzelteile().size() * 2;
    }

    private void setTextPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mDescrPanel = new JPanel(new GridBagLayout());
        this.mDescrLabel = new JLabel();
        this.mDescrLabel.setPreferredSize(BALKEN_DIMENSION);
        this.mDescrLabel.setMinimumSize(BALKEN_DIMENSION);
        this.mDescrLabel.setMaximumSize(BALKEN_DIMENSION);
        this.mDescrLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.mDescrLabel.setOpaque(true);
        this.mDescrLabel.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
        this.mDescrLabel.setText(this.mModel.getProductName());
        FontMetrics fontMetrics = this.mDescrLabel.getFontMetrics(Constants.Layout.getZubBoldFont());
        int textBreite = fontMetrics.stringWidth(this.mModel.getProductName());
        if (textBreite > 400) {
            this.mDescrLabel.setToolTipText(this.mModel.getProductName());
        } else {
            this.mDescrLabel.setToolTipText(null);
        }
        this.mDescrLabel.setName(TEXT);
        this.mDescrLabel.setBoldFont();
        gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 0, 11, new Insets(0, 0, 0, 0));
        this.mDescrPanel.add((Component)this.mDescrLabel, gbc);
        this.showTextPanel();
        gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 11, new Insets(0, 0, 0, 0));
        this.textPanel.add((Component)this.mDescrPanel, gbc);
    }

    private void setBestandteilePanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mBestandteilePanel = new JPanel(new GridBagLayout());
        this.mBestandteilePanel.setBackground(Color.WHITE);
        this.mBestandteileLabel = new JLabel();
        this.mBestandteileLabel.setPreferredSize(BALKEN_DIMENSION);
        this.mBestandteileLabel.setMinimumSize(BALKEN_DIMENSION);
        this.mBestandteileLabel.setMaximumSize(BALKEN_DIMENSION);
        this.mBestandteileLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.mBestandteileLabel.setOpaque(true);
        this.mBestandteileLabel.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
        this.mBestandteileLabel.setBoldFont();
        this.mBestandteileLabel.setName(BESTANDTEILE);
        this.mBestandteileLabel.setText(Resource.getInstance().getBestehtAus() + ":");
        gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
        this.mBestandteilePanel.add((Component)this.mBestandteileLabel, gbc);
        if (!this.isDynamic && this.modus > 0 || this.isDynamic && !this.isTextOpened && !this.isAltOpened && !this.isEinzelOpened) {
            this.showBestandteilePanel();
            if (this.besttSize > 0 && this.isDynamic) {
                this.dynamicLabels.add(this.mBestandteileLabel);
            }
        } else {
            this.mBestandteileLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
            if (this.besttSize > 0) {
                this.dynamicLabels.add(this.mBestandteileLabel);
            }
        }
        if (this.besttSize > 0) {
            gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 0, 11, new Insets(5, 0, 0, 0));
            this.textPanel.add((Component)this.mBestandteilePanel, gbc);
        }
    }

    private void setAlternativenPanel() {
        if (this.altSize > 0) {
            GridBagConstraints gbc = new GridBagConstraints();
            this.mAltPanel = new JPanel(new GridBagLayout());
            this.mAltPanel.setBackground(Color.WHITE);
            this.mAltLabel = new JLabel();
            this.mAltLabel.setPreferredSize(BALKEN_DIMENSION);
            this.mAltLabel.setMinimumSize(BALKEN_DIMENSION);
            this.mAltLabel.setMaximumSize(BALKEN_DIMENSION);
            this.mAltLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.mAltLabel.setOpaque(true);
            this.mAltLabel.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
            this.mAltLabel.setBoldFont();
            this.mAltLabel.setName(ALTERNATIVEN);
            this.mAltLabel.setText(Resource.getInstance().getAlternativen() + ":");
            gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
            this.mAltPanel.add((Component)this.mAltLabel, gbc);
            if (!this.isDynamic && this.modus > 0 || this.isDynamic && !this.isTextOpened && !this.isBestOpened && !this.isEinzelOpened) {
                this.showAlternativenPanel();
                if (this.isDynamic) {
                    this.dynamicLabels.add(this.mAltLabel);
                }
            } else {
                this.mAltLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
                this.dynamicLabels.add(this.mAltLabel);
            }
            gbc = this.mLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 0, 11, new Insets(5, 0, 0, 0));
            this.textPanel.add((Component)this.mAltPanel, gbc);
        }
    }

    public void showTextPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.isDynamic && this.textSize > 0) {
            this.removeBestandteilePanel();
            this.removeAlternativenPanel();
            this.removeEinzelteilePanel();
            this.mDescrLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.isTextOpened = true;
        } else {
            this.mDescrLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mLayout.getPrimaryBackground()));
        }
        if (this.mTextLabel == null) {
            this.mTextLabel = new JTextPane();
            this.mTextLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.mTextLabel.setFont(Constants.Layout.getZubDefaultFont());
            this.mTextLabel.setEditable(false);
            this.mTextLabel.setContentType("text/html; charset=UTF-8");
            this.mTextLabel.setBorder(null);
            this.mTextLabel.setEditorKit(new CssEditorKit());
            this.mTextLabel.setCaretPosition(0);
            if (this.textSize > 0) {
                this.mDescrPanel.setBackground(Color.WHITE);
                this.mTextLabel.setText(this.marketingText);
                this.mTextLabel.setBackground(Color.WHITE);
                this.mDescrScrollPanel = new JScrollPane(this.mTextLabel, 20, 31);
                this.mDescrScrollPanel.setBorder(null);
                this.mDescrScrollPanel.setBackground(Color.WHITE);
                this.isTextOpened = true;
                if (this.isDynamic) {
                    this.dynamicLabels.add(this.mDescrLabel);
                }
                gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(3, 3, 3, 0));
                this.mDescrPanel.add((Component)this.mDescrScrollPanel, gbc);
            } else {
                this.mDescrPanel.setBackground(this.mLayout.getPrimaryBackground());
                gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 0, 11, new Insets(0, 0, 0, 0));
                this.isTextOpened = false;
                this.mTextLabel.setBackground(this.mLayout.getPrimaryBackground());
                this.mDescrPanel.add((Component)this.mTextLabel, gbc);
                if (this.modus == 0) {
                    gbc = this.mLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
                    this.textPanel.add((Component)new JLabel(""), gbc);
                }
                this.mDescrPanel.validate();
            }
        }
        Dimension dim = this.getCurrentPanelDimension(this.mDescrPanel);
        this.mDescrPanel.setPreferredSize(dim);
        this.mDescrPanel.setMinimumSize(dim);
        this.mDescrPanel.setMaximumSize(dim);
        if (this.textSize > 0) {
            this.mDescrPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Constants.Layout.MARKETING_LEISTE_COLOR));
            this.mDescrScrollPanel.setPreferredSize(new Dimension(dim.width, dim.height - 20));
            this.mDescrScrollPanel.setMinimumSize(new Dimension(dim.width, dim.height - 20));
            this.mDescrScrollPanel.setMaximumSize(new Dimension(dim.width, dim.height - 20));
            this.mDescrScrollPanel.setVisible(true);
            this.mTextLabel.scrollRectToVisible(new Rectangle(1, 1));
            this.mTextLabel.setBorder(null);
            this.mTextLabel.updateUI();
            this.mTextLabel.validate();
        }
    }

    public void showBestandteilePanel() {
        if (this.mBestandteileLabel != null) {
            GridBagConstraints gbc = new GridBagConstraints();
            if (this.isDynamic) {
                this.removeTextPanel();
                this.removeAlternativenPanel();
                this.removeEinzelteilePanel();
                this.mBestandteileLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen.gif"), this.mLayout.getPrimaryBackground()));
                this.isBestOpened = true;
            } else {
                this.mBestandteileLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mLayout.getPrimaryBackground()));
            }
            if (this.mBestandteileInhalt == null) {
                this.mBestandteileInhalt = new JPanel(new GridBagLayout());
                this.mBestandteileInhalt.setBackground(Color.WHITE);
                int gbcY = 0;
                if (this.mModel.getBestandteile().size() > 0) {
                    for (Bestandteil part : this.mModel.getBestandteile()) {
                        JLabel bestandteileLabel;
                        ArrayList<Variante> varianten = part.getVarianten();
                        if (varianten == null || varianten.size() == 0) {
                            bestandteileLabel = new JLabel("<html><U>" + part.getName() + "</U></html>");
                            gbc = this.mLayout.setGridBagConstraints(0, gbcY++, 2, 1, 1.0, 0.0, 0, 18, new Insets(5, 3, 0, 0));
                            this.mBestandteileInhalt.add((Component)bestandteileLabel, gbc);
                            continue;
                        }
                        if (varianten.size() <= 0) continue;
                        bestandteileLabel = new JLabel("<html><U>" + part.getName() + " </U></html>");
                        gbc = this.mLayout.setGridBagConstraints(0, gbcY, 1, 1, 1.0, 0.0, 0, 18, new Insets(5, 3, 0, 0));
                        this.mBestandteileInhalt.add((Component)bestandteileLabel, gbc);
                        gbc = this.mLayout.setGridBagConstraints(1, gbcY++, 1, 1, 0.0, 0.0, 2, 18, new Insets(5, 0, 0, 0));
                        JComboBox varCombo = new JComboBox();
                        varCombo.setRenderer(new LimitedComboBoxRenderer(TextPanel.getMaxZeichenAnzahl()));
                        varCombo.setPreferredSize(new Dimension(180, 20));
                        varCombo.setActionCommand(part.getBildPosNr());
                        varCombo.setName(part.getElementart());
                        varCombo.addItem(Resource.getInstance().getAuswaehlen());
                        if (varianten.size() == 1) {
                            varCombo.addItem(varianten.get(0));
                            varCombo.setSelectedItem(varianten.get(0));
                            if (varianten.get(0).toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                                varCombo.setToolTipText(varianten.get(0).toString());
                            } else {
                                varCombo.setToolTipText(null);
                            }
                            part.setSelectedVariante(varianten.get(0));
                            ControllerMarketingPanel.getInstance().updateSelectedVarianten(part.getBildPosNr(), varianten.get(0));
                        } else {
                            for (int i = 0; i < varianten.size(); ++i) {
                                varCombo.addItem(varianten.get(i));
                                if (part.getSelectedVariante() == null || varianten.get(i).getVarianteId() != part.getSelectedVariante().getVarianteId()) continue;
                                varCombo.setSelectedItem(varianten.get(i));
                                if (varianten.get(i).toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                                    varCombo.setToolTipText(varianten.get(i).toString());
                                    continue;
                                }
                                varCombo.setToolTipText(null);
                            }
                        }
                        this.mBestandteileInhalt.add((Component)varCombo, gbc);
                        part.setVariantenCombo(varCombo);
                    }
                }
                gbc = this.mLayout.setGridBagConstraints(0, gbcY, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
                this.mBestandteileInhalt.add((Component)new JLabel(" "), gbc);
                this.mBestandteileInhalt.validate();
                this.mBesttScrollPanel = new JScrollPane(this.mBestandteileInhalt, 20, 31);
                this.mBesttScrollPanel.setBackground(Color.WHITE);
                this.mBesttScrollPanel.setBorder(null);
                gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
                this.mBestandteilePanel.add((Component)this.mBesttScrollPanel, gbc);
            }
            Dimension dim = this.getCurrentPanelDimension(this.mBestandteilePanel);
            Dimension scrollDim = new Dimension(dim.width, dim.height - 20);
            this.mBestandteilePanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Constants.Layout.MARKETING_LEISTE_COLOR));
            this.mBestandteilePanel.setPreferredSize(dim);
            this.mBestandteilePanel.setMinimumSize(dim);
            this.mBestandteilePanel.setMaximumSize(dim);
            this.mBesttScrollPanel.setPreferredSize(scrollDim);
            this.mBesttScrollPanel.setVisible(true);
            this.setBestandteileEditable(this.isEditable);
            this.setChanged();
            this.notifyObservers(this.mModel.getBestandteile());
            if (this.fehlerFall) {
                this.setVerbaubareVariantenDerBestandteile();
            }
        }
    }

    public void showAlternativenPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.isDynamic) {
            this.removeTextPanel();
            this.removeBestandteilePanel();
            this.removeEinzelteilePanel();
            this.mAltLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.isAltOpened = true;
        } else {
            this.mAltLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mLayout.getPrimaryBackground()));
        }
        if (this.mAltInhaltPanel == null) {
            this.mAltInhaltPanel = new JPanel(new GridBagLayout());
            this.mAltInhaltPanel.setBackground(Color.WHITE);
            this.mAlternativesRadioButtons = new ArrayList();
            int altSize = this.mModel.getMarketingProdukt().getAlternativen().size();
            int k = 0;
            if (altSize > 0) {
                ButtonGroup buttonGroup = new ButtonGroup();
                for (Bnb alter : (ArrayList)this.mModel.getMarketingProdukt().getAlternativen()) {
                    JRadioButton altRadio = new JRadioButton();
                    altRadio.setName(alter.getElementArt());
                    altRadio.setActionCommand(alter.getBildPos());
                    altRadio.setText(alter.getBnbName());
                    buttonGroup.add(altRadio);
                    Bnb selectedAlter = this.mModel.getSelectedAlternative();
                    if (selectedAlter == null && k == 0 || selectedAlter != null && alter.getBildPos().equals(selectedAlter.getBildPos())) {
                        this.mModel.setSelectedAlternative(alter.getBildPos());
                        altRadio.setSelected(true);
                    } else {
                        altRadio.setSelected(false);
                    }
                    this.mAlternativesRadioButtons.add(altRadio);
                    ArrayList<Variante> varianten = this.getVerbaubareVariantenZuSelectedAlt(alter.getBildPos());
                    if (varianten == null || varianten.size() == 0) {
                        gbc = this.mLayout.setGridBagConstraints(0, k, 2, 1, 1.0, 0.0, 2, 18, new Insets(3, 0, 0, 0));
                        this.mAltInhaltPanel.add((Component)altRadio, gbc);
                    } else {
                        gbc = this.mLayout.setGridBagConstraints(0, k, 1, 1, 1.0, 0.0, 2, 18, new Insets(3, 0, 0, 0));
                        this.mAltInhaltPanel.add((Component)altRadio, gbc);
                        gbc = this.mLayout.setGridBagConstraints(1, k, 1, 1, 0.0, 0.0, 2, 18, new Insets(3, 0, 0, 0));
                        JComboBox varCombo = new JComboBox();
                        varCombo.setRenderer(new LimitedComboBoxRenderer(TextPanel.getMaxZeichenAnzahl()));
                        varCombo.setPreferredSize(new Dimension(180, 20));
                        varCombo.setActionCommand(alter.getBildPos());
                        varCombo.setName(alter.getElementArt());
                        varCombo.addItem(Resource.getInstance().getAuswaehlen());
                        if (varianten.size() == 1) {
                            varCombo.addItem(varianten.get(0));
                            varCombo.setSelectedItem(varianten.get(0));
                            if (varianten.get(0).toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                                varCombo.setToolTipText(varianten.get(0).toString());
                            } else {
                                varCombo.setToolTipText(null);
                            }
                        } else {
                            for (int i = 0; i < varianten.size(); ++i) {
                                varCombo.addItem(varianten.get(i));
                                if (!altRadio.isSelected() || this.mModel.getSelectedVariante() == null || varianten.get(i).getVarianteId() != this.mModel.getSelectedVariante().getVarianteId()) continue;
                                varCombo.setSelectedItem(varianten.get(i));
                                if (varianten.get(i).toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                                    varCombo.setToolTipText(varianten.get(i).toString());
                                    continue;
                                }
                                varCombo.setToolTipText(null);
                            }
                        }
                        if (altRadio.isSelected()) {
                            varCombo.setEnabled(true);
                        } else {
                            varCombo.setEnabled(false);
                        }
                        this.mAltInhaltPanel.add((Component)varCombo, gbc);
                        this.mVariantenZuAlternativen.put(altRadio.getActionCommand(), varCombo);
                    }
                    ++k;
                }
            }
            this.setChanged();
            this.notifyObservers(this.mAlternativesRadioButtons);
            this.setChanged();
            this.notifyObservers(this.mVariantenZuAlternativen);
            this.setAlternativenEditable(this.isEditable);
            this.setVarAlternativenEditable(this.isEditable);
            gbc = this.mLayout.setGridBagConstraints(0, k, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            this.mAltInhaltPanel.add((Component)new JLabel(" "), gbc);
            this.mAltInhaltPanel.validate();
            this.mAltScrollPanel = new JScrollPane(this.mAltInhaltPanel, 20, 31);
            this.mAltScrollPanel.setBackground(Color.WHITE);
            this.mAltScrollPanel.setBorder(null);
            gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
            this.mAltPanel.add((Component)this.mAltScrollPanel, gbc);
        }
        Dimension dim = this.getCurrentPanelDimension(this.mAltPanel);
        Dimension scrollDim = new Dimension(dim.width, dim.height);
        this.mAltPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Constants.Layout.MARKETING_LEISTE_COLOR));
        this.mAltPanel.setPreferredSize(dim);
        this.mAltPanel.setMinimumSize(dim);
        this.mAltPanel.setMaximumSize(dim);
        this.mAltScrollPanel.setPreferredSize(scrollDim);
        this.mAltScrollPanel.setMinimumSize(scrollDim);
        this.mAltScrollPanel.setMaximumSize(scrollDim);
        this.mAltScrollPanel.setVisible(true);
        if (this.fehlerFall) {
            this.setVerbaubareAlternativen();
        }
    }

    private void setEinzelteilePanel() {
        if (this.einzelteileSize > 0) {
            GridBagConstraints gbc = new GridBagConstraints();
            this.mEinzelteilPanel = new JPanel(new GridBagLayout());
            this.mEinzelteilPanel.setBackground(Color.WHITE);
            this.mEinzelteilLabel = new JLabel();
            this.mEinzelteilLabel.setPreferredSize(BALKEN_DIMENSION);
            this.mEinzelteilLabel.setMinimumSize(BALKEN_DIMENSION);
            this.mEinzelteilLabel.setMaximumSize(BALKEN_DIMENSION);
            this.mEinzelteilLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.mEinzelteilLabel.setOpaque(true);
            this.mEinzelteilLabel.setBackground(Constants.Layout.MARKETING_LEISTE_COLOR);
            this.mEinzelteilLabel.setBoldFont();
            this.mEinzelteilLabel.setName(EINZELTEILE);
            this.mEinzelteilLabel.setText(Resource.getInstance().getBestehtAus() + ":");
            gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 11, new Insets(0, 0, 0, 0));
            this.mEinzelteilPanel.add((Component)this.mEinzelteilLabel, gbc);
            if (!this.isDynamic && this.modus > 0 || this.isDynamic && !this.isTextOpened && !this.isBestOpened && !this.isAltOpened) {
                this.showEinzelteilePanel();
                if (this.isDynamic) {
                    this.dynamicLabels.add(this.mEinzelteilLabel);
                }
            } else {
                this.mEinzelteilLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
                this.dynamicLabels.add(this.mEinzelteilLabel);
            }
            gbc = this.mLayout.setGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 0, 11, new Insets(5, 0, 0, 0));
            this.textPanel.add((Component)this.mEinzelteilPanel, gbc);
        }
    }

    public void showEinzelteilePanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.isDynamic) {
            this.removeTextPanel();
            this.removeBestandteilePanel();
            this.removeAlternativenPanel();
            this.mEinzelteilLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.isEinzelOpened = true;
        } else {
            this.mEinzelteilLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_inaktiv.gif"), this.mLayout.getPrimaryBackground()));
        }
        if (this.mEinzelteilInhaltPanel == null) {
            this.mEinzelteilInhaltPanel = new JPanel(new GridBagLayout());
            this.mEinzelteilInhaltPanel.setBackground(Color.WHITE);
            this.mEinzelteilCheckBoxes = new ArrayList();
            int einzelteilSize = this.mModel.getMarketingProdukt().getEinzelteile().size();
            int k = 0;
            if (einzelteilSize > 0) {
                for (Bnb einzelteil : (ArrayList)this.mModel.getMarketingProdukt().getEinzelteile()) {
                    JCheckBox checkBox = new JCheckBox();
                    checkBox.setSelected(false);
                    checkBox.setName(einzelteil.getElementArt());
                    checkBox.setActionCommand(einzelteil.getBildPos());
                    checkBox.setText(einzelteil.getBnbName());
                    ArrayList<Bnb> selEinzelteile = this.mModel.getSelectedEinzelteile();
                    Variante selVariante = null;
                    if (selEinzelteile != null && selEinzelteile.size() > 0) {
                        for (Bnb einzel : selEinzelteile) {
                            if (!einzel.getBildPos().equals(einzelteil.getBildPos())) continue;
                            checkBox.setSelected(true);
                            selVariante = einzel.getSelectedVariante();
                            break;
                        }
                    } else if (einzelteilSize == 1) {
                        checkBox.setSelected(true);
                        this.mModel.addSelectedEinzelteil(einzelteil);
                    }
                    this.mEinzelteilCheckBoxes.add(checkBox);
                    ArrayList varianten = (ArrayList)this.mModel.getMarketingProdukt().getVariantenZuEinzelteile().get(einzelteil.getBildPos());
                    if (varianten == null || varianten.size() == 0) {
                        gbc = this.mLayout.setGridBagConstraints(0, k, 2, 1, 1.0, 0.0, 2, 18, new Insets(3, 0, 0, 0));
                        this.mEinzelteilInhaltPanel.add((Component)checkBox, gbc);
                    } else {
                        gbc = this.mLayout.setGridBagConstraints(0, k, 1, 1, 1.0, 0.0, 2, 18, new Insets(3, 0, 0, 0));
                        this.mEinzelteilInhaltPanel.add((Component)checkBox, gbc);
                        gbc = this.mLayout.setGridBagConstraints(1, k, 1, 1, 0.0, 0.0, 2, 18, new Insets(3, 0, 0, 0));
                        JComboBox varCombo = new JComboBox();
                        varCombo.setRenderer(new LimitedComboBoxRenderer(TextPanel.getMaxZeichenAnzahl()));
                        varCombo.setPreferredSize(new Dimension(180, 20));
                        varCombo.setActionCommand(einzelteil.getBildPos());
                        varCombo.setName(einzelteil.getElementArt());
                        varCombo.addItem(Resource.getInstance().getAuswaehlen());
                        if (varianten.size() == 1) {
                            varCombo.addItem(varianten.get(0));
                            varCombo.setSelectedItem(varianten.get(0));
                            if (((Variante)varianten.get(0)).toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                                varCombo.setToolTipText(((Variante)varianten.get(0)).toString());
                            } else {
                                varCombo.setToolTipText(null);
                            }
                        } else {
                            for (int i = 0; i < varianten.size(); ++i) {
                                varCombo.addItem(varianten.get(i));
                                if (!checkBox.isSelected() || selVariante == null || ((Variante)varianten.get(i)).getVarianteId() != selVariante.getVarianteId()) continue;
                                varCombo.setSelectedItem(varianten.get(i));
                                if (selVariante.toString().length() > TextPanel.getMaxZeichenAnzahl()) {
                                    varCombo.setToolTipText(selVariante.toString());
                                    continue;
                                }
                                varCombo.setToolTipText(null);
                            }
                        }
                        if (checkBox.isSelected()) {
                            varCombo.setEnabled(true);
                        } else {
                            varCombo.setEnabled(false);
                        }
                        this.mEinzelteilInhaltPanel.add((Component)varCombo, gbc);
                        this.mVariantenZuEinzelteile.put(varCombo.getActionCommand(), varCombo);
                    }
                    ++k;
                }
            }
            this.setChanged();
            this.notifyObservers(this.mEinzelteilCheckBoxes);
            this.setChanged();
            this.notifyObservers(this.mVariantenZuEinzelteile);
            this.setEinzelteileEditable(this.isEditable);
            this.setVarEinzelteilEditable(this.isEditable);
            gbc = this.mLayout.setGridBagConstraints(0, k, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            this.mEinzelteilInhaltPanel.add((Component)new JLabel(" "), gbc);
            this.mEinzelteilInhaltPanel.validate();
            this.mEinzelteilScrollPanel = new JScrollPane(this.mEinzelteilInhaltPanel, 20, 31);
            this.mEinzelteilScrollPanel.setBackground(Color.WHITE);
            this.mEinzelteilScrollPanel.setBorder(null);
            gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 0));
            this.mEinzelteilPanel.add((Component)this.mEinzelteilScrollPanel, gbc);
        }
        Dimension dim = this.getCurrentPanelDimension(this.mEinzelteilPanel);
        Dimension scrollDim = new Dimension(dim.width, dim.height);
        this.mEinzelteilPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Constants.Layout.MARKETING_LEISTE_COLOR));
        this.mEinzelteilPanel.setPreferredSize(dim);
        this.mEinzelteilPanel.setMinimumSize(dim);
        this.mEinzelteilPanel.setMaximumSize(dim);
        this.mEinzelteilScrollPanel.setPreferredSize(scrollDim);
        this.mEinzelteilScrollPanel.setMinimumSize(scrollDim);
        this.mEinzelteilScrollPanel.setMaximumSize(scrollDim);
        this.mEinzelteilScrollPanel.setVisible(true);
    }

    public void setVerbaubareAlternativen() {
        List<Bnb> verbaubareAlternativen = this.mModel.getVerbaubareAlternativen();
        int firstIndexVerbaubar = -1;
        if (verbaubareAlternativen != null && this.isEditable) {
            for (int k = 0; k < this.mAlternativesRadioButtons.size(); ++k) {
                JRadioButton radio = this.mAlternativesRadioButtons.get(k);
                boolean verbaubar = false;
                Bnb verbaubareAlt = null;
                for (Bnb alter : verbaubareAlternativen) {
                    if (!alter.getBildPos().equals(radio.getActionCommand())) continue;
                    verbaubareAlt = alter;
                    if (firstIndexVerbaubar == -1) {
                        firstIndexVerbaubar = k;
                    }
                    verbaubar = true;
                    break;
                }
                radio.setEnabled(verbaubar);
                if (firstIndexVerbaubar < 0) continue;
                this.mModel.setSelectedAlternative(verbaubareAlt);
                radio.doClick();
                radio.setSelected(true);
                firstIndexVerbaubar = -5;
            }
        }
    }

    public void updateVariantenZuSelectedAlt(String position) {
        boolean sindVariantenVorhanden = false;
        for (JComboBox combo : this.mVariantenZuAlternativen.values()) {
            if (combo.getActionCommand() == position) {
                sindVariantenVorhanden = true;
                combo.setEnabled(true);
                if (combo.getSelectedIndex() > 0) {
                    Variante var = (Variante)combo.getSelectedItem();
                    this.mModel.setSelectedVariante(var);
                    continue;
                }
                this.mModel.setSelectedVariante(null);
                continue;
            }
            combo.setEnabled(false);
        }
        if (!sindVariantenVorhanden) {
            this.mModel.setSelectedVariante(null);
        }
    }

    public void updateVariantenZuSelectedEinzelteil(String position) {
        for (JComboBox combo : this.mVariantenZuEinzelteile.values()) {
            if (combo.getActionCommand() == position) {
                combo.setEnabled(true);
                combo.updateUI();
                continue;
            }
            combo.setEnabled(false);
            combo.updateUI();
        }
    }

    public ArrayList<Variante> getVerbaubareVariantenZuSelectedAlt(String bildPosNr) {
        return (ArrayList)this.mModel.getMarketingProdukt().getVariantenZuAlternativen().get(bildPosNr);
    }

    public void setVerbaubareVariantenDerBestandteile() {
    }

    public void removeBestandteilePanel() {
        if (this.mBestandteilePanel != null && this.mBesttScrollPanel != null && this.mBestandteileLabel != null) {
            this.mBesttScrollPanel.setVisible(false);
            this.mBestandteilePanel.setBorder(BorderFactory.createEmptyBorder());
            this.mBestandteilePanel.setPreferredSize(BALKEN_DIMENSION);
            this.mBestandteilePanel.setMinimumSize(BALKEN_DIMENSION);
            this.mBestandteilePanel.setMaximumSize(BALKEN_DIMENSION);
            this.mBestandteileLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.mBestandteileLabel.validate();
            this.mBestandteileLabel.updateUI();
            this.isBestOpened = false;
        }
    }

    public void removeEinzelteilePanel() {
        if (this.mEinzelteilPanel != null && this.mEinzelteilScrollPanel != null && this.mEinzelteilLabel != null) {
            this.mEinzelteilScrollPanel.setVisible(false);
            this.mEinzelteilPanel.setBorder(BorderFactory.createEmptyBorder());
            this.mEinzelteilPanel.setPreferredSize(BALKEN_DIMENSION);
            this.mEinzelteilPanel.setMinimumSize(BALKEN_DIMENSION);
            this.mEinzelteilPanel.setMaximumSize(BALKEN_DIMENSION);
            this.mEinzelteilLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.mEinzelteilLabel.validate();
            this.mEinzelteilLabel.updateUI();
            this.isEinzelOpened = false;
        }
    }

    public void removeTextPanel() {
        if (this.mDescrPanel != null && this.mDescrScrollPanel != null && this.mDescrLabel != null) {
            this.mDescrScrollPanel.setVisible(false);
            this.mDescrPanel.setBorder(BorderFactory.createEmptyBorder());
            this.mDescrPanel.setPreferredSize(BALKEN_DIMENSION);
            this.mDescrPanel.setMinimumSize(BALKEN_DIMENSION);
            this.mDescrPanel.setMaximumSize(BALKEN_DIMENSION);
            this.mDescrLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.isTextOpened = false;
        }
    }

    public void removeAlternativenPanel() {
        if (this.mAltPanel != null && this.mAltScrollPanel != null && this.mAltLabel != null) {
            this.mAltScrollPanel.setVisible(false);
            this.mAltPanel.setBorder(BorderFactory.createEmptyBorder());
            this.mAltPanel.setPreferredSize(BALKEN_DIMENSION);
            this.mAltPanel.setMinimumSize(BALKEN_DIMENSION);
            this.mAltPanel.setMaximumSize(BALKEN_DIMENSION);
            this.mAltLabel.setIcon(this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen.gif"), this.mLayout.getPrimaryBackground()));
            this.isAltOpened = false;
        }
    }

    public ArrayList<JLabel> getDynamicLabels() {
        return this.dynamicLabels;
    }

    public void setDynamicLabels(ArrayList<JLabel> dynamicLabels) {
        this.dynamicLabels = dynamicLabels;
    }

    public Dimension getCurrentPanelDimension(JPanel panel) {
        Dimension dim = null;
        if (this.isDynamic) {
            if (this.modus == 0 || this.modus == 1) {
                dim = new Dimension(490, 255);
                return dim;
            }
            if (this.modus == 2 && this.textSize == 0 && panel.equals(this.mDescrPanel)) {
                dim = BALKEN_DIMENSION;
                return dim;
            }
            if (this.modus == 2 && this.textSize > 0) {
                dim = new Dimension(490, 235);
                return dim;
            }
            if (this.modus == 3 || this.modus == 2 && this.textSize == 0 && !panel.equals(this.mDescrPanel)) {
                dim = new Dimension(490, 210);
                return dim;
            }
            if (this.modus == 4) {
                dim = new Dimension(490, 185);
                return dim;
            }
        } else {
            if (panel.equals(this.mDescrPanel) && this.modus == 1 && this.textSize > 0) {
                dim = new Dimension(490, 260);
                return dim;
            }
            if (panel.equals(this.mDescrPanel) && this.textSize == 0) {
                dim = BALKEN_DIMENSION;
                return dim;
            }
            if (this.modus == 2) {
                int textPanelHeight = 0;
                int bestandteileHeight = 0;
                int alternativenHeight = 0;
                textPanelHeight = this.isTextOpened ? TextPanel.BALKEN_DIMENSION.height + this.textSize * 13 + 20 : TextPanel.BALKEN_DIMENSION.height;
                if (panel.equals(this.mDescrPanel)) {
                    dim = new Dimension(490, textPanelHeight);
                    return dim;
                }
                if (!this.isTextOpened) {
                    bestandteileHeight = TextPanel.BALKEN_DIMENSION.height + this.besttSize * 13 + 20;
                    alternativenHeight = TextPanel.BALKEN_DIMENSION.height + this.altSize * 13 + 20;
                    if (panel.equals(this.mBestandteilePanel) && (this.altSize > 0 || this.einzelteileSize > 0)) {
                        dim = new Dimension(490, bestandteileHeight);
                        return dim;
                    }
                    if (panel.equals(this.mAltPanel) && this.besttSize > 0) {
                        dim = new Dimension(490, 250 - textPanelHeight - bestandteileHeight);
                        return dim;
                    }
                    if (panel.equals(this.mAltPanel) && this.einzelteileSize > 0) {
                        dim = new Dimension(490, alternativenHeight);
                        return dim;
                    }
                    dim = new Dimension(490, 250 - textPanelHeight - alternativenHeight);
                    return dim;
                }
                dim = new Dimension(490, 255 - textPanelHeight);
                return dim;
            }
            if (this.modus == 0) {
                return new Dimension(490, 255);
            }
            return new Dimension(490, 235);
        }
        return dim;
    }

    public void setCombosEditable(boolean flag) {
        this.isEditable = flag;
        this.setAlternativenEditable(flag);
        this.setVarAlternativenEditable(flag);
        this.setBestandteileEditable(flag);
        this.setEinzelteileEditable(flag);
        this.setVarEinzelteilEditable(flag);
    }

    private void setAlternativenEditable(boolean flag) {
        if (this.mAlternativesRadioButtons != null) {
            for (JRadioButton alternative : this.mAlternativesRadioButtons) {
                alternative.setEnabled(flag);
                alternative.updateUI();
            }
        }
    }

    private void setVarAlternativenEditable(boolean flag) {
        block6: {
            if (this.mVariantenZuAlternativen == null) break block6;
            if (flag) {
                for (JComboBox variante : this.mVariantenZuAlternativen.values()) {
                    if (this.mModel.getSelectedAlternative() != null && this.mModel.getSelectedAlternative().getBildPos().equals(variante.getActionCommand())) {
                        variante.setEnabled(true);
                    } else {
                        variante.setEnabled(false);
                    }
                    variante.updateUI();
                }
            } else {
                for (JComboBox variante : this.mVariantenZuAlternativen.values()) {
                    variante.setEnabled(false);
                    variante.updateUI();
                }
            }
        }
    }

    private void setEinzelteileEditable(boolean flag) {
        if (this.mEinzelteilCheckBoxes != null) {
            for (JCheckBox einzelteil : this.mEinzelteilCheckBoxes) {
                einzelteil.setEnabled(flag);
                einzelteil.updateUI();
            }
        }
    }

    private void setVarEinzelteilEditable(boolean flag) {
        block5: {
            if (this.mVariantenZuEinzelteile.isEmpty()) break block5;
            if (flag && this.mModel.getSelectedEinzelteile() != null) {
                for (JCheckBox einzelteil : this.mEinzelteilCheckBoxes) {
                    JComboBox varCombo = this.mVariantenZuEinzelteile.get(einzelteil.getActionCommand());
                    if (varCombo != null && einzelteil.isSelected()) {
                        varCombo.setEnabled(true);
                        varCombo.updateUI();
                        continue;
                    }
                    if (varCombo == null) continue;
                    varCombo.setEnabled(false);
                    varCombo.updateUI();
                }
            } else {
                for (JComboBox variante : this.mVariantenZuEinzelteile.values()) {
                    variante.setEnabled(false);
                    variante.updateUI();
                }
            }
        }
    }

    private void setBestandteileEditable(boolean flag) {
        for (Bestandteil part : this.mModel.getBestandteile()) {
            JComboBox combo = part.getVariantenCombo();
            if (combo == null) continue;
            combo.setEnabled(flag);
            combo.updateUI();
        }
    }

    public HashMap<String, JComboBox> getVariantenZuAlternativen() {
        return this.mVariantenZuAlternativen;
    }

    public void setVariantenZuAlternativen(HashMap<String, JComboBox> variantsRadioButtons) {
        this.mVariantenZuAlternativen = variantsRadioButtons;
    }

    public ArrayList<JRadioButton> getAlternativesRadioButtons() {
        return this.mAlternativesRadioButtons;
    }

    public void setAlternativesRadioButtons(ArrayList<JRadioButton> alternativesRadioButtons) {
        this.mAlternativesRadioButtons = alternativesRadioButtons;
    }

    public JPanel getTextPanel() {
        return this.textPanel;
    }

    public void setTextPanel(JPanel textPanel) {
        this.textPanel = textPanel;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public void setAltInhaltPanel(JPanel altInhaltPanel) {
        this.mAltInhaltPanel = altInhaltPanel;
    }

    public void setBestandteileInhalt(JPanel bestandteileInhalt) {
        this.mBestandteileInhalt = bestandteileInhalt;
    }

    public boolean isFehlerFall() {
        return this.fehlerFall;
    }

    public void setFehlerFall(boolean fehlerFall) {
        this.fehlerFall = fehlerFall;
    }

    public ArrayList<JCheckBox> getEinzelteilCheckBoxes() {
        return this.mEinzelteilCheckBoxes;
    }

    public void setEinzelteilCheckBoxes(ArrayList<JCheckBox> einzelteilCheckBoxes) {
        this.mEinzelteilCheckBoxes = einzelteilCheckBoxes;
    }

    public HashMap<String, JComboBox> getVariantenZuEinzelteile() {
        return this.mVariantenZuEinzelteile;
    }

    public void setVariantenZuEinzelteile(HashMap<String, JComboBox> variantenZuEinzelteile) {
        this.mVariantenZuEinzelteile = variantenZuEinzelteile;
    }

    public void resetView() {
        this.mAltInhaltPanel = null;
        this.mBestandteileInhalt = null;
        this.mEinzelteilInhaltPanel = null;
        this.mTextLabel = null;
        this.textPanel.removeAll();
    }

    public static int getMaxZeichenAnzahl() {
        int maxZeichenAnzahl = 27;
        if (GlobalObjects.getInstance().getLanguage().equals("ja")) {
            maxZeichenAnzahl = 14;
        } else if (GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("zh")) {
            maxZeichenAnzahl = 18;
        }
        return maxZeichenAnzahl;
    }

    public class MyFontMetrics
    extends FontMetrics {
        private static final long serialVersionUID = 1L;

        public MyFontMetrics(Font font) {
            super(font);
        }
    }
}

