/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.utilities.CssEditorKit;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import webetk.app.bteinfo.Info;
import webetk.resources.Resource;

public class WeitereInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MarketingModel mModel;
    private MarkenLayout mLayout;
    private Color textSelect;
    private Component[] mContainer;

    public WeitereInfoPanel(MarketingModel model, MarkenLayout layout) {
        this.mModel = model;
        this.mLayout = layout;
        this.textSelect = this.mLayout.isMINI() ? this.mLayout.getTertiaryForeground() : this.mLayout.getPrimaryForeground();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(800, 235));
        this.setMinimumSize(new Dimension(800, 235));
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.createTabs();
    }

    private void createTabs() {
        ArrayList<String> tabNames = new ArrayList<String>();
        ArrayList<JScrollPane> container = new ArrayList<JScrollPane>();
        if (this.mModel.getTextBnb() == null) {
            if (this.mModel.getMarketingProdukt().getNutzen() != null && !this.mModel.getMarketingProdukt().getNutzen().equals("")) {
                tabNames.add(Resource.getInstance().getNutzen());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getNutzen(), false));
            }
            if (this.mModel.getMarketingRelevantenKommentar() != null && this.mModel.getMarketingRelevantenKommentar().getHinweise().size() > 0) {
                tabNames.add(Resource.getInstance().getKommentare());
                container.add(this.setMarketingRelevantenKom());
            }
            if (this.mModel.getMarketingProdukt().getWettbewerb() != null && !this.mModel.getMarketingProdukt().getWettbewerb().equals("")) {
                tabNames.add(Resource.getInstance().getWettbewerb());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getWettbewerb(), false));
            }
            if (this.mModel.getMarketingProdukt().getZusatzNutzen() != null && !this.mModel.getMarketingProdukt().getZusatzNutzen().equals("")) {
                tabNames.add(Resource.getInstance().getZusatznutzen());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getZusatzNutzen(), false));
            }
            if (this.mModel.getMarketingProdukt().getTippsUndTricks() != null && !this.mModel.getMarketingProdukt().getTippsUndTricks().equals("")) {
                tabNames.add(Resource.getInstance().getTippsTricks());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getTippsUndTricks(), false));
            }
            if (this.mModel.getMarketingProdukt().getWeitergehendeInformationen() != null && !this.mModel.getMarketingProdukt().getWeitergehendeInformationen().equals("")) {
                tabNames.add(Resource.getInstance().getWeitergehendeinfo());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getWeitergehendeInformationen(), false));
            }
            boolean markvorhanden = false;
            String markText = "";
            if (this.mModel.getMarketingProdukt().getWerbungAktionen() != null && !this.mModel.getMarketingProdukt().getWerbungAktionen().equals("")) {
                markvorhanden = true;
                markText = "<b>" + Resource.getInstance().getWerbungaktion() + "</b><br>" + this.mModel.getMarketingProdukt().getWerbungAktionen();
            }
            if (this.mModel.getMarketingProdukt().getKundeninformationen() != null && !this.mModel.getMarketingProdukt().getKundeninformationen().equals("")) {
                markvorhanden = true;
                markText = !markText.equals("") ? markText + "<br><br><b>" + Resource.getInstance().getKundeninfo() + "</b><br>" + this.mModel.getMarketingProdukt().getKundeninformationen() : "<b>" + Resource.getInstance().getKundeninfo() + "</b><br>" + this.mModel.getMarketingProdukt().getKundeninformationen();
            }
            if (this.mModel.getMarketingProdukt().getShopDisplaysUndAndere() != null && !this.mModel.getMarketingProdukt().getShopDisplaysUndAndere().equals("")) {
                markvorhanden = true;
                markText = !markText.equals("") ? markText + "<br><br><b>" + Resource.getInstance().getWeiteresmaterial() + "</b><br>" + this.mModel.getMarketingProdukt().getShopDisplaysUndAndere() : "<b>" + Resource.getInstance().getWeiteresmaterial() + "</b><br>" + this.mModel.getMarketingProdukt().getShopDisplaysUndAndere();
            }
            if (markvorhanden) {
                tabNames.add(Resource.getInstance().getMarketingmaterial());
                container.add(this.setTextInTextPane(markText, true));
            }
            if (this.mModel.getMarketingProdukt().getDetails() != null && !this.mModel.getMarketingProdukt().getDetails().equals("")) {
                tabNames.add(Resource.getInstance().getDetails());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getDetails(), true));
            }
            if (this.mModel.getMarketingProdukt().getVerkaufsinfo() != null && !this.mModel.getMarketingProdukt().getVerkaufsinfo().equals("")) {
                tabNames.add(Resource.getInstance().getVerkaufsbeschreibung());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getVerkaufsinfo(), true));
            }
            if (this.mModel.getMarketingProdukt().getCrossSelling() != null && !this.mModel.getMarketingProdukt().getCrossSelling().equals("")) {
                tabNames.add(Resource.getInstance().getCrossSelling());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getCrossSelling(), true));
            }
            if (this.mModel.getMarketingProdukt().getErsatzTeile() != null && !this.mModel.getMarketingProdukt().getErsatzTeile().equals("")) {
                tabNames.add(Resource.getInstance().getErsatzteile());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getErsatzTeile(), true));
            }
            if (this.mModel.getMarketingProdukt().getHinweise() != null && !this.mModel.getMarketingProdukt().getHinweise().equals("")) {
                tabNames.add(Resource.getInstance().getHinweise());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getHinweise(), true));
            }
            if (this.mModel.getMarketingProdukt().getSonstiges() != null && !this.mModel.getMarketingProdukt().getSonstiges().equals("")) {
                tabNames.add(Resource.getInstance().getSonstiges());
                container.add(this.setTextInTextPane(this.mModel.getMarketingProdukt().getSonstiges(), true));
            }
        } else {
            if (this.mModel.getTextBnb().getVerkaufsinfo() != null && !this.mModel.getTextBnb().getVerkaufsinfo().equals("")) {
                tabNames.add(Resource.getInstance().getVerkaufsbeschreibung());
                container.add(this.setTextInTextPane(this.mModel.getTextBnb().getVerkaufsinfo(), true));
            }
            if (this.mModel.getTextBnb().getHinweise() != null && !this.mModel.getTextBnb().getHinweise().equals("")) {
                tabNames.add(Resource.getInstance().getHinweise());
                container.add(this.setTextInTextPane(this.mModel.getTextBnb().getHinweise(), true));
            }
            if (this.mModel.getTextBnb().getCrossSelling() != null && !this.mModel.getTextBnb().getCrossSelling().equals("")) {
                tabNames.add(Resource.getInstance().getCrossSelling());
                container.add(this.setTextInTextPane(this.mModel.getTextBnb().getCrossSelling(), true));
            }
            if (this.mModel.getTextBnb().getDetails() != null && !this.mModel.getTextBnb().getDetails().equals("")) {
                tabNames.add(Resource.getInstance().getDetails());
                container.add(this.setTextInTextPane(this.mModel.getTextBnb().getDetails(), true));
            }
            if (this.mModel.getTextBnb().getSonstiges() != null && !this.mModel.getTextBnb().getSonstiges().equals("")) {
                tabNames.add(Resource.getInstance().getSonstiges());
                container.add(this.setTextInTextPane(this.mModel.getTextBnb().getSonstiges(), true));
            }
            if (this.mModel.getTextBnb().getErsatzTeile() != null && !this.mModel.getTextBnb().getErsatzTeile().equals("")) {
                tabNames.add(Resource.getInstance().getErsatzteile());
                container.add(this.setTextInTextPane(this.mModel.getTextBnb().getErsatzTeile(), true));
            }
        }
        String[] tabs = new String[1];
        tabs = tabNames.toArray(tabs);
        this.mContainer = new Component[1];
        this.mContainer = container.toArray(this.mContainer);
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 11, new Insets(0, 0, 0, 8));
        this.add((Component)this.getPrototypeTabbedPane(tabs, this.mContainer, 800, 470), gbc);
        this.validate();
    }

    private JScrollPane setMarketingRelevantenKom() {
        JScrollPane markScrollPane = this.getNewPanel();
        JPanel markPanel = (JPanel)markScrollPane.getViewport().getComponent(0);
        markPanel.setLayout(new GridBagLayout());
        Info bteKom = this.mModel.getMarketingRelevantenKommentar();
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 0, 18, new Insets(5, 0, 0, 0));
        markPanel.add((Component)new JLabel(), gbc);
        int counter = 2;
        Iterator iter = bteKom.getHinweise().iterator();
        while (iter.hasNext()) {
            gbc = this.mLayout.setGridBagConstraints(0, counter, 1, 1, 0.0, 0.0, 0, 17, new Insets(5, 5, 0, 0));
            JLabel kommentar = this.mLayout.getLabel((String)((Hashtable)iter.next()).get("Text"));
            kommentar.setForeground(this.mLayout.getPrimaryForeground());
            markPanel.add((Component)kommentar, gbc);
            ++counter;
        }
        gbc = this.mLayout.setGridBagConstraints(0, counter, 1, 1, 0.0, 1.0, 0, 11, new Insets(5, 0, 0, 0));
        markPanel.add((Component)new JLabel(), gbc);
        return markScrollPane;
    }

    private JScrollPane setTextInTextPane(String text, boolean isFormated) {
        JTextPane textPane = new JTextPane();
        textPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        textPane.setFont(Constants.Layout.getZubDefaultFont());
        textPane.setEditable(false);
        textPane.setContentType("text/html; charset=UTF-8");
        textPane.setEditorKit(new CssEditorKit());
        textPane.setBorder(null);
        if (this.mLayout.isBMWMotorrad()) {
            textPane.setText("<div class='menu2'>" + text + "</div>");
        } else if (text.contains("#")) {
            textPane.setText("<div class='menu2'>" + this.mLayout.cleanTextWithNewLine(text, "#", "&#149; ") + "</div>");
        } else {
            textPane.setText("<div class='menu2'>" + text + "</div>");
        }
        textPane.setForeground(Color.BLACK);
        textPane.setBackground(Color.WHITE);
        textPane.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textPane, 20, 31);
        scrollPane.setBackground(this.mLayout.getPrimaryBackground());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBackground(this.mLayout.getPrimaryBackground());
        scrollPane.updateUI();
        scrollPane.validate();
        return scrollPane;
    }

    public static int buchstabenzaehler(String text, char buchstabe) {
        int counter = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != buchstabe) continue;
            ++counter;
        }
        return counter;
    }

    public static int stringzaehler(String text, String suchstring) {
        int counter = 0;
        String dummy = "";
        int index = text.indexOf(suchstring);
        if (index != -1) {
            ++counter;
            while (index < text.length()) {
                int indexold = index;
                dummy = text.substring(index);
                if ((index = dummy.indexOf(suchstring)) != -1) {
                    ++counter;
                } else {
                    index = text.length();
                }
                index = index + indexold + suchstring.length();
            }
        }
        return counter;
    }

    protected JTabbedPane getPrototypeTabbedPane(String[] bezeichnungen, Component[] content, int width, int height) {
        int i;
        JTabbedPane pane = new JTabbedPane();
        for (i = 0; i < Math.max(bezeichnungen.length, content.length); ++i) {
            String bezeichnung = i >= bezeichnungen.length ? "" : bezeichnungen[i];
            Component comp = i >= content.length ? new JPanel() : content[i];
            pane.setFont(Constants.Layout.getZubBigFont());
            pane.addTab(bezeichnung, comp);
        }
        pane.setPreferredSize(new Dimension(width, height));
        for (i = 0; i < pane.getTabCount(); ++i) {
            pane.setBackgroundAt(i, i == pane.getSelectedIndex() ? this.mLayout.getSelectedReiterBackground() : this.mLayout.getDeselectedReiterBackground());
            pane.setForegroundAt(i, i == pane.getSelectedIndex() ? this.textSelect : this.mLayout.getPrimaryForeground());
            ((JComponent)((JScrollPane)pane.getComponent(i)).getViewport().getComponent(0)).setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mLayout.getBorderColor()));
        }
        pane.setBackground(this.mLayout.getPrimaryBackground());
        pane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                for (int i = 0; i < pane.getTabCount(); ++i) {
                    pane.setBackgroundAt(i, WeitereInfoPanel.this.mLayout.getDeselectedReiterBackground());
                    pane.setForegroundAt(i, WeitereInfoPanel.this.mLayout.getPrimaryForeground());
                    ((JScrollPane)pane.getComponent(i)).getViewport().setViewPosition(new Point(1, 1));
                    ((JScrollPane)pane.getComponent(i)).repaint();
                }
                pane.setBackgroundAt(pane.getSelectedIndex(), WeitereInfoPanel.this.mLayout.getSelectedReiterBackground());
                pane.setForegroundAt(pane.getSelectedIndex(), WeitereInfoPanel.this.textSelect);
            }
        });
        return pane;
    }

    private JScrollPane getNewPanel() {
        JScrollPane scrollPane = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setBackground(this.mLayout.getPrimaryBackground());
        panel.setLayout(new GridBagLayout());
        scrollPane.getViewport().add(panel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }
}

