/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ZusatzproduktLabel
extends JPanel {
    private JLabel mImage = null;
    private JLabel mDescription = null;
    private Border mBorder = null;
    private JCheckBox mCheck = null;
    private MarkenLayout mMarkenLayout;

    public ZusatzproduktLabel(ImageIcon image, String descText, int count, MarkenLayout layout) {
        this.mMarkenLayout = layout;
        int bordersize = this.mMarkenLayout.getBorderSize();
        this.setName("BILD");
        this.mBorder = BorderFactory.createMatteBorder(bordersize, bordersize, bordersize, bordersize, this.mMarkenLayout.getBorderColor());
        this.setBorder(this.mBorder);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(120, 100));
        this.setMinimumSize(new Dimension(120, 100));
        this.setMaximumSize(new Dimension(120, 100));
        this.setName(descText + "_" + count);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = this.setGridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 0, 0, 1, 18, new Insets(3, 0, 0, 0));
        this.mImage = new JLabel(image);
        this.mImage.setName(descText + "_" + count);
        this.add((Component)this.mImage, gbc);
        this.mDescription = new JLabel(descText);
        this.mDescription.setToolTipText(descText);
        gbc = this.setGridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 0, 0, 1, 18, new Insets(0, 5, 0, 0));
        this.add((Component)this.mDescription, gbc);
        this.mCheck = new JCheckBox();
        this.mCheck.setSelected(false);
        this.mCheck.setName("OPTIONAL");
        gbc = this.setGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 0, 0, 1, 12, new Insets(0, 0, 0, 0));
        this.add((Component)this.mCheck, gbc);
        this.setLayout(this.mMarkenLayout);
        this.validate();
        this.setVisible(true);
    }

    public void setLayout(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mCheck.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDescription.setForeground(this.mMarkenLayout.getPrimaryForeground());
    }

    public void setCheckBox(Boolean value) {
        this.mCheck.setSelected(value);
        this.validate();
        this.updateUI();
    }

    public JCheckBox getCheck() {
        return this.mCheck;
    }

    private GridBagConstraints setGridBagConstraints(int gx, int gy, int gw, int gh, double wx, double wy, int ix, int iy, int fill, int anchor, Insets inset) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.weightx = wx;
        c.weighty = wy;
        c.ipadx = ix;
        c.ipady = iy;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = inset;
        return c;
    }

    public JLabel getImage() {
        return this.mImage;
    }

    public void setLabelBorder() {
        int bordersize = this.mMarkenLayout.getBorderSize();
        this.mBorder = BorderFactory.createMatteBorder(bordersize, bordersize, bordersize, bordersize, this.mMarkenLayout.getBorderColor());
        this.setBorder(this.mBorder);
        this.mDescription.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.validate();
    }

    public void removeLabelBorder() {
        int bordersize = this.mMarkenLayout.getBorderSize();
        this.mBorder = BorderFactory.createMatteBorder(bordersize, bordersize, bordersize, bordersize, this.mMarkenLayout.getPrimaryBackground());
        this.mDescription.setForeground(Color.GRAY);
        this.setBorder(this.mBorder);
        this.validate();
    }

    public JLabel getDescription() {
        return this.mDescription;
    }
}

