/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.marketing;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.content.marketing.ZusatzproduktInfoPanel;
import de.esg.zub.configurator.content.marketing.ZusatzproduktLabel;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.resources.Resource;

public class ZusatzproduktPanel
extends Observable {
    private ArrayList<ZusatzproduktLabel> mImageLabels = null;
    private JPanel mOptionalPanel = null;
    private ArrayList<JButton> mNextButtons = null;
    private ArrayList<JButton> mNextButtonsPIAS = null;
    private static final int MAXANZEIGE = 3;
    private static final int MAXANZEIGEPIAS = 5;
    private MarkenLayout mLayout;
    private int mOptionalsCount = 0;
    private int mOptionalsCountPias = 0;
    private MarketingModel mModel;
    private JPanel mNextPanel;
    private JPanel mNextPanelPias;
    private JPanel mImagePanel;
    private ArrayList<ZusatzproduktInfoPanel> mInfoPanelsProdukte = null;
    private JPanel mInfoPanel = null;
    private JPanel mContainerZusatzTPS = null;
    private JPanel mContainerZusatzPIAS = null;
    private ArrayList<JLabel> mProduktLabelsPias = null;
    private JPanel mContainerSeitenPias = null;
    private JLabel mEmptyLabelOben = null;
    private JLabel mEmptyLabelUnten = null;

    public ZusatzproduktPanel(MarkenLayout layout) {
        this.mLayout = layout;
        this.createComponents();
        this.setLayout(layout);
    }

    private void createComponents() {
        this.createOptionalPanel();
        this.mImagePanel = new JPanel();
        this.mImagePanel.setPreferredSize(new Dimension(550, 100));
        this.mImagePanel.setMinimumSize(new Dimension(550, 100));
        this.mImagePanel.setMaximumSize(new Dimension(550, 100));
        this.mImagePanel.setLayout(new GridBagLayout());
        this.mInfoPanel = new JPanel();
        this.mInfoPanel.setLayout(new CardLayout());
        this.mInfoPanel.setSize(new Dimension(550, 50));
        this.mInfoPanel.setMinimumSize(new Dimension(550, 50));
        this.mInfoPanel.setMaximumSize(new Dimension(550, 50));
        this.mContainerZusatzTPS = new JPanel(new GridBagLayout());
        this.mContainerZusatzTPS.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerZusatzTPS.setPreferredSize(new Dimension(550, 150));
        this.mContainerZusatzTPS.setMinimumSize(new Dimension(550, 150));
        this.mContainerZusatzTPS.setMaximumSize(new Dimension(550, 150));
        this.mContainerZusatzPIAS = new JPanel(new GridBagLayout());
        this.mContainerZusatzPIAS.setPreferredSize(new Dimension(220, 150));
        this.mContainerZusatzPIAS.setMinimumSize(new Dimension(220, 150));
        this.mContainerZusatzPIAS.setMaximumSize(new Dimension(220, 150));
        this.mContainerSeitenPias = new JPanel();
        this.mContainerSeitenPias.setLayout(new CardLayout());
        this.mProduktLabelsPias = new ArrayList();
        this.mEmptyLabelOben = new JLabel();
        this.mEmptyLabelUnten = new JLabel();
    }

    private void createOptionalPanel() {
        this.mOptionalPanel = new JPanel();
        this.mOptionalPanel.setPreferredSize(new Dimension(790, 235));
        this.mOptionalPanel.setMinimumSize(new Dimension(790, 235));
        this.mOptionalPanel.setLayout(new GridBagLayout());
        this.mOptionalPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mLayout.getBorderColor()), Resource.getInstance().getZusatzprodukte(), 1, 2, Constants.Layout.getZubBoldFont(), this.mLayout.getBorderTextColor()));
    }

    public void setOptionalPanel(MarketingModel model) {
        this.mModel = model;
        this.mOptionalPanel.removeAll();
        this.mOptionalsCount = this.mModel.getNamesZusatzprodukte().size();
        this.mOptionalsCountPias = this.mModel.getPiasZusatzprodukte().size();
        this.mOptionalPanel.removeAll();
        this.mInfoPanelsProdukte = new ArrayList();
        this.mInfoPanel.removeAll();
        this.createImageLabels();
        this.createNextButtonsPIAS();
        this.setImagePanel(1);
        this.createPiasPanel();
        this.setPiasProdukte(1);
    }

    public void createImageLabels() {
        if (this.mOptionalsCount != 0) {
            this.mImageLabels = new ArrayList();
            this.mNextButtons = new ArrayList();
            for (int i = 0; i < this.mOptionalsCount; ++i) {
                ImageIcon unscaledIcon = this.mModel.getImagesZusatzprodukte(i);
                Image image = unscaledIcon.getImage().getScaledInstance(100, 70, 16);
                ImageIcon icon = new ImageIcon(image);
                this.mImageLabels.add(i, new ZusatzproduktLabel(icon, this.mModel.getNamesZusatzprodukte().get(i), i, this.mLayout));
                for (int jj = 0; jj < this.mModel.getIndexSelectedZusatzprodukte().size(); ++jj) {
                    if (this.mModel.getIndexSelectedZusatzprodukte().get(jj) != i) continue;
                    this.mImageLabels.get(i).setCheckBox(true);
                }
            }
            this.createNextButtons();
        } else {
            this.mImageLabels = null;
        }
    }

    private void createNextButtons() {
        this.mNextPanel = new JPanel();
        int anzahlSeiten = 0;
        int counter = 0;
        anzahlSeiten = (int)Math.ceil((double)this.mOptionalsCount / 3.0);
        GridLayout gl = new GridLayout(1, anzahlSeiten);
        this.mNextPanel.setLayout(gl);
        JButton nextB = null;
        if (anzahlSeiten > 1) {
            if (anzahlSeiten == 2) {
                this.mNextPanel.setPreferredSize(new Dimension(40, 9));
                this.mNextPanel.setMinimumSize(new Dimension(40, 9));
            } else {
                this.mNextPanel.setPreferredSize(new Dimension(60, 9));
                this.mNextPanel.setMinimumSize(new Dimension(60, 9));
            }
            for (int i = 0; i < anzahlSeiten; ++i) {
                nextB = new JButton(Integer.toString(i + 1));
                nextB.setBackground(this.mLayout.getPrimaryBackground());
                if (i == anzahlSeiten - 1) {
                    nextB.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.GRAY));
                } else {
                    nextB.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
                }
                counter = i + 1;
                nextB.setName("Button" + counter);
                this.mNextButtons.add(nextB);
                this.mNextPanel.add(nextB);
            }
        }
    }

    private void createNextButtonsPIAS() {
        this.mNextButtonsPIAS = new ArrayList();
        this.mNextPanelPias = new JPanel();
        int anzahlSeiten = 0;
        int counter = 0;
        anzahlSeiten = (int)Math.ceil((double)this.mOptionalsCountPias / 5.0);
        GridLayout gl = new GridLayout(1, anzahlSeiten);
        this.mNextPanelPias.setLayout(gl);
        JButton nextB = null;
        if (anzahlSeiten > 1) {
            if (anzahlSeiten == 2) {
                this.mNextPanelPias.setPreferredSize(new Dimension(40, 9));
                this.mNextPanelPias.setMinimumSize(new Dimension(40, 9));
            } else {
                this.mNextPanelPias.setPreferredSize(new Dimension(60, 9));
                this.mNextPanelPias.setMinimumSize(new Dimension(60, 9));
            }
            for (int i = 0; i < anzahlSeiten; ++i) {
                nextB = new JButton(Integer.toString(i + 1));
                nextB.setBackground(this.mLayout.getPrimaryBackground());
                if (i == anzahlSeiten - 1) {
                    nextB.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.GRAY));
                } else {
                    nextB.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY));
                }
                counter = i + 1;
                nextB.setName("ButtonPIAS" + counter);
                this.mNextButtonsPIAS.add(nextB);
                this.mNextPanelPias.add(nextB);
            }
        }
    }

    public void setImagePanel(int seitennummer) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.mImagePanel.removeAll();
        if (this.mOptionalsCount > 0) {
            int ii;
            int first = 0;
            if (seitennummer != 1) {
                first = (seitennummer - 1) * 3;
            }
            int position = 0;
            if (this.mImageLabels.size() > 3 * seitennummer) {
                for (ii = first; ii < 3 * seitennummer; ++ii) {
                    gbc = this.setGridBagConstraints(position, 0, 1, 2, 0.0, 0.0, 1, 18, new Insets(0, 10, 2, 25));
                    this.mImageLabels.get(ii).removeLabelBorder();
                    this.mImagePanel.add((Component)this.mImageLabels.get(ii), gbc);
                    ++position;
                }
            } else {
                for (ii = first; ii < this.mImageLabels.size(); ++ii) {
                    gbc = this.setGridBagConstraints(position, 0, 1, 2, 0.0, 0.0, 1, 18, new Insets(0, 10, 2, 25));
                    this.mImageLabels.get(ii).removeLabelBorder();
                    this.mImagePanel.add((Component)this.mImageLabels.get(ii), gbc);
                    ++position;
                }
            }
            gbc = this.setGridBagConstraints(4, 0, 1, 1, 10.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            JLabel empty2 = new JLabel();
            this.mImagePanel.add((Component)empty2, gbc);
            this.markNextButton(seitennummer);
            this.mContainerZusatzTPS.removeAll();
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 1, 18, new Insets(5, 0, 5, 5));
            this.mContainerZusatzTPS.add((Component)this.mImagePanel, gbc);
            this.createOptionInformation();
            this.setOptionInformation(first);
            gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.4, 1, 18, new Insets(5, 10, 0, 10));
            this.mContainerZusatzTPS.add((Component)this.mInfoPanel, gbc);
            gbc = this.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 0, 12, new Insets(0, 400, 0, 0));
            this.mContainerZusatzTPS.add((Component)this.mNextPanel, gbc);
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
            this.mOptionalPanel.add((Component)this.mContainerZusatzTPS, gbc);
            this.mOptionalPanel.validate();
            this.mOptionalPanel.updateUI();
        } else {
            JPanel empty = new JPanel();
            empty.setBackground(this.mLayout.getPrimaryBackground());
            empty.setPreferredSize(new Dimension(790, 215));
            empty.setMinimumSize(new Dimension(790, 215));
            empty.setPreferredSize(new Dimension(790, 215));
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(500, 0, 0, 0));
            this.mOptionalPanel.add((Component)empty, gbc);
        }
    }

    private void markNextButton(int seitennummer) {
        JButton nextB = null;
        for (int jj = 0; jj < this.mNextButtons.size(); ++jj) {
            nextB = this.mNextButtons.get(jj);
            if (jj == seitennummer - 1) {
                nextB.setFont(Constants.Layout.getZubDefaultFont());
                nextB.setForeground(this.mLayout.getPrimaryForeground());
                continue;
            }
            nextB.setForeground(Color.GRAY);
            nextB.setFont(Constants.Layout.getZubDefaultFont());
        }
    }

    public void setPiasProdukte(int seitennummer) {
        if (this.mOptionalsCountPias > 0) {
            JButton nextB = null;
            for (int jj = 0; jj < this.mNextButtonsPIAS.size(); ++jj) {
                nextB = this.mNextButtonsPIAS.get(jj);
                if (jj == seitennummer - 1) {
                    nextB.setFont(Constants.Layout.getZubDefaultFont());
                    nextB.setForeground(this.mLayout.getPrimaryForeground());
                    continue;
                }
                nextB.setForeground(Color.GRAY);
                nextB.setFont(Constants.Layout.getZubDefaultFont());
            }
            ((CardLayout)this.mContainerSeitenPias.getLayout()).show(this.mContainerSeitenPias, Integer.toString(seitennummer - 1));
            this.mContainerZusatzPIAS.updateUI();
            this.mContainerZusatzPIAS.validate();
        }
    }

    private void createPiasPanel() {
        GridBagConstraints gbc;
        if (this.mContainerZusatzPIAS != null) {
            this.mContainerZusatzPIAS.removeAll();
            this.mContainerSeitenPias.removeAll();
        }
        this.mProduktLabelsPias = new ArrayList();
        int seitenanzahl = (int)Math.ceil((double)this.mOptionalsCountPias / 5.0);
        if (this.mProduktLabelsPias.size() != this.mOptionalsCountPias) {
            gbc = new GridBagConstraints();
            for (int jj = 0; jj < seitenanzahl; ++jj) {
                int start = jj * 5;
                int ende = (jj + 1) * 5;
                if (ende > this.mOptionalsCountPias) {
                    ende = this.mOptionalsCountPias;
                }
                JPanel containerProdukte = new JPanel();
                containerProdukte.setLayout(new GridBagLayout());
                containerProdukte.setBackground(this.mLayout.getPrimaryBackground());
                for (int ii = start; ii < ende; ++ii) {
                    JLabel produktLabel;
                    String text = this.mModel.getPiasZusatzprodukte().get(ii);
                    int maxTextLength = 30;
                    if (GlobalObjects.getInstance().getLanguage().equals("ja") || GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("zh")) {
                        maxTextLength = 17;
                    } else if (GlobalObjects.getInstance().getLanguage().equals("th")) {
                        maxTextLength = 24;
                    }
                    if (text.length() > maxTextLength) {
                        produktLabel = this.mLayout.getLabel(text.substring(0, maxTextLength - 2) + "...");
                        produktLabel.setToolTipText(this.mModel.getPiasZusatzprodukte().get(ii));
                    } else {
                        produktLabel = new JLabel(this.mModel.getPiasZusatzprodukte().get(ii));
                    }
                    produktLabel.setForeground(this.mLayout.getPrimaryForeground());
                    produktLabel.setBigFont();
                    gbc = this.mLayout.setGridBagConstraints(0, ii, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 10, 5, 3));
                    containerProdukte.add((Component)produktLabel, gbc);
                    this.mProduktLabelsPias.add(produktLabel);
                }
                gbc = this.setGridBagConstraints(0, ende, 1, 1, 0.0, 10.0, 3, 18, new Insets(0, 0, 0, 0));
                containerProdukte.add((Component)new JLabel(), gbc);
                gbc = this.setGridBagConstraints(1, ende, 1, 1, 10.0, 0.0, 2, 18, new Insets(0, 0, 0, 0));
                containerProdukte.add((Component)new JLabel(), gbc);
                this.mContainerSeitenPias.add((Component)containerProdukte, Integer.toString(jj));
            }
            if (seitenanzahl == 1) {
                gbc = this.setGridBagConstraints(0, 2, 1, 1, 0.0, 10.0, 3, 18, new Insets(0, 0, 0, 0));
                this.mContainerZusatzPIAS.add((Component)this.mEmptyLabelOben, gbc);
                gbc = this.setGridBagConstraints(1, 1, 1, 1, 10.0, 0.0, 2, 18, new Insets(0, 0, 0, 0));
                this.mContainerZusatzPIAS.add((Component)this.mEmptyLabelUnten, gbc);
            }
            gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
            this.mContainerZusatzPIAS.add((Component)this.mContainerSeitenPias, gbc);
            ((CardLayout)this.mContainerSeitenPias.getLayout()).show(this.mContainerSeitenPias, Integer.toString(0));
            gbc = this.mLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(15, 30, 3, 0));
            this.mContainerZusatzPIAS.add((Component)this.mNextPanelPias, gbc);
        }
        gbc = new GridBagConstraints();
        this.mContainerZusatzPIAS.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.LIGHT_GRAY));
        this.mContainerZusatzPIAS.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerZusatzPIAS.setForeground(this.mLayout.getPrimaryForeground());
        this.mContainerZusatzPIAS.validate();
        this.mContainerSeitenPias.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerSeitenPias.setForeground(this.mLayout.getPrimaryForeground());
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mOptionalPanel.add((Component)this.mContainerZusatzPIAS, gbc);
        this.mOptionalPanel.validate();
        this.mOptionalPanel.updateUI();
    }

    private void createOptionInformation() {
        if (this.mInfoPanelsProdukte.size() != this.mModel.getNamesZusatzprodukteLang().size()) {
            for (int ii = 0; ii < this.mModel.getNamesZusatzprodukteLang().size(); ++ii) {
                ZusatzproduktInfoPanel zusatzInfoPanel = new ZusatzproduktInfoPanel(new Dimension(790, 70), this.mLayout);
                zusatzInfoPanel.setInfoPanel(this.mModel.getNamesZusatzprodukteLang().get(ii), this.mModel.getDetailtextZusatzprodukte(ii), this.mModel.getPriceZusatzprodukte().get(ii), this.mModel.getBaureihenZusatzprodukte(ii), 1, "");
                this.mInfoPanelsProdukte.add(zusatzInfoPanel);
                this.mInfoPanel.add((Component)zusatzInfoPanel, Integer.toString(ii));
            }
        }
    }

    public void setOptionInformation(int imgNumb) {
        if (this.mImageLabels != null) {
            this.mImageLabels.get(imgNumb).setLabelBorder();
            ((CardLayout)this.mInfoPanel.getLayout()).show(this.mInfoPanel, Integer.toString(imgNumb));
        }
    }

    public void setLayout(MarkenLayout layout) {
        this.mLayout = layout;
        this.mImagePanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mInfoPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mOptionalPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerZusatzTPS.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerZusatzTPS.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerSeitenPias.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerSeitenPias.setForeground(this.mLayout.getPrimaryForeground());
        this.mContainerZusatzPIAS.setBackground(this.mLayout.getPrimaryBackground());
        this.mContainerZusatzPIAS.setForeground(this.mLayout.getPrimaryForeground());
    }

    public void refreshZusatzprodukte() {
        int index = 0;
        int ii = 0;
        ArrayList<ProduktListenElement> ausgewaehlteZusatzProdukte = this.mModel.getSelectedZusatzprodukte();
        Iterator<Integer> it = this.mModel.getIndexSelectedZusatzprodukte().iterator();
        while (it.hasNext()) {
            index = it.next();
            if (this.mModel.getMarketingProdukt().isFahrzeugUngebunden()) {
                this.getImageButtons().get(index).getCheck().setEnabled(true);
                this.getImageButtons().get(index).setCheckBox(true);
                ++ii;
            } else if (this.mModel.getVerbaubareZusatzprodukte() != null) {
                if (!this.mModel.getVerbaubareZusatzprodukte().contains(ausgewaehlteZusatzProdukte.get(ii))) {
                    it.remove();
                    ausgewaehlteZusatzProdukte.remove(ii);
                    this.getImageButtons().get(index).setCheckBox(false);
                    this.getImageButtons().get(index).getCheck().setEnabled(false);
                } else {
                    this.getImageButtons().get(index).getCheck().setEnabled(true);
                    this.getImageButtons().get(index).setCheckBox(true);
                    ++ii;
                }
            }
            this.getOptionalPanel().updateUI();
        }
        this.setChanged();
        this.notifyObservers(this);
    }

    private GridBagConstraints setGridBagConstraints(int gx, int gy, int gw, int gh, double wx, double wy, int fill, int anchor, Insets inset) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = gw;
        c.gridheight = gh;
        c.weightx = wx;
        c.weighty = wy;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = inset;
        return c;
    }

    public ArrayList<ZusatzproduktLabel> getImageButtons() {
        return this.mImageLabels;
    }

    public JPanel getOptionalPanel() {
        return this.mOptionalPanel;
    }

    public ArrayList<JButton> getNextButtons() {
        return this.mNextButtons;
    }

    public void setNextButtons(ArrayList<JButton> nextButtons) {
        this.mNextButtons = nextButtons;
    }

    public void setEnable() {
    }

    public ArrayList<ZusatzproduktInfoPanel> getInfoPanelsProdukte() {
        return this.mInfoPanelsProdukte;
    }

    public ArrayList<JButton> getNextButtonsPIAS() {
        return this.mNextButtonsPIAS;
    }
}

