/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.suche;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.suche.KategorieJLabel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.ImageUtils;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.HitListenHauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.resources.Resource;

public class SubCategoryPanel
extends Observable {
    private JPanel containerPanel = null;
    private JPanel unterkategorienPanel = null;
    private JPanel blaetternPanel = null;
    private JPanel[] unterkategorienPanelList = null;
    private int elementCount = 0;
    private ArrayList<HitListenUnterkategorie> unterkategorieList = null;
    private ArrayList<JLabel> unterkategorieTextList = null;
    private ArrayList<KategorieJLabel> unterkategorieGraphikenList = null;
    private String selectedUnterkategorieText = "";
    private String aktuellesPanel = "";
    private ArrayList<ProduktListenElement> zubehoerList = null;
    private Dimension panelDimension = null;
    private int panelRows = 0;
    private int panelColumns = 0;
    private int panelDistance = 0;
    private boolean isFBAVisible = false;
    private MarkenLayout mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();
    private static Logger log = Logger.getLogger(NavigationPanel.class);

    public SubCategoryPanel(MarkenLayout markenLayout) {
        this.containerPanel = new JPanel(new BorderLayout());
        this.mMarkenLayout = markenLayout;
    }

    public void buildUnterkategorieListen() {
        this.unterkategorieTextList = null;
        this.unterkategorieGraphikenList = null;
        if (this.unterkategorieList == null) {
            return;
        }
        int count = this.unterkategorieList.size();
        if (count <= 0) {
            return;
        }
        this.unterkategorieTextList = new ArrayList(count);
        this.unterkategorieGraphikenList = new ArrayList(count);
        JLabel unterkategorieTextLabel = null;
        KategorieJLabel unterkategorieGraphikLabel = null;
        String unterkategorieText = "";
        ImageIcon unterkategorieImageIcon = null;
        for (int i = 0; i < count; ++i) {
            unterkategorieText = this.unterkategorieList.get(i).getName();
            unterkategorieImageIcon = ImageUtils.getImageIcon(this.unterkategorieList.get(i).getGrafik().getImageData());
            if (unterkategorieImageIcon == null) {
                unterkategorieImageIcon = new ImageIcon(ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg"));
            }
            unterkategorieTextLabel = new JLabel(unterkategorieText);
            unterkategorieTextLabel.setBigFont();
            unterkategorieGraphikLabel = new KategorieJLabel(unterkategorieImageIcon);
            unterkategorieGraphikLabel.setUnterkategorieText(unterkategorieText);
            this.unterkategorieTextList.add(unterkategorieTextLabel);
            this.unterkategorieGraphikenList.add(unterkategorieGraphikLabel);
        }
    }

    public void setUnterkategoriePanel(int rows, int columns, int distance, MarkenLayout markenLayout, ArrayList<HitListenUnterkategorie> newUnterkategorieList) {
        int BREITE_FAKTOR = 233;
        int HOEHE_FAKTOR = 150;
        this.mMarkenLayout = markenLayout;
        this.panelDimension = new Dimension(columns * 233 + columns * distance, rows * 150 + rows * distance);
        this.panelColumns = columns;
        this.panelRows = rows;
        this.panelDistance = distance;
        this.unterkategorieList = newUnterkategorieList;
        if (this.unterkategorienPanel != null) {
            this.unterkategorienPanel.removeAll();
        }
        if (this.unterkategorienPanelList != null && this.unterkategorienPanelList.length > 0) {
            for (int i = 0; i < this.unterkategorienPanelList.length; ++i) {
                if (this.unterkategorienPanelList[i] == null) continue;
                this.unterkategorienPanelList[i].removeAll();
            }
        }
        this.containerPanel.removeAll();
        this.buildUnterkategorieListen();
        this.unterkategorienPanel = new JPanel();
        this.unterkategorienPanel.setLayout(new CardLayout());
        this.unterkategorienPanel.setPreferredSize(this.panelDimension);
        this.unterkategorienPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        if (this.unterkategorieTextList == null || this.unterkategorieTextList.size() <= 0) {
            this.containerPanel.add((Component)this.unterkategorienPanel, "Center");
            return;
        }
        int anzahlPanels = this.unterkategorieTextList.size() / (this.panelRows * this.panelColumns);
        if (this.unterkategorieTextList.size() % (this.panelRows * this.panelColumns) > 0) {
            ++anzahlPanels;
        }
        int aktuellesElementIndex = 0;
        this.unterkategorienPanelList = new JPanel[anzahlPanels];
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 11;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 10, 2, 10);
        JLabel unterkategorieTextLabel = null;
        JLabel unterkategorieGraphikLabel = null;
        int currentRow = 0;
        int currentColumn = 0;
        String cardNumber = "";
        for (int i = 0; i < anzahlPanels; ++i) {
            this.unterkategorienPanelList[i] = new JPanel();
            this.unterkategorienPanelList[i].setLayout(layout);
            this.unterkategorienPanelList[i].setBackground(this.mMarkenLayout.getPrimaryBackground());
            currentRow = 0;
            currentColumn = 0;
            for (int j = 0; j < this.panelRows * this.panelColumns && this.unterkategorieTextList.size() > aktuellesElementIndex; ++aktuellesElementIndex, ++j) {
                unterkategorieTextLabel = this.unterkategorieTextList.get(aktuellesElementIndex);
                unterkategorieGraphikLabel = this.unterkategorieGraphikenList.get(aktuellesElementIndex);
                unterkategorieTextLabel.setName(String.valueOf(this.unterkategorieList.get(aktuellesElementIndex).getId()));
                unterkategorieGraphikLabel.setName(String.valueOf(this.unterkategorieList.get(aktuellesElementIndex).getId()));
                unterkategorieGraphikLabel.setCursor(Constants.CursorTypen.HAND_CURSOR);
                unterkategorieTextLabel.setCursor(Constants.CursorTypen.HAND_CURSOR);
                unterkategorieTextLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
                unterkategorieTextLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
                constraints.gridx = currentColumn++;
                constraints.gridy = currentRow;
                constraints.weighty = 1.0;
                constraints.insets = new Insets(10, 10, 0, 10);
                this.unterkategorienPanelList[i].add((Component)unterkategorieTextLabel, constraints);
                constraints.gridy = currentRow + 1;
                constraints.weighty = 100.0;
                constraints.insets = new Insets(9, 10, 10, 10);
                this.unterkategorienPanelList[i].add((Component)unterkategorieGraphikLabel, constraints);
                if (currentColumn < this.panelColumns) continue;
                currentRow += 2;
                currentColumn = 0;
            }
            cardNumber = String.valueOf(i);
            this.unterkategorienPanel.add((Component)this.unterkategorienPanelList[i], cardNumber);
        }
        ((CardLayout)this.unterkategorienPanel.getLayout()).first(this.unterkategorienPanel);
        if (this.aktuellesPanel.length() <= 0) {
            ((CardLayout)this.unterkategorienPanel.getLayout()).first(this.unterkategorienPanel);
        } else {
            ((CardLayout)this.unterkategorienPanel.getLayout()).show(this.unterkategorienPanel, this.aktuellesPanel);
        }
        this.unterkategorienPanel.updateUI();
        this.unterkategorienPanel.invalidate();
        this.unterkategorienPanel.validate();
        this.unterkategorienPanel.setVisible(true);
        this.containerPanel.add((Component)this.unterkategorienPanel, "Center");
        this.setBlaetternPanel();
        if (this.aktuellesPanel.length() > 0) {
            try {
                int index = Integer.parseInt(this.aktuellesPanel);
                if (this.blaetternPanel.getComponents().length > index) {
                    this.aktiviereBlaetternButton((JLabel)this.blaetternPanel.getComponent(index));
                }
            }
            catch (NumberFormatException e1) {
                log.error((Object)e1.getMessage());
            }
        }
        this.setChanged();
        this.notifyObservers();
        MainController.getInstance().getMainFrame().getRootPane().updateUI();
        MainController.getInstance().getMainFrame().getRootPane().invalidate();
    }

    private void setBlaetternPanel() {
        this.blaetternPanel = new JPanel(new FlowLayout(2));
        this.blaetternPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.buildBlaetternPanel();
        this.containerPanel.add((Component)this.blaetternPanel, "South");
    }

    private void buildBlaetternPanel() {
        this.blaetternPanel.removeAll();
        int anzahlElementeSeite = this.panelRows * this.panelColumns;
        if (anzahlElementeSeite <= 0) {
            return;
        }
        if (this.unterkategorieTextList == null) {
            return;
        }
        int anzahlSeiten = this.unterkategorieTextList.size() / anzahlElementeSeite;
        if (this.unterkategorieTextList.size() % anzahlElementeSeite > 0) {
            ++anzahlSeiten;
        }
        if (anzahlSeiten <= 1) {
            return;
        }
        String BLAETTERN_SEPARATOR = " |";
        JLabel blaetternLabel = null;
        String text = "";
        for (int i = 0; i < anzahlSeiten; ++i) {
            blaetternLabel = new JLabel();
            text = String.valueOf(i + 1);
            if (i + 1 < anzahlSeiten) {
                text = text + " |";
            }
            blaetternLabel.setText(text);
            blaetternLabel.setName(String.valueOf(i));
            blaetternLabel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            blaetternLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.blaetternPanel.add(blaetternLabel);
        }
        if (this.blaetternPanel.getComponents().length > 0) {
            this.aktiviereBlaetternButton((JLabel)this.blaetternPanel.getComponent(0));
        }
    }

    private void deaktiviereBlaetternButtons() {
        if (this.blaetternPanel == null) {
            return;
        }
        JLabel blaetternLabel = null;
        for (int i = 0; i < this.blaetternPanel.getComponentCount(); ++i) {
            if (!(this.blaetternPanel.getComponent(i) instanceof JLabel)) continue;
            blaetternLabel = (JLabel)this.blaetternPanel.getComponent(i);
            blaetternLabel.setBigFont();
        }
    }

    private void aktiviereBlaetternButton(JLabel blaetternLabel) {
        this.deaktiviereBlaetternButtons();
        if (this.blaetternPanel == null) {
            return;
        }
        if (blaetternLabel == null) {
            return;
        }
        for (int i = 0; i < this.blaetternPanel.getComponents().length; ++i) {
            if (this.blaetternPanel.getComponent(i) != blaetternLabel) continue;
            blaetternLabel.setBoldFont();
        }
    }

    public boolean handleUnterkategorieMouseEvent(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.getSource() instanceof JLabel)) {
            return false;
        }
        JLabel selectedUnterkategorie = (JLabel)event.getSource();
        int unterkategorieId = -1;
        int hauptkategorieId = -1;
        try {
            unterkategorieId = Integer.parseInt(selectedUnterkategorie.getName());
            ControllerNavigationPanel.getInstance().getNavigationPanel().setSelectedUnterkategorie(((KategorieJLabel)selectedUnterkategorie).getUnterkategorieText());
            this.selectedUnterkategorieText = selectedUnterkategorie.getText();
            if ((this.selectedUnterkategorieText == null || this.selectedUnterkategorieText.length() <= 0) && selectedUnterkategorie instanceof KategorieJLabel) {
                this.selectedUnterkategorieText = ((KategorieJLabel)selectedUnterkategorie).getUnterkategorieText();
            }
            MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().setSelectedUnterkategorieText(this.selectedUnterkategorieText);
            ControllerNavigationPanel.getInstance().selectUnterkategorieItem(this.selectedUnterkategorieText);
        }
        catch (NumberFormatException e1) {
            log.error((Object)e1.getMessage());
            return false;
        }
        int fetchPage = 1;
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedBaureihe() == null) {
            boolean isLifestyle = false;
            if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie() != null) {
                isLifestyle = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie().isLifestyle();
            }
            hauptkategorieId = ControllerNavigationPanel.getInstance().getNavigationPanel().getSelectedKategorie().getId();
            this.zubehoerList = NavigationPanelDataLoader.loadZubehoerUnterkategorie(Integer.valueOf(hauptkategorieId).longValue(), Integer.valueOf(unterkategorieId).longValue(), fetchPage, isLifestyle);
        } else {
            this.zubehoerList = this.getFahrzeugZubehoerList(fetchPage);
        }
        WorkflowController.getInstance().setNewKonfiguration(true);
        WorkflowController.getInstance().setAddKonfiguration(false);
        WorkflowController.getInstance().setAddKonfigurationDataSet(true);
        return this.zubehoerList != null && this.zubehoerList.size() > 0;
    }

    public ArrayList<ProduktListenElement> getFahrzeugZubehoerList(int fetchPage) {
        int kategorieId = -1;
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKategorie() != null) {
            kategorieId = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedKategorie().getId();
        }
        int unterkategorieId = -1;
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie() != null) {
            unterkategorieId = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie().getId();
        }
        Baureihe selectedFahrzeugdaten = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedFahrzeugdaten();
        ArrayList<HitListenHauptKategorie> trefferliste = NavigationPanelDataLoader.loadZubehoer("", kategorieId, unterkategorieId, selectedFahrzeugdaten, null);
        ArrayList<ProduktListenElement> elementListe = null;
        if (trefferliste != null && trefferliste.size() > 0) {
            elementListe = new ArrayList<ProduktListenElement>();
            for (int i = 0; i < trefferliste.size(); ++i) {
                if (trefferliste.get(i).getBteResults() == null) continue;
                elementListe.addAll(this.getElementList(trefferliste.get(i).getBteResults(), fetchPage));
            }
        } else {
            JOptionPane.showMessageDialog((Component)this.unterkategorienPanel, Resource.getInstance().getMeldungKeinTreffer(), Resource.getInstance().getInformation(), 1);
            return null;
        }
        return elementListe;
    }

    private ArrayList<ProduktListenElement> getElementList(List produktIdList, int fetchPage) {
        if (produktIdList == null || produktIdList.size() <= 0) {
            return null;
        }
        boolean isLifestyle = false;
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie() != null) {
            isLifestyle = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie().isLifestyle();
        }
        return NavigationPanelDataLoader.loadZubehoer(produktIdList, fetchPage, isLifestyle);
    }

    public void handleBlaetternMouseEvent(MouseEvent event) {
        if (event == null) {
            return;
        }
        if (!(event.getSource() instanceof JLabel)) {
            return;
        }
        JLabel selectedLabel = (JLabel)event.getSource();
        this.aktuellesPanel = selectedLabel.getName();
        if (this.aktuellesPanel == null || this.aktuellesPanel.length() <= 0) {
            return;
        }
        ((CardLayout)this.unterkategorienPanel.getLayout()).show(this.unterkategorienPanel, this.aktuellesPanel);
        try {
            int index = Integer.parseInt(this.aktuellesPanel);
            if (this.blaetternPanel.getComponents().length > index) {
                this.aktiviereBlaetternButton((JLabel)this.blaetternPanel.getComponent(index));
            }
        }
        catch (NumberFormatException e1) {
            log.error((Object)e1.getMessage());
        }
    }

    public void handleMouseEnteredEvent(MouseEvent event) {
    }

    public void handleMouseExitedEvent(MouseEvent event) {
    }

    public ArrayList<KategorieJLabel> getUnterkategorieGraphikenList() {
        return this.unterkategorieGraphikenList;
    }

    public int getPanelColumns() {
        return this.panelColumns;
    }

    public void setPanelColumns(int panelColumns) {
        this.panelColumns = panelColumns;
    }

    public Dimension getPanelDimension() {
        return this.panelDimension;
    }

    public void setPanelDimension(Dimension panelDimension) {
        this.panelDimension = panelDimension;
    }

    public int getPanelDistance() {
        return this.panelDistance;
    }

    public void setPanelDistance(int panelDistance) {
        this.panelDistance = panelDistance;
    }

    public int getPanelRows() {
        return this.panelRows;
    }

    public void setPanelRows(int panelRows) {
        this.panelRows = panelRows;
    }

    public ArrayList<JLabel> getUnterkategorieTextList() {
        return this.unterkategorieTextList;
    }

    public JPanel getContainerPanel() {
        return this.containerPanel;
    }

    public JPanel getUnterkategorienPanel() {
        return this.unterkategorienPanel;
    }

    public JPanel getBlaetternPanel() {
        return this.blaetternPanel;
    }

    public ArrayList<ProduktListenElement> getZubehoerList() {
        return this.zubehoerList;
    }

    public void setZubehoerList(ArrayList<ProduktListenElement> zubehoerList) {
        this.zubehoerList = zubehoerList;
    }

    public String getSelectedUnterkategorieText() {
        return this.selectedUnterkategorieText;
    }

    public void setSelectedUnterkategorieText(String selectedUnterkategorieText) {
        this.selectedUnterkategorieText = selectedUnterkategorieText;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public void setElementCount(int elementCount) {
        this.elementCount = elementCount;
    }

    public String getAktuellesPanel() {
        return this.aktuellesPanel;
    }

    public void setAktuellesPanel(String aktuellesPanel) {
        this.aktuellesPanel = aktuellesPanel;
    }

    public boolean isFBAVisible() {
        return this.isFBAVisible;
    }

    public void setFBAVisible(boolean isFBAVisible) {
        this.isFBAVisible = isFBAVisible;
    }

    public ArrayList<HitListenUnterkategorie> getUnterkategorieList() {
        return this.unterkategorieList;
    }

    public void setUnterkategorieList(ArrayList<HitListenUnterkategorie> unterkategorieList) {
        this.unterkategorieList = unterkategorieList;
    }
}

