/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.EinbauCalculator;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class ArbeitHinzufuegenDialog
extends AbstractDialog {
    private static final String PATTERN_MENGE = "[0-9]{0,4}";
    private JComponent price = null;
    private JFormattedTextField mMengeField;
    private JTextField mNummerField;
    private JTextField mBemekrungField;
    private int dialogResult = -1;
    public static final int DIALOG_OK = 1;
    public static final int DIALOG_ABBRECHEN = -1;
    private AufwandsKonfiguration mAufwaende = ControllerTechnikPanel.getInstance().getModel().getAufwaende();
    private Object[] comboValues;
    private JComboBox mArbeitComboBox;
    private JLabel header;
    private JPanel headerPanel;

    public ArbeitHinzufuegenDialog(JFrame owner, String title, MarkenLayout mLayout, Dimension dialogSize) {
        super(owner, title, mLayout, dialogSize);
        this.setComboValues();
        this.mDialog.setDefaultCloseOperation(2);
        this.mDialog.setLayout(new GridBagLayout());
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.setModal(true);
        this.mDialog.setResizable(false);
        this.mDialog.setVisible(false);
        this.setArbeitHinzuf\u00fcgenDialog();
    }

    private void setComboValues() {
        if (this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.comboValues = new Object[6];
            this.comboValues[0] = "";
            this.comboValues[1] = ControllerTechnikPanel.getInstance().getModel().getMechanischeBezeichnung();
            this.comboValues[2] = ControllerTechnikPanel.getInstance().getModel().getElektrischeBezeichnung();
            this.comboValues[3] = ControllerTechnikPanel.getInstance().getModel().getProgrammierBezeichnung();
            this.comboValues[4] = ControllerTechnikPanel.getInstance().getModel().getLackierBezeichnung();
            this.comboValues[5] = ControllerTechnikPanel.getInstance().getModel().getSonstigeBezeichnung();
        } else {
            this.comboValues = new Object[1];
            this.comboValues[0] = ControllerTechnikPanel.getInstance().getModel().getArbeitsaufwandBezeichnung();
        }
    }

    public void setArbeitHinzuf\u00fcgenDialog() {
        this.header = new JLabel(Resource.getInstance().getArbeitHinzufuegen(), 2);
        this.header.setBigBoldFont();
        this.headerPanel = new JPanel(new GridBagLayout());
        this.headerPanel.setPreferredSize(new Dimension(this.mDialogSize.width, 50));
        this.headerPanel.setMinimumSize(new Dimension(this.mDialogSize.width, 50));
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mDialog.add((Component)this.headerPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 17, new Insets(10, 5, 0, 5));
        this.mDialog.add((Component)this.setArbeitsNummerPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 2, 17, new Insets(10, 5, 0, 5));
        this.mDialog.add((Component)this.setButtonsPanel(Resource.getInstance().getUebernehmen(), Resource.getInstance().getSchlieszen(), false, 15, 200), gbc);
        this.setLayout();
        this.setChanged();
        this.notifyObservers();
    }

    private JPanel setArbeitsNummerPanel() {
        JPanel arbeitsNummerPanel = new JPanel();
        arbeitsNummerPanel.setLayout(new GridBagLayout());
        arbeitsNummerPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        arbeitsNummerPanel.setMinimumSize(new Dimension(this.mDialogSize.width, 100));
        arbeitsNummerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY), Resource.getInstance().getArbeitsPositionsNummer(), 0, 0, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
        JLabel nummer = this.mMarkenLayout.getLabel(Resource.getInstance().getArbeitsnummer() + ":");
        nummer.setForeground(this.mMarkenLayout.getPrimaryForeground());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(15, 5, 0, 0));
        arbeitsNummerPanel.add((Component)nummer, gbc);
        this.mNummerField = this.mMarkenLayout.getTextField();
        this.mNummerField.setEditable(false);
        this.mNummerField.setMinimumSize(new Dimension(80, 22));
        this.mNummerField.setPreferredSize(new Dimension(80, 22));
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(15, 2, 0, 0));
        arbeitsNummerPanel.add((Component)this.mNummerField, gbc);
        JLabel artArbeit = this.mMarkenLayout.getLabel(Resource.getInstance().getArtDerArbeit() + ":");
        artArbeit.setForeground(this.mMarkenLayout.getPrimaryForeground());
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(15, 20, 0, 0));
        arbeitsNummerPanel.add((Component)artArbeit, gbc);
        this.mArbeitComboBox = new JComboBox(this.comboValues);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 2, 13, new Insets(15, 2, 0, 20));
        arbeitsNummerPanel.add((Component)this.mArbeitComboBox, gbc);
        JLabel menge = this.mMarkenLayout.getLabel(Resource.getInstance().getMengeInAw() + ":");
        menge.setForeground(this.mMarkenLayout.getPrimaryForeground());
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(7, 10, 0, 0));
        arbeitsNummerPanel.add((Component)menge, gbc);
        this.mMengeField = new JFormattedTextField(JFormattedTextField.getTextFieldPatternFormatter(PATTERN_MENGE));
        this.mMengeField.setMinimumSize(new Dimension(35, 22));
        this.mMengeField.setPreferredSize(new Dimension(35, 22));
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 0, 17, new Insets(15, 2, 0, 0));
        arbeitsNummerPanel.add((Component)this.mMengeField, gbc);
        JLabel bemerkung = this.mMarkenLayout.getLabel(Resource.getInstance().getBemerkung() + ":");
        bemerkung.setForeground(this.mMarkenLayout.getPrimaryForeground());
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(7, 20, 0, 0));
        arbeitsNummerPanel.add((Component)bemerkung, gbc);
        this.mBemekrungField = this.mMarkenLayout.getTextField();
        this.mBemekrungField.setMaxCharacters(20);
        this.mBemekrungField.setMinimumSize(new Dimension(260, 22));
        this.mBemekrungField.setPreferredSize(new Dimension(260, 22));
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 1, 2, 1, 1.0, 0.0, 0, 17, new Insets(15, 2, 0, 20));
        arbeitsNummerPanel.add((Component)this.mBemekrungField, gbc);
        return arbeitsNummerPanel;
    }

    public void setPrice(JComponent priceComponent, String text) {
        if (priceComponent.getClass().getCanonicalName().equals("javax.swing.JLabel")) {
            this.price = new JLabel();
            ((JLabel)this.price).setText(text);
        }
        if (priceComponent.getClass().getCanonicalName().equals("javax.swing.JTextField")) {
            this.price = new JTextField(5);
            ((JTextField)this.price).setText(text);
        }
        this.mMarkenLayout.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, 17, new Insets(7, 7, 0, 0));
    }

    public JComboBox getCombo() {
        return this.mArbeitComboBox;
    }

    public void aktiviereUeberButton(boolean flag) {
        if (flag) {
            this.actionButton.setForeground(this.mMarkenLayout.getEnabledButtonForeground());
            this.actionButton.setBackground(this.mMarkenLayout.getEnabledButtonBackground());
            this.actionButton.setEnabled(flag);
        } else {
            this.actionButton.setForeground(this.mMarkenLayout.getDisabledButtonForeground());
            this.actionButton.setBackground(this.mMarkenLayout.getDisabledButtonBackground());
            this.actionButton.setEnabled(flag);
        }
        this.actionButton.updateUI();
        this.actionButton.validate();
        this.mDialog.validate();
    }

    public void handleDialogAbbrechenMouseEvent(MouseEvent event) {
        this.hideDialog();
        this.dialogResult = -1;
    }

    public void handleDialogUebbernehmenMouseEvent(MouseEvent event) {
        if (this.checkPlausibilitaeten()) {
            this.hideDialog();
            this.dialogResult = 1;
        }
    }

    public void handleComboBoxActionEvent(ActionEvent e) {
        String selectedItem = (String)((JComboBox)e.getSource()).getSelectedItem();
        int selectedIndex = ((JComboBox)e.getSource()).getSelectedIndex();
        if (this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (selectedIndex == 1) {
                this.mNummerField.setText(this.mAufwaende.getMechanischeArbeit().getId());
            } else if (selectedIndex == 2) {
                this.mNummerField.setText(this.mAufwaende.getElektrischeArbeit().getId());
            } else if (selectedIndex == 3) {
                this.mNummerField.setText(this.mAufwaende.getProgrammierArbeit().getId());
            } else if (selectedIndex == 4) {
                this.mNummerField.setText(this.mAufwaende.getLackierArbeit().getId());
            } else if (selectedIndex == 5) {
                this.mNummerField.setText(this.mAufwaende.getSonstigeArbeit().getId());
            } else if (selectedItem.equals("")) {
                this.mNummerField.setText("");
            }
        } else {
            this.mNummerField.setText("");
        }
    }

    public void handleMengenFieldActionEvent(ActionEvent e) {
        if (this.checkPlausibilitaeten()) {
            this.aktiviereUeberButton(true);
        } else {
            this.aktiviereUeberButton(false);
        }
    }

    public boolean checkPlausibilitaeten() {
        return this.checkPlausibilitaetAwNummer() && this.checkPlausibilitaetArbeit() && this.checkPlausibilitaetMenge();
    }

    public boolean checkPlausibilitaetAwNummer() {
        if (this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            return !this.mNummerField.getText().equals("");
        }
        return true;
    }

    public boolean checkPlausibilitaetArbeit() {
        if (this.mMarkenLayout.getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            return this.mArbeitComboBox.getSelectedIndex() != 0;
        }
        return true;
    }

    public boolean checkPlausibilitaetMenge() {
        return !this.mMengeField.getText().equals("") && this.mMengeField.getText().matches(PATTERN_MENGE);
    }

    public JLabelButton getButUebernehmen() {
        return this.actionButton;
    }

    public JLabelButton getButAbbrechen() {
        return this.cancelButton;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public Arbeit getSelectedArbeit() {
        int menge = Integer.parseInt(this.mMengeField.getText());
        EinbauCalculator einbauCalc = ControllerTechnikPanel.getInstance().getModel().getEinbauCalculator();
        double einzelpreisNetto = einbauCalc.berechnePreisFuerAwNr(this.mNummerField.getText(), 1.0f, true);
        double gesamtpreisNetto = einzelpreisNetto * (double)menge;
        double einzelpreisBrutto = einbauCalc.berechnePreisFuerAwNr(this.mNummerField.getText(), 1.0f, false);
        double gesamtpreisBrutto = einbauCalc.berechnePreisFuerAwNr(this.mNummerField.getText(), menge, false);
        Arbeit arbeit = new Arbeit(this.mNummerField.getText(), this.mArbeitComboBox.getSelectedItem().toString(), "HILFSSTOFFE", menge, this.mBemekrungField.getText(), einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false);
        arbeit.setHinzugefuegt(true);
        return arbeit;
    }

    @Override
    public void hideDialog() {
        if (this.isVisible) {
            this.mDialog.removeAll();
            this.isVisible = false;
            this.mDialog.setVisible(this.isVisible);
        }
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.mDialog.setModal(true);
        this.setDialogLocation();
        this.isVisible = true;
        this.setLayout();
        this.mDialog.setVisible(true);
        this.mDialog.validate();
    }

    private void setLayout() {
        if (this.mMarkenLayout.isBMW() || this.mMarkenLayout.isBMWi() || this.mMarkenLayout.isBMWMotorrad()) {
            this.headerPanel.removeAll();
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 16, new Insets(30, 10, 3, 5));
            this.headerPanel.add((Component)this.header, gbc);
            this.headerPanel.setBackground(this.mMarkenLayout.getTertiaryBackground());
            this.header.setForeground(this.mMarkenLayout.getTertiaryForeground());
        } else if (this.mMarkenLayout.isMINI()) {
            this.headerPanel.removeAll();
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 16, new Insets(10, 10, 5, 5));
            this.headerPanel.add((Component)this.header, gbc);
            this.headerPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.headerPanel.setBorder(BorderFactory.createMatteBorder(7, 7, 7, 7, Constants.Layout.LIGHTGRAY_COLOR));
            this.header.setForeground(this.mMarkenLayout.getSecondaryForeground());
        }
    }

    public JTextField getTfNummer() {
        return this.mNummerField;
    }

    public JFormattedTextField getTfMenge() {
        return this.mMengeField;
    }

    public JTextField getTfBemekrung() {
        return this.mBemekrungField;
    }

    public void setTfBemekrung(JTextField bemekrungField) {
        this.mBemekrungField = bemekrungField;
    }
}

