/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.teileliste.Teil;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Kunde;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.extras.teileliste.EditTeil;
import webetk.javaclient.utils.DmsUtils;
import webetk.resources.Resource;

public class ControllerTeileHinzufuegen {
    private static ControllerTeileHinzufuegen mInstance;
    static Logger log;
    private EditTeil mTeileHinzuf\u00fcgenDialog;

    private ControllerTeileHinzufuegen() {
    }

    public static ControllerTeileHinzufuegen getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerTeileHinzufuegen();
        }
        return mInstance;
    }

    public void init() {
        this.mTeileHinzuf\u00fcgenDialog = new EditTeil((Frame)MainController.getInstance().getMainFrame(), true);
        this.mTeileHinzuf\u00fcgenDialog.setController(null);
        this.mTeileHinzuf\u00fcgenDialog.setNeuanlage(true);
        this.mTeileHinzuf\u00fcgenDialog.initComponents();
        this.mTeileHinzuf\u00fcgenDialog.setVisible(true);
    }

    public int getDialogResult() {
        return this.mTeileHinzuf\u00fcgenDialog.getDialogResult();
    }

    public Bauteil getBauteil() {
        float mwst;
        String teilenummer;
        Teil teil = this.mTeileHinzuf\u00fcgenDialog.getTeil();
        if (teil.getPreis() <= 0.0) {
            teil = this.doDatenAbgleich(teil);
        }
        if ((teilenummer = teil.getTeilenummer()).length() == 11) {
            StringBuilder sbTeilenummer = new StringBuilder();
            sbTeilenummer.append(teilenummer.charAt(4));
            sbTeilenummer.append(' ');
            sbTeilenummer.append(teilenummer.substring(5, 8));
            sbTeilenummer.append(' ');
            sbTeilenummer.append(teilenummer.substring(8, 11));
            teilenummer = sbTeilenummer.toString();
        }
        int menge = 0;
        if (teil.getMenge() != null && !teil.getMenge().trim().equals("")) {
            menge = (int)teil.getMengeDouble();
        }
        int lagerBestand = 0;
        if (teil.getLagerbestand() != null) {
            lagerBestand = teil.getLagerbestand().intValue();
        }
        if ((mwst = (float)teil.getMwSt()) == 0.0f) {
            String code = teil.getMwstCode();
            mwst = (float)ClientKonfiguration.getClientKonfiguration().getMwStSatzZuCode(code);
        }
        String benennung = this.mTeileHinzuf\u00fcgenDialog.getTeil().getBenennung();
        if (!teil.getBenennung().equals("")) {
            benennung = teil.getBenennung();
        }
        if (!teil.getZusatz().equals("")) {
            benennung = benennung + "/" + teil.getZusatz();
        }
        Bauteil bauteil = new Bauteil(teilenummer, teil.getTeileart(), "NORMAL", 0, null, benennung, menge, lagerBestand, teil.getPreis(), mwst, teil.getBemerkung() != null && !teil.getBemerkung().equals(""), teil.getBemerkung(), new EinbauInfo(), false, true, new Integer(-1));
        bauteil.setBTEBauteil(false);
        return bauteil;
    }

    private Teil doDatenAbgleich(Teil teil) {
        Kunde kunde;
        if (teil == null) {
            return teil;
        }
        Collection cNewParts = new Vector<Teil>();
        cNewParts.add(teil);
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        LoginInfo sessionInfo = GlobalObjects.getInstance().getSessionInfo();
        trfTL.setValue("eigentuemer", sessionInfo.getLogin());
        trfTL.setValue("filialid", sessionInfo.getFilialeId());
        trfTL.setValue("teile", cNewParts);
        trfTL.setValue("marke", sessionInfo.getMarke());
        String kundennr = null;
        Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
        if (anfrage != null && (kunde = anfrage.getKunde()) != null) {
            kundennr = kunde.getKundennummer();
        }
        if (kundennr != null) {
            trfTL.setValue("kundennr", kundennr);
        }
        trfTL.setValue("datenabgleich_full", true);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DATENABGLEICH);
        }
        catch (CommunicationException ex) {
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainController.getInstance().getMainFrame(), ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return teil;
        }
        MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        if (!DmsUtils.showMsgTxt((String)((String)trfTL.getValue("msgtxt")), (Exception)trfTL.getError())) {
            return teil;
        }
        cNewParts = (Collection)trfTL.getValue("teile");
        return (Teil)cNewParts.iterator().next();
    }

    static {
        log = Logger.getLogger(ControllerTeileHinzufuegen.class);
    }
}

