/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.zub.configurator.workflow.WorkflowController;
import java.util.ArrayList;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.technisch.RefaArbeit;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.mrkprd.Produkte;

public class EinbauCalculator {
    private TechnischesProdukt mTechnikProdukt;
    private EinbauInfo mEinbauInfoKernprodukt;
    private EinbauInfo mEinbauInfoZusatzprodukt;
    private EinbauInfo mEinbauInfoHilf;
    private float mMechanischeArbeit;
    private float mElektronikArbeit;
    private float mProgrammierArbeit;
    private float mLakierArbeit;
    private float mSonstigeArbeit;
    private float mArbeitsAufwand;
    private ArrayList<RefaArbeit> mRefaArbeiten;
    private float mMechGesamtInAW;
    private float mElekGesamtInAW;
    private float mProgGesamtInAW;
    private float mLackGesamtInAW;
    private float mSonsGesamtInAW;
    private float mArbeitsAufwGesamtInAW;
    private float mGesamtMechanischeArbeit;
    private float mGesamtElektronikArbeit;
    private float mGesamtProgrammierArbeit;
    private float mGesamtLakierArbeit;
    private float mGesamtSonstigeArbeit;
    private float mGesamtArbeitsAufwand;
    private ArrayList<RefaArbeit> mGesamtRefaArbeit;
    private String mSchwierigkeitsgrad;
    private AufwandsKonfiguration mAufwaende;

    public EinbauCalculator(TechnischesProdukt produkt, AufwandsKonfiguration aufwaende) {
        this.mTechnikProdukt = produkt;
        this.mAufwaende = aufwaende;
        this.calculate();
    }

    private void initializeEinbauCalculator() {
        this.mEinbauInfoKernprodukt = new EinbauInfo();
        this.mEinbauInfoZusatzprodukt = new EinbauInfo();
        this.mEinbauInfoHilf = new EinbauInfo();
        this.mGesamtMechanischeArbeit = 0.0f;
        this.mGesamtElektronikArbeit = 0.0f;
        this.mGesamtProgrammierArbeit = 0.0f;
        this.mGesamtLakierArbeit = 0.0f;
        this.mGesamtSonstigeArbeit = 0.0f;
        this.mGesamtArbeitsAufwand = 0.0f;
        this.mGesamtRefaArbeit = new ArrayList();
        this.mSchwierigkeitsgrad = "";
    }

    public void calculate() {
        this.initializeEinbauCalculator();
        this.initializeVariables();
        this.calculateKernprodukt();
        this.initializeVariables();
        this.calculateZusatzprodukt();
        this.initializeVariables();
        this.calculateHilf();
    }

    private void initializeVariables() {
        this.mMechanischeArbeit = 0.0f;
        this.mElektronikArbeit = 0.0f;
        this.mProgrammierArbeit = 0.0f;
        this.mLakierArbeit = 0.0f;
        this.mSonstigeArbeit = 0.0f;
        this.mArbeitsAufwand = 0.0f;
        this.mRefaArbeiten = new ArrayList();
    }

    private void calculateKernprodukt() {
        this.getEinbauInfoVonListe((ArrayList)this.mTechnikProdukt.getEinbauInfoProdukt());
        this.getEinbauInfoVonListe((ArrayList)this.mTechnikProdukt.getEinbauInfoVariante());
        ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getKernProduktBnbs();
        for (TechnischerBnb tbnb : technischeBnb) {
            this.getEinbauInfoVonListe((ArrayList)tbnb.getEinbauInfo());
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                this.getEinbauInfoVonListe(bauteil.getEinbauInfo());
            }
        }
        this.mEinbauInfoKernprodukt.setMechanischerAufwand(this.mMechanischeArbeit);
        this.mEinbauInfoKernprodukt.setElektrischerAufwand(this.mElektronikArbeit);
        this.mEinbauInfoKernprodukt.setProgrammierAufwand(this.mProgrammierArbeit);
        this.mEinbauInfoKernprodukt.setLackierAufwand(this.mLakierArbeit);
        this.mEinbauInfoKernprodukt.setSonstigerAufwand(this.mSonstigeArbeit);
        this.mEinbauInfoKernprodukt.setArbeitsAufwand(this.mArbeitsAufwand);
        this.mEinbauInfoKernprodukt.setRefaArbeitenList(this.mRefaArbeiten);
        this.mMechGesamtInAW = (float)this.berechneMinInAw("mech", this.mMechanischeArbeit);
        this.mElekGesamtInAW = (float)this.berechneMinInAw("elektr", this.mElektronikArbeit);
        this.mProgGesamtInAW = (float)this.berechneMinInAw("progr", this.mProgrammierArbeit);
        this.mLackGesamtInAW = (float)this.berechneMinInAw("lack", this.mLakierArbeit);
        this.mSonsGesamtInAW = (float)this.berechneMinInAw("sonst", this.mSonstigeArbeit);
        this.mArbeitsAufwGesamtInAW = (float)this.berechneMinInAw("arbauf", this.mArbeitsAufwand);
        this.mGesamtMechanischeArbeit = this.mMechanischeArbeit;
        this.mGesamtElektronikArbeit = this.mElektronikArbeit;
        this.mGesamtProgrammierArbeit = this.mProgrammierArbeit;
        this.mGesamtLakierArbeit = this.mLakierArbeit;
        this.mGesamtSonstigeArbeit = this.mSonstigeArbeit;
        this.mGesamtArbeitsAufwand = this.mArbeitsAufwand;
        this.addRefaArbeiten(this.mRefaArbeiten, this.mGesamtRefaArbeit);
    }

    private void checkSchwierigkeitsgrad(String schwierig) {
        if (schwierig != null && this.mSchwierigkeitsgrad.compareTo(schwierig) < 1) {
            this.mSchwierigkeitsgrad = schwierig;
        }
    }

    private void calculateZusatzprodukt() {
        ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getZusatzProduktBnbs();
        for (TechnischerBnb tbnb : technischeBnb) {
            this.getEinbauInfoVonListe((ArrayList)tbnb.getEinbauInfo());
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                this.getEinbauInfoVonListe(bauteil.getEinbauInfo());
            }
        }
        this.mEinbauInfoZusatzprodukt.setMechanischerAufwand(this.mMechanischeArbeit);
        this.mEinbauInfoZusatzprodukt.setElektrischerAufwand(this.mElektronikArbeit);
        this.mEinbauInfoZusatzprodukt.setProgrammierAufwand(this.mProgrammierArbeit);
        this.mEinbauInfoZusatzprodukt.setLackierAufwand(this.mLakierArbeit);
        this.mEinbauInfoZusatzprodukt.setSonstigerAufwand(this.mSonstigeArbeit);
        this.mEinbauInfoZusatzprodukt.setArbeitsAufwand(this.mArbeitsAufwand);
        this.mEinbauInfoZusatzprodukt.setRefaArbeitenList(this.mRefaArbeiten);
        this.mMechGesamtInAW = (float)((double)this.mMechGesamtInAW + this.berechneMinInAw("mech", this.mMechanischeArbeit));
        this.mElekGesamtInAW = (float)((double)this.mElekGesamtInAW + this.berechneMinInAw("elektr", this.mElektronikArbeit));
        this.mProgGesamtInAW = (float)((double)this.mProgGesamtInAW + this.berechneMinInAw("progr", this.mProgrammierArbeit));
        this.mLackGesamtInAW = (float)((double)this.mLackGesamtInAW + this.berechneMinInAw("lack", this.mLakierArbeit));
        this.mSonsGesamtInAW = (float)((double)this.mSonsGesamtInAW + this.berechneMinInAw("sonst", this.mSonstigeArbeit));
        this.mArbeitsAufwGesamtInAW = (float)((double)this.mArbeitsAufwGesamtInAW + this.berechneMinInAw("arbauf", this.mArbeitsAufwand));
        this.mGesamtMechanischeArbeit += this.mMechanischeArbeit;
        this.mGesamtElektronikArbeit += this.mElektronikArbeit;
        this.mGesamtProgrammierArbeit += this.mProgrammierArbeit;
        this.mGesamtLakierArbeit += this.mLakierArbeit;
        this.mGesamtSonstigeArbeit += this.mSonstigeArbeit;
        this.mGesamtArbeitsAufwand += this.mArbeitsAufwand;
        this.addRefaArbeiten(this.mRefaArbeiten, this.mGesamtRefaArbeit);
    }

    private void calculateHilf() {
        ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs();
        for (TechnischerBnb tbnb : technischeBnb) {
            this.getEinbauInfoVonListe((ArrayList)tbnb.getEinbauInfo());
            if (tbnb.getBauteile() == null) continue;
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                if (!bauteil.isAktiv()) continue;
                this.getEinbauInfoVonListe(bauteil.getEinbauInfo());
            }
        }
        this.mEinbauInfoHilf.setMechanischerAufwand(this.mMechanischeArbeit);
        this.mEinbauInfoHilf.setElektrischerAufwand(this.mElektronikArbeit);
        this.mEinbauInfoHilf.setProgrammierAufwand(this.mProgrammierArbeit);
        this.mEinbauInfoHilf.setLackierAufwand(this.mLakierArbeit);
        this.mEinbauInfoHilf.setSonstigerAufwand(this.mSonstigeArbeit);
        this.mEinbauInfoHilf.setArbeitsAufwand(this.mArbeitsAufwand);
        this.mEinbauInfoHilf.setRefaArbeitenList(this.mRefaArbeiten);
        this.mMechGesamtInAW = (float)((double)this.mMechGesamtInAW + this.berechneMinInAw("mech", this.mMechanischeArbeit));
        this.mElekGesamtInAW = (float)((double)this.mElekGesamtInAW + this.berechneMinInAw("elektr", this.mElektronikArbeit));
        this.mProgGesamtInAW = (float)((double)this.mProgGesamtInAW + this.berechneMinInAw("progr", this.mProgrammierArbeit));
        this.mLackGesamtInAW = (float)((double)this.mLackGesamtInAW + this.berechneMinInAw("lack", this.mLakierArbeit));
        this.mSonsGesamtInAW = (float)((double)this.mSonsGesamtInAW + this.berechneMinInAw("sonst", this.mSonstigeArbeit));
        this.mArbeitsAufwGesamtInAW = (float)((double)this.mArbeitsAufwGesamtInAW + this.berechneMinInAw("arbauf", this.mArbeitsAufwand));
        this.mGesamtMechanischeArbeit += this.mMechanischeArbeit;
        this.mGesamtElektronikArbeit += this.mElektronikArbeit;
        this.mGesamtProgrammierArbeit += this.mProgrammierArbeit;
        this.mGesamtLakierArbeit += this.mLakierArbeit;
        this.mGesamtSonstigeArbeit += this.mSonstigeArbeit;
        this.mGesamtArbeitsAufwand += this.mArbeitsAufwand;
        this.addRefaArbeiten(this.mRefaArbeiten, this.mGesamtRefaArbeit);
    }

    private void getEinbauInfoVonListe(ArrayList<EinbauInfo> einbauList) {
        if (einbauList != null) {
            for (EinbauInfo einbau : einbauList) {
                this.mMechanischeArbeit += einbau.getMechanischerAufwand();
                this.mElektronikArbeit += einbau.getElektrischerAufwand();
                this.mProgrammierArbeit += einbau.getProgrammierAufwand();
                this.mLakierArbeit += einbau.getLackierAufwand();
                this.mSonstigeArbeit += einbau.getSonstigerAufwand();
                this.mArbeitsAufwand += einbau.getArbeitsAufwand();
                if (einbau.getRefaArbeitenList() != null) {
                    this.addRefaArbeiten(einbau.getRefaArbeitenList(), this.mRefaArbeiten);
                }
                this.checkSchwierigkeitsgrad(einbau.getKomplexitaet());
            }
        }
    }

    private void getEinbauInfoVonListe(EinbauInfo einbau) {
        if (einbau != null) {
            this.mMechanischeArbeit += einbau.getMechanischerAufwand();
            this.mElektronikArbeit += einbau.getElektrischerAufwand();
            this.mProgrammierArbeit += einbau.getProgrammierAufwand();
            this.mLakierArbeit += einbau.getLackierAufwand();
            this.mSonstigeArbeit += einbau.getSonstigerAufwand();
            this.mArbeitsAufwand += einbau.getArbeitsAufwand();
            if (einbau.getRefaArbeitenList() != null) {
                this.addRefaArbeiten(einbau.getRefaArbeitenList(), this.mRefaArbeiten);
            }
            this.checkSchwierigkeitsgrad(einbau.getKomplexitaet());
        }
    }

    private void addRefaArbeiten(ArrayList<RefaArbeit> refaArbeitenToAdd, ArrayList<RefaArbeit> refaList) {
        for (RefaArbeit refa : refaArbeitenToAdd) {
            boolean foundInList = false;
            for (int i = 0; i < refaList.size(); ++i) {
                if (!refaList.get(i).getAwnummer().equals(refa.getAwnummer())) continue;
                foundInList = true;
                refaList.get(i).addMenge(refa.getMenge());
            }
            if (foundInList) continue;
            try {
                refaList.add((RefaArbeit)refa.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public EinbauInfo getEinbauInfoKernprodukt() {
        return this.mEinbauInfoKernprodukt;
    }

    public EinbauInfo getEinbauInfoZusatzprodukt() {
        return this.mEinbauInfoZusatzprodukt;
    }

    public EinbauInfo getEinbauInfoHilf() {
        return this.mEinbauInfoHilf;
    }

    public float getGesamtMechanischeArbeit() {
        if (this.mMechGesamtInAW == 0.0f) {
            return 0.0f;
        }
        if ((double)this.mMechGesamtInAW != this.berechneMinInAw("mech", this.mGesamtMechanischeArbeit)) {
            return (float)((double)this.mMechGesamtInAW * this.mAufwaende.getMechanischeArbeit().getAwMin());
        }
        return this.mGesamtMechanischeArbeit;
    }

    public String getGesamtMechanischeArbeitAw() {
        if ((double)this.mMechGesamtInAW != this.berechneMinInAw("mech", this.mGesamtMechanischeArbeit)) {
            return Long.toString(Math.round(this.mMechGesamtInAW));
        }
        return Long.toString(Math.round(this.berechneMinInAw("mech", this.mGesamtMechanischeArbeit)));
    }

    public float getGesamtElektronikArbeit() {
        if ((double)this.mElekGesamtInAW != this.berechneMinInAw("elektr", this.mGesamtElektronikArbeit)) {
            return (float)((double)this.mElekGesamtInAW * this.mAufwaende.getElektrischeArbeit().getAwMin());
        }
        return this.mGesamtElektronikArbeit;
    }

    public String getGesamtElektronikArbeitAw() {
        if ((double)this.mElekGesamtInAW != this.berechneMinInAw("elektr", this.mGesamtElektronikArbeit)) {
            return Long.toString(Math.round(this.mElekGesamtInAW));
        }
        return Long.toString(Math.round(this.berechneMinInAw("elektr", this.mGesamtElektronikArbeit)));
    }

    public float getGesamtProgrammierArbeit() {
        if ((double)this.mProgGesamtInAW != this.berechneMinInAw("progr", this.mGesamtProgrammierArbeit)) {
            return (float)((double)this.mProgGesamtInAW * this.mAufwaende.getProgrammierArbeit().getAwMin());
        }
        return this.mGesamtProgrammierArbeit;
    }

    public String getGesamtProgrammierArbeitAw() {
        if ((double)this.mProgGesamtInAW != this.berechneMinInAw("progr", this.mGesamtProgrammierArbeit)) {
            return Long.toString(Math.round(this.mProgGesamtInAW));
        }
        return Long.toString(Math.round(this.berechneMinInAw("progr", this.mGesamtProgrammierArbeit)));
    }

    public float getGesamtLakierArbeit() {
        if ((double)this.mLackGesamtInAW != this.berechneMinInAw("lack", this.mGesamtLakierArbeit)) {
            return (float)((double)this.mLackGesamtInAW * this.mAufwaende.getLackierArbeit().getAwMin());
        }
        return this.mGesamtLakierArbeit;
    }

    public String getGesamtLakierArbeitAw() {
        if ((double)this.mLackGesamtInAW != this.berechneMinInAw("lack", this.mGesamtLakierArbeit)) {
            return Long.toString(Math.round(this.mLackGesamtInAW));
        }
        return Long.toString(Math.round(this.berechneMinInAw("lack", this.mGesamtLakierArbeit)));
    }

    public float getGesamtSonstigeArbeit() {
        if ((double)this.mSonsGesamtInAW != this.berechneMinInAw("sonst", this.mGesamtSonstigeArbeit)) {
            return (float)((double)this.mSonsGesamtInAW * this.mAufwaende.getSonstigeArbeit().getAwMin());
        }
        return this.mGesamtSonstigeArbeit;
    }

    public String getGesamtSonstigeArbeitAw() {
        if ((double)this.mSonsGesamtInAW != this.berechneMinInAw("sonst", this.mGesamtSonstigeArbeit)) {
            return Long.toString(Math.round(this.mSonsGesamtInAW));
        }
        return Long.toString(Math.round(this.berechneMinInAw("sonst", this.mGesamtSonstigeArbeit)));
    }

    public float getGesamtenArbeitsAufwand() {
        if ((double)this.mArbeitsAufwGesamtInAW != this.berechneMinInAw("arbauf", this.mGesamtArbeitsAufwand)) {
            return (float)((double)this.mArbeitsAufwGesamtInAW * this.mAufwaende.getArbeitAufwand().getAwMin());
        }
        return this.mGesamtArbeitsAufwand;
    }

    public String getGesamtArbeitsAufwandInAw() {
        if ((double)this.mArbeitsAufwGesamtInAW != this.berechneMinInAw("arbauf", this.mGesamtArbeitsAufwand)) {
            return Long.toString(Math.round(this.mArbeitsAufwGesamtInAW));
        }
        return Long.toString(Math.round(this.berechneMinInAw("arbauf", this.mGesamtArbeitsAufwand)));
    }

    public float getGesamtRefaArbeitenInAw() {
        int refaArbeitenGesamtInAW = 0;
        for (RefaArbeit refa : this.mGesamtRefaArbeit) {
            refaArbeitenGesamtInAW += refa.getMenge();
        }
        return refaArbeitenGesamtInAW;
    }

    public String getGesamtRefaArbeitenInAwToString() {
        int refaArbeitenGesamtInAW = 0;
        for (RefaArbeit refa : this.mGesamtRefaArbeit) {
            refaArbeitenGesamtInAW += refa.getMenge();
        }
        return Long.toString(Math.round(refaArbeitenGesamtInAW));
    }

    public float getGesamtRefaArbeitenInMin() {
        int refaArbeitenGesamtInAW = 0;
        for (RefaArbeit refa : this.mGesamtRefaArbeit) {
            refaArbeitenGesamtInAW += refa.getMenge();
        }
        return this.mTechnikProdukt.getPreise().getMinutenZuAW("", refaArbeitenGesamtInAW);
    }

    public String getGesamteArbeitAw() {
        double speicher = this.berechneMinInAw("mech", this.mGesamtMechanischeArbeit) + this.berechneMinInAw("elektr", this.mGesamtElektronikArbeit) + this.berechneMinInAw("progr", this.mGesamtProgrammierArbeit) + this.berechneMinInAw("sonst", this.mGesamtSonstigeArbeit) + this.berechneMinInAw("lack", this.mGesamtLakierArbeit) + this.berechneMinInAw("arbauf", this.mGesamtArbeitsAufwand) + (double)this.getGesamtRefaArbeitenInAw();
        speicher = Math.floor(speicher + 0.5);
        return Long.toString(Math.round(speicher));
    }

    public String getSchwierigkeitsgrad() {
        return this.mSchwierigkeitsgrad;
    }

    public float berechneAwInMin(String awNummer, float aw) {
        return this.mTechnikProdukt.getPreise().getMinutenZuAW(awNummer, aw);
    }

    public double berechneMinInAw(String art, float arbeitInMinuten) {
        return this.mTechnikProdukt.getPreise().getAWZuMinuten(art, arbeitInMinuten);
    }

    public double berechnePreisVonAwArt(String art, int aw, boolean bNetto) {
        return this.mTechnikProdukt.getPreise().getPreisZuAw(art, aw, bNetto);
    }

    public double berechnePreisFuerAwNr(String awNummer, float aw, boolean bNetto) {
        if (awNummer == null || aw == 0.0f) {
            return 0.0;
        }
        String art = null;
        if (WorkflowController.getInstance().getMarkenLayout().getProdukt().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (awNummer.equals(this.mAufwaende.getMechanischeArbeit().getId())) {
                art = "mech";
            } else if (awNummer.equals(this.mAufwaende.getElektrischeArbeit().getId())) {
                art = "elektr";
            } else if (awNummer.equals(this.mAufwaende.getProgrammierArbeit().getId())) {
                art = "progr";
            } else if (awNummer.equals(this.mAufwaende.getLackierArbeit().getId())) {
                art = "lack";
            } else if (awNummer.equals(this.mAufwaende.getSonstigeArbeit().getId())) {
                art = "sonst";
            }
        } else {
            art = "arbauf";
        }
        return this.mTechnikProdukt.getPreise().getPreisZuAw(art, aw, bNetto);
    }

    public void updateArbeitsMenge(String awNummer, float aw) {
        if (awNummer.equals(this.mAufwaende.getMechanischeArbeit().getId())) {
            this.mGesamtMechanischeArbeit = aw;
        } else if (awNummer.equals(this.mAufwaende.getElektrischeArbeit().getId())) {
            this.mGesamtElektronikArbeit = aw;
        } else if (awNummer.equals(this.mAufwaende.getProgrammierArbeit().getId())) {
            this.mGesamtProgrammierArbeit = aw;
        } else if (awNummer.equals(this.mAufwaende.getLackierArbeit().getId())) {
            this.mGesamtLakierArbeit = aw;
        } else if (awNummer.equals(this.mAufwaende.getSonstigeArbeit().getId())) {
            this.mGesamtSonstigeArbeit = aw;
        } else {
            this.mGesamtArbeitsAufwand = aw;
        }
    }

    public ArrayList<RefaArbeit> getGesamtRefaArbeit() {
        return this.mGesamtRefaArbeit;
    }

    public void setGesamtRefaArbeit(ArrayList<RefaArbeit> mGesamtRefaArbeit) {
        this.mGesamtRefaArbeit = mGesamtRefaArbeit;
    }
}

