/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.EinbauCalculator;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.ImageUtils;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import rasterviewer.imageloaders.ImageLoader;
import webetk.WebetkUtils;
import webetk.app.bteinfo.Info;
import webetk.app.zub.common.Preise;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.technisch.RefaArbeit;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.communication.LoginInfo;
import webetk.resources.Resource;

public class TechnikModel {
    private static final String FEHLER_LADEN_TECHNISCHE_SICHT = Resource.getInstance().getFehlerLadenTechnischeSicht();
    static Logger log = Logger.getLogger(TechnikModel.class);
    private boolean mAbPreiseMitSteuer = true;
    private TechnischesProdukt mTechnikProdukt;
    private EinbauCalculator mEinbauCalculator;
    private ArrayList<ImageIcon> mImageIcons = null;
    private AufwandsKonfiguration mAufwaende;
    private ArrayList<Arbeit> mArbeitKernprodukt;
    private ArrayList<Arbeit> mArbeitZusatzprodukt;
    private ArrayList<Arbeit> mArbeitHilf;
    private boolean mPreisevorhanden;
    private int mAnzahlTeile;
    private int mAnzahlArbeit;
    private double mKostenTeile;
    private Image maBildAsImage = null;
    ArrayList<Info> mKommentare;

    public TechnikModel() {
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        int marktId = loginInfo.getSettings().getMarktId();
        try {
            this.mAbPreiseMitSteuer = AdminDataLoader.ladeMwstAnzeigen(marktId);
        }
        catch (Exception ex) {
            log.error((Object)"ladeMwstAnzeigen", (Throwable)ex);
        }
    }

    public void setTechnikProdukt(TechnischesProdukt produkt) {
        this.mTechnikProdukt = produkt;
        this.mImageIcons = new ArrayList();
        this.mPreisevorhanden = false;
        this.mAnzahlArbeit = 0;
        this.berechnePreiseUndGesamtMenge();
        this.mEinbauCalculator = new EinbauCalculator(this.mTechnikProdukt, this.mAufwaende);
        this.mArbeitKernprodukt = this.getArbeiten(this.mEinbauCalculator.getEinbauInfoKernprodukt(), "HP_OBLIGAT");
        this.mArbeitZusatzprodukt = this.getArbeiten(this.mEinbauCalculator.getEinbauInfoZusatzprodukt(), "OPTIONAL");
        this.mArbeitHilf = this.getArbeiten(this.mEinbauCalculator.getEinbauInfoHilf(), "HILFSSTOFFE");
    }

    public void berechnePreiseUndGesamtMenge() {
        int menge;
        double einzelpreis;
        Double oEinzelpreis;
        String teilenummer;
        this.mKostenTeile = 0.0;
        this.mAnzahlTeile = 0;
        Preise preise = GlobalObjects.getInstance().getIpacData().getPreise();
        if (preise == null) {
            return;
        }
        for (TechnischerBnb tbnb : (ArrayList)this.mTechnikProdukt.getKernProduktBnbs()) {
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                teilenummer = bauteil.getTeilenummer().replace(" ", "");
                oEinzelpreis = preise.getPreisZuSachnummer(teilenummer);
                einzelpreis = 0.0;
                if (oEinzelpreis != null) {
                    einzelpreis = oEinzelpreis;
                }
                menge = bauteil.getMenge();
                this.mKostenTeile += einzelpreis * (double)menge;
                this.mKostenTeile = Math.floor(this.mKostenTeile * 100.0 + 0.5) / 100.0;
                bauteil.setEinzelPreis(einzelpreis);
                if (bauteil.getEinzelPreis() != 0.0) {
                    this.mPreisevorhanden = true;
                }
                this.mAnzahlTeile += bauteil.getMenge();
                bauteil.setBestand((int)preise.getLagerbestandZuSachnummer(teilenummer));
            }
        }
        for (TechnischerBnb tbnb : (ArrayList)this.mTechnikProdukt.getZusatzProduktBnbs()) {
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                teilenummer = bauteil.getTeilenummer().replace(" ", "");
                oEinzelpreis = preise.getPreisZuSachnummer(teilenummer);
                einzelpreis = 0.0;
                if (oEinzelpreis != null) {
                    einzelpreis = oEinzelpreis;
                }
                menge = bauteil.getMenge();
                this.mKostenTeile += einzelpreis * (double)menge;
                this.mKostenTeile = Math.floor(this.mKostenTeile * 100.0 + 0.5) / 100.0;
                bauteil.setEinzelPreis(einzelpreis);
                this.mAnzahlTeile += bauteil.getMenge();
                bauteil.setBestand((int)preise.getLagerbestandZuSachnummer(teilenummer));
            }
        }
        for (TechnischerBnb tbnb : (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs()) {
            for (Bauteil bauteil : (ArrayList)tbnb.getBauteile()) {
                if (!bauteil.isAktiv()) continue;
                teilenummer = bauteil.getTeilenummer().replace(" ", "");
                oEinzelpreis = preise.getPreisZuSachnummer(teilenummer);
                einzelpreis = 0.0;
                if (oEinzelpreis != null) {
                    einzelpreis = oEinzelpreis;
                }
                menge = bauteil.getMenge();
                double gesamtpreis = Math.floor(einzelpreis * (double)menge * 100.0 + 0.5) / 100.0;
                if (!bauteil.isBTEBauteil() && this.mAbPreiseMitSteuer) {
                    gesamtpreis += gesamtpreis * (double)bauteil.getMwStSatz() / 100.0;
                    gesamtpreis = Math.floor(gesamtpreis * 100.0 + 0.5) / 100.0;
                }
                this.mKostenTeile += gesamtpreis;
                bauteil.setEinzelPreis(einzelpreis);
                this.mAnzahlTeile += bauteil.getMenge();
                bauteil.setBestand((int)preise.getLagerbestandZuSachnummer(teilenummer));
            }
        }
    }

    private ArrayList<Arbeit> getArbeiten(EinbauInfo einbau, String elementart) {
        double gesamtpreisBrutto;
        double einzelpreisBrutto;
        double gesamtpreisNetto;
        double einzelpreisNetto;
        int aw;
        ArrayList<Arbeit> arbeiten = new ArrayList<Arbeit>();
        if (Math.round(einbau.getMechanischerAufwand()) != 0) {
            aw = (int)Math.round(this.mEinbauCalculator.berechneMinInAw("mech", einbau.getMechanischerAufwand()));
            einzelpreisNetto = this.mEinbauCalculator.berechnePreisVonAwArt("mech", 1, true);
            gesamtpreisNetto = (double)aw * einzelpreisNetto;
            einzelpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("mech", 1, false);
            gesamtpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("mech", aw, false);
            arbeiten.add(new Arbeit(this.mAufwaende.getMechanischeArbeit().getId(), this.getMechanischeBezeichnung(), elementart, aw, "", einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false));
            this.mAnzahlArbeit += aw;
        }
        if (Math.round(einbau.getElektrischerAufwand()) != 0) {
            aw = (int)Math.round(this.mEinbauCalculator.berechneMinInAw("elektr", einbau.getElektrischerAufwand()));
            einzelpreisNetto = this.mEinbauCalculator.berechnePreisVonAwArt("elektr", 1, true);
            gesamtpreisNetto = (double)aw * einzelpreisNetto;
            einzelpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("elektr", 1, false);
            gesamtpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("elektr", aw, false);
            arbeiten.add(new Arbeit(this.mAufwaende.getElektrischeArbeit().getId(), this.getElektrischeBezeichnung(), elementart, aw, "", einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false));
            this.mAnzahlArbeit += aw;
        }
        if (Math.round(einbau.getProgrammierAufwand()) != 0) {
            aw = (int)Math.round(this.mEinbauCalculator.berechneMinInAw("progr", einbau.getProgrammierAufwand()));
            einzelpreisNetto = this.mEinbauCalculator.berechnePreisVonAwArt("progr", 1, true);
            gesamtpreisNetto = (double)aw * einzelpreisNetto;
            einzelpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("progr", 1, false);
            gesamtpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("progr", aw, false);
            arbeiten.add(new Arbeit(this.mAufwaende.getProgrammierArbeit().getId(), this.getProgrammierBezeichnung(), elementart, aw, "", einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false));
            this.mAnzahlArbeit += aw;
        }
        if (Math.round(einbau.getLackierAufwand()) != 0) {
            aw = (int)Math.round(this.mEinbauCalculator.berechneMinInAw("lack", einbau.getLackierAufwand()));
            einzelpreisNetto = this.mEinbauCalculator.berechnePreisVonAwArt("lack", 1, true);
            gesamtpreisNetto = (double)aw * einzelpreisNetto;
            einzelpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("lack", 1, false);
            gesamtpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("lack", aw, false);
            arbeiten.add(new Arbeit(this.mAufwaende.getLackierArbeit().getId(), this.getLackierBezeichnung(), elementart, aw, "", einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false));
            this.mAnzahlArbeit += aw;
        }
        if (Math.round(einbau.getSonstigerAufwand()) != 0) {
            aw = (int)Math.round(this.mEinbauCalculator.berechneMinInAw("sonst", einbau.getSonstigerAufwand()));
            einzelpreisNetto = this.mEinbauCalculator.berechnePreisVonAwArt("sonst", 1, true);
            gesamtpreisNetto = (double)aw * einzelpreisNetto;
            einzelpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("sonst", 1, false);
            gesamtpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("sonst", aw, false);
            arbeiten.add(new Arbeit(this.mAufwaende.getSonstigeArbeit().getId(), this.getSonstigeBezeichnung(), elementart, aw, "", einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false));
            this.mAnzahlArbeit += aw;
        }
        if (Math.round(einbau.getArbeitsAufwand()) != 0) {
            aw = (int)Math.round(this.mEinbauCalculator.berechneMinInAw("arbauf", einbau.getArbeitsAufwand()));
            einzelpreisNetto = this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", 1, true);
            gesamtpreisNetto = (double)aw * einzelpreisNetto;
            einzelpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", 1, false);
            gesamtpreisBrutto = this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", aw, false);
            arbeiten.add(new Arbeit(this.mAufwaende.getArbeitAufwand().getId(), this.getArbeitsaufwandBezeichnung(), elementart, aw, "", einzelpreisNetto, gesamtpreisNetto, einzelpreisBrutto, gesamtpreisBrutto, false));
            this.mAnzahlArbeit += aw;
        }
        if (einbau.getRefaArbeitenList() != null && einbau.getRefaArbeitenList().size() > 0) {
            for (int i = 0; i < einbau.getRefaArbeitenList().size(); ++i) {
                RefaArbeit refa = einbau.getRefaArbeitenList().get(i);
                int aw2 = refa.getMenge();
                double einzelpreisNetto2 = this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", 1, true);
                double gesamtpreisNetto2 = (double)aw2 * einzelpreisNetto2;
                double einzelpreisBrutto2 = this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", 1, false);
                double gesamtpreisBrutto2 = this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", aw2, false);
                arbeiten.add(new Arbeit(refa.getAwnummer(), refa.getBenennung(), elementart, aw2, "", einzelpreisNetto2, gesamtpreisNetto2, einzelpreisBrutto2, gesamtpreisBrutto2, true));
                this.mAnzahlArbeit += aw2;
            }
        }
        return arbeiten;
    }

    public String getDialogTitel() {
        return FEHLER_LADEN_TECHNISCHE_SICHT;
    }

    public String getProduktBenennung() {
        return this.mTechnikProdukt.getProduktBenennung();
    }

    public ArrayList<ImageIcon> getImages() {
        if (this.mImageIcons == null) {
            this.mImageIcons = new ArrayList();
            for (int ii = 0; ii < this.mTechnikProdukt.getImages().size(); ++ii) {
                Zubehoergrafik grafik = (Zubehoergrafik)this.mTechnikProdukt.getImages().get(ii);
                ImageIcon icon = ImageUtils.getImageIcon(grafik.getImageData());
                this.mImageIcons.add(icon);
            }
        }
        return this.mImageIcons;
    }

    public Image getImage() {
        if (this.mTechnikProdukt.getImages().size() > 0) {
            Zubehoergrafik grafik = (Zubehoergrafik)this.mTechnikProdukt.getImages().get(0);
            System.out.println("TYP : " + grafik.getDateiTyp());
            return ImageUtils.getScaledImage(grafik.getImageData(), 175, 192);
        }
        Image dummy = ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg");
        dummy.getScaledInstance(175, 192, 2);
        return dummy;
    }

    public Image getCurrentGrafikAsImage() {
        if (this.mTechnikProdukt.getImages().size() > 0) {
            byte[] bildByte = ((Zubehoergrafik)this.mTechnikProdukt.getImages().get(0)).getImageData();
            ImageLoader loader = new ImageLoader();
            this.maBildAsImage = ((Zubehoergrafik)this.mTechnikProdukt.getImages().get(0)).getDateiTyp().equalsIgnoreCase("TIF") || ((Zubehoergrafik)this.mTechnikProdukt.getImages().get(0)).getDateiTyp().equalsIgnoreCase("TIFF") ? loader.loadImage(bildByte, 3, 0) : loader.loadImage(bildByte, 2, 0);
            return this.maBildAsImage;
        }
        Image dummy = ImageCache.getInstance().getImage("Icons/no_picture_icon.jpg");
        dummy.getScaledInstance(300, 200, 2);
        return dummy;
    }

    public ArrayList<TechnischerBnb> getKernProduktBnbs() {
        return (ArrayList)this.mTechnikProdukt.getKernProduktBnbs();
    }

    public ArrayList<TechnischerBnb> getZusatzProduktBnbs() {
        return (ArrayList)this.mTechnikProdukt.getZusatzProduktBnbs();
    }

    public ArrayList<TechnischerBnb> getHilfBnbs() {
        return (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs();
    }

    public String getSchwierigkeitsgrad() {
        return this.mEinbauCalculator.getSchwierigkeitsgrad();
    }

    public String getMechanischeArbeit() {
        return Integer.toString(Math.round(this.mEinbauCalculator.getGesamtMechanischeArbeit()));
    }

    public String getMechanischeArbeitAw() {
        return this.mEinbauCalculator.getGesamtMechanischeArbeitAw();
    }

    public String getElektrikArbeit() {
        return Integer.toString(Math.round(this.mEinbauCalculator.getGesamtElektronikArbeit()));
    }

    public String getElektrikArbeitAw() {
        return this.mEinbauCalculator.getGesamtElektronikArbeitAw();
    }

    public String getProgrammierArbeit() {
        return Integer.toString(Math.round(this.mEinbauCalculator.getGesamtProgrammierArbeit()));
    }

    public String getProgrammierArbeitAw() {
        return this.mEinbauCalculator.getGesamtProgrammierArbeitAw();
    }

    public String getLackierArbeit() {
        return Integer.toString(Math.round(this.mEinbauCalculator.getGesamtLakierArbeit()));
    }

    public String getLackierArbeitAw() {
        return this.mEinbauCalculator.getGesamtLakierArbeitAw();
    }

    public String getSonstigeArbeit() {
        return Integer.toString(Math.round(this.mEinbauCalculator.getGesamtSonstigeArbeit()));
    }

    public String getSonstigeArbeitAw() {
        return this.mEinbauCalculator.getGesamtSonstigeArbeitAw();
    }

    public String getArbeitsAufwand() {
        return Integer.toString(Math.round(this.mEinbauCalculator.getGesamtenArbeitsAufwand()));
    }

    public ArrayList<RefaArbeit> getRefaArbeiten() {
        return this.mEinbauCalculator.getGesamtRefaArbeit();
    }

    public String getArbeitsAufwandAw() {
        return this.mEinbauCalculator.getGesamtArbeitsAufwandInAw();
    }

    public String getGesamteArbeit() {
        float speicher = this.mEinbauCalculator.getGesamtMechanischeArbeit() + this.mEinbauCalculator.getGesamtElektronikArbeit() + this.mEinbauCalculator.getGesamtProgrammierArbeit() + this.mEinbauCalculator.getGesamtSonstigeArbeit() + this.mEinbauCalculator.getGesamtLakierArbeit() + this.mEinbauCalculator.getGesamtenArbeitsAufwand() + this.mEinbauCalculator.getGesamtRefaArbeitenInMin();
        return Integer.toString(Math.round(speicher));
    }

    public String getGesamteArbeitAw() {
        return this.mEinbauCalculator.getGesamteArbeitAw();
    }

    public String getKostenTeile() {
        return WebetkUtils.getPriceString(this.getKostenTeileDouble());
    }

    public double getKostenTeileDouble() {
        double kosten = Math.floor(this.mKostenTeile * 100.0 + 0.5) / 100.0;
        return kosten;
    }

    public String getKostenArbeit() {
        return WebetkUtils.getPriceString(this.getKostenArbeitDouble());
    }

    public double getKostenArbeitDouble() {
        double kostenArbeiten = 0.0;
        kostenArbeiten = this.mEinbauCalculator.berechnePreisVonAwArt("mech", Integer.parseInt(this.mEinbauCalculator.getGesamtMechanischeArbeitAw()), false);
        kostenArbeiten += this.mEinbauCalculator.berechnePreisVonAwArt("elektr", Integer.parseInt(this.mEinbauCalculator.getGesamtElektronikArbeitAw()), false);
        kostenArbeiten += this.mEinbauCalculator.berechnePreisVonAwArt("progr", Integer.parseInt(this.mEinbauCalculator.getGesamtProgrammierArbeitAw()), false);
        kostenArbeiten += this.mEinbauCalculator.berechnePreisVonAwArt("lack", Integer.parseInt(this.mEinbauCalculator.getGesamtLakierArbeitAw()), false);
        kostenArbeiten += this.mEinbauCalculator.berechnePreisVonAwArt("sonst", Integer.parseInt(this.mEinbauCalculator.getGesamtSonstigeArbeitAw()), false);
        kostenArbeiten += this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", Integer.parseInt(this.mEinbauCalculator.getGesamtArbeitsAufwandInAw()), false);
        return kostenArbeiten += this.mEinbauCalculator.berechnePreisVonAwArt("arbauf", Integer.parseInt(this.mEinbauCalculator.getGesamtRefaArbeitenInAwToString()), false);
    }

    public String getGesamtkosten() {
        double kosten = this.getKostenTeileDouble() + this.getKostenArbeitDouble();
        kosten = Math.floor(kosten * 100.0 + 0.5) / 100.0;
        return WebetkUtils.getPriceString(kosten);
    }

    public ArrayList<Arbeit> getArbeitKernprodukt() {
        return this.mArbeitKernprodukt;
    }

    public ArrayList<Arbeit> getArbeitZusatzprodukt() {
        return this.mArbeitZusatzprodukt;
    }

    public ArrayList<Arbeit> getArbeitHilf() {
        return this.mArbeitHilf;
    }

    public boolean isPreisevorhanden() {
        return this.mPreisevorhanden;
    }

    public int getAnzahlTeile() {
        return this.mAnzahlTeile;
    }

    public int getAnzahlArbeit() {
        return this.mAnzahlArbeit;
    }

    public TechnischesProdukt getTechnikProdukt() {
        return this.mTechnikProdukt;
    }

    public void arbeitHinzuf\u00fcgen(Arbeit arbeit) {
        boolean flagArbeitHinzugef\u00fcgt = false;
        this.mAnzahlArbeit += arbeit.getMenge();
        float minuten = this.mEinbauCalculator.berechneAwInMin(arbeit.getAwnummer(), arbeit.getMenge());
        if (this.mTechnikProdukt.getHilfsStoffeBnbs() != null) {
            ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs();
            for (TechnischerBnb tbnb : technischeBnb) {
                if (!tbnb.isHinzugefuegt()) continue;
                if (tbnb.getEinbauInfo() == null) {
                    tbnb.setEinbauInfo(new ArrayList<EinbauInfo>());
                }
                ArrayList einbauList = (ArrayList)tbnb.getEinbauInfo();
                EinbauInfo einbauInfo = new EinbauInfo();
                einbauList.add(einbauInfo);
                if (this.mAufwaende.getMechanischeArbeit() != null) {
                    if (arbeit.getBenennung().equals(this.mAufwaende.getMechanischeArbeit().getBezeichnung())) {
                        einbauInfo.setMechanischerAufwand(einbauInfo.getMechanischerAufwand() + minuten);
                    } else if (arbeit.getBenennung().equals(this.mAufwaende.getElektrischeArbeit().getBezeichnung())) {
                        einbauInfo.setElektrischerAufwand(einbauInfo.getElektrischerAufwand() + minuten);
                    } else if (arbeit.getBenennung().equals(this.mAufwaende.getProgrammierArbeit().getBezeichnung())) {
                        einbauInfo.setProgrammierAufwand(einbauInfo.getProgrammierAufwand() + minuten);
                    } else if (arbeit.getBenennung().equals(this.mAufwaende.getLackierArbeit().getBezeichnung())) {
                        einbauInfo.setLackierAufwand(einbauInfo.getLackierAufwand() + minuten);
                    } else if (arbeit.getBenennung().equals(this.mAufwaende.getSonstigeArbeit().getBezeichnung())) {
                        einbauInfo.setSonstigerAufwand(einbauInfo.getSonstigerAufwand() + minuten);
                    } else {
                        einbauInfo.setArbeitsAufwand(einbauInfo.getArbeitsAufwand() + minuten);
                    }
                } else {
                    einbauInfo.setArbeitsAufwand(einbauInfo.getArbeitsAufwand() + minuten);
                }
                this.mEinbauCalculator.calculate();
                return;
            }
        }
        if (!flagArbeitHinzugef\u00fcgt) {
            TechnischerBnb newBnb = new TechnischerBnb();
            newBnb.setHinzugefuegt(true);
            EinbauInfo newEinbauInfo = new EinbauInfo();
            newEinbauInfo.setKomplexitaet("");
            if (this.mAufwaende.getMechanischeArbeit() != null) {
                if (arbeit.getBenennung().equals(this.mAufwaende.getMechanischeArbeit().getBezeichnung())) {
                    newEinbauInfo.setMechanischerAufwand(minuten);
                } else if (arbeit.getBenennung().equals(this.mAufwaende.getElektrischeArbeit().getBezeichnung())) {
                    newEinbauInfo.setElektrischerAufwand(minuten);
                } else if (arbeit.getBenennung().equals(this.mAufwaende.getProgrammierArbeit().getBezeichnung())) {
                    newEinbauInfo.setProgrammierAufwand(minuten);
                } else if (arbeit.getBenennung().equals(this.mAufwaende.getLackierArbeit().getBezeichnung())) {
                    newEinbauInfo.setLackierAufwand(minuten);
                } else if (arbeit.getBenennung().equals(this.mAufwaende.getSonstigeArbeit().getBezeichnung())) {
                    newEinbauInfo.setSonstigerAufwand(minuten);
                } else {
                    newEinbauInfo.setArbeitsAufwand(minuten);
                }
            } else {
                newEinbauInfo.setArbeitsAufwand(minuten);
            }
            ArrayList<EinbauInfo> newEinbauInfoList = new ArrayList<EinbauInfo>();
            newEinbauInfoList.add(newEinbauInfo);
            newBnb.setEinbauInfo(newEinbauInfoList);
            newBnb.setBauteile(new ArrayList<Bauteil>());
            this.mTechnikProdukt.getHilfsStoffeBnbs().add(newBnb);
        }
        this.mEinbauCalculator.calculate();
    }

    public void teilHinzuf\u00fcgen(Bauteil bauteil) {
        boolean addBnb = false;
        this.mAnzahlTeile += bauteil.getMenge();
        double gesamtpreis = bauteil.getGesamtPreis();
        if (!bauteil.isBTEBauteil() && this.mAbPreiseMitSteuer) {
            gesamtpreis += gesamtpreis * (double)bauteil.getMwStSatz() / 100.0;
            gesamtpreis = Math.floor(gesamtpreis * 100.0 + 0.5) / 100.0;
        }
        this.mKostenTeile += gesamtpreis;
        if (this.mTechnikProdukt.getHilfsStoffeBnbs() != null) {
            ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs();
            for (TechnischerBnb tbnb : technischeBnb) {
                if (tbnb.isHinzugefuegt()) {
                    addBnb = true;
                }
                if (!addBnb) continue;
                if (tbnb.getBauteile() == null) {
                    tbnb.setBauteile(new ArrayList<Bauteil>());
                }
                tbnb.getBauteile().add(bauteil);
                return;
            }
        }
        if (!addBnb) {
            TechnischerBnb bnb = new TechnischerBnb();
            bnb.setBauteile(new ArrayList<Bauteil>());
            bnb.getBauteile().add(bauteil);
            bnb.setHinzugefuegt(true);
            this.mTechnikProdukt.getHilfsStoffeBnbs().add(bnb);
        }
    }

    public void removeArbeit(Arbeit arbeit) {
        this.mAnzahlArbeit -= arbeit.getMenge();
        float aw = Integer.valueOf(arbeit.getMenge()).floatValue();
        String awNummer = arbeit.getAwnummer();
        Preise preise = GlobalObjects.getInstance().getIpacData().getPreise();
        float minuten = preise.getMinutenZuAW(awNummer, aw);
        if (this.mTechnikProdukt.getHilfsStoffeBnbs() != null) {
            ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs();
            boolean set = false;
            for (TechnischerBnb tbnb : technischeBnb) {
                if (!tbnb.isHinzugefuegt()) continue;
                ArrayList einbauList = (ArrayList)tbnb.getEinbauInfo();
                for (int ii = 0; ii < einbauList.size(); ++ii) {
                    if (set) continue;
                    if (this.mAufwaende.getMechanischeArbeit() != null) {
                        if (arbeit.getBenennung().equals(this.mAufwaende.getMechanischeArbeit().getBezeichnung())) {
                            if (((EinbauInfo)einbauList.get(ii)).getMechanischerAufwand() != minuten) continue;
                            einbauList.remove(ii);
                            set = true;
                            continue;
                        }
                        if (arbeit.getBenennung().equals(this.mAufwaende.getElektrischeArbeit().getBezeichnung())) {
                            if (((EinbauInfo)einbauList.get(ii)).getElektrischerAufwand() != minuten) continue;
                            einbauList.remove(ii);
                            set = true;
                            continue;
                        }
                        if (arbeit.getBenennung().equals(this.mAufwaende.getProgrammierArbeit().getBezeichnung())) {
                            if (((EinbauInfo)einbauList.get(ii)).getProgrammierAufwand() != minuten) continue;
                            einbauList.remove(ii);
                            set = true;
                            continue;
                        }
                        if (arbeit.getBenennung().equals(this.mAufwaende.getLackierArbeit().getBezeichnung())) {
                            if (((EinbauInfo)einbauList.get(ii)).getLackierAufwand() != minuten) continue;
                            einbauList.remove(ii);
                            set = true;
                            continue;
                        }
                        if (arbeit.getBenennung().equals(this.mAufwaende.getSonstigeArbeit().getBezeichnung())) {
                            if (((EinbauInfo)einbauList.get(ii)).getSonstigerAufwand() != minuten) continue;
                            einbauList.remove(ii);
                            set = true;
                            continue;
                        }
                        if (!arbeit.getBenennung().equals(this.mAufwaende.getArbeitAufwand().getBezeichnung()) || ((EinbauInfo)einbauList.get(ii)).getArbeitsAufwand() != minuten) continue;
                        einbauList.remove(ii);
                        set = true;
                        continue;
                    }
                    if (!arbeit.getBenennung().equals(this.mAufwaende.getArbeitAufwand().getBezeichnung()) || ((EinbauInfo)einbauList.get(ii)).getArbeitsAufwand() != minuten) continue;
                    einbauList.remove(ii);
                    set = true;
                }
            }
        }
        this.mEinbauCalculator.calculate();
    }

    public void removeTeil(Bauteil bauteil) {
        if (this.mTechnikProdukt.getHilfsStoffeBnbs() != null) {
            ArrayList technischeBnb = (ArrayList)this.mTechnikProdukt.getHilfsStoffeBnbs();
            for (TechnischerBnb tbnb : technischeBnb) {
                Iterator<Bauteil> it = tbnb.getBauteile().iterator();
                while (it.hasNext()) {
                    Bauteil bnbBauteil = it.next();
                    if (!bnbBauteil.getTeilenummer().equals(bauteil.getTeilenummer()) || bnbBauteil.isBTEBauteil() || bnbBauteil.getPosIntern() != bauteil.getPosIntern()) continue;
                    this.mAnzahlTeile -= bauteil.getMenge();
                    double gesamtpreis = bauteil.getGesamtPreis();
                    if (!bauteil.isBTEBauteil() && this.mAbPreiseMitSteuer) {
                        gesamtpreis += gesamtpreis * (double)bauteil.getMwStSatz() / 100.0;
                        gesamtpreis = Math.floor(gesamtpreis * 100.0 + 0.5) / 100.0;
                    }
                    this.mKostenTeile -= gesamtpreis;
                    it.remove();
                    return;
                }
            }
        }
    }

    public void setBauteilAktiv(String teilenummer, boolean flag, int bnbIndex) {
        TechnischerBnb hilfsBetreibsBNBs = (TechnischerBnb)this.mTechnikProdukt.getHilfsStoffeBnbs().get(bnbIndex);
        Bauteil bauteil = null;
        Preise preise = GlobalObjects.getInstance().getIpacData().getPreise();
        for (int ii = 0; ii < hilfsBetreibsBNBs.getBauteile().size(); ++ii) {
            bauteil = hilfsBetreibsBNBs.getBauteile().get(ii);
            if (!bauteil.getTeilenummer().equals(teilenummer)) continue;
            bauteil.setAktiv(flag);
            teilenummer = bauteil.getTeilenummer().replace(" ", "");
            Double oEinzelpreis = preise.getPreisZuSachnummer(teilenummer);
            double einzelpreis = 0.0;
            if (oEinzelpreis != null) {
                einzelpreis = oEinzelpreis;
            }
            int menge = bauteil.getMenge();
            if (flag) {
                this.mAnzahlTeile += bauteil.getMenge();
                this.mKostenTeile += einzelpreis * (double)menge;
                this.mKostenTeile = Math.floor(this.mKostenTeile * 100.0 + 0.5) / 100.0;
            } else {
                this.mAnzahlTeile -= bauteil.getMenge();
                this.mKostenTeile -= einzelpreis * (double)menge;
                this.mKostenTeile = Math.floor(this.mKostenTeile * 100.0 + 0.5) / 100.0;
            }
            return;
        }
        this.mEinbauCalculator.calculate();
    }

    public void changeMengeArbeit(String bereich, String art, String awNr, int awNeu, int awAlt) {
        float mengeNeu = this.mEinbauCalculator.berechneAwInMin(awNr, Integer.valueOf(awNeu).floatValue());
        float mengeAlt = this.mEinbauCalculator.berechneAwInMin(awNr, Integer.valueOf(awAlt).floatValue());
        boolean set = false;
        if (bereich.equals("KERNPRODUKT")) {
            int jj;
            int ii;
            if (this.mTechnikProdukt.getEinbauInfoProdukt() != null) {
                for (ii = 0; ii < this.mTechnikProdukt.getEinbauInfoProdukt().size(); ++ii) {
                    set = this.setEinbauInfo(art, mengeNeu, mengeAlt, (EinbauInfo)this.mTechnikProdukt.getEinbauInfoProdukt().get(ii));
                    if (!set) continue;
                    this.mEinbauCalculator.calculate();
                    return;
                }
            }
            if (!set) {
                for (ii = 0; ii < this.mTechnikProdukt.getKernProduktBnbs().size(); ++ii) {
                    if (((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(ii)).getEinbauInfo() == null) continue;
                    for (jj = 0; jj < ((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(ii)).getEinbauInfo().size(); ++jj) {
                        set = this.setEinbauInfo(art, mengeNeu, mengeAlt, ((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(jj)).getEinbauInfo().get(jj));
                        if (!set) continue;
                        this.mEinbauCalculator.calculate();
                        return;
                    }
                }
            }
            if (!set) {
                for (ii = 0; ii < this.mTechnikProdukt.getKernProduktBnbs().size(); ++ii) {
                    if (((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(ii)).getBauteile() == null) continue;
                    for (jj = 0; jj < ((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(ii)).getBauteile().size(); ++jj) {
                        set = this.setEinbauInfo(art, mengeNeu, mengeAlt, ((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(ii)).getBauteile().get(jj).getEinbauInfo());
                        if (!set) continue;
                        this.mEinbauCalculator.calculate();
                        return;
                    }
                }
            }
            if (!set) {
                if (this.mTechnikProdukt.getEinbauInfoProdukt() != null && (EinbauInfo)this.mTechnikProdukt.getEinbauInfoProdukt().get(0) != null) {
                    EinbauInfo einbauDummy = (EinbauInfo)this.mTechnikProdukt.getEinbauInfoProdukt().get(0);
                    set = this.setEinbauInfo(art, mengeAlt - mengeNeu, einbauDummy);
                } else {
                    EinbauInfo einbauDummy = new EinbauInfo();
                    einbauDummy.setKomplexitaet("");
                    set = this.setEinbauInfo(art, mengeAlt - mengeNeu, einbauDummy);
                    ArrayList<EinbauInfo> einbauList = new ArrayList<EinbauInfo>();
                    einbauList.add(einbauDummy);
                    this.mTechnikProdukt.setEinbauInfoProdukt(einbauList);
                }
                this.mEinbauCalculator.calculate();
                return;
            }
        } else if (bereich.equals("ZUSATZPRODUKT") || bereich.equals("OPTIONAL")) {
            int jj;
            int ii;
            for (ii = 0; ii < this.mTechnikProdukt.getZusatzProduktBnbs().size(); ++ii) {
                if (this.mTechnikProdukt.getZusatzProduktBnbs().get(ii).getEinbauInfo() == null) continue;
                for (jj = 0; jj < this.mTechnikProdukt.getZusatzProduktBnbs().get(ii).getEinbauInfo().size(); ++jj) {
                    set = this.setEinbauInfo(art, mengeNeu, mengeAlt, this.mTechnikProdukt.getZusatzProduktBnbs().get(jj).getEinbauInfo().get(jj));
                    if (!set) continue;
                    this.mEinbauCalculator.calculate();
                    return;
                }
            }
            if (!set) {
                for (ii = 0; ii < this.mTechnikProdukt.getZusatzProduktBnbs().size(); ++ii) {
                    if (this.mTechnikProdukt.getZusatzProduktBnbs().get(ii).getBauteile().size() == 0) continue;
                    for (jj = 0; jj < this.mTechnikProdukt.getZusatzProduktBnbs().get(ii).getBauteile().size(); ++jj) {
                        set = this.setEinbauInfo(art, mengeNeu, mengeAlt, this.mTechnikProdukt.getZusatzProduktBnbs().get(ii).getBauteile().get(jj).getEinbauInfo());
                        if (!set) continue;
                        this.mEinbauCalculator.calculate();
                        return;
                    }
                }
            }
            if (!set) {
                EinbauInfo einbauDummy;
                if (this.mTechnikProdukt.getZusatzProduktBnbs().get(0).getEinbauInfo().get(0) != null) {
                    einbauDummy = this.mTechnikProdukt.getZusatzProduktBnbs().get(0).getEinbauInfo().get(0);
                } else {
                    einbauDummy = new EinbauInfo();
                    einbauDummy.setKomplexitaet("");
                }
                set = this.setEinbauInfo(art, mengeAlt - mengeNeu, einbauDummy);
                this.mEinbauCalculator.calculate();
                return;
            }
        } else if (bereich.equals("HILFS") && !set) {
            for (int ii = 0; ii < this.mTechnikProdukt.getHilfsStoffeBnbs().size(); ++ii) {
                if (((TechnischerBnb)this.mTechnikProdukt.getHilfsStoffeBnbs().get(ii)).getBauteile().size() != 0) continue;
                ArrayList einbauList = (ArrayList)((TechnischerBnb)this.mTechnikProdukt.getHilfsStoffeBnbs().get(ii)).getEinbauInfo();
                for (int jj = 0; jj < einbauList.size(); ++jj) {
                    set = this.setEinbauInfo(art, mengeNeu, mengeAlt, (EinbauInfo)einbauList.get(jj));
                    if (!set) continue;
                    this.mEinbauCalculator.calculate();
                    return;
                }
            }
        }
    }

    private boolean setEinbauInfo(String art, float mengeNeu, float mengeAlt, EinbauInfo einbauInfo) {
        if (einbauInfo != null) {
            if (this.mAufwaende.getMechanischeArbeit() != null) {
                if (art.equals(this.mAufwaende.getMechanischeArbeit().getBezeichnung())) {
                    if (Math.round(this.mEinbauCalculator.berechneMinInAw("mech", einbauInfo.getMechanischerAufwand()) * this.mAufwaende.getMechanischeArbeit().getAwMin()) == (long)Math.round(mengeAlt)) {
                        einbauInfo.setMechanischerAufwand(mengeNeu);
                        return true;
                    }
                } else if (art.equals(this.mAufwaende.getElektrischeArbeit().getBezeichnung())) {
                    if (Math.round(this.mEinbauCalculator.berechneMinInAw("elektr", einbauInfo.getElektrischerAufwand()) * this.mAufwaende.getElektrischeArbeit().getAwMin()) == (long)Math.round(mengeAlt)) {
                        einbauInfo.setElektrischerAufwand(mengeNeu);
                        return true;
                    }
                } else if (art.equals(this.mAufwaende.getProgrammierArbeit().getBezeichnung())) {
                    if (Math.round(this.mEinbauCalculator.berechneMinInAw("progr", einbauInfo.getProgrammierAufwand()) * this.mAufwaende.getProgrammierArbeit().getAwMin()) == (long)Math.round(mengeAlt)) {
                        einbauInfo.setProgrammierAufwand(mengeNeu);
                        return true;
                    }
                } else if (art.equals(this.mAufwaende.getLackierArbeit().getBezeichnung())) {
                    if (Math.round(this.mEinbauCalculator.berechneMinInAw("lack", einbauInfo.getLackierAufwand()) * this.mAufwaende.getLackierArbeit().getAwMin()) == (long)Math.round(mengeAlt)) {
                        einbauInfo.setLackierAufwand(mengeNeu);
                        return true;
                    }
                } else if (art.equals(this.mAufwaende.getSonstigeArbeit().getBezeichnung())) {
                    if (Math.round(this.mEinbauCalculator.berechneMinInAw("sonst", einbauInfo.getSonstigerAufwand()) * this.mAufwaende.getSonstigeArbeit().getAwMin()) == (long)Math.round(mengeAlt)) {
                        einbauInfo.setSonstigerAufwand(mengeNeu);
                        return true;
                    }
                } else if (Math.round(this.mEinbauCalculator.berechneMinInAw("arbauf", einbauInfo.getArbeitsAufwand()) * this.mAufwaende.getArbeitAufwand().getAwMin()) == (long)Math.round(mengeAlt)) {
                    einbauInfo.setArbeitsAufwand(mengeNeu);
                    return true;
                }
            } else if (art.equals(this.mAufwaende.getArbeitAufwand().getBezeichnung()) && Math.round(this.mEinbauCalculator.berechneMinInAw("arbauf", einbauInfo.getArbeitsAufwand()) * this.mAufwaende.getArbeitAufwand().getAwMin()) == (long)Math.round(mengeAlt)) {
                einbauInfo.setArbeitsAufwand(mengeNeu);
                return true;
            }
        }
        return false;
    }

    private boolean setEinbauInfo(String art, float mengeDif, EinbauInfo einbauInfo) {
        if (this.mAufwaende.getMechanischeArbeit() != null) {
            if (art.equals(this.mAufwaende.getMechanischeArbeit().getBezeichnung())) {
                einbauInfo.setMechanischerAufwand(einbauInfo.getMechanischerAufwand() - mengeDif);
                return true;
            }
            if (art.equals(this.mAufwaende.getElektrischeArbeit().getBezeichnung())) {
                einbauInfo.setElektrischerAufwand(einbauInfo.getElektrischerAufwand() - mengeDif);
                return true;
            }
            if (art.equals(this.mAufwaende.getProgrammierArbeit().getBezeichnung())) {
                einbauInfo.setProgrammierAufwand(einbauInfo.getProgrammierAufwand() - mengeDif);
                return true;
            }
            if (art.equals(this.mAufwaende.getLackierArbeit().getBezeichnung())) {
                einbauInfo.setLackierAufwand(einbauInfo.getLackierAufwand() - mengeDif);
                return true;
            }
            if (art.equals(this.mAufwaende.getSonstigeArbeit().getBezeichnung())) {
                einbauInfo.setSonstigerAufwand(einbauInfo.getSonstigerAufwand() - mengeDif);
                return true;
            }
        }
        return false;
    }

    public double setKostenTeile(double kostenTeile) {
        this.mKostenTeile = kostenTeile;
        return this.mKostenTeile;
    }

    public void setAnzahlArbeit(int anzahlArbeit) {
        this.mAnzahlArbeit = anzahlArbeit;
    }

    public void setAnzahlTeile(int anzahlTeile) {
        this.mAnzahlTeile = anzahlTeile;
    }

    public AufwandsKonfiguration getAufwaende() {
        return this.mAufwaende;
    }

    public void setAufwaende(AufwandsKonfiguration aufwaende) {
        this.mAufwaende = aufwaende;
        this.checkBenennungAufwaende();
    }

    public String getMechanischeBezeichnung() {
        if (this.mAufwaende.getMechanischeArbeit() != null && this.mAufwaende.getMechanischeArbeit().getBezeichnung() != null && !this.mAufwaende.getMechanischeArbeit().getBezeichnung().equals("")) {
            return this.mAufwaende.getMechanischeArbeit().getBezeichnung();
        }
        return ZubCustomizable.getInstance().getBenennungMechanischeArbeit();
    }

    public String getElektrischeBezeichnung() {
        if (this.mAufwaende.getElektrischeArbeit() != null && this.mAufwaende.getElektrischeArbeit().getBezeichnung() != null && !this.mAufwaende.getElektrischeArbeit().getBezeichnung().equals("")) {
            return this.mAufwaende.getElektrischeArbeit().getBezeichnung();
        }
        return ZubCustomizable.getInstance().getBenennungElektrischeArbeit();
    }

    public String getProgrammierBezeichnung() {
        if (this.mAufwaende.getProgrammierArbeit() != null && this.mAufwaende.getProgrammierArbeit().getBezeichnung() != null && !this.mAufwaende.getProgrammierArbeit().getBezeichnung().equals("")) {
            return this.mAufwaende.getProgrammierArbeit().getBezeichnung();
        }
        return ZubCustomizable.getInstance().getBenennungProgrammierArbeit();
    }

    public String getLackierBezeichnung() {
        if (this.mAufwaende.getLackierArbeit() != null && this.mAufwaende.getLackierArbeit().getBezeichnung() != null && !this.mAufwaende.getLackierArbeit().getBezeichnung().equals("")) {
            return this.mAufwaende.getLackierArbeit().getBezeichnung();
        }
        return ZubCustomizable.getInstance().getBenennungLackierArbeit();
    }

    public String getSonstigeBezeichnung() {
        if (this.mAufwaende.getSonstigeArbeit() != null && this.mAufwaende.getSonstigeArbeit().getBezeichnung() != null && !this.mAufwaende.getSonstigeArbeit().getBezeichnung().equals("")) {
            return this.mAufwaende.getSonstigeArbeit().getBezeichnung();
        }
        return ZubCustomizable.getInstance().getBenennungSonstigeArbeit();
    }

    public String getArbeitsaufwandBezeichnung() {
        if (this.mAufwaende.getArbeitAufwand() != null && this.mAufwaende.getArbeitAufwand().getBezeichnung() != null && !this.mAufwaende.getArbeitAufwand().getBezeichnung().equals("")) {
            return this.mAufwaende.getArbeitAufwand().getBezeichnung();
        }
        return ZubCustomizable.getInstance().getBenennungArbeitsaufwand();
    }

    public EinbauCalculator getEinbauCalculator() {
        return this.mEinbauCalculator;
    }

    public String berechneMinInStunden(String arbeit) {
        double stunden = Double.valueOf(arbeit) / 60.0;
        stunden = Math.floor(stunden * 100.0 + 0.5) / 100.0;
        return Double.toString(stunden);
    }

    public ArrayList<Info> getKommentare() {
        int i;
        this.mKommentare = new ArrayList();
        for (i = 0; i < this.mTechnikProdukt.getKernProduktBnbs().size(); ++i) {
            if (((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(i)).getTechnischerKommentar() == null) continue;
            this.mKommentare.add(((TechnischerBnb)this.mTechnikProdukt.getKernProduktBnbs().get(i)).getTechnischerKommentar());
        }
        for (i = 0; i < this.mTechnikProdukt.getZusatzProduktBnbs().size(); ++i) {
            if (this.mTechnikProdukt.getZusatzProduktBnbs().get(i).getTechnischerKommentar() == null) continue;
            this.mKommentare.add(this.mTechnikProdukt.getZusatzProduktBnbs().get(i).getTechnischerKommentar());
        }
        for (i = 0; i < this.mTechnikProdukt.getHilfsStoffeBnbs().size(); ++i) {
            if (((TechnischerBnb)this.mTechnikProdukt.getHilfsStoffeBnbs().get(i)).getTechnischerKommentar() == null) continue;
            this.mKommentare.add(((TechnischerBnb)this.mTechnikProdukt.getHilfsStoffeBnbs().get(i)).getTechnischerKommentar());
        }
        return this.mKommentare;
    }

    public boolean isNPZsVorhanden() {
        ArrayList bauteileKern = (ArrayList)this.getTechnikProdukt().getKernProduktTeile();
        ArrayList bauteileZusatz = (ArrayList)this.getTechnikProdukt().getZusatzProdukte();
        ArrayList bauteileHilf = (ArrayList)this.getTechnikProdukt().getHilfsStoffe();
        if (bauteileKern != null) {
            for (Bauteil teil : bauteileKern) {
                if (teil.getNpzText() == null || teil.getNpzText().equals("")) continue;
                return true;
            }
        }
        if (bauteileZusatz != null) {
            for (Bauteil teil : bauteileZusatz) {
                if (teil.getNpzText() == null || teil.getNpzText().equals("")) continue;
                return true;
            }
        }
        if (bauteileHilf != null) {
            for (Bauteil teil : bauteileHilf) {
                if (teil.getNpzText() == null || teil.getNpzText().equals("")) continue;
                return true;
            }
        }
        return false;
    }

    private void checkBenennungAufwaende() {
        if (this.mAufwaende.getMechanischeArbeit() != null) {
            if (this.mAufwaende.getMechanischeArbeit().getBezeichnung() == null) {
                this.mAufwaende.getMechanischeArbeit().setBezeichnung(ZubCustomizable.getInstance().getBenennungMechanischeArbeit());
            }
            if (this.mAufwaende.getElektrischeArbeit().getBezeichnung() == null) {
                this.mAufwaende.getElektrischeArbeit().setBezeichnung(ZubCustomizable.getInstance().getBenennungElektrischeArbeit());
            }
            if (this.mAufwaende.getProgrammierArbeit().getBezeichnung() == null) {
                this.mAufwaende.getProgrammierArbeit().setBezeichnung(ZubCustomizable.getInstance().getBenennungProgrammierArbeit());
            }
            if (this.mAufwaende.getLackierArbeit().getBezeichnung() == null) {
                this.mAufwaende.getLackierArbeit().setBezeichnung(ZubCustomizable.getInstance().getBenennungLackierArbeit());
            }
            if (this.mAufwaende.getSonstigeArbeit().getBezeichnung() == null) {
                this.mAufwaende.getSonstigeArbeit().setBezeichnung(ZubCustomizable.getInstance().getBenennungSonstigeArbeit());
            }
            if (this.mAufwaende.getArbeitAufwand() != null && this.mAufwaende.getArbeitAufwand().getBezeichnung() == null) {
                this.mAufwaende.getArbeitAufwand().setBezeichnung(ZubCustomizable.getInstance().getBenennungArbeitsaufwand());
            }
        } else if (this.mAufwaende.getArbeitAufwand().getBezeichnung() == null) {
            this.mAufwaende.getArbeitAufwand().setBezeichnung(ZubCustomizable.getInstance().getBenennungArbeitsaufwand());
        }
    }

    public boolean isAbPreiseMitSteuer() {
        return this.mAbPreiseMitSteuer;
    }
}

