/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TabelCellEditorInteger;
import de.esg.zub.common.TableCellRendererInteger;
import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.EinbauInfoPanel;
import de.esg.zub.configurator.content.technisch.HilfsTableCellRenderer;
import de.esg.zub.configurator.content.technisch.HilfsTableCellRendererBoolean;
import de.esg.zub.configurator.content.technisch.HilfsTableCellRendererInteger;
import de.esg.zub.configurator.content.technisch.HilfsTableHeaderRenderer;
import de.esg.zub.configurator.content.technisch.HilfsTableModel;
import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.configurator.content.technisch.TeileTableCellRenderer;
import de.esg.zub.configurator.content.technisch.TeileTableCellRendererString;
import de.esg.zub.configurator.content.technisch.TeileTableHeaderRenderer;
import de.esg.zub.configurator.content.technisch.TeileTableModel;
import de.esg.zub.configurator.content.technisch.ViewerToolbar2;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JComboBox;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import rasterviewer.ImageViewerComponent;
import rasterviewer.hotspot.HotspotManager;
import rasterviewer.hotspot.IHotspotManager;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.zub.technisch.Bauteil;
import webetk.resources.Resource;

public class TechnikPanel
extends Observable {
    private JPanel mTechnikPanel;
    private MarkenLayout mMarkenLayout;
    public static final String SYMBOLKERN = "SYMBOLKERN";
    public static final String SYMBOLOPTIONAL = "SYMBOLOPTIONAL";
    public static final String SYMBOLHILF = "SYMBOLHILF";
    public static final String ANSICHTKERN = "KERN";
    public static final String ANSICHTZUSATZ = "ZUSATZ";
    public static final String ANSICHTHILF = "HILF";
    public static final String TABELLE_KERN = "TABELLE_KERN";
    public static final String TABELLE_ZUSATZ = "TABELLE_ZUSATZ";
    public static final String TABELLE_HILF = "TABELLE_HILF";
    public static final String TEIL_HINZU = "TEIL_HINZUFUEGEN";
    public static final String ARBEIT_HINZU = "ARBEIT_HINZUFUEGEN";
    public static final String IN_TEILELISTE_UEBERNEHMEN = "IN_TEILELISTE_UEBERNEHMEN";
    public static final String RETURN_TO_ISPA = "RETURN_TO_ISPA";
    private Dimension mTableHeaderSize = new Dimension(20, 19);
    private JTable mKernTable = null;
    private JScrollPane mKernScrollPane = null;
    private TeileTableModel mKernTableModel;
    private TeileTableCellRenderer mTableRendererKern = null;
    private JLabel mKernLabel = null;
    private JLabel mSymbolKern;
    private boolean mSymbolKernOpen;
    private JPanel mKernLabelPanel;
    private TabelCellEditorInteger mEditorInt;
    private JScrollPane mZusatzScrollPane = null;
    private JTable mZusatzTable = null;
    private TeileTableModel mZusatzTableModel;
    private TeileTableCellRenderer mTableRendererZusatz = null;
    private JLabel mSymbolZusatz;
    private boolean mSymbolZusatzOpen;
    private JLabel mZusatzLabel = null;
    private JPanel mZusatzLabelPanel;
    private JLabel mHilfLabel = null;
    private JScrollPane mHilfScrollPane = null;
    private JTable mHilfTable = null;
    private HilfsTableModel mHilfTableModel;
    private HilfsTableCellRenderer mTableRendererHilf = null;
    private JLabel mSymbolHilf;
    private boolean mSymbolHilfOpen;
    private JPanel mHilfLabelPanel;
    private JPanel mButtonPanel = null;
    private JLabel mISPALabel = null;
    private JLabel mTeileHinzufuegenLabel = null;
    private JLabel mArbeitHinzufuegenLabel = null;
    private JPanel mUebernehmenInTeileliste = null;
    private JLabel mLabInTeileliste = null;
    private JComboBox mCboTeilelisten = null;
    private JLabel mButUebernehmen = null;
    private GridBagConstraints gbc;
    private EinbauInfoPanel mEinbauInfoPanel = null;
    private int counter = 0;
    private int ipad = 5;
    private int mSpeicher = 12;
    private TechnikModel mModel;
    private boolean isFBAVisible = false;

    public TechnikPanel(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.createComponents();
    }

    public void setModel(TechnikModel model) {
        this.mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mModel = model;
        this.setTechnikPanel();
    }

    public void createComponents() {
        this.mTechnikPanel = new JPanel();
        this.mTechnikPanel.setLayout(new GridBagLayout());
        this.mTechnikPanel.setCursor(null);
        this.mTechnikPanel.setPreferredSize(new Dimension(846, 500));
        this.mTechnikPanel.setMinimumSize(new Dimension(846, 500));
        this.mKernLabelPanel = new JPanel();
        this.mKernLabelPanel.setLayout(new GridBagLayout());
        this.mEditorInt = new TabelCellEditorInteger(this.mMarkenLayout);
        this.mKernLabel = new JLabel();
        this.mKernLabel.setText(Resource.getInstance().getBestehtAus() + ": ");
        this.mKernLabel.setSmallboldFont();
        this.mSymbolKern = new JLabel();
        this.mSymbolKern.setName(SYMBOLKERN);
        this.mSymbolKern.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mSymbolKernOpen = true;
        this.mKernScrollPane = new JScrollPane();
        this.mTableRendererKern = new TeileTableCellRenderer();
        this.mZusatzLabelPanel = new JPanel();
        this.mZusatzLabelPanel.setLayout(new GridBagLayout());
        this.mSymbolZusatz = new JLabel();
        this.mSymbolZusatz.setName(SYMBOLOPTIONAL);
        this.mSymbolZusatz.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mSymbolZusatzOpen = true;
        this.mZusatzLabel = new JLabel();
        this.mZusatzLabel.setSmallboldFont();
        this.mZusatzLabel.setText(Resource.getInstance().getZusatzprodukt() + ": ");
        this.mZusatzScrollPane = new JScrollPane();
        this.mTableRendererZusatz = new TeileTableCellRenderer();
        this.mHilfLabelPanel = new JPanel();
        this.mHilfLabelPanel.setLayout(new GridBagLayout());
        this.mSymbolHilf = new JLabel();
        this.mSymbolHilf.setName(SYMBOLHILF);
        this.mSymbolHilf.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        this.mSymbolHilfOpen = true;
        this.mHilfLabel = new JLabel();
        this.mHilfLabel.setText(Resource.getInstance().getHilfsUndBetriebsstoffeUndWeitereLeistungen() + ": ");
        this.mHilfLabel.setSmallboldFont();
        this.mHilfScrollPane = new JScrollPane();
        this.mTableRendererHilf = new HilfsTableCellRenderer();
        this.mTeileHinzufuegenLabel = new JLabel("> " + Resource.getInstance().getTeilHinzufuegen());
        this.mTeileHinzufuegenLabel.setName(TEIL_HINZU);
        this.mArbeitHinzufuegenLabel = new JLabel("> " + Resource.getInstance().getArbeitHinzufuegen());
        this.mArbeitHinzufuegenLabel.setName(ARBEIT_HINZU);
        this.mUebernehmenInTeileliste = this.getUebernehmenInTeilelistePanel();
        this.mISPALabel = new JLabel("> Transfer");
        this.mISPALabel.setName(RETURN_TO_ISPA);
        this.mEinbauInfoPanel = new EinbauInfoPanel(this.mMarkenLayout);
    }

    public void setTechnikPanel() {
        this.mTechnikPanel.removeAll();
        this.mEinbauInfoPanel.setData(this.mModel, this.mMarkenLayout);
        this.mKernTableModel = null;
        this.mZusatzTableModel = null;
        this.mHilfTableModel = null;
        this.ipad = 0;
        HotspotManager hotspotManager = new HotspotManager();
        ImageViewerComponent imageViewer = new ImageViewerComponent((IHotspotManager)hotspotManager, (JFrame)MainController.getInstance().getMainFrame(), false, true);
        ViewerToolbar2 defaultToolbar = new ViewerToolbar2(imageViewer);
        imageViewer.setToolbar((JToolBar)defaultToolbar);
        hotspotManager.setImageViewer(imageViewer);
        imageViewer.setScrollbarsVisible(false);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        imageViewer.setMaximumSize(new Dimension(175, 212));
        imageViewer.setMinimumSize(new Dimension(175, 212));
        imageViewer.setImagePanelBackgroundColor(Color.WHITE);
        imageViewer.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        imageViewer.setImage(this.mModel.getCurrentGrafikAsImage());
        this.gbc.ipadx = 175;
        this.gbc.ipady = 192;
        this.mTechnikPanel.add((Component)imageViewer, this.gbc);
        this.counter = 0;
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, this.counter, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, this.ipad));
        this.mTechnikPanel.add((Component)this.mEinbauInfoPanel, this.gbc);
        ++this.counter;
        this.setKernprodukt();
        this.setZusatzprodukt();
        this.setHilfsundBetriebs();
        this.mTechnikPanel.validate();
        this.mTechnikPanel.updateUI();
        this.setLayout(this.mMarkenLayout);
        this.checkPlatzAnsicht();
        this.mTechnikPanel.validate();
        this.mTechnikPanel.updateUI();
        this.updateTeilelistenCombobox();
        this.setChanged();
        this.notifyObservers();
    }

    private void setKernprodukt() {
        this.mKernLabelPanel.removeAll();
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 17, new Insets(10, 10, 5, 10));
        this.mKernLabelPanel.add((Component)this.mSymbolKern, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 2, 17, new Insets(10, 0, 0, 0));
        this.mKernLabelPanel.add((Component)this.mKernLabel, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 0.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mTechnikPanel.add((Component)this.mKernLabelPanel, this.gbc);
        ++this.counter;
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 1.0, 0.0, 2, 17, new Insets(0, this.ipad, 0, this.ipad));
        this.mTechnikPanel.add((Component)this.getKernScrollPane(), this.gbc);
        ++this.counter;
    }

    JScrollPane getKernScrollPane() {
        JTable table = this.getKernTable();
        int rowCount = 0;
        rowCount = this.mModel.getZusatzProduktBnbs().size() == 0 ? (table.getRowCount() < 12 ? table.getRowCount() : 12) : (table.getRowCount() < 7 ? table.getRowCount() : 7);
        this.mKernScrollPane.setPreferredSize(new Dimension(786, rowCount * table.getRowHeight() + 23));
        this.mKernScrollPane.setMinimumSize(new Dimension(786, rowCount * table.getRowHeight() + 23));
        this.mKernScrollPane.setMaximumSize(new Dimension(786, rowCount * table.getRowHeight() + 23));
        this.mKernScrollPane.setViewportView(table);
        this.mKernScrollPane.updateUI();
        this.mKernTable.updateUI();
        this.mTechnikPanel.updateUI();
        return this.mKernScrollPane;
    }

    public JTable getKernTable() {
        if (this.mKernTableModel == null) {
            this.mKernTableModel = new TeileTableModel(this.mModel.getKernProduktBnbs(), this.mModel.getArbeitKernprodukt(), "KERNPRODUKT", this.mModel.isPreisevorhanden());
            this.mKernTable = new JTable(this.mKernTableModel);
            this.mKernTable.setName(TABELLE_KERN);
            this.mKernTable.setDefaultRenderer(Integer.class, new TableCellRendererInteger(this.mMarkenLayout));
            this.mKernTable.setDefaultRenderer(ImageIcon.class, this.mTableRendererKern);
            this.mKernTable.setDefaultRenderer(String.class, new TeileTableCellRendererString(this.mMarkenLayout));
            this.mKernTable.getTableHeader().setReorderingAllowed(false);
            this.mKernTable.setDefaultEditor(Integer.class, this.mEditorInt);
            this.mKernTable.getTableHeader().setMinimumSize(this.mTableHeaderSize);
            this.mKernTable.getTableHeader().setPreferredSize(this.mTableHeaderSize);
            this.mKernTable.getTableHeader().setFont(Constants.Layout.getZubDefaultFont());
            this.mKernTable.getTableHeader().setDefaultRenderer(new TeileTableHeaderRenderer(this.mMarkenLayout));
            this.mKernTable.addMouseListener(ControllerTechnikPanel.getInstance());
            this.mKernTable.addMouseListener(new HilfeMouseListener("i50074"));
            this.mKernTable.addMouseMotionListener(ControllerTechnikPanel.getInstance());
        }
        return this.mKernTable;
    }

    private void setZusatzprodukt() {
        this.mZusatzLabelPanel.removeAll();
        if (this.mModel.getZusatzProduktBnbs().size() > 0) {
            this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 17, new Insets(10, 10, 5, 10));
            this.mZusatzLabelPanel.add((Component)this.mSymbolZusatz, this.gbc);
            this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 2, 17, new Insets(10, 0, 0, 0));
            this.mZusatzLabelPanel.add((Component)this.mZusatzLabel, this.gbc);
            this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 0.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
            this.mTechnikPanel.add((Component)this.mZusatzLabelPanel, this.gbc);
            ++this.counter;
            this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 1.0, 0.0, 2, 17, new Insets(0, this.ipad, 0, this.ipad));
            this.mTechnikPanel.add((Component)this.setZusatzScrollPane(), this.gbc);
            ++this.counter;
        }
    }

    private JScrollPane setZusatzScrollPane() {
        JTable table = this.setZusatzTable();
        int rowCount = 0;
        rowCount = table.getRowCount() < 7 ? table.getRowCount() : 7;
        this.mZusatzScrollPane.setPreferredSize(new Dimension(786, rowCount * table.getRowHeight() + 23));
        this.mZusatzScrollPane.setMinimumSize(new Dimension(786, rowCount * table.getRowHeight() + 23));
        this.mZusatzScrollPane.setMaximumSize(new Dimension(786, rowCount * table.getRowHeight() + 23));
        this.mZusatzScrollPane.setViewportView(table);
        return this.mZusatzScrollPane;
    }

    public JScrollPane getZusatzScrollPane() {
        return this.mZusatzScrollPane;
    }

    private JTable setZusatzTable() {
        if (this.mZusatzTableModel == null) {
            this.mZusatzTableModel = new TeileTableModel(this.mModel.getZusatzProduktBnbs(), this.mModel.getArbeitZusatzprodukt(), "ZUSATZPRODUKT", this.mModel.isPreisevorhanden());
            this.mZusatzTable = new JTable(this.mZusatzTableModel);
            this.mZusatzTable.setName(TABELLE_ZUSATZ);
            this.mZusatzTable.setDefaultRenderer(Integer.class, new TableCellRendererInteger(this.mMarkenLayout));
            this.mZusatzTable.setDefaultRenderer(ImageIcon.class, this.mTableRendererZusatz);
            this.mZusatzTable.setDefaultRenderer(String.class, new TeileTableCellRendererString(this.mMarkenLayout));
            this.mZusatzTable.getTableHeader().setReorderingAllowed(false);
            this.mZusatzTable.setDefaultEditor(Integer.class, this.mEditorInt);
            this.mZusatzTable.getTableHeader().setMinimumSize(this.mTableHeaderSize);
            this.mZusatzTable.getTableHeader().setPreferredSize(this.mTableHeaderSize);
            this.mZusatzTable.getTableHeader().setFont(Constants.Layout.getZubDefaultFont());
            this.mZusatzTable.getTableHeader().setDefaultRenderer(new TeileTableHeaderRenderer(this.mMarkenLayout));
            this.mZusatzTable.addMouseListener(ControllerTechnikPanel.getInstance());
            this.mZusatzTable.addMouseListener(new HilfeMouseListener("i50074"));
            this.mZusatzTable.addMouseMotionListener(ControllerTechnikPanel.getInstance());
        }
        return this.mZusatzTable;
    }

    private void setHilfsundBetriebs() {
        this.mHilfLabelPanel.removeAll();
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 2, 17, new Insets(10, 10, 5, 10));
        this.mHilfLabelPanel.add((Component)this.mSymbolHilf, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 2, 17, new Insets(10, 0, 0, 0));
        this.mHilfLabelPanel.add((Component)this.mHilfLabel, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 0.0, 0.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mTechnikPanel.add((Component)this.mHilfLabelPanel, this.gbc);
        ++this.counter;
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 1.0, 0.0, 2, 17, new Insets(0, this.ipad, 10, this.ipad));
        this.mTechnikPanel.add((Component)this.setHilfScrollPane(), this.gbc);
        ++this.counter;
        this.setButtonPanel();
    }

    private void setButtonPanel() {
        this.mButtonPanel = new JPanel();
        this.mButtonPanel.setLayout(new GridBagLayout());
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 3, 17, new Insets(0, 10, 0, 0));
        this.mTeileHinzufuegenLabel.setPreferredSize(new Dimension(100, 25));
        this.mTeileHinzufuegenLabel.setAlignmentX(0.0f);
        this.mButtonPanel.add((Component)this.mTeileHinzufuegenLabel, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 2, 1, 0.0, 1.0, 3, 17, new Insets(0, 5, 0, 0));
        this.mArbeitHinzufuegenLabel.setPreferredSize(new Dimension(130, 25));
        this.mArbeitHinzufuegenLabel.setAlignmentX(0.5f);
        this.mButtonPanel.add((Component)this.mArbeitHinzufuegenLabel, this.gbc);
        JLabel emptyButton = new JLabel();
        this.gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 2, 17, new Insets(0, 0, 0, 0));
        this.mButtonPanel.add((Component)emptyButton, this.gbc);
        this.gbc = this.mMarkenLayout.setGridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 3, 17, new Insets(0, 0, 0, 10));
        if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.mButtonPanel.add((Component)this.mISPALabel, this.gbc);
        } else {
            this.mButtonPanel.add((Component)this.mUebernehmenInTeileliste, this.gbc);
        }
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 1.0, 0.0, 2, 17, new Insets(0, this.ipad, 5, this.ipad));
        this.mTechnikPanel.add((Component)this.mButtonPanel, this.gbc);
        ++this.counter;
        JLabel empty = new JLabel("");
        this.gbc = this.mMarkenLayout.setGridBagConstraints(0, this.counter, 2, 1, 1.0, 1.0, 2, 17, new Insets(0, this.ipad, 5, this.ipad));
        this.mTechnikPanel.add((Component)empty, this.gbc);
    }

    public JPanel getButtonPanel() {
        return this.mButtonPanel;
    }

    private JScrollPane setHilfScrollPane() {
        JTable table = this.setHilfTable();
        this.setSizeHilfsTable();
        this.mHilfScrollPane.setViewportView(table);
        return this.mHilfScrollPane;
    }

    public JScrollPane getHilfScrollPane() {
        return this.mHilfScrollPane;
    }

    private JTable setHilfTable() {
        if (this.mHilfTableModel == null) {
            this.mHilfTableModel = new HilfsTableModel(this.mModel.getHilfBnbs(), this.mModel.getArbeitHilf(), this.mModel.isAbPreiseMitSteuer());
            this.mHilfTable = new JTable(this.mHilfTableModel);
            this.mHilfTable.setName(TABELLE_HILF);
            this.mHilfTable.setDefaultRenderer(Integer.class, new HilfsTableCellRendererInteger(this.mMarkenLayout));
            this.mHilfTable.setDefaultRenderer(ImageIcon.class, this.mTableRendererHilf);
            this.mHilfTable.setDefaultEditor(Integer.class, this.mEditorInt);
            this.mHilfTable.setDefaultRenderer(String.class, this.mTableRendererHilf);
            this.mHilfTable.setDefaultRenderer(Boolean.class, new HilfsTableCellRendererBoolean(this.mMarkenLayout));
            this.mHilfTable.getTableHeader().setMinimumSize(this.mTableHeaderSize);
            this.mHilfTable.getTableHeader().setPreferredSize(this.mTableHeaderSize);
            this.mHilfTable.getTableHeader().setDefaultRenderer(new HilfsTableHeaderRenderer(this.mMarkenLayout));
            this.mHilfTable.setSelectionBackground(Color.white);
            this.mHilfTable.getTableHeader().setReorderingAllowed(false);
            this.mHilfTable.getTableHeader().setFont(Constants.Layout.getZubDefaultFont());
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(20);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(1).setMaxWidth(20);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(20);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(3).setMinWidth(85);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(85);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(4).setPreferredWidth(180);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(5).setMinWidth(50);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(5).setMaxWidth(50);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(6).setMinWidth(60);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(60);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(7).setMinWidth(70);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(7).setMaxWidth(70);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(8).setMinWidth(80);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(8).setMaxWidth(80);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(9).setMinWidth(20);
            this.mHilfTable.getTableHeader().getColumnModel().getColumn(9).setMaxWidth(20);
            this.mHilfTable.addMouseListener(ControllerTechnikPanel.getInstance());
            this.mHilfTable.addMouseListener(new HilfeMouseListener("i50074"));
            this.mHilfTable.addMouseMotionListener(ControllerTechnikPanel.getInstance());
        }
        return this.mHilfTable;
    }

    public void compactView() {
        this.mKernScrollPane.setVisible(false);
        this.setAufklappenIcon(this.mSymbolKern);
        this.mZusatzScrollPane.setVisible(false);
        this.setAufklappenIcon(this.mSymbolZusatz);
        this.mHilfScrollPane.setVisible(false);
        this.setAufklappenIcon(this.mSymbolHilf);
        this.mButtonPanel.setVisible(false);
    }

    public void normalizeView() {
        this.checkPlatzAnsicht();
    }

    public void handleArbeitsHinzuf\u00fcgen(Arbeit arbeit) {
        this.mHilfTableModel.addRowArbeit(arbeit);
        this.setSizeHilfsTable();
        this.mEinbauInfoPanel.refreshEinbauInfoPanel();
        this.checkPlatzAnsicht(ANSICHTHILF);
        this.mTechnikPanel.updateUI();
    }

    public void handleTeilHinzuf\u00fcgen(Bauteil bauteil) {
        this.mHilfTableModel.addRowTeil(bauteil);
        this.setSizeHilfsTable();
        this.mEinbauInfoPanel.refreshEinbauInfoPanel();
        this.checkPlatzAnsicht(ANSICHTHILF);
        this.mTechnikPanel.updateUI();
    }

    public void handleRemoveRow(MouseEvent e) {
        int aktRow = this.mHilfTable.rowAtPoint(new Point(e.getX(), e.getY()));
        this.mHilfTableModel.removeRow(aktRow);
        this.setSizeHilfsTable();
        this.mEinbauInfoPanel.refreshEinbauInfoPanel();
    }

    private void setSizeHilfsTable() {
        int rowCount = 0;
        rowCount = this.mModel.getZusatzProduktBnbs().size() == 0 ? (this.mHilfTableModel.getRowCount() < 12 ? this.mHilfTableModel.getRowCount() : 12) : (this.mHilfTableModel.getRowCount() < 7 ? this.mHilfTableModel.getRowCount() : 7);
        this.mHilfScrollPane.setPreferredSize(new Dimension(786, rowCount * this.mHilfTable.getRowHeight() + 23));
        this.mHilfScrollPane.setMinimumSize(new Dimension(786, rowCount * this.mHilfTable.getRowHeight() + 23));
        this.mHilfScrollPane.setMaximumSize(new Dimension(786, rowCount * this.mHilfTable.getRowHeight() + 23));
        this.mHilfScrollPane.updateUI();
        this.mHilfTable.updateUI();
        this.mTechnikPanel.updateUI();
    }

    private void checkPlatzAnsicht() {
        this.mSpeicher = 14;
        this.mSpeicher -= this.mKernTableModel.getRowCount();
        int zusatzPlatz = 0;
        int hilfPlatz = 0;
        if (this.mModel.getZusatzProduktBnbs().size() > 0) {
            zusatzPlatz = 3 + this.mZusatzTable.getRowCount();
            this.mSpeicher -= zusatzPlatz;
        }
        if (this.mModel.getHilfBnbs().size() > 0) {
            hilfPlatz = 5 + this.mHilfTable.getRowCount();
            this.mSpeicher -= hilfPlatz;
        } else {
            hilfPlatz = 5;
            this.mSpeicher -= 5;
        }
        if (this.mSpeicher > 0) {
            this.mKernScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolKern);
            this.mZusatzScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolZusatz);
            this.mHilfScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolHilf);
            this.mButtonPanel.setVisible(true);
        } else if (this.mSpeicher + hilfPlatz > 0) {
            this.mKernScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolKern);
            this.mZusatzScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolZusatz);
            this.mHilfScrollPane.setVisible(false);
            this.setAufklappenIcon(this.mSymbolHilf);
            this.mButtonPanel.setVisible(false);
        } else if (this.mSpeicher + zusatzPlatz > 0) {
            this.mKernScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolKern);
            this.mZusatzScrollPane.setVisible(false);
            this.setAufklappenIcon(this.mSymbolZusatz);
            this.mHilfScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolHilf);
            this.mButtonPanel.setVisible(true);
        } else if (this.mSpeicher < 0) {
            this.mKernScrollPane.setVisible(true);
            this.setZuklappenIcon(this.mSymbolKern);
            this.mZusatzScrollPane.setVisible(false);
            this.setAufklappenIcon(this.mSymbolZusatz);
            this.mHilfScrollPane.setVisible(false);
            this.setAufklappenIcon(this.mSymbolHilf);
            this.mButtonPanel.setVisible(false);
        }
    }

    public void checkPlatzAnsicht(String bereich) {
        this.mSpeicher = 14;
        this.mSpeicher -= this.mKernTableModel.getRowCount();
        int kernPlatz = this.mKernTableModel.getRowCount();
        int zusatzPlatz = 0;
        int hilfPlatz = 0;
        if (this.mModel.getZusatzProduktBnbs().size() > 0) {
            zusatzPlatz = 3 + this.mZusatzTable.getRowCount();
            this.mSpeicher -= zusatzPlatz;
        }
        if (this.mModel.getHilfBnbs().size() > 0) {
            hilfPlatz = 5 + this.mHilfTable.getRowCount();
            this.mSpeicher -= hilfPlatz;
        } else {
            hilfPlatz = 5;
            this.mSpeicher -= 5;
        }
        if (bereich.equals(ANSICHTKERN)) {
            if (this.mSpeicher > 0) {
                this.mKernScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolKern);
            } else if (this.mSpeicher + hilfPlatz > 0) {
                this.mKernScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolKern);
                this.mHilfScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(false);
            } else if (this.mSpeicher + zusatzPlatz > 0) {
                this.mKernScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolKern);
                this.mZusatzScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolZusatz);
                this.mHilfScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(true);
            } else if (this.mSpeicher < 0) {
                this.mKernScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolKern);
                this.mZusatzScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolZusatz);
                this.mHilfScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(false);
            }
        } else if (bereich.equals(ANSICHTZUSATZ)) {
            if (this.mSpeicher > 0) {
                this.mZusatzScrollPane.setVisible(true);
                this.mSymbolZusatz.setText("-");
            } else if (this.mSpeicher + hilfPlatz > 0) {
                this.mZusatzScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolZusatz);
                this.mHilfScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(false);
            } else if (this.mSpeicher + kernPlatz > 0) {
                this.mZusatzScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolZusatz);
                this.mKernScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolKern);
            } else if (this.mSpeicher < 0) {
                this.mZusatzScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolZusatz);
                this.mKernScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolKern);
                this.mHilfScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(false);
            }
        } else if (bereich.equals(ANSICHTHILF)) {
            if (this.mSpeicher > 0) {
                this.mHilfScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(true);
            } else if (this.mSpeicher + zusatzPlatz > 0) {
                this.mZusatzScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolZusatz);
                this.mHilfScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(true);
            } else if (this.mSpeicher + kernPlatz > 0) {
                this.mHilfScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(true);
                this.mKernScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolKern);
            } else if (this.mSpeicher < 0) {
                this.mHilfScrollPane.setVisible(true);
                this.setZuklappenIcon(this.mSymbolHilf);
                this.mButtonPanel.setVisible(true);
                this.mZusatzScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolZusatz);
                this.mKernScrollPane.setVisible(false);
                this.setAufklappenIcon(this.mSymbolKern);
            }
        }
    }

    public void setLayout(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        Color backgroundForLabelPanel = Color.WHITE;
        if (this.mMarkenLayout.isMINI()) {
            backgroundForLabelPanel = this.mMarkenLayout.getPrimaryBackground();
        } else if (this.mMarkenLayout.isBMW() || this.mMarkenLayout.isBMWi() || this.mMarkenLayout.isBMWMotorrad()) {
            if (this.mZusatzTable != null) {
                this.mZusatzTable.setShowVerticalLines(false);
            }
            this.mHilfTable.setShowVerticalLines(false);
            this.mKernTable.setShowVerticalLines(false);
            backgroundForLabelPanel = this.mMarkenLayout.getSecondaryBackground();
        }
        this.mTechnikPanel.setBackground(backgroundForLabelPanel);
        this.mKernTable.getTableHeader().setForeground(Color.WHITE);
        this.mKernTable.getTableHeader().setBackground(Color.GRAY);
        this.mKernTable.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mKernTable.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mTableRendererKern.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mKernScrollPane.setBackground(backgroundForLabelPanel);
        this.mKernLabelPanel.setBackground(backgroundForLabelPanel);
        this.mKernLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mZusatzLabelPanel.setBackground(backgroundForLabelPanel);
        this.mZusatzLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        if (this.mZusatzTable != null) {
            this.mZusatzTable.getTableHeader().setBackground(Color.GRAY);
            this.mZusatzTable.getTableHeader().setForeground(Color.WHITE);
            this.mZusatzTable.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mZusatzTable.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.mTableRendererZusatz.setForeground(this.mMarkenLayout.getPrimaryForeground());
        }
        this.mZusatzScrollPane.setBackground(backgroundForLabelPanel);
        this.mHilfLabelPanel.setBackground(backgroundForLabelPanel);
        this.mHilfLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHilfTable.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mHilfTable.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mHilfTable.getTableHeader().setBackground(Color.GRAY);
        this.mHilfTable.getTableHeader().setForeground(Color.WHITE);
        this.mHilfScrollPane.setBackground(backgroundForLabelPanel);
        this.mTableRendererHilf.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mButtonPanel.setBackground(backgroundForLabelPanel);
        if (this.mTeileHinzufuegenLabel != null) {
            this.mTeileHinzufuegenLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mTeileHinzufuegenLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.mArbeitHinzufuegenLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mArbeitHinzufuegenLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.mLabInTeileliste.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mCboTeilelisten.setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mCboTeilelisten.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.mButUebernehmen.setForeground(this.mMarkenLayout.getPrimaryForeground());
        }
        this.mSymbolZusatz.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mSymbolHilf.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.getTechnikPanel().validate();
    }

    public void setAufklappenIcon(JLabel label) {
        label.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "aufklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        if (label.getName().equals(SYMBOLKERN)) {
            this.mSymbolKernOpen = false;
        }
        if (label.getName().equals(SYMBOLOPTIONAL)) {
            this.mSymbolZusatzOpen = false;
        }
        if (label.getName().equals(SYMBOLHILF)) {
            this.mSymbolHilfOpen = false;
        }
    }

    public void setZuklappenIcon(JLabel label) {
        label.setIcon(this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mMarkenLayout.getIconPath() + "zuklappen.gif"), this.mMarkenLayout.getPrimaryBackground()));
        if (label.getName().equals(SYMBOLKERN)) {
            this.mSymbolKernOpen = true;
        }
        if (label.getName().equals(SYMBOLOPTIONAL)) {
            this.mSymbolZusatzOpen = true;
        }
        if (label.getName().equals(SYMBOLHILF)) {
            this.mSymbolHilfOpen = true;
        }
    }

    public EinbauInfoPanel getInfoPanel() {
        return this.mEinbauInfoPanel;
    }

    public JLabel getArbeitHinzufuegenLabel() {
        return this.mArbeitHinzufuegenLabel;
    }

    public JLabel getTeileHinzufuegenLabel() {
        return this.mTeileHinzufuegenLabel;
    }

    public JLabel getISPALabel() {
        return this.mISPALabel;
    }

    public JPanel getTechnikPanel() {
        return this.mTechnikPanel;
    }

    public JLabel getSymbolHilf() {
        return this.mSymbolHilf;
    }

    public JLabel getSymbolOptional() {
        return this.mSymbolZusatz;
    }

    public JLabel getSymbolKern() {
        return this.mSymbolKern;
    }

    public HilfsTableModel getHilfTableModel() {
        return this.mHilfTableModel;
    }

    public EinbauInfoPanel getEinbauInfoPanel() {
        return this.mEinbauInfoPanel;
    }

    public JTable getHilfTable() {
        return this.mHilfTable;
    }

    public void setAngebotssicht(boolean flag) {
        if (this.mKernTableModel != null) {
            this.mKernTableModel.setAngebotsSicht(flag);
        }
        if (this.mZusatzTableModel != null) {
            this.mZusatzTableModel.setAngebotsSicht(flag);
        }
        if (this.mHilfTableModel != null) {
            this.mHilfTableModel.setAngebotsSicht(flag);
        }
    }

    public JPanel getUebernehmenInTeilelistePanel() {
        if (this.mUebernehmenInTeileliste == null) {
            this.mUebernehmenInTeileliste = new JPanel();
            this.mUebernehmenInTeileliste.setOpaque(false);
            this.mUebernehmenInTeileliste.setLayout(new BoxLayout(this.mUebernehmenInTeileliste, 0));
            this.mLabInTeileliste = new JLabel(Resource.getInstance().getInTeileliste());
            this.mLabInTeileliste.setOpaque(false);
            this.mCboTeilelisten = this.getTeilelistenCombobox();
            this.mCboTeilelisten.addMouseListener(new HilfeMouseListener("i50074"));
            this.mButUebernehmen = new JLabel(Resource.getInstance().getUebernehmen());
            this.mButUebernehmen.setOpaque(false);
            this.mButUebernehmen.setName(IN_TEILELISTE_UEBERNEHMEN);
            this.mButUebernehmen.setCursor(Cursor.getPredefinedCursor(12));
            this.mButUebernehmen.addMouseListener(ControllerTechnikPanel.getInstance());
            this.mButUebernehmen.addMouseListener(new HilfeMouseListener("i50074"));
            this.mUebernehmenInTeileliste.add(this.mLabInTeileliste);
            this.mUebernehmenInTeileliste.add(Box.createRigidArea(new Dimension(3, 0)));
            this.mUebernehmenInTeileliste.add(this.mCboTeilelisten);
            this.mUebernehmenInTeileliste.add(Box.createRigidArea(new Dimension(3, 0)));
            this.mUebernehmenInTeileliste.add(this.mButUebernehmen);
        }
        return this.mUebernehmenInTeileliste;
    }

    public JComboBox getTeilelistenCombobox() {
        if (this.mCboTeilelisten == null) {
            this.mCboTeilelisten = new JComboBox();
        }
        return this.mCboTeilelisten;
    }

    void updateTeilelistenCombobox() {
        FontMetrics metrics = this.mCboTeilelisten.getFontMetrics(this.mCboTeilelisten.getFont());
        this.mCboTeilelisten.removeAllItems();
        ArrayList<ComboTeilelisteItem> cTeilelisten = ControllerTechnikPanel.getTeilelisten();
        if (cTeilelisten.size() == 0) {
            this.mButUebernehmen.setEnabled(false);
        } else {
            this.mButUebernehmen.setEnabled(true);
        }
        int maxLength = 0;
        for (ComboTeilelisteItem comboTeilelisteItem : cTeilelisten) {
            int length = metrics.stringWidth(comboTeilelisteItem.getName());
            maxLength = length > maxLength ? length : maxLength;
            this.mCboTeilelisten.addItem(comboTeilelisteItem);
        }
        this.mCboTeilelisten.setMinimumSize(new Dimension(maxLength + 30, 20));
        this.mCboTeilelisten.setMaximumSize(new Dimension(maxLength + 30, 20));
        this.mCboTeilelisten.setPreferredSize(new Dimension(maxLength + 30, 20));
    }

    public boolean isSymbolKernOpen() {
        return this.mSymbolKernOpen;
    }

    public boolean isSymbolZusatzOpen() {
        return this.mSymbolZusatzOpen;
    }

    public boolean isSymbolHilfOpen() {
        return this.mSymbolHilfOpen;
    }

    public TabelCellEditorInteger getEditorInt() {
        return this.mEditorInt;
    }

    public boolean isFBAVisible() {
        return this.isFBAVisible;
    }

    public void setFBAVisible(boolean isFBAVisible) {
        this.isFBAVisible = isFBAVisible;
    }
}

