/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.content.technisch;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TeileTableCellRendererString
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    MarkenLayout mLayout;
    private final Color background;
    private final Color foreground;
    private int lengthToTooltip;

    public TeileTableCellRendererString(MarkenLayout layout) {
        this.background = layout.getPrimaryBackground();
        this.foreground = layout.getPrimaryForeground();
        this.mLayout = layout;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        this.setFont(Constants.Layout.getZubDefaultFont());
        FontMetrics fontMetrics = this.getFontMetrics(Constants.Layout.getZubDefaultFont());
        this.setText(value.toString());
        int textBreite = fontMetrics.stringWidth(value.toString());
        int columnWidth = table.getColumnModel().getColumn(column).getWidth();
        if (textBreite > columnWidth - 5) {
            this.setToolTipText(value.toString());
        } else {
            this.setToolTipText(null);
        }
        if (column == 7) {
            this.setHorizontalAlignment(0);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setBackground(this.background);
        this.setForeground(this.foreground);
        return this;
    }
}

