/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation;

import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.suche.ProduktSucheDataLoader;
import de.esg.zub.configurator.navigation.suche.ETKErgebnisDialog;
import de.esg.zub.configurator.navigation.suche.ETKSuchModel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.app.zub.suche.BildTafelETK;
import webetk.resources.Resource;

public class ControllerETKSearch
extends MouseAdapter {
    static ControllerETKSearch mInstance;
    ETKSuchModel mModel = new ETKSuchModel();
    ETKErgebnisDialog mDialog;

    public static ControllerETKSearch getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerETKSearch();
            ControllerETKSearch.mInstance.mDialog = new ETKErgebnisDialog((Frame)MainController.getIMainControllerInstance().getMainFrame(), Resource.getInstance().getErgebnisBildtafeln(), WorkflowController.getInstance().getMarkenLayout());
            ControllerETKSearch.mInstance.mDialog.getTable().setModel(ControllerETKSearch.mInstance.mModel);
            ControllerETKSearch.mInstance.mDialog.setOptimalSize();
        }
        return mInstance;
    }

    public void performSearch(String suchbegriff) {
        try {
            this.mDialog.setLayout(WorkflowController.getInstance().getMarkenLayout());
            List<BildTafelETK> liste = ProduktSucheDataLoader.sucheETKProdukte(suchbegriff);
            this.mModel.setErgebnisListe(liste);
            if (liste.size() > 0) {
                this.mDialog.getTable().setModel(this.mModel);
                this.mDialog.updateView();
            } else {
                JOptionPane.showMessageDialog((Component)MainController.getIMainControllerInstance().getMainFrame(), Resource.getInstance().getSucheNoResult());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)MainController.getIMainControllerInstance().getMainFrame(), Resource.getInstance().getFehlerLadeTeileinfo());
            Logger.getLogger(ControllerETKSearch.class).error((Object)e);
            e.printStackTrace();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getComponent() == this.mDialog.getButton()) {
            this.mDialog.setVisible(false);
        }
    }
}

