/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.miniatur;

import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.navigation.miniatur.IMiniaturPanel;
import de.esg.zub.configurator.navigation.miniatur.MiniaturKalkulationsPanel;
import de.esg.zub.configurator.navigation.miniatur.MiniaturMarketingPanel;
import de.esg.zub.configurator.navigation.miniatur.MiniaturTechnikPanel;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

public class ControllerMiniaturansicht
implements MouseListener {
    private static ControllerMiniaturansicht mInstance;
    private MiniaturMarketingPanel mMiniaturMarketing;
    private MiniaturTechnikPanel mMiniaturTechnik;
    private MiniaturKalkulationsPanel mMiniaturKalkulation;
    private boolean mAngebotsSicht;

    private ControllerMiniaturansicht() {
    }

    public static ControllerMiniaturansicht getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerMiniaturansicht();
        }
        return mInstance;
    }

    public void init() {
        List<IMiniaturPanel> miniPanels;
        if (this.mMiniaturMarketing != null && (miniPanels = ClientKonfiguration.getClientKonfiguration().getMiniPanels()).contains(this.mMiniaturMarketing)) {
            miniPanels.remove(miniPanels.indexOf(this.mMiniaturMarketing));
        }
        this.mMiniaturMarketing = new MiniaturMarketingPanel();
        this.mMiniaturMarketing.getPanel().addMouseListener(mInstance);
        this.mMiniaturMarketing.getPanel().addMouseListener(new HilfeMouseListener("i500511"));
        ClientKonfiguration.getClientKonfiguration().addMiniaturAnsicht(this.mMiniaturMarketing);
        if (this.mMiniaturTechnik != null && (miniPanels = ClientKonfiguration.getClientKonfiguration().getMiniPanels()).contains(this.mMiniaturTechnik)) {
            miniPanels.remove(miniPanels.indexOf(this.mMiniaturTechnik));
        }
        this.mMiniaturTechnik = new MiniaturTechnikPanel();
        this.mMiniaturTechnik.getPanel().addMouseListener(mInstance);
        this.mMiniaturTechnik.getImageViewer().getPaintPanel().addMouseListener((MouseListener)mInstance);
        this.mMiniaturTechnik.getPanel().addMouseListener(new HilfeMouseListener("i50074"));
        this.mMiniaturTechnik.getImageViewer().getPaintPanel().addMouseListener((MouseListener)new HilfeMouseListener("i50074"));
        ClientKonfiguration.getClientKonfiguration().addMiniaturAnsicht(this.mMiniaturTechnik);
        if (this.mMiniaturKalkulation != null && (miniPanels = ClientKonfiguration.getClientKonfiguration().getMiniPanels()).contains(this.mMiniaturKalkulation)) {
            miniPanels.remove(miniPanels.indexOf(this.mMiniaturKalkulation));
        }
        this.mMiniaturKalkulation = new MiniaturKalkulationsPanel();
        this.mMiniaturKalkulation.getPanel().addMouseListener(mInstance);
        this.mMiniaturKalkulation.getPanel().addMouseListener(new HilfeMouseListener("i50086"));
        ClientKonfiguration.getClientKonfiguration().addMiniaturAnsicht(this.mMiniaturKalkulation);
        this.mAngebotsSicht = false;
        this.showMiniaturansichten();
    }

    public void showMiniaturansichten() {
        MainController.getInstance().getMainFrame().setMiniaturansichten(this.mMiniaturMarketing, this.mMiniaturTechnik, this.mMiniaturKalkulation);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.getButton() == 3) {
            return;
        }
        if (!this.mAngebotsSicht) {
            try {
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mMiniaturKalkulation.getPanel().setCursor(Cursor.getPredefinedCursor(3));
                this.mMiniaturTechnik.getPanel().setCursor(Cursor.getPredefinedCursor(3));
                this.mMiniaturMarketing.getPanel().setCursor(Cursor.getPredefinedCursor(3));
                if (arg0.getComponent().getName().equals("TECHNIK")) {
                    if (WorkflowController.getInstance().isNewKonfiguration()) {
                        if (!WorkflowController.getInstance().isAddKonfiguration()) {
                            if (ControllerMenuBar.getInstance().checkAnzahlVorgaenge()) {
                                WorkflowController.getInstance().changeState("FBI");
                                return;
                            }
                            return;
                        }
                        WorkflowController.getInstance().changeState("FBI");
                    } else {
                        this.mMiniaturKalkulation.removeBorder();
                        this.mMiniaturMarketing.removeBorder();
                        this.mMiniaturTechnik.setBorder();
                        WorkflowController.getInstance().changeState("TECHNIK");
                    }
                } else if (arg0.getComponent().getName().equals("KALKULATION")) {
                    if (!this.mMiniaturKalkulation.isInitial()) {
                        this.mMiniaturKalkulation.setBorder();
                        this.mMiniaturMarketing.removeBorder();
                        this.mMiniaturTechnik.removeBorder();
                        WorkflowController.getInstance().changeState("KALKULATION");
                    }
                } else if (arg0.getComponent().getName().equals("MARKETING")) {
                    this.mMiniaturKalkulation.removeBorder();
                    this.mMiniaturMarketing.setBorder();
                    this.mMiniaturTechnik.removeBorder();
                    WorkflowController.getInstance().changeState("MARKETING");
                }
            }
            finally {
                this.mMiniaturKalkulation.getPanel().setCursor(Cursor.getPredefinedCursor(12));
                this.mMiniaturTechnik.getPanel().setCursor(Cursor.getPredefinedCursor(12));
                this.mMiniaturMarketing.getPanel().setCursor(Cursor.getPredefinedCursor(12));
                MainController.getInstance().getMainFrame().setDefaultCursor();
            }
        }
    }

    public MiniaturMarketingPanel getMiniaturMarketing() {
        return this.mMiniaturMarketing;
    }

    public MiniaturTechnikPanel getMiniaturTechnik() {
        return this.mMiniaturTechnik;
    }

    public MiniaturKalkulationsPanel getMiniaturKalkulation() {
        return this.mMiniaturKalkulation;
    }

    public void setAngebotsSicht(boolean angebotsSicht) {
        if (this.mMiniaturMarketing != null) {
            this.mMiniaturMarketing.setAngebotsSicht(angebotsSicht);
        }
        if (this.mMiniaturTechnik != null) {
            this.mMiniaturTechnik.setAngebotsSicht(angebotsSicht);
        }
        this.mAngebotsSicht = angebotsSicht;
    }

    public boolean isAngebotsSicht() {
        return this.mAngebotsSicht;
    }
}

