/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.miniatur;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.navigation.miniatur.AbstractMiniaturPanel;
import de.esg.zub.configurator.workflow.KalkulationsState;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class MiniaturKalkulationsPanel
extends AbstractMiniaturPanel {
    private boolean initial;
    private JLabel seperator1;
    private JLabel seperator2;
    private JLabel labKalkulation;
    private JLabel labPreisTeile;
    private JLabel labPreisArbeit;
    private JLabel labPreisNetto;
    private JLabel labMwSt;
    private JLabel labAufAbschlag;
    private JLabel labPreisGesamt;
    private JLabel labPreisTeileWert;
    private JLabel labPreisArbeitWert;
    private JLabel labPreisNettoWert;
    private JLabel labMwStWert;
    private JLabel labAufAbschlagWert;
    private JLabel labPreisGesamtWert;

    public MiniaturKalkulationsPanel() {
        this.mLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mPanel = new JPanel();
        this.mPanel.setName("KALKULATION");
        this.mPanel.setLayout(new GridBagLayout());
        ClientKonfiguration.getClientKonfiguration().addMiniaturAnsicht(this);
        this.updatePanel();
    }

    private void updatePanel() {
        if (WorkflowController.getInstance().isNewKonfiguration()) {
            this.setInitPanel();
            this.mPanel.setCursor(Cursor.getPredefinedCursor(0));
            this.initial = true;
        } else {
            this.setDetailPanel();
            this.mPanel.setCursor(Cursor.getPredefinedCursor(12));
            this.initial = false;
            if (WorkflowController.getInstance().getActiveState() instanceof KalkulationsState) {
                this.setBorder();
            } else {
                this.removeBorder();
            }
        }
    }

    private void setInitPanel() {
        this.mPanel.removeAll();
        JLabel lab = new JLabel(Resource.getInstance().getKalkulationssicht() + "    3/3");
        lab.setHorizontalAlignment(0);
        lab.setBigBoldFont();
        lab.setForeground(Color.LIGHT_GRAY);
        this.mPanel.setBackground(this.mLayout.getPrimaryBackground());
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)lab, gbc);
        this.mPanel.updateUI();
        this.mPanel.validate();
    }

    private void setDetailPanel() {
        this.mPanel.removeAll();
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.getHeadPanel(), gbc);
        gbc = this.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 2, 18, new Insets(0, 0, 0, 0));
        this.mPanel.add((Component)this.getMainPanel(), gbc);
        this.setLayout();
        this.updateData();
        this.mPanel.updateUI();
        this.mPanel.validate();
    }

    private JPanel getHeadPanel() {
        if (this.mHead == null) {
            Color background = this.mLayout.getPrimaryBackground();
            Color foreground = this.mLayout.getPrimaryForeground();
            if (this.mLayout.isBMW() || this.mLayout.isBMWi() | this.mLayout.isBMWMotorrad()) {
                background = this.mLayout.getTertiaryBackground();
                foreground = this.mLayout.getTertiaryForeground();
            } else if (this.mLayout.isMINI()) {
                foreground = new Color(224, 224, 224);
            }
            this.mHead = new JPanel();
            this.mHead.setBackground(background);
            this.mHead.setLayout(new GridBagLayout());
            this.labKalkulation = new JLabel(Resource.getInstance().getKalkulationssicht());
            this.labKalkulation.setBigBoldFont();
            this.labKalkulation.setForeground(foreground);
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(10, 5, 0, 0));
            this.mHead.add((Component)this.labKalkulation, gbc);
            JLabel step = new JLabel("3/3");
            step.setBigBoldFont();
            step.setForeground(foreground);
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 14, new Insets(0, 0, 0, 5));
            this.mHead.add((Component)step, gbc);
        }
        return this.mHead;
    }

    private JPanel getMainPanel() {
        if (this.mMain == null) {
            this.mMain = new JPanel();
            this.mMain.setLayout(new GridBagLayout());
            this.labPreisTeile = new JLabel(Resource.getInstance().getPreisTeile() + ":");
            this.labPreisTeile.setHorizontalAlignment(4);
            this.labPreisArbeit = new JLabel(Resource.getInstance().getPreisArbeit() + ":");
            this.labPreisArbeit.setHorizontalAlignment(4);
            this.labPreisNetto = new JLabel(Resource.getInstance().getPreisNetto() + ":");
            this.labPreisNetto.setHorizontalAlignment(4);
            this.labMwSt = new JLabel(ZubCustomizable.getInstance().getBegriffAbkuerzungMwst());
            this.labMwSt.setHorizontalAlignment(4);
            this.labAufAbschlag = new JLabel(ZubCustomizable.getInstance().getBegriffAufAbschlag());
            this.labAufAbschlag.setHorizontalAlignment(4);
            this.labPreisGesamt = new JLabel(Resource.getInstance().getGesamtpreis() + ": ");
            this.labPreisGesamt.setHorizontalAlignment(4);
            this.labPreisTeileWert = new JLabel();
            this.labPreisArbeitWert = new JLabel();
            this.labPreisNettoWert = new JLabel();
            this.labMwStWert = new JLabel();
            this.labAufAbschlagWert = new JLabel();
            this.labPreisGesamtWert = new JLabel();
            GridBagConstraints gbcText = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 14, new Insets(10, 0, 0, 5));
            this.mMain.add((Component)this.labPreisTeile, gbcText);
            GridBagConstraints gbcWert = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 14, new Insets(0, 0, 0, 5));
            this.mMain.add((Component)this.labPreisTeileWert, gbcWert);
            gbcText.gridy = 1;
            gbcText.insets = new Insets(5, 0, 0, 5);
            this.mMain.add((Component)this.labPreisArbeit, gbcText);
            gbcWert.gridy = 1;
            this.mMain.add((Component)this.labPreisArbeitWert, gbcWert);
            this.seperator1 = new JLabel();
            GridBagConstraints gbcSep = this.setGridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 2, 14, new Insets(5, 5, 0, 5));
            this.mMain.add((Component)this.seperator1, gbcSep);
            gbcText.gridy = 3;
            this.mMain.add((Component)this.labPreisNetto, gbcText);
            gbcWert.gridy = 3;
            this.mMain.add((Component)this.labPreisNettoWert, gbcWert);
            gbcText.gridy = 4;
            this.mMain.add((Component)this.labMwSt, gbcText);
            gbcWert.gridy = 4;
            this.mMain.add((Component)this.labMwStWert, gbcWert);
            gbcText.gridy = 5;
            this.mMain.add((Component)this.labAufAbschlag, gbcText);
            gbcWert.gridy = 5;
            this.mMain.add((Component)this.labAufAbschlagWert, gbcWert);
            this.seperator2 = new JLabel();
            gbcSep = this.setGridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 2, 14, new Insets(5, 5, 0, 5));
            this.mMain.add((Component)this.seperator2, gbcSep);
            gbcText.gridy = 7;
            this.mMain.add((Component)this.labPreisGesamt, gbcText);
            gbcWert.gridy = 7;
            this.mMain.add((Component)this.labPreisGesamtWert, gbcWert);
        }
        return this.mMain;
    }

    private void setLayout() {
        Color foreground = this.mLayout.getPrimaryForeground();
        Color background = this.mLayout.getPrimaryBackground();
        this.labPreisGesamt.setBoldFont();
        this.labPreisNettoWert.setBoldFont();
        this.labPreisGesamtWert.setBoldFont();
        this.labPreisTeile.setForeground(foreground);
        this.labPreisArbeit.setForeground(foreground);
        this.labPreisNetto.setForeground(foreground);
        this.labMwSt.setForeground(foreground);
        this.labAufAbschlag.setForeground(foreground);
        this.labPreisGesamt.setForeground(foreground);
        this.labPreisTeileWert.setForeground(foreground);
        this.labPreisArbeitWert.setForeground(foreground);
        this.labPreisNettoWert.setForeground(foreground);
        this.labMwStWert.setForeground(foreground);
        this.labAufAbschlagWert.setForeground(foreground);
        this.labPreisGesamtWert.setForeground(foreground);
        this.mMain.setBackground(background);
        this.mPanel.setBackground(background);
        this.seperator1.setPreferredSize(new Dimension(0, 2));
        this.seperator1.setBorder(BorderFactory.createLineBorder(foreground));
        this.seperator2.setPreferredSize(new Dimension(0, 2));
        this.seperator2.setBorder(BorderFactory.createLineBorder(foreground));
    }

    public void updateData() {
        ClientKonfiguration konfig = ClientKonfiguration.getClientKonfiguration();
        KalkulationModel model = null;
        if (konfig != null) {
            model = konfig.getKalkulationModel();
        }
        if (model == null) {
            model = new KalkulationModel();
            model.setAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage());
        }
        this.labPreisTeileWert.setText(KalkulationModel.nfWaehrung.format(model.getTeilePreis()) + " " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.labPreisArbeitWert.setText(KalkulationModel.nfWaehrung.format(model.getArbeitPreis()) + " " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.labPreisNettoWert.setText(KalkulationModel.nfWaehrung.format(model.getNettoPreis()) + " " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.labMwStWert.setText(KalkulationModel.nfWaehrung.format(model.getMwSt()) + " " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.labAufAbschlagWert.setText(KalkulationModel.nfWaehrung.format(model.getAufAbschlag()) + " " + ZubCustomizable.getInstance().getWaehrungsKz());
        this.labPreisGesamtWert.setText(KalkulationModel.nfWaehrung.format(model.getGesamtPreis()) + " " + ZubCustomizable.getInstance().getWaehrungsKz());
    }

    public boolean isInitial() {
        return this.initial;
    }

    @Override
    public void update() {
        this.updatePanel();
    }
}

