/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.navigation.suche.BauartenPanel;
import de.esg.zub.configurator.navigation.suche.BaureihenPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.CssEditorKit;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baureihe;

public class DetailPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    public static final String NAME = "DETAIL_PANEL";
    private JLabel graphikLabel = null;
    private BaureihenPanel baureihePanel = null;
    private BauartenPanel bauartenPanel = null;
    private JScrollPane textAreaScrollPane = null;
    private JPanel contentCardPanel = null;
    private static final String TEXT = "Text";
    private static final String GRAPHIK = "Graphik";
    private static final String BAUREIHEN_TREE = "Baureihen_Tree";
    private static final String BAUARTEN_TREE = "Bauarten_Tree";
    private static final String DETAIL_ANZEIGE = "Preview";
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();
    private JPanel mainHeaderPanel = null;
    private JLabel openIcon = null;
    private JLabel closeIcon = null;
    private JLabel headerName;

    public DetailPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Constants.Layout.DARKGRAY_COLOR));
        this.mainHeaderPanel = new JPanel(new GridBagLayout());
        this.mainHeaderPanel.setMinimumSize(new Dimension(200, 28));
        this.mainHeaderPanel.setPreferredSize(new Dimension(200, 28));
        this.headerName = new JLabel(DETAIL_ANZEIGE);
        this.headerName.setBoldFont();
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 5, 0, 0));
        this.mainHeaderPanel.add((Component)this.headerName, gbc);
        this.openIcon = new JLabel(this.createOpenIcon());
        this.openIcon.setName("OPENPREVIEW");
        this.openIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.closeIcon = new JLabel(this.createCloseIcon());
        this.closeIcon.setName("CLOSEPREVIEW");
        this.closeIcon.setCursor(Cursor.getPredefinedCursor(12));
        gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 1, 13, new Insets(0, 5, 0, 3));
        this.mainHeaderPanel.add((Component)this.closeIcon, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.mainHeaderPanel, gbc);
        this.contentCardPanel = new JPanel(new CardLayout());
        this.textAreaScrollPane = new JScrollPane();
        this.textAreaScrollPane.setBorder(null);
        this.contentCardPanel.add((Component)this.textAreaScrollPane, TEXT);
        this.graphikLabel = new JLabel();
        this.graphikLabel.setBackground(this.mLayout.getPrimaryBackground());
        this.graphikLabel.setForeground(this.mLayout.getPrimaryForeground());
        this.graphikLabel.setHorizontalAlignment(0);
        this.contentCardPanel.add((Component)this.graphikLabel, GRAPHIK);
        this.baureihePanel = new BaureihenPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().add(this.baureihePanel);
        this.contentCardPanel.add((Component)scrollPane, BAUREIHEN_TREE);
        this.bauartenPanel = new BauartenPanel();
        JScrollPane scrollPane_bauart = new JScrollPane();
        scrollPane_bauart.setBorder(BorderFactory.createEmptyBorder());
        scrollPane_bauart.getViewport().add(this.bauartenPanel);
        this.contentCardPanel.add((Component)scrollPane_bauart, BAUARTEN_TREE);
        ((CardLayout)this.contentCardPanel.getLayout()).show(this.contentCardPanel, TEXT);
        this.contentCardPanel.setPreferredSize(new Dimension(204, 300));
        this.contentCardPanel.setMinimumSize(new Dimension(204, 300));
        gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 0, 11, new Insets(0, 0, 0, 0));
        this.add((Component)this.contentCardPanel, gbc);
        this.setStyle();
        this.setVisible(true);
    }

    public void setStyle() {
        if (this.baureihePanel != null) {
            this.baureihePanel.setStyle();
        }
        if (this.bauartenPanel != null) {
            this.bauartenPanel.setStyle();
        }
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.setHeadersColor();
        this.openIcon.setIcon(this.createOpenIcon());
        this.closeIcon.setIcon(this.createCloseIcon());
        this.contentCardPanel.setBackground(this.mLayout.getPrimaryBackground());
        this.mainHeaderPanel.validate();
    }

    private void setHeadersColor() {
        this.mainHeaderPanel.setBackground(this.mLayout.getNaviHeaderColor());
        this.mainHeaderPanel.getComponent(0).setForeground(this.mLayout.getNaviHeaderFont());
        this.mainHeaderPanel.setBorder(this.mLayout.getNaviBorderOpenheader());
        this.setBorder(this.mLayout.getNaviBorderSelect());
    }

    public void setText(String text) {
        JTextPane textPane = new JTextPane();
        textPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        textPane.setFont(Constants.Layout.getZubDefaultFont());
        textPane.setEditable(false);
        textPane.setContentType("text/html; charset=UTF-8");
        textPane.setEditorKit(new CssEditorKit());
        textPane.setBorder(null);
        textPane.setBorder(null);
        if (this.mLayout.isBMWMotorrad()) {
            textPane.setText("<div class='menu2'>" + text + "</div>");
        } else {
            textPane.setText(text);
        }
        textPane.setBackground(this.mLayout.getPrimaryBackground());
        textPane.setForeground(this.mLayout.getPrimaryForeground());
        this.textAreaScrollPane.getViewport().add(textPane);
        ((CardLayout)this.contentCardPanel.getLayout()).show(this.contentCardPanel, TEXT);
    }

    public void setGraphik(ImageIcon graphik) {
        this.graphikLabel.setIcon(graphik);
        ((CardLayout)this.contentCardPanel.getLayout()).show(this.contentCardPanel, GRAPHIK);
    }

    public void setBaureiheTree(ArrayList<Baureihe> baureiheList) {
        this.baureihePanel.buildTree(baureiheList);
        ((CardLayout)this.contentCardPanel.getLayout()).show(this.contentCardPanel, BAUREIHEN_TREE);
    }

    public void setBauartTree(ArrayList<Bauart> bauartList) {
        this.bauartenPanel.buildTree(bauartList);
        ((CardLayout)this.contentCardPanel.getLayout()).show(this.contentCardPanel, BAUARTEN_TREE);
    }

    public JPanel getContentCardPanel() {
        return this.contentCardPanel;
    }

    public JPanel getMainHeaderPanel() {
        return this.mainHeaderPanel;
    }

    public void setIcon(String action) {
        if (action.equals("OPEN")) {
            this.mainHeaderPanel.removeAll();
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 1, 18, new Insets(0, 5, 0, 0));
            this.mainHeaderPanel.add((Component)this.headerName, gbc);
            gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 1, 13, new Insets(0, 5, 0, 3));
            this.mainHeaderPanel.add((Component)this.openIcon, gbc);
        } else if (action.equals("CLOSE")) {
            this.mainHeaderPanel.removeAll();
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 1, 18, new Insets(0, 5, 0, 0));
            this.mainHeaderPanel.add((Component)this.headerName, gbc);
            gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 1, 13, new Insets(0, 5, 0, 3));
            this.mainHeaderPanel.add((Component)this.closeIcon, gbc);
        }
        this.mainHeaderPanel.validate();
        this.mainHeaderPanel.updateUI();
        this.updateUI();
    }

    public JLabel getOpenIcon() {
        return this.openIcon;
    }

    public JLabel getCloseIcon() {
        return this.closeIcon;
    }

    private ImageIcon createOpenIcon() {
        if (this.mLayout.isBMWMotorrad()) {
            return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_nav.gif"), this.mLayout.getPrimaryForeground());
        }
        return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_nav.gif"), this.mLayout.getPrimaryBackground());
    }

    private ImageIcon createCloseIcon() {
        if (this.mLayout.isBMWMotorrad()) {
            return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen_nav.gif"), this.mLayout.getPrimaryForeground());
        }
        return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen_nav.gif"), this.mLayout.getPrimaryBackground());
    }
}

