/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.navigation.ControllerETKSearch;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import webetk.resources.Resource;

public class ETKErgebnisDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    MarkenLayout mMarkenLayout;
    JScrollPane mScrollPane;
    JTable mTable;
    JPanel buttonPanel;
    JLabelButton button;
    Frame mOwner;

    public ETKErgebnisDialog(Frame owner, String title, MarkenLayout markenLayout) throws HeadlessException {
        super(owner, title);
        this.mMarkenLayout = markenLayout;
        this.mOwner = owner;
        this.init();
    }

    public ETKErgebnisDialog(Frame owner, MarkenLayout markenLayout) throws HeadlessException {
        super(owner);
        this.mOwner = owner;
        this.mMarkenLayout = markenLayout;
        this.init();
    }

    public ETKErgebnisDialog(MarkenLayout markenLayout) {
        this.mMarkenLayout = markenLayout;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.createComponents();
        this.setLayout(this.mMarkenLayout);
        this.button.addMouseListener(ControllerETKSearch.getInstance());
    }

    private void createComponents() {
        this.mScrollPane = new JScrollPane();
        this.mScrollPane.setPreferredSize(new Dimension(400, 400));
        this.mTable = new JTable();
        this.mScrollPane.getViewport().add(this.mTable);
        this.getContentPane().add((Component)this.mScrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.button = new JLabelButton(Resource.getInstance().getOk(), "OKButton", true, this.mMarkenLayout);
        this.buttonPanel.add(this.button);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void setLayout(MarkenLayout layout) {
        this.mMarkenLayout = layout;
        this.mTable.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mTable.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mTable.setFont(Constants.Layout.getZubDefaultFont());
        this.mScrollPane.getViewport().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mScrollPane.getViewport().setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.mScrollPane.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mScrollPane.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.buttonPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.buttonPanel.setForeground(this.mMarkenLayout.getPrimaryForeground());
    }

    public JTable getTable() {
        return this.mTable;
    }

    public JLabelButton getButton() {
        return this.button;
    }

    public void setOptimalSize() {
        this.mTable.setAutoResizeMode(3);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.mTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.mTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        this.mTable.getColumnModel().getColumn(1).setMaxWidth(25);
        this.mTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.mTable.getColumnModel().getColumn(2).setCellRenderer(renderer);
        this.mTable.getColumnModel().getColumn(2).setMaxWidth(90);
        this.mTable.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.setDialogLocation();
    }

    public void setDialogLocation() {
        if (this.mOwner != null) {
            int xOwner = this.mOwner.getX();
            int yOwner = this.mOwner.getY();
            int wOwner = this.mOwner.getWidth();
            int hOwner = this.mOwner.getHeight();
            this.setLocation(xOwner + wOwner / 2 - this.getWidth() / 2, yOwner + hOwner / 2 - this.getHeight() / 2);
        }
    }

    public void updateView() {
        this.setVisible(true);
        this.setModal(true);
        this.getTable().validate();
        this.validate();
        this.pack();
        this.setDialogLocation();
    }
}

