/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.navigation.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.navigation.suche.KategorieNodeData;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.navigation.suche.UnterkategorieNodeData;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JScrollPane;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import webetk.app.zub.suche.HitListenHauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktId;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.resources.Resource;

public class TrefferlistePanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JTree trefferlisteJTree = null;
    private TrefferlisteCellRenderer treeCellRenderer = null;
    private TrefferlisteSelectionListener treeSelectionListener = null;
    private ArrayList<HitListenHauptKategorie> mTrefferliste = null;
    private Hashtable<ProduktId, ProduktListenElement> mTrefferlisteHashtable = null;
    private DefaultMutableTreeNode topTreeNode = null;
    private JScrollPane scrollPane = null;
    private JPanel mainHeaderPanel = null;
    private JLabel headerName = null;
    private JLabel openIcon = null;
    private JLabel closeIcon = null;
    private MarkenLayout mLayout = WorkflowController.getInstance().getMarkenLayout();

    public TrefferlistePanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.mainHeaderPanel = new JPanel(new GridBagLayout());
        this.mainHeaderPanel.setMinimumSize(new Dimension(200, 28));
        this.mainHeaderPanel.setPreferredSize(new Dimension(200, 28));
        this.headerName = new JLabel(Resource.getInstance().getHitliste());
        this.headerName.setBoldFont();
        this.headerName.setForeground(Color.WHITE);
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 1, 18, new Insets(0, 5, 0, 0));
        this.mainHeaderPanel.add((Component)this.headerName, gbc);
        this.openIcon = new JLabel(this.createOpenIcon());
        this.openIcon.setName("OPENTREFFER");
        this.openIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.closeIcon = new JLabel(this.createCloseIcon());
        this.closeIcon.setName("CLOSETREFFER");
        this.closeIcon.setCursor(Cursor.getPredefinedCursor(12));
        gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 1, 13, new Insets(0, 5, 0, 3));
        this.mainHeaderPanel.add((Component)this.closeIcon, gbc);
        gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.add((Component)this.mainHeaderPanel, gbc);
        this.initTree();
        this.setBackground(this.mLayout.getPrimaryBackground());
    }

    public void initTree() {
        if (this.trefferlisteJTree == null) {
            this.trefferlisteJTree = new JTree();
            this.treeSelectionListener = new TrefferlisteSelectionListener();
            this.trefferlisteJTree.addTreeSelectionListener(this.treeSelectionListener);
            this.trefferlisteJTree.getSelectionModel().setSelectionMode(1);
            this.trefferlisteJTree.setShowsRootHandles(false);
            this.trefferlisteJTree.setBackground(this.mLayout.getPrimaryBackground());
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getViewport().add(this.trefferlisteJTree);
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 18, new Insets(2, 2, 0, 0));
            this.add((Component)this.scrollPane, gbc);
            this.trefferlisteJTree.setEditable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTrefferlisteSelectionChanged(KategorieNodeData kategorie, UnterkategorieNodeData unterkategorie, ArrayList<ProduktListenElement> selectedNodeList) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setAktuellesPanel("");
            }
            if (MainController.getInstance().getMainFrame().getMainPanel().getSubcategory() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getSubcategory().setZubehoerList(selectedNodeList);
            } else if (MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel() != null) {
                MainController.getInstance().getMainFrame().getMainPanel().getProduktListPanel().setProduktList(selectedNodeList);
            } else {
                MainController.getInstance().getMainFrame().getMainPanel().showProduktListe(kategorie == null ? null : kategorie.getKategorie(), unterkategorie == null ? null : unterkategorie.getUnterkategorie(), selectedNodeList);
            }
            if (!WorkflowController.getInstance().isFzBedIdentified() && GlobalObjects.getInstance().getIpacData().getFahrzeug() == null) {
                ControllerMenuBar.getInstance().getMenuBar().disableIcon("add");
                ControllerMenuBar.getInstance().getMenuBar().disableIcon("remove");
            }
            MainController.getInstance().getMainFrame().getStatusBar().removeAllStatusFromIndex(2);
            ControllerProduktListPanel.getInstance().setTrefferlisteKategorie(kategorie);
            ControllerProduktListPanel.getInstance().setTrefferlisteUnterkategorie(unterkategorie);
            WorkflowController.getInstance().changeState("PRODUCTLIST");
            MainController.getInstance().getMainFrame().getStatusBar().changeValueHashTable(2, "PRODUCTLIST");
            MainController.getInstance().getMainFrame().invalidate();
            MainController.getInstance().getMainFrame().getMainPanel().updateUI();
            MainController.getInstance().getMainFrame().getMainPanel().invalidate();
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private DefaultMutableTreeNode getTreeNode(TreePath path) {
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ProduktListenElement> getSelectedNodeList(DefaultMutableTreeNode node) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (node == null) {
                ArrayList<ProduktListenElement> arrayList = null;
                return arrayList;
            }
            Object selectedObject = node.getUserObject();
            if (selectedObject == null) {
                ArrayList<ProduktListenElement> arrayList = null;
                return arrayList;
            }
            ArrayList<ProduktListenElement> elementList = null;
            ArrayList<ProduktListenElement> gesamtElementList = null;
            int fetchPage = 1;
            if (node.isRoot()) {
                DefaultMutableTreeNode tmpNodeKategorie = null;
                if (this.topTreeNode.getChildCount() > 0) {
                    gesamtElementList = new ArrayList<ProduktListenElement>();
                }
                for (int i = 0; i < this.topTreeNode.getChildCount(); ++i) {
                    tmpNodeKategorie = (DefaultMutableTreeNode)this.topTreeNode.getChildAt(i);
                    selectedObject = tmpNodeKategorie.getUserObject();
                    if (!(selectedObject instanceof KategorieNodeData) || ((KategorieNodeData)selectedObject).isGesamtNode()) continue;
                    if (((KategorieNodeData)selectedObject).getElementList() == null) {
                        elementList = this.getListForHkNode(tmpNodeKategorie, fetchPage);
                        ((KategorieNodeData)selectedObject).setElementList(elementList);
                        ((KategorieNodeData)selectedObject).setElementList(elementList);
                        ((KategorieNodeData)selectedObject).getKategorie().getBteResults().size();
                    }
                    gesamtElementList.addAll(((KategorieNodeData)selectedObject).getElementList());
                }
                ArrayList<ProduktListenElement> arrayList = gesamtElementList;
                return arrayList;
            }
            if (selectedObject instanceof KategorieNodeData) {
                if (!((KategorieNodeData)selectedObject).isGesamtNode()) {
                    if (((KategorieNodeData)selectedObject).getElementList() == null) {
                        elementList = this.getListForHkNode(node, fetchPage);
                        ((KategorieNodeData)selectedObject).setElementList(elementList);
                        ((KategorieNodeData)selectedObject).getKategorie().getBteResults().size();
                    }
                    ArrayList<ProduktListenElement> tmpNodeKategorie = ((KategorieNodeData)selectedObject).getElementList();
                    return tmpNodeKategorie;
                }
            } else if (selectedObject instanceof UnterkategorieNodeData) {
                if (((UnterkategorieNodeData)selectedObject).isGesamtNode()) {
                    DefaultMutableTreeNode tmpNodeKategorie = (DefaultMutableTreeNode)node.getParent();
                    if (tmpNodeKategorie != null && tmpNodeKategorie.getUserObject() instanceof KategorieNodeData) {
                        if (tmpNodeKategorie.getChildCount() > 0) {
                            gesamtElementList = new ArrayList();
                        }
                        gesamtElementList = this.getListForHkNode(tmpNodeKategorie, fetchPage);
                    }
                    ArrayList<ProduktListenElement> arrayList = gesamtElementList;
                    return arrayList;
                }
                if (((UnterkategorieNodeData)selectedObject).getElementList() == null) {
                    elementList = this.getElementList(((UnterkategorieNodeData)selectedObject).getUnterkategorie().getBteNrn(), fetchPage);
                    ((UnterkategorieNodeData)selectedObject).setElementList(elementList);
                    ((UnterkategorieNodeData)selectedObject).getUnterkategorie().getBteNrn().size();
                }
                ArrayList<ProduktListenElement> arrayList = ((UnterkategorieNodeData)selectedObject).getElementList();
                return arrayList;
            }
            ArrayList<ProduktListenElement> arrayList = null;
            return arrayList;
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ArrayList<ProduktListenElement> getListForHkNode(TreeNode node, int fetchPage) {
        ArrayList<ProduktListenElement> gesamtElementList = new ArrayList<ProduktListenElement>();
        for (int j = 0; j < node.getChildCount(); ++j) {
            DefaultMutableTreeNode unterkategorieNode = (DefaultMutableTreeNode)node.getChildAt(j);
            gesamtElementList.addAll(this.getListForUkNode(unterkategorieNode, fetchPage));
        }
        return gesamtElementList;
    }

    private ArrayList<ProduktListenElement> getListForUkNode(DefaultMutableTreeNode unterkategorieNode, int fetchPage) {
        ArrayList<ProduktListenElement> gesamtElementList = new ArrayList<ProduktListenElement>();
        Object selectedObject = unterkategorieNode.getUserObject();
        if (selectedObject instanceof UnterkategorieNodeData && !((UnterkategorieNodeData)selectedObject).isGesamtNode()) {
            if (((UnterkategorieNodeData)selectedObject).getElementList() == null) {
                ArrayList<ProduktListenElement> elementList = this.getElementList(((UnterkategorieNodeData)selectedObject).getUnterkategorie().getBteNrn(), fetchPage);
                ((UnterkategorieNodeData)selectedObject).setElementList(elementList);
                ((UnterkategorieNodeData)selectedObject).getUnterkategorie().getBteNrn().size();
            }
            gesamtElementList.addAll(((UnterkategorieNodeData)selectedObject).getElementList());
        }
        return gesamtElementList;
    }

    public ArrayList<ProduktListenElement> getListForHkUk(String hk, String uk, int fetchPage) {
        TreeModel model = this.trefferlisteJTree.getModel();
        Object nodeRoot = model.getRoot();
        int anzHk = model.getChildCount(nodeRoot);
        for (int ii = 0; ii < anzHk; ++ii) {
            DefaultMutableTreeNode nodeHk = (DefaultMutableTreeNode)model.getChild(nodeRoot, ii);
            KategorieNodeData nodeDataHk = (KategorieNodeData)nodeHk.getUserObject();
            if (!nodeDataHk.getKategorieText().equals(hk)) continue;
            int anzUk = model.getChildCount(nodeHk);
            for (int kk = 0; kk < anzUk; ++kk) {
                DefaultMutableTreeNode nodeUk = (DefaultMutableTreeNode)model.getChild(nodeHk, kk);
                UnterkategorieNodeData nodeDataUk = (UnterkategorieNodeData)nodeUk.getUserObject();
                if (!nodeDataUk.getUnterkategorie().getName().equals(uk) || nodeDataUk.isGesamtNode()) continue;
                return this.getListForUkNode(nodeUk, fetchPage);
            }
        }
        return null;
    }

    private ArrayList<ProduktListenElement> getElementList(List<?> produktIdList, int fetchPage) {
        ArrayList<ProduktListenElement> trefferliste;
        if (produktIdList == null || produktIdList.size() <= 0) {
            return null;
        }
        boolean isLifestyle = false;
        if (MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie() != null) {
            isLifestyle = MainController.getInstance().getMainFrame().getInfoPanel().getNavigationPanel().getSelectedUnterkategorie().isLifestyle();
        }
        if ((trefferliste = NavigationPanelDataLoader.loadZubehoer(produktIdList, fetchPage, isLifestyle)) != null && trefferliste.size() > 0 && trefferliste.size() == produktIdList.size()) {
            if (this.mTrefferlisteHashtable == null) {
                this.mTrefferlisteHashtable = new Hashtable();
            }
            for (int i = 0; i < trefferliste.size(); ++i) {
                if (this.mTrefferlisteHashtable.containsKey((ProduktId)produktIdList.get(i))) continue;
                this.mTrefferlisteHashtable.put((ProduktId)produktIdList.get(i), trefferliste.get(i));
            }
        }
        return trefferliste;
    }

    public void setTree(ArrayList<HitListenHauptKategorie> newTrefferliste) {
        this.mTrefferliste = newTrefferliste;
        this.buildTree();
    }

    public void deleteTree() {
        this.mTrefferliste = null;
        this.buildTree();
    }

    private void buildTree() {
        this.trefferlisteJTree.removeTreeSelectionListener(this.treeSelectionListener);
        if (this.mTrefferliste == null || this.mTrefferliste.size() <= 0) {
            this.trefferlisteJTree.setModel(null);
            this.trefferlisteJTree.addTreeSelectionListener(this.treeSelectionListener);
            return;
        }
        this.topTreeNode = new DefaultMutableTreeNode("");
        DefaultMutableTreeNode nodeKategorie = null;
        DefaultMutableTreeNode nodeUnterkategorie = null;
        HitListenHauptKategorie kategorie = null;
        HitListenUnterkategorie unterkategorie = null;
        UnterkategorieNodeData unterkategorieNodeData = null;
        int anzahlElemente = 0;
        for (int i = 0; i < this.mTrefferliste.size(); ++i) {
            kategorie = this.mTrefferliste.get(i);
            nodeKategorie = new DefaultMutableTreeNode(new KategorieNodeData(kategorie, kategorie.getBteResults().size()));
            this.topTreeNode.add(nodeKategorie);
            anzahlElemente += kategorie.getBteResults().size();
            for (int j = 0; j < kategorie.getUnterkategorie().size(); ++j) {
                unterkategorie = kategorie.getUnterkategorie().get(j);
                if (j == 0) {
                    unterkategorieNodeData = new UnterkategorieNodeData();
                    unterkategorieNodeData.setGesamtNode(true);
                    unterkategorieNodeData.setUnterkategorie(unterkategorie);
                    unterkategorieNodeData.setKategorieText(kategorie.getName());
                    unterkategorieNodeData.setAnzeigeText(Resource.getInstance().getAlleProdukte() + " (" + String.valueOf(kategorie.getBteResults().size() + ")"));
                    nodeUnterkategorie = new DefaultMutableTreeNode(unterkategorieNodeData);
                    nodeKategorie.add(nodeUnterkategorie);
                }
                nodeUnterkategorie = new DefaultMutableTreeNode(new UnterkategorieNodeData(unterkategorie, unterkategorie.getBteNrn().size(), kategorie.getName()));
                nodeKategorie.add(nodeUnterkategorie);
            }
        }
        this.topTreeNode.setUserObject(Resource.getInstance().getAlleProdukte() + " (" + String.valueOf(anzahlElemente + ")"));
        this.trefferlisteJTree.setModel(new DefaultTreeModel(this.topTreeNode));
        this.trefferlisteJTree.expandRow(0);
        this.trefferlisteJTree.addTreeSelectionListener(this.treeSelectionListener);
    }

    public void setStyle() {
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.trefferlisteJTree.setBackground(this.mLayout.getPrimaryBackground());
        this.treeCellRenderer = new TrefferlisteCellRenderer();
        this.trefferlisteJTree.setCellRenderer(this.treeCellRenderer);
        this.setHeadersColor();
        this.openIcon.setIcon(this.createOpenIcon());
        this.closeIcon.setIcon(this.createCloseIcon());
        this.mainHeaderPanel.validate();
    }

    private void setHeadersColor() {
        this.mainHeaderPanel.setBackground(this.mLayout.getNaviHeaderColor());
        this.mainHeaderPanel.getComponent(0).setForeground(this.mLayout.getNaviHeaderFont());
        this.mainHeaderPanel.setBorder(this.mLayout.getNaviBorderOpenheader());
        this.setBorder(this.mLayout.getNaviBorderSelect());
    }

    public JTree getTree() {
        return this.trefferlisteJTree;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JPanel getMainHeaderPanel() {
        return this.mainHeaderPanel;
    }

    public void setIcon(String action) {
        if (action.equals("OPEN")) {
            this.mainHeaderPanel.removeAll();
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 1, 18, new Insets(0, 5, 0, 0));
            this.mainHeaderPanel.add((Component)this.headerName, gbc);
            gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 1, 13, new Insets(0, 5, 0, 3));
            this.mainHeaderPanel.add((Component)this.openIcon, gbc);
        } else if (action.equals("CLOSE")) {
            this.mainHeaderPanel.removeAll();
            GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 1, 18, new Insets(0, 5, 0, 0));
            this.mainHeaderPanel.add((Component)this.headerName, gbc);
            gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 1, 13, new Insets(0, 5, 0, 3));
            this.mainHeaderPanel.add((Component)this.closeIcon, gbc);
        }
        this.mainHeaderPanel.validate();
        this.mainHeaderPanel.updateUI();
        this.updateUI();
    }

    public JLabel getOpenIcon() {
        return this.openIcon;
    }

    public JLabel getCloseIcon() {
        return this.closeIcon;
    }

    private ImageIcon createOpenIcon() {
        if (this.mLayout.isBMWMotorrad()) {
            return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_nav.gif"), this.mLayout.getPrimaryForeground());
        }
        return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "aufklappen_nav.gif"), this.mLayout.getPrimaryBackground());
    }

    private ImageIcon createCloseIcon() {
        if (this.mLayout.isBMWMotorrad()) {
            return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen_nav.gif"), this.mLayout.getPrimaryForeground());
        }
        return this.mLayout.getTransparentImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + "zuklappen_nav.gif"), this.mLayout.getPrimaryBackground());
    }

    private class TrefferlisteSelectionListener
    implements TreeSelectionListener {
        private TrefferlisteSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = TrefferlistePanel.this.getTreeNode(event.getPath());
            KategorieNodeData kategorie = null;
            UnterkategorieNodeData unterkategorie = null;
            Object selectedObject = node.getUserObject();
            if (selectedObject != null) {
                if (selectedObject instanceof KategorieNodeData) {
                    kategorie = (KategorieNodeData)selectedObject;
                } else if (selectedObject instanceof UnterkategorieNodeData) {
                    unterkategorie = (UnterkategorieNodeData)selectedObject;
                }
            }
            TrefferlistePanel.this.handleTrefferlisteSelectionChanged(kategorie, unterkategorie, TrefferlistePanel.this.getSelectedNodeList(node));
        }
    }

    private class TrefferlisteCellRenderer
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = 1L;
        private JPanel nodePanel = new JPanel(new CardLayout());
        private JLabel nodeLabel = new JLabel();

        public TrefferlisteCellRenderer() {
            this.nodeLabel.setBackground(TrefferlistePanel.this.mLayout.getPrimaryBackground());
            this.nodeLabel.setForeground(TrefferlistePanel.this.mLayout.getPrimaryForeground());
            this.nodePanel.setBackground(TrefferlistePanel.this.mLayout.getPrimaryBackground());
            this.nodePanel.add((Component)this.nodeLabel, "");
            this.setLeafIcon(null);
            this.setOpenIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeObject = node.getUserObject();
            if (nodeObject != null) {
                this.nodeLabel.setText(nodeObject.toString());
            }
            return this.nodePanel;
        }
    }
}

