/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.ControllerAgbDialog;
import de.esg.zub.common.ControllerAnfrageSave;
import de.esg.zub.common.ControllerAngebotSave;
import de.esg.zub.common.ControllerPrintDialog;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MainFrame;
import de.esg.zub.common.Version;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.ControllerConfigurationPanel;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.anfrage.AnfragenContainer;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.content.marketing.ControllerFBA;
import de.esg.zub.configurator.content.marketing.ControllerFBI;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.PrototypeMenuBar;
import de.esg.zub.configurator.workflow.VorgangKonfigView;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.score.ZubScoreDataCreator;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.ControllerWelcomePanel;
import de.esg.zub.welcome.WelcomePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.ObjectLockedException;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.etkscore.ZubIspaZubehoerpakete;
import webetk.resources.Resource;

public class ControllerMenuBar
implements ActionListener,
MouseListener,
Observer {
    private static MainFrame mMainFrame = null;
    private static ControllerMenuBar mInstance = null;
    private static PrototypeMenuBar mMenuBar = null;
    private static final int MAXANZAHLVORGANG = 6;
    private static Logger log;

    private ControllerMenuBar() {
    }

    public static ControllerMenuBar getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerMenuBar();
            log = Logger.getLogger(ControllerMenuBar.class);
            log.debug((Object)"WelcomeController initialisieren");
            ControllerMenuBar.init();
        }
        return mInstance;
    }

    public static void reset() {
        mInstance = null;
    }

    private static void init() {
        mMenuBar = new PrototypeMenuBar(WorkflowController.getInstance().getMarkenLayout());
        mMainFrame = MainController.getInstance().getMainFrame();
        mMainFrame.addMenuBar(mMenuBar);
        mMenuBar.getFBAIcon().addMouseListener(mInstance);
        mMenuBar.getFBIIcon().addMouseListener(mInstance);
        mMenuBar.getPrintIcon().addMouseListener(mInstance);
        mMenuBar.getMenuItemFileBeenden().addActionListener(mInstance);
        mMenuBar.getMenuItemFileNew().addActionListener(mInstance);
        mMenuBar.getMenuItemAgb().addActionListener(mInstance);
        mMenuBar.getMenuItemAbout().addActionListener(mInstance);
        mMenuBar.getMenuItemSpeichernAnfrage().addActionListener(mInstance);
        mMenuBar.getMenuItemSpeichernAngebot().addActionListener(mInstance);
        mMenuBar.getMenuItemExit().addActionListener(mInstance);
        mMenuBar.getMenuItemFilePrint().addActionListener(mInstance);
        mMenuBar.getMenuItemInfoContents().addActionListener(mInstance);
        if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            mMenuBar.getMenuItemISPA().addActionListener(mInstance);
        }
        mMenuBar.addObserver(mInstance);
    }

    public boolean addVorgang() {
        if (this.checkAnzahlVorgaenge()) {
            String vorgangsName = "";
            Integer vorgangsIdObject = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getVorgangsId();
            List<Integer> vorgangsIdList = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgangsId();
            List<String> vorgangsIdNamen = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgangsNamen();
            int index = vorgangsIdList.indexOf(vorgangsIdObject);
            vorgangsName = index < 0 ? String.valueOf(vorgangsIdObject) : vorgangsIdNamen.get(index);
            if (!mMenuBar.getVorgaenge().containsKey(vorgangsIdObject)) {
                mMenuBar.addVorgang(vorgangsIdObject, vorgangsName);
                ControllerConfigurationPanel.getInstance().removeAllConfigurations();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean checkAnzahlVorgaenge() {
        if (mMenuBar.getCountVorgaenge() + 1 <= 6) {
            return true;
        }
        MainController.getInstance().getMainFrame().getMainPanel().showErrorMessage(Resource.getInstance().getMaxcountvorgang());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == mMenuBar.getMenuItemFileBeenden()) {
            MainController.getInstance().getMainFrame().setHidden(true);
            MainController.getInstance().exit(0);
        } else if (event.getSource() == mMenuBar.getMenuItemAgb()) {
            ControllerAgbDialog.getInstance().showAgb();
        } else if (event.getSource() == mMenuBar.getMenuItemInfoContents()) {
            MainController.getInstance().getMainFrame().showErrorMessage(ZubCustomizable.getInstance().getFussnoteVerbindlichkeit());
        } else if (event.getSource() == mMenuBar.getMenuItemAbout()) {
            Version.getInstance().show();
        } else if (event.getSource() == mMenuBar.getMenuItemSpeichernAnfrage()) {
            if (GlobalObjects.getInstance().getIpacData().getAnfrage() == null || !GlobalObjects.getInstance().getIpacData().getAnfrage().isExplizitGespeichert()) {
                ControllerAnfrageSave.getInstance().getAnfrageSavedialog().showDialog(WorkflowController.getInstance().getMarkenLayout());
            } else {
                try {
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    ControllerMiniaturansicht.getInstance().getMiniaturMarketing().getPanel().setCursor(Cursor.getPredefinedCursor(3));
                    AnfragenDataLoader.speichereAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getFehlerBeimSpeichern(), 0);
                }
                finally {
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                    ControllerMiniaturansicht.getInstance().getMiniaturMarketing().getPanel().setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        } else if (event.getSource() == mMenuBar.getMenuItemSpeichernAngebot()) {
            ControllerAngebotSave saveCtrl = new ControllerAngebotSave();
            saveCtrl.getAngebotSavedialog().showDialog(WorkflowController.getInstance().getMarkenLayout());
        } else if (event.getSource() == mMenuBar.getMenuItemFileNew()) {
            String alteMarke = WorkflowController.getInstance().getMarkenLayout().getMarke();
            String altesProdukt = WorkflowController.getInstance().getMarkenLayout().getProdukt();
            this.returnToWelcomePanel(false);
            ControllerWelcomePanel instance = ControllerWelcomePanel.getInstance();
            WelcomePanel welcomePanel = instance.getWelcomePanel();
            if (GlobalObjects.getInstance().getSessionInfo().getUserMarken().size() > 1) {
                welcomePanel.setPanel(instance.getMarkenPanel());
            } else {
                ControllerWelcomePanel.setMarkeProduktartGlobal(alteMarke, altesProdukt);
                WorkflowController.getInstance().changeState("CONFIG");
            }
            welcomePanel.setPanel(instance.getMarkenPanel());
        } else if (event.getSource() == mMenuBar.getMenuItemISPA()) {
            System.out.println("RETURN TO ISPA ! ! ! ! ! ! ! ! ! !");
            ZubIspaZubehoerpakete zubPaket = ZubScoreDataCreator.getInstance().calculateAllKonfigurationen();
            if (zubPaket == null) {
                return;
            }
            GlobalObjects.getInstance().getIpacData().setIspaZubpakete(zubPaket);
            MainController.getInstance().getMainFrame().setVisible(false);
            MainController.getInstance().getMainFrame().setHidden(true);
        } else if (event.getSource() == mMenuBar.getMenuItemFilePrint()) {
            ControllerPrintDialog.getInstance().getPrintDialog().showDialog(WorkflowController.getInstance().getMarkenLayout());
        } else if (event.getSource() == mMenuBar.getMenuItemExit()) {
            this.returnToWelcomePanel(true);
        }
    }

    private void returnToWelcomePanel(boolean closeAnfrage) {
        AnfragenContainer anfragenContainer;
        ArrayList<AnfragenContainer> liste;
        Anfrage anfrage;
        WorkflowController.getInstance().changeState("WELCOME");
        if (GlobalObjects.getInstance().getIpacData().getAnfrage() != null && GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId() != 0) {
            try {
                AnfragenDataLoader.entsperreAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
            }
            catch (ObjectLockedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage()) != null && !closeAnfrage && anfrage.getVorgang().getKonfiguration().getAngebot() == null) {
            ControllerAnfragenPanel.getInstance().getAnfragenPanel().getAnfragenleiste().addAnfrageContainer(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getPlainProduktName(), GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
        } else if (anfrage != null && closeAnfrage && (liste = ControllerAnfragenPanel.getInstance().getAnfragenPanel().getAnfragenleiste().getAnfragenContainerList()).contains(anfragenContainer = new AnfragenContainer(WorkflowController.getInstance().getMarkenLayout(), anfrage.getAnfrageName(), anfrage.getAnfrageId()))) {
            ControllerAnfragenPanel.getInstance().getAnfragenPanel().getAnfragenleiste().removeAnfrageContainer(liste.indexOf(anfragenContainer));
        }
        MainController.getInstance().getMainFrame().removeMenuBar();
        GlobalObjects.getInstance().getIpacData().setAnfrage(null);
        ControllerStatusBar.getInstance().emptyStatusBar();
        ControllerStatusBar.getInstance().clearDialoge();
        ControllerFBI.getModel().setFahrzeug(null);
        ControllerMainPanel.getInstance().getMainPanel().removeFBA();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (event.getComponent().getName().startsWith("schliessen_")) {
            Integer id = Integer.valueOf(event.getComponent().getName().substring("schliessen_".length()));
            VorgangKonfigView vorgangView = mMenuBar.getVorgaenge().get(id);
            if (!vorgangView.isSelected()) {
                vorgangView.getSchliessen().setIcon(new ImageIcon(ImageCache.getInstance().getImage(WorkflowController.getInstance().getMarkenLayout().getIconPath() + "schliessen_mouseover.gif")));
                vorgangView.validate();
            }
            vorgangView.getSchliessen().setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (event.getComponent().getName().startsWith("schliessen_")) {
            Integer id = Integer.valueOf(event.getComponent().getName().substring("schliessen_".length()));
            VorgangKonfigView vorgangView = mMenuBar.getVorgaenge().get(id);
            if (!vorgangView.isSelected()) {
                vorgangView.getSchliessen().setIcon(new ImageIcon(ImageCache.getInstance().getImage(WorkflowController.getInstance().getMarkenLayout().getIconPath() + "schliessen_inaktiv.gif")));
                vorgangView.validate();
            }
            vorgangView.getSchliessen().setBorder(BorderFactory.createEmptyBorder());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            if (event.getComponent().getName().equals("print_en")) {
                ControllerPrintDialog.getInstance().getPrintDialog().showDialog(WorkflowController.getInstance().getMarkenLayout());
            } else if (event.getComponent().getName().equals("addFahrzeug_en")) {
                if (!ControllerMainPanel.getInstance().getMainPanel().isFbaVisible()) {
                    ControllerFBA.getInstance().showFBA();
                } else {
                    ControllerMainPanel.getInstance().getMainPanel().removeFBA();
                }
            } else if (event.getComponent().getName().equals("removeFahrzeug_en")) {
                GlobalObjects.getInstance().getIpacData().setFahrzeug(null);
                WorkflowController.getInstance().setFzBedIdentified(false);
                MainController.getInstance().getMainFrame().getMainPanel().removeConfigPanel();
                WorkflowController.getInstance().changeState("CONFIG");
                mMenuBar.disableIcon("add");
                mMenuBar.disableIcon("remove");
                mMainFrame.getInfoPanel().getNavigationPanel().enableFahrzeugAuswahlControls();
                if (ControllerMainPanel.getInstance().getMainPanel().isConfigPanelSet()) {
                    ControllerMainPanel.getInstance().getMainPanel().getConfigPanel().removeAllConfigurations();
                    ControllerMainPanel.getInstance().getMainPanel().removeConfigPanel();
                }
                ControllerMenuBar.getInstance().getMenuBar().deselectAllButtons();
            } else if (event.getComponent().getName().startsWith("text_")) {
                if (mMenuBar.getVorgaenge() != null) {
                    Integer id = Integer.valueOf(((JLabel)event.getComponent()).getName().substring("text_".length()));
                    this.handleLadeVorgangEvent((int)id);
                }
            } else if (event.getComponent().getName().startsWith("schliessen_")) {
                Integer id = Integer.valueOf(event.getComponent().getName().substring("schliessen_".length()));
                String fulName = mMenuBar.getVorgaenge().get(id).getFulName();
                String msg = Resource.getInstance().getVorgangLoeschenMeldung();
                msg = msg.replace("{0}", fulName);
                if (MainController.getInstance().getMainFrame().showConfirmMessage(msg)) {
                    this.handleVorgangSchliessen(id);
                }
            }
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    public void handleVorgangSchliessen(Integer id) {
        if (id == 0) {
            try {
                ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(WorkflowController.getInstance().getActiveState().getName());
            }
            catch (Exception e) {
                log.error((Object)"speichereKonfiguration", (Throwable)e);
                e.printStackTrace();
            }
            id = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getVorgangsId();
        }
        if (mMenuBar.getReihenfolge().size() > 1) {
            if (mMenuBar.getVorgaenge().get(id).isSelected()) {
                if (ControllerMainPanel.getInstance().getMainPanel().getConfigPanel() != null) {
                    ControllerMainPanel.getInstance().getMainPanel().getConfigPanel().removeAllConfigurations();
                    ControllerMainPanel.getInstance().getMainPanel().removeConfigPanel();
                }
                Integer id_nextSelected = null;
                for (int i = 0; i < mMenuBar.getReihenfolge().size(); ++i) {
                    if (!mMenuBar.getReihenfolge().get(i).equals(id)) continue;
                    if (i == 0) {
                        id_nextSelected = mMenuBar.getReihenfolge().get(i + 1);
                        break;
                    }
                    id_nextSelected = mMenuBar.getReihenfolge().get(i - 1);
                    break;
                }
                if (id_nextSelected != null) {
                    this.handleLadeVorgangEvent(id_nextSelected);
                }
            }
        } else {
            AnfragenContainer anfragenContainer;
            ArrayList<AnfragenContainer> liste;
            if (ControllerMainPanel.getInstance().getMainPanel().isConfigPanelSet()) {
                ControllerMainPanel.getInstance().getMainPanel().getConfigPanel().removeAllConfigurations();
                ControllerMainPanel.getInstance().getMainPanel().removeConfigPanel();
            }
            ControllerStatusBar.getInstance().clearDialoge();
            Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
            if (anfrage != null && (liste = ControllerAnfragenPanel.getInstance().getAnfragenPanel().getAnfragenleiste().getAnfragenContainerList()).contains(anfragenContainer = new AnfragenContainer(WorkflowController.getInstance().getMarkenLayout(), anfrage.getAnfrageName(), anfrage.getAnfrageId()))) {
                ControllerAnfragenPanel.getInstance().getAnfragenPanel().getAnfragenleiste().removeAnfrageContainer(liste.indexOf(anfragenContainer));
            }
            WorkflowController.getInstance().setFzBedIdentified(false);
            ControllerConfigurationPanel.getInstance().getConfigurationPanel().deselectAllButtons();
            WorkflowController.getInstance().changeState("CONFIG");
        }
        this.deleteVorgangFromViewAndDB(id);
    }

    private void deleteVorgangFromViewAndDB(Integer id) {
        mMenuBar.removeVorgang(id);
        Iterator<Integer> it = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgangsId().iterator();
        while (it.hasNext()) {
            Integer vorgangsId = it.next();
            if (!vorgangsId.equals(id)) continue;
            it.remove();
        }
        try {
            KalkulationDataLoader.loescheVorgang(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    public void updateNewVorgang(Vorgang vorgang) {
        for (Integer key : mMenuBar.getVorgaenge().keySet()) {
            if (key != 0) continue;
            try {
                mMenuBar.updateVorgangView(key, vorgang.getVorgangsId());
            }
            catch (NoDataFoundException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            break;
        }
    }

    public PrototypeMenuBar getMenuBar() {
        return mMenuBar;
    }

    @Override
    public void update(Observable o, Object arg) {
        VorgangKonfigView vView = (VorgangKonfigView)arg;
        vView.getSchliessen().addMouseListener(this);
        vView.getBenennung().addMouseListener(this);
    }

    public void handleLadeVorgangEvent(Integer id) {
        if (mMenuBar.getVorgaenge().containsKey(id)) {
            try {
                AnfrageHandler.getInstance().ladeVorgang(id);
                Vorgang aktuellerVorgang = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang();
                boolean forceReload = true;
                this.updateViewComponents(id, aktuellerVorgang, forceReload);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage());
                e1.printStackTrace();
                return;
            }
        }
    }

    public void updateViewComponents(int id, Vorgang aktuellerVorgang, boolean forceReload) {
        Fahrzeug fzg = aktuellerVorgang.getFahrzeug();
        GlobalObjects.getInstance().getIpacData().setFahrzeug(fzg);
        if (fzg != null) {
            mMenuBar.enableIcon("add");
            mMenuBar.enableIcon("remove");
        } else {
            mMenuBar.disableIcon("add");
            mMenuBar.disableIcon("remove");
        }
        ControllerMainPanel.getInstance().getMainPanel().addConfigPanel();
        ControllerConfigurationPanel.getInstance().removeAllConfigurations();
        ControllerConfigurationPanel.getInstance().addAllConfigurations(aktuellerVorgang.getKonfigurationsNamen(), aktuellerVorgang.getKonfigurationsId(), aktuellerVorgang.getKonfiguration().getKonfigurationsId(), forceReload);
        mMenuBar.selectButton(id);
        ControllerConfigurationPanel.getInstance().getConfigurationPanel().selectButton(aktuellerVorgang.getKonfiguration().getKonfigurationsId());
        String hauptkat = aktuellerVorgang.getHauptKategorie().getName();
        String unterkat = aktuellerVorgang.getUnterKategorie().getName();
        ControllerStatusBar.getInstance().getStatusBar().setConfigurationStatusbar(ControllerStatusBar.createStatusHauptkat(hauptkat), unterkat);
    }

    public void setSpeichern() {
        String name = WorkflowController.getInstance().getActiveState().getName();
        if (name.equals("TECHNIK") || name.equals("KALKULATION") || name.equals("MARKETING")) {
            if (ClientKonfiguration.getClientKonfiguration().getAngebot() == null && GlobalObjects.getInstance().getIpacData().getAnfrage() != null && GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang() != null) {
                this.getMenuBar().enableMenuSpeichern(true);
                this.getMenuBar().getMenuItemSpeichernAnfrage().setEnabled(true);
                if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                    this.getMenuBar().getMenuItemSpeichernAngebot().setEnabled(false);
                    this.getMenuBar().getMenuItemISPA().setEnabled(true);
                } else {
                    this.getMenuBar().getMenuItemSpeichernAngebot().setEnabled(ClientKonfiguration.getClientKonfiguration().isKalkulationSet());
                }
            } else {
                this.getMenuBar().getMenuItemSpeichernAnfrage().setEnabled(false);
                this.getMenuBar().getMenuItemSpeichernAngebot().setEnabled(false);
                if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                    this.getMenuBar().getMenuItemISPA().setEnabled(true);
                }
            }
        } else {
            if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                this.getMenuBar().getMenuItemISPA().setEnabled(false);
            }
            this.getMenuBar().getMenuItemFilePrint().setEnabled(false);
            this.getMenuBar().getMenuItemSpeichernAnfrage().setEnabled(false);
            this.getMenuBar().getMenuItemSpeichernAngebot().setEnabled(false);
            if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                this.getMenuBar().getMenuItemFileNew().setEnabled(true);
            }
            this.getMenuBar().getMenuItemExit().setEnabled(false);
            return;
        }
        if (ClientKonfiguration.getClientKonfiguration().getAngebot() != null && ClientKonfiguration.getClientKonfiguration().getAngebot().isStorniert()) {
            this.getMenuBar().getMenuItemFilePrint().setEnabled(false);
            this.getMenuBar().disableIcon("print");
        } else if (ClientKonfiguration.getClientKonfiguration().getAngebot() != null) {
            if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                this.getMenuBar().getMenuItemFilePrint().setEnabled(true);
            }
            this.getMenuBar().disableIcon("remove");
            this.getMenuBar().enableIcon("print");
        } else {
            if (GlobalObjects.getInstance().getIpacData().getFahrzeug() != null) {
                this.getMenuBar().enableIcon("remove");
            } else {
                this.getMenuBar().disableIcon("remove");
            }
            if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                this.getMenuBar().getMenuItemFilePrint().setEnabled(true);
            }
            this.getMenuBar().enableIcon("print");
        }
        if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
            this.getMenuBar().getMenuItemFileNew().setEnabled(true);
            this.getMenuBar().getMenuItemExit().setEnabled(true);
        }
    }
}

