/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.suche.ControllerProduktListPanel;
import de.esg.zub.configurator.content.suche.ControllerSubCategoryPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.navigation.suche.NavigationPanel;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.resources.Resource;

public class StatusBar
extends Observable {
    private ArrayList<JLabel> statusList = new ArrayList();
    private JPanel statusBar = null;
    private Hashtable<JLabel, String> mHashtable = new Hashtable();
    private JLabel homeBig = null;
    private JLabel homeSmall = null;
    private MarkenLayout mLayout = null;
    String iconPath = "";

    public StatusBar(MarkenLayout markenLayout) {
        this.iconPath = markenLayout.getIconPath();
        this.mLayout = markenLayout;
        this.statusBar = new JPanel();
        this.statusBar.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, Constants.Layout.RAHMEN_COLOR));
        FlowLayout flow = new FlowLayout(0);
        flow.setVgap(4);
        this.statusBar.setLayout(flow);
        Image home = GlobalObjects.getInstance().getIpacData().isStartedFromISPA() && !GlobalObjects.getInstance().getIpacData().hasAnfrageAngebotWithVIN() ? ImageCache.getInstance().getImage(this.iconPath + "homeSmall_inaktiv.gif") : ImageCache.getInstance().getImage(this.iconPath + "homeSmall_aktiv.gif");
        this.homeBig = home != null ? new JLabel(new ImageIcon(home)) : new JLabel();
        this.homeBig.setName("HOME_BIG");
        this.addNewStatus(this.homeBig);
        Image warenkorb = ImageCache.getInstance().getImage(this.iconPath + "warenkorbPlus_aktiv.gif");
        this.homeSmall = warenkorb != null ? new JLabel(new ImageIcon(warenkorb)) : new JLabel();
        this.homeSmall.setName("HOME_SMALL");
        this.addNewStatus(this.homeSmall);
        this.setStyle(markenLayout);
        this.statusBar.setVisible(true);
    }

    public void addNewStatus(String status) {
        this.addNewStatus(status, "");
    }

    public void addNewStatus(String status, String statusName) {
        boolean iselement = false;
        if (!iselement) {
            JLabel button = this.createLabel(status);
            button.setBackground(this.mLayout.getPrimaryBackground());
            button.setForeground(this.mLayout.getPrimaryForeground());
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(10);
            button.setName(status);
            button.setBorder(BorderFactory.createEmptyBorder());
            int position = this.statusList.size();
            this.statusList.add(position, button);
            this.setChanged();
            this.notifyObservers(position);
            this.statusBar.add(button);
            if (statusName.length() > 0) {
                this.mHashtable.put(button, statusName);
            }
            this.statusBar.updateUI();
            this.statusBar.validate();
        }
    }

    private JLabel createLabel(String statusText) {
        JLabel statusLabel = new JLabel();
        if (statusText.length() > 31) {
            statusLabel.setText(statusText.substring(0, 31) + "...");
            statusLabel.setToolTipText(statusText);
        } else {
            statusLabel.setText(statusText);
        }
        return statusLabel;
    }

    public void addNewStatusAtIndex(String status, String statusName, int position) {
        boolean iselement = false;
        if (!iselement) {
            JLabel button = this.createLabel(status);
            button.setBackground(this.mLayout.getPrimaryBackground());
            button.setForeground(this.mLayout.getPrimaryForeground());
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(10);
            button.setName(status);
            button.setBorder(BorderFactory.createEmptyBorder());
            Iterator<JLabel> it = this.mHashtable.keySet().iterator();
            while (it.hasNext()) {
                JLabel label = it.next();
                if (!label.getText().equals(status) || !this.mHashtable.get(label).equals(statusName)) continue;
                int index = this.statusList.indexOf(label);
                it.remove();
                this.statusList.remove(index);
                this.statusBar.remove(label);
            }
            this.statusList.add(position, button);
            this.setChanged();
            this.notifyObservers(position);
            this.statusBar.add((Component)button, position);
            if (statusName.length() > 0) {
                this.mHashtable.put(button, statusName);
            }
            this.statusBar.updateUI();
            this.statusBar.validate();
        }
    }

    public void changeValueHashTable(int index, String newValue) {
        JLabel key = this.statusList.get(index);
        if (this.mHashtable.containsKey(key)) {
            this.mHashtable.remove(key);
            this.mHashtable.put(key, newValue);
        }
    }

    public void setConfigurationStatusbar(String hauptkategorie, String unterkategorie) {
        this.removeAllStatusFromIndex(2);
        ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + hauptkategorie, "SUBCAT");
        ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + unterkategorie, "PRODUCTLIST");
        ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + Resource.getInstance().getSchritt() + " 1: " + Resource.getInstance().getMarketingsicht(), "MARKETING");
        ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + Resource.getInstance().getSchritt() + " 2: " + Resource.getInstance().getTechnischeSicht(), "TECHNIK");
        ControllerStatusBar.getInstance().getStatusBar().addNewStatus(" > " + Resource.getInstance().getSchritt() + " 3: " + Resource.getInstance().getKalkulationssicht(), "KALKULATION");
        this.statusBar.validate();
    }

    public void addNewStatus(JLabel status) {
        this.addNewStatus(status, "");
    }

    public void addNewStatus(JLabel status, String statusName) {
        JLabel button = status;
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(10);
        button.setBorder(BorderFactory.createEmptyBorder());
        if (this.mHashtable.containsValue(statusName)) {
            this.removeStatus(this.statusList.size() - 1);
        }
        int position = this.statusList.size();
        this.statusList.add(position, button);
        this.setChanged();
        this.notifyObservers(position);
        this.statusBar.add(button);
        if (statusName.length() > 0) {
            this.mHashtable.put(button, statusName);
        }
        if (statusName.length() > 0) {
            this.mHashtable.put(button, statusName);
        }
        this.statusBar.updateUI();
    }

    public void setIntialState() {
        boolean isEnthalten = false;
        for (int ii = 0; ii < this.statusList.size(); ++ii) {
            if (!this.statusList.get(ii).getName().equals("HOME_SMALL")) continue;
            return;
        }
        if (!isEnthalten) {
            this.homeSmall = new JLabel(new ImageIcon(ImageCache.getInstance().getImage(this.iconPath + "warenkorbPlus_aktiv.gif")));
            this.homeSmall.setName("HOME_SMALL");
            this.addNewStatus(this.homeSmall);
        }
    }

    public void removeStatus(int index) {
        if (index < 1) {
            return;
        }
        if (this.statusList.size() < index + 1) {
            return;
        }
        JLabel statusLabel = this.statusList.get(index);
        if (this.mHashtable.containsKey(statusLabel)) {
            this.mHashtable.remove(statusLabel);
        }
        this.statusBar.remove(this.statusList.get(index));
        this.statusList.remove(index);
        this.statusBar.updateUI();
    }

    public void removeAllStatusFromIndex(int index) {
        if (index < 1) {
            return;
        }
        if (this.statusList.size() <= index) {
            return;
        }
        JLabel statusLabel = null;
        for (int i = this.statusList.size() - 1; i >= index; --i) {
            statusLabel = this.statusList.get(i);
            Iterator<JLabel> it = this.mHashtable.keySet().iterator();
            while (it.hasNext()) {
                JLabel label = it.next();
                if (!label.getText().equals(statusLabel.getText())) continue;
                it.remove();
            }
            this.statusBar.remove(this.statusList.get(i));
            this.statusList.remove(i);
        }
        this.statusBar.updateUI();
    }

    public String getStatusName(int index) {
        if (this.statusList.size() > index) {
            return this.statusList.get(index).getText().substring(3);
        }
        return "";
    }

    public void updateSubcatProd(String statusName) {
        Vorgang vorgang = GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang();
        String hauptkatVorgang = vorgang.getHauptKategorie().getName();
        NavigationPanel navPanel = ControllerNavigationPanel.getInstance().getNavigationPanel();
        navPanel.setKategorien();
        String selectedKategorie = navPanel.getSelectedKategorieText();
        if (!hauptkatVorgang.equals(selectedKategorie)) {
            navPanel.getCategoryComboBox().setSelectedItem(hauptkatVorgang);
        }
        if (navPanel.getSubCategoryComboBox().getSelectedItem() == null) {
            this.setUnterkatProdlist(GlobalObjects.getInstance().getIpacData().getAnfrage(), statusName);
        } else if (!navPanel.getSubCategoryComboBox().getSelectedItem().equals(vorgang.getUnterKategorie())) {
            this.setUnterkatProdlist(GlobalObjects.getInstance().getIpacData().getAnfrage(), statusName);
        }
    }

    private void setUnterkatProdlist(Anfrage anfrage, String statusName) {
        int hauptKategorieID = ControllerNavigationPanel.getInstance().getNavigationPanel().getNavModel().getIdToKategorieName(anfrage.getVorgang().getHauptKategorie().getName());
        ControllerNavigationPanel.getInstance().getNavigationPanel().setUnterkategorien(hauptKategorieID, true);
        ControllerNavigationPanel.getInstance().getNavigationPanel().setSelectedUnterkategorieText(anfrage.getVorgang().getUnterKategorie().getName());
        ControllerNavigationPanel.getInstance().getNavigationPanel().setSelectedUnterkategorie(anfrage.getVorgang().getUnterKategorie().getName());
        ControllerNavigationPanel.getInstance().getNavigationPanel().getSubCategoryComboBox().setSelectedItem(anfrage.getVorgang().getUnterKategorie());
        ControllerNavigationPanel.getInstance().getNavigationPanel().getSubCategoryComboBox().setVisible(true);
        if (statusName.equals("PRODUCTLIST")) {
            ArrayList<ProduktListenElement> newProduktList = ControllerSubCategoryPanel.getInstance().getSubCategoryPanel().getFahrzeugZubehoerList(1);
            ControllerSubCategoryPanel.getInstance().getSubCategoryPanel().setZubehoerList(newProduktList);
            ControllerProduktListPanel.getInstance().getProduktListPanel().setProduktList(newProduktList);
        }
    }

    public JPanel getStatusBar() {
        return this.statusBar;
    }

    public ArrayList<JLabel> getStatusList() {
        return this.statusList;
    }

    public void setStyle(MarkenLayout markenLayout) {
        this.mLayout = markenLayout;
        this.statusBar.setBackground(this.mLayout.getPrimaryBackground());
        this.iconPath = this.mLayout.getIconPath();
        Icon home = ImageCache.getInstance().getIcon(this.iconPath + "homeSmall_aktiv.gif");
        home = GlobalObjects.getInstance().getIpacData().isStartedFromISPA() && !GlobalObjects.getInstance().getIpacData().hasAnfrageAngebotWithVIN() || GlobalObjects.getInstance().getIpacData().getIspaAngebotsNr() != 0 ? ImageCache.getInstance().getIcon(this.iconPath + "homeSmall_inaktiv.gif") : ImageCache.getInstance().getIcon(this.iconPath + "homeSmall_aktiv.gif");
        Icon warenkorb = ImageCache.getInstance().getIcon(this.iconPath + "warenkorbPlus_aktiv.gif");
        if (home != null) {
            this.homeBig.setIcon(home);
        }
        if (warenkorb != null) {
            this.homeSmall.setIcon(warenkorb);
        }
        for (int i = 0; i < this.statusList.size(); ++i) {
            this.statusList.get(i).setForeground(this.mLayout.getPrimaryForeground());
            this.statusList.get(i).setBackground(this.mLayout.getPrimaryBackground());
            this.statusList.get(i).setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public Hashtable<JLabel, String> getHashtable() {
        return this.mHashtable;
    }
}

