/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.WrongSelectionException;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.resources.Resource;

public class TechnikState
extends AbstractState {
    Logger logger = Logger.getLogger(TechnikState.class);
    public static final String STATE_NAME = "TECHNIK";

    public TechnikState() {
        super.setName(STATE_NAME);
    }

    @Override
    public void entry() {
        if (WorkflowController.getInstance().isFzBedIdentified() && (!WorkflowController.getInstance().isAddKonfiguration() || WorkflowController.getInstance().isAddKonfigurationDataSet())) {
            try {
                ControllerTechnikPanel.getInstance().init();
            }
            catch (WrongSelectionException e) {
                return;
            }
            ControllerMiniaturansicht.getInstance().getMiniaturTechnik().setBorder();
            ControllerMenuBar.getInstance().setSpeichern();
        } else {
            WorkflowController.getInstance().changeState("FBI");
        }
    }

    @Override
    public void exit() {
        String stateName = WorkflowController.getInstance().getNewState().getName();
        if (!WorkflowController.getInstance().isNewKonfiguration() || !ControllerTechnikPanel.getInstance().hasErrors()) {
            if (stateName.equals(STATE_NAME) || stateName.equals("KALKULATION") || stateName.equals("MARKETING")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (WorkflowController.getInstance().isFzBedIdentified()) {
                                ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(TechnikState.STATE_NAME);
                            }
                        }
                        catch (Exception e) {
                            TechnikState.this.logger.error((Object)"Error saving Konfiguration data:", (Throwable)e);
                            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame().getMainPanel(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getSpeicherfehler(), 1);
                        }
                    }
                });
            } else {
                try {
                    if (WorkflowController.getInstance().isFzBedIdentified()) {
                        ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(STATE_NAME);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error saving Konfiguration data:", (Throwable)e);
                    JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame().getMainPanel(), Resource.getInstance().getFehlerBeimSpeichernDerKonfiguration(), Resource.getInstance().getSpeicherfehler(), 1);
                }
            }
        }
        ControllerTechnikPanel.getInstance().exit();
        ControllerMiniaturansicht.getInstance().getMiniaturTechnik().removeBorder();
        ControllerMenuBar.getInstance().getMenuBar().disableIcon("print");
    }
}

