/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.configurator.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class VorgangKonfigView
extends JPanel {
    private MarkenLayout mLayout;
    private JLabel schliessen;
    private JLabel benennung;
    private String mId;
    private String mFulName;
    private boolean selected;
    private String mSchliessenIconName;
    public static final String BENENNUNG = "text_";
    public static final String SCHLIESSEN = "schliessen_";

    public VorgangKonfigView(String id, String name, Dimension dim, String schliessenIconName, boolean cutString) {
        this.mId = id;
        this.mFulName = name;
        this.mLayout = WorkflowController.getInstance().getMarkenLayout();
        this.setBackground(this.mLayout.getPrimaryBackground());
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 2, Constants.Layout.RAHMEN_COLOR));
        String showName = "";
        showName = cutString && name.length() > this.getMaxZeichenAnzahl() ? name.substring(0, this.getMaxZeichenAnzahl()) + "..." : name;
        this.benennung = new JLabel(showName);
        this.benennung.setName(BENENNUNG + id);
        this.benennung.setToolTipText(name);
        GridBagConstraints gbc = this.mLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 0, 17, new Insets(0, 2, 0, 0));
        this.add((Component)this.benennung, gbc);
        this.mSchliessenIconName = schliessenIconName;
        this.schliessen = new JLabel(new ImageIcon(ImageCache.getInstance().getImage(this.mLayout.getIconPath() + schliessenIconName)));
        this.schliessen.setName(SCHLIESSEN + id);
        gbc = this.mLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 0, 13, new Insets(0, 0, 0, 0));
        this.add((Component)this.schliessen, gbc);
        this.selected = true;
    }

    public void setLayout(MarkenLayout markenLayout) {
        this.mLayout = markenLayout;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(Integer id) {
        this.mId = id.toString();
        this.benennung.setName(BENENNUNG + this.mId);
        this.schliessen.setName(SCHLIESSEN + this.mId);
    }

    public JLabel getSchliessen() {
        return this.schliessen;
    }

    public JLabel getBenennung() {
        return this.benennung;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getSchliessenIconName() {
        return this.mSchliessenIconName;
    }

    public String getFulName() {
        return this.mFulName;
    }

    private int getMaxZeichenAnzahl() {
        int maxZeichenAnzahl = 7;
        if (GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("zh") || GlobalObjects.getInstance().getLanguage().equals("ja")) {
            maxZeichenAnzahl = 4;
        }
        return maxZeichenAnzahl;
    }
}

