/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.content.marketing.Bestandteil;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.customizable.ZubCustomizable;
import de.esg.zub.jasper.AnfrageDataSource;
import de.esg.zub.jasper.AnfrageKundeDatumSource;
import de.esg.zub.jasper.AnfragePrintDataBean;
import de.esg.zub.jasper.ElementeDataSource;
import de.esg.zub.jasper.Filiale;
import de.esg.zub.jasper.KalkulationspositionBean;
import de.esg.zub.jasper.KalkulationspositionSource;
import de.esg.zub.jasper.MarketingDataSource;
import de.esg.zub.jasper.NutzenDataSource;
import de.esg.zub.jasper.Nutzer;
import de.esg.zub.jasper.SingleStringDataSource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.Variante;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Kunde;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.resources.Resource;

public class AnfrageFactory {
    static final char[] MWST_SYMBOLE = new char[]{'*', '+', 'o', 'x'};
    private static Logger log = Logger.getLogger(AnfrageFactory.class);

    public static AnfrageDataSource getAnfrageSource(boolean isAngebot) {
        return new AnfrageDataSource(AnfrageFactory.getAnfragePrintData(isAngebot));
    }

    public static MarketingDataSource getMarketingDataSource() {
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        if (model == null) {
            model = ClientKonfiguration.getClientKonfiguration().getMarketingModel();
        }
        return new MarketingDataSource(model);
    }

    public static SingleStringDataSource getBestandteilDataSource() {
        log.debug((Object)"getBestandteilDataSource 222222  =  ");
        SingleStringDataSource source = new SingleStringDataSource();
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        if (model == null) {
            model = ClientKonfiguration.getClientKonfiguration().getMarketingModel();
        }
        ArrayList<Bestandteil> bestandTeile = model.getBestandteile();
        log.debug((Object)"getBestandteilDataSource 333333333333  =  ");
        for (Bestandteil best : bestandTeile) {
            StringBuilder bestandteilBuilder = new StringBuilder();
            bestandteilBuilder.append(best.getName());
            if (best.getVarianten().size() != 0) {
                bestandteilBuilder.append(" in " + best.getSelectedVariante().getName());
            }
            source.getData().add(bestandteilBuilder.toString());
        }
        ArrayList<Bnb> einzelTeile = model.getSelectedEinzelteile();
        if (einzelTeile != null) {
            for (Bnb einzel : einzelTeile) {
                StringBuilder einzelteilBuilder = new StringBuilder();
                einzelteilBuilder.append(einzel.getBnbName());
                if (einzel.getSelectedVariante() != null) {
                    einzelteilBuilder.append(" in " + einzel.getSelectedVariante().getName());
                }
                source.getData().add(einzelteilBuilder.toString());
            }
        }
        return source;
    }

    public static ElementeDataSource getAlternativenDataSource() {
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        if (model == null) {
            model = ClientKonfiguration.getClientKonfiguration().getMarketingModel();
        }
        Bnb selAlternative = model.getSelectedAlternative();
        ArrayList alternativen = (ArrayList)model.getMarketingProdukt().getAlternativen();
        ArrayList<String> alleAlternativen = new ArrayList<String>();
        ArrayList<String> selectedAlternativen = new ArrayList<String>();
        for (Bnb alter : alternativen) {
            alleAlternativen.add(alter.getBnbName());
            if (alter.getBildPos() == selAlternative.getBildPos()) {
                selectedAlternativen.add("1");
                continue;
            }
            selectedAlternativen.add("0");
        }
        ElementeDataSource elem = new ElementeDataSource(alleAlternativen, selectedAlternativen);
        return elem;
    }

    public static ElementeDataSource getVariantenDataSource() {
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        if (model == null) {
            model = ClientKonfiguration.getClientKonfiguration().getMarketingModel();
        }
        Bnb selAlternative = model.getSelectedAlternative();
        ArrayList varianten = new ArrayList();
        if (selAlternative != null) {
            varianten = (ArrayList)model.getMarketingProdukt().getVariantenZuAlternativen().get(selAlternative.getBildPos());
        }
        ArrayList<String> alleVarianten = new ArrayList<String>();
        ArrayList<String> selectedVarianten = new ArrayList<String>();
        for (Variante var : varianten) {
            alleVarianten.add(var.getName());
            if (var.getVarianteId() == model.getSelectedVariante().getVarianteId()) {
                selectedVarianten.add("1");
                continue;
            }
            selectedVarianten.add("0");
        }
        ElementeDataSource elem = new ElementeDataSource(alleVarianten, selectedVarianten);
        return elem;
    }

    public static ElementeDataSource getZusatzProduktDataSource() {
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        if (model == null) {
            model = ClientKonfiguration.getClientKonfiguration().getMarketingModel();
        }
        int numberOfZusatzProdukte = model.getNamesZusatzprodukte().size();
        ArrayList<String> allVarianten = model.getNamesZusatzprodukte();
        ArrayList<String> selectedVarianten = new ArrayList<String>();
        for (int index = 0; index < numberOfZusatzProdukte; ++index) {
            if (model.getIndexSelectedZusatzprodukte().contains(index)) {
                selectedVarianten.add("1");
                continue;
            }
            selectedVarianten.add("0");
        }
        ElementeDataSource elem = new ElementeDataSource(allVarianten, selectedVarianten);
        return elem;
    }

    public static NutzenDataSource getNutzenDataSource() {
        MarketingModel model = ControllerMarketingPanel.getInstance().getModel();
        if (model == null) {
            model = ClientKonfiguration.getClientKonfiguration().getMarketingModel();
        }
        return new NutzenDataSource(model);
    }

    public static KalkulationspositionSource getKalkulationsPositionsSource(boolean isAngebot) {
        List<KalkulationspositionBean> liste = AnfrageFactory.getKalkulationsData(isAngebot);
        ArrayList<String> ben = AnfrageFactory.getKalkbezeichnungen();
        KalkulationspositionSource source = new KalkulationspositionSource(ben.get(0), ben.get(1), ben.get(2), ben.get(3), ben.get(4));
        source.setData(liste);
        return source;
    }

    private static List<KalkulationspositionBean> getKalkulationsData(boolean isAngebot) {
        ClientKonfiguration konfig = ClientKonfiguration.getClientKonfiguration();
        HashMap<Double, String> mwSteuerSaetze = new HashMap<Double, String>();
        for (KonfigurationsPosition pos : konfig.getPositionen()) {
            if (mwSteuerSaetze.containsKey(new Double(pos.getMwstSatz()))) continue;
            int index = mwSteuerSaetze.size();
            if (index >= MWST_SYMBOLE.length) {
                Logger log = Logger.getLogger(AnfrageFactory.class);
                log.error((Object)("Zu viele unterschiedliche MwSt-S\u00e4tze erkannt. Zul\u00e4ssige Anzahl von MwSt-S\u00e4tzen = " + MWST_SYMBOLE.length + ". Aktuelle Anzahl = " + index + "."));
                break;
            }
            mwSteuerSaetze.put(new Double(pos.getMwstSatz()), Character.toString(MWST_SYMBOLE[index]));
        }
        ArrayList<KalkulationspositionBean> liste = new ArrayList<KalkulationspositionBean>();
        for (KonfigurationsPosition pos : konfig.getPositionen()) {
            if (!pos.getStatus().equals("INSERT") && pos.getStatus().equals("DELETE")) continue;
            KalkulationspositionBean bean = new KalkulationspositionBean();
            bean.setBenennung(pos.getArtikelBenennung());
            bean.setTeileNummer(pos.getArtikelNummer());
            bean.setEinzelPreis(pos.getPreis());
            bean.setMwSteuerSatz(new Double(pos.getMwstSatz()));
            bean.setMwStSymbol((String)mwSteuerSaetze.get(bean.getMwSteuerSatz()));
            if (isAngebot) {
                bean.setRabatt(pos.getRabatt());
                bean.setGesamtPreis(pos.getGesamtPreis());
            } else {
                bean.setRabatt(0.0);
                double gesamtPreis = pos.getPreis() * (double)pos.getMenge();
                bean.setGesamtPreis(Math.floor(gesamtPreis * 100.0 + 0.5) / 100.0);
            }
            bean.setMenge(pos.getMenge());
            bean.setPos(pos.getPos());
            liste.add(bean);
        }
        return liste;
    }

    public static FilialeZub getFiliale() {
        FilialeZub filiale = null;
        try {
            List<FilialeZub> filialen = AdminDataLoader.ladeFilialListeZub(GlobalObjects.getInstance().getFirmaId());
            if (filialen != null) {
                for (int i = 0; i < filialen.size(); ++i) {
                    if (!filialen.get(i).getId().equals(GlobalObjects.getInstance().getSessionInfo().getFilialeId())) continue;
                    filiale = filialen.get(i);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Fehler beim Laden der Filiale", (Throwable)e);
            e.printStackTrace();
        }
        return filiale;
    }

    public static ArrayList<String> getKalkbezeichnungen() {
        ArrayList<String> ben = new ArrayList<String>();
        String waehrungsKz = ZubCustomizable.getInstance().getWaehrungsKz();
        if (waehrungsKz == null || waehrungsKz.equals("")) {
            ben.add(Resource.getInstance().getNetto());
            ben.add(ZubCustomizable.getInstance().getBegriffAufAbschlag());
            ben.add(ZubCustomizable.getInstance().getBegriffAbkuerzungMwst());
            ben.add(Resource.getInstance().getAngebotsbetrag());
            ben.add(Resource.getInstance().getGesamtpreis());
        } else {
            ben.add(Resource.getInstance().getNetto() + " " + Resource.getInstance().getInKlein() + " " + waehrungsKz);
            ben.add(ZubCustomizable.getInstance().getBegriffAufAbschlag() + " " + Resource.getInstance().getInKlein() + " " + waehrungsKz);
            ben.add(ZubCustomizable.getInstance().getBegriffAbkuerzungMwst() + " " + Resource.getInstance().getInKlein() + " " + waehrungsKz);
            ben.add(Resource.getInstance().getAngebotsbetrag() + " " + Resource.getInstance().getInKlein() + " " + waehrungsKz);
            ben.add(Resource.getInstance().getGesamtpreis() + " " + Resource.getInstance().getInKlein() + " " + waehrungsKz);
        }
        return ben;
    }

    private static AnfragePrintDataBean getAnfragePrintData(boolean isAngebot) {
        AnfragePrintDataBean bean = new AnfragePrintDataBean();
        bean.setProduktName(ControllerMarketingPanel.getInstance().getModel().getProductName());
        try {
            NutzerZub nutzerZub = AdminDataLoader.ladeNutzerDatenZuUserId(GlobalObjects.getInstance().getSessionInfo().getLogin());
            FilialeZub filiale = AnfrageFactory.getFiliale();
            if (filiale != null) {
                Filiale firma = new Filiale();
                firma.setFirmenbezeichung(filiale.getBezeichnungFirma());
                firma.setFilialName(filiale.getBezeichnung());
                firma.setZusatz(filiale.getBezeichnungFirma());
                firma.setStrasse(filiale.getStrasse());
                firma.setPlz(filiale.getPlz());
                firma.setOrt(filiale.getOrt());
                firma.setTelefon(filiale.getTelefon());
                firma.setFax(filiale.getFax());
                bean.setFirma(firma);
            }
            if (nutzerZub != null) {
                Nutzer nutzer = new Nutzer();
                nutzer.setRealName(nutzerZub.getRealName());
                nutzer.setTelefon(nutzerZub.getTelefon());
                nutzer.setEmail(nutzerZub.getEmail());
                bean.setNutzer(nutzer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KalkulationModel kalkulationModel = ClientKonfiguration.getClientKonfiguration().getKalkulationModel();
        bean.setWaehrung(ZubCustomizable.getInstance().getWaehrungsKz());
        Anfrage anfrage = kalkulationModel.getAnfrage();
        if (anfrage == null) {
            return null;
        }
        Kunde kunde = null;
        kunde = isAngebot ? anfrage.getVorgang().getKonfiguration().getAngebot().getKunde() : anfrage.getKunde();
        if (kunde != null) {
            bean.setKunde(kunde);
        } else {
            kunde = kalkulationModel.getKunde();
            if (kunde != null) {
                bean.setKunde(kunde);
            }
        }
        Vorgang vorgang = anfrage.getVorgang();
        if (vorgang != null) {
            bean.setAngebot(isAngebot);
            bean.setBteNr(vorgang.getBtNummer());
            bean.setBnbNr(vorgang.getBildPos());
            bean.setAnlagedatum(vorgang.getAnlageDatum());
            Fahrzeug fahrzeug = vorgang.getFahrzeug();
            StringBuilder bui = new StringBuilder();
            if (fahrzeug != null) {
                bui.append(fahrzeug.getBaureiheBezeichnung());
                bui.append(" ").append(fahrzeug.getModellBezeichnung());
                if (fahrzeug.getFahrgestellnummer() != null) {
                    bean.setVIN(fahrzeug.getFahrgestellnummer());
                } else {
                    bean.setVIN("");
                }
                bean.setFahrzeugString(bui.toString());
            } else {
                bean.setFahrzeugString("");
            }
            bean.setProduktName(vorgang.getPlainProduktName());
            if (isAngebot && vorgang.getKonfiguration() != null && vorgang.getKonfiguration().getAngebot() != null) {
                bean.setId(vorgang.getKonfiguration().getAngebot().getAngebotsnummer());
            } else {
                bean.setId(anfrage.getAnfrageId());
            }
            if (isAngebot) {
                bean.setBemerkung(vorgang.getKonfiguration().getAngebot().getBemerkung());
            } else {
                bean.setBemerkung(anfrage.getBemerkung());
            }
        }
        bean.setNettoPreis(kalkulationModel.getNettoPreis());
        bean.setSteuer(kalkulationModel.getMwSt());
        if (isAngebot) {
            bean.setAufabschlag(kalkulationModel.getAufAbschlag());
        } else {
            bean.setAufabschlag(0.0);
        }
        if (isAngebot) {
            Calendar cal = Calendar.getInstance();
            cal.add(6, vorgang.getKonfiguration().getAngebot().getBindeFrist());
            cal.clear(14);
            cal.clear(13);
            cal.clear(12);
            cal.set(10, 0);
            bean.setGueltigBis(cal.getTime());
        }
        return bean;
    }

    public static AnfrageKundeDatumSource getAnfrageKundeDatumSource(boolean isAngebot) {
        AnfrageKundeDatumSource akds = new AnfrageKundeDatumSource();
        KalkulationModel kalkulationModel = ClientKonfiguration.getClientKonfiguration().getKalkulationModel();
        Anfrage anfrage = kalkulationModel.getAnfrage();
        if (isAngebot && anfrage.getVorgang().getKonfiguration().getAngebot() == null && GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().getAngebot() != null) {
            anfrage.getVorgang().getKonfiguration().setAngebot(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().getAngebot());
        }
        if (anfrage == null) {
            return null;
        }
        akds.setAnlagedatum(anfrage.getAnlageDatum());
        Kunde kunde = null;
        kunde = isAngebot ? anfrage.getVorgang().getKonfiguration().getAngebot().getKunde() : anfrage.getKunde();
        if (kunde != null) {
            akds.setKundennummer(kunde.getKundennummer());
        }
        akds.setAngebot(isAngebot);
        Vorgang vorgang = anfrage.getVorgang();
        if (vorgang != null) {
            if (isAngebot && vorgang.getKonfiguration() != null && vorgang.getKonfiguration().getAngebot() != null) {
                akds.setNummer(vorgang.getKonfiguration().getAngebot().getAngebotsnummer());
            } else {
                akds.setNummer(anfrage.getAnfrageId());
            }
        }
        if (isAngebot) {
            Calendar cal = Calendar.getInstance();
            cal.add(6, vorgang.getKonfiguration().getAngebot().getBindeFrist());
            cal.clear(14);
            cal.clear(13);
            cal.clear(12);
            cal.set(10, 0);
            akds.setGueltigBis(cal.getTime());
        }
        return akds;
    }
}

